/*
 * Decompiled with CFR 0.152.
 */
package com.uravgcode.survivalunlocked.module.coordinatehud;

import com.uravgcode.survivalunlocked.annotation.ConfigModule;
import com.uravgcode.survivalunlocked.annotation.ConfigValue;
import com.uravgcode.survivalunlocked.event.CoordinateHudEvent;
import com.uravgcode.survivalunlocked.module.PluginModule;
import io.papermc.paper.threadedregions.scheduler.GlobalRegionScheduler;
import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import java.util.ArrayList;
import java.util.List;
import net.kyori.adventure.pointer.Pointered;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.Tag;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ConfigModule(path="coordinate-hud")
public final class CoordinateHudModule
extends PluginModule {
    private final List<Player> players = new ArrayList<Player>();
    private final NamespacedKey hudKey;
    private final MiniMessage miniMessage;
    private ScheduledTask task = null;
    @ConfigValue(path="format")
    private String format = "<x>,<y>,<z>  <yellow><direction>";
    @ConfigValue(path="refresh-interval")
    private long refreshInterval = 2L;

    public CoordinateHudModule(@NotNull JavaPlugin plugin) {
        super(plugin);
        this.hudKey = new NamespacedKey((Plugin)plugin, "coordinate_hud");
        this.miniMessage = MiniMessage.builder().tags(TagResolver.resolver((TagResolver[])new TagResolver[]{TagResolver.standard(), this.positionPlaceholders()})).build();
    }

    @Override
    public void enable() {
        super.enable();
        if (this.task == null) {
            GlobalRegionScheduler scheduler = this.plugin.getServer().getGlobalRegionScheduler();
            this.task = scheduler.runAtFixedRate((Plugin)this.plugin, this::updateCoordinateHud, 1L, this.refreshInterval);
        }
    }

    @Override
    public void disable() {
        super.disable();
        if (this.task != null) {
            this.task.cancel();
            this.task = null;
        }
    }

    @EventHandler
    public void onCoordinateHud(CoordinateHudEvent event) {
        Player player = event.getPlayer();
        PersistentDataContainer dataContainer = player.getPersistentDataContainer();
        if (dataContainer.has(this.hudKey)) {
            dataContainer.remove(this.hudKey);
            this.players.remove(player);
        } else {
            dataContainer.set(this.hudKey, PersistentDataType.BYTE, (Object)1);
            this.players.add(player);
        }
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        if (event.getPlayer().getPersistentDataContainer().has(this.hudKey)) {
            this.players.add(event.getPlayer());
        }
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        this.players.remove(event.getPlayer());
    }

    private void updateCoordinateHud(@Nullable ScheduledTask ignored) {
        for (Player player : this.players) {
            player.sendActionBar(this.miniMessage.deserialize(this.format, (Pointered)player));
        }
    }

    @NotNull
    private TagResolver positionPlaceholders() {
        return TagResolver.builder().tag("x", (arguments, context) -> {
            Player player = (Player)context.targetAsType(Player.class);
            int x = player.getLocation().getBlockX();
            return Tag.selfClosingInserting((Component)Component.text((int)x));
        }).tag("y", (arguments, context) -> {
            Player player = (Player)context.targetAsType(Player.class);
            int y = player.getLocation().getBlockY();
            return Tag.selfClosingInserting((Component)Component.text((int)y));
        }).tag("z", (arguments, context) -> {
            Player player = (Player)context.targetAsType(Player.class);
            int z = player.getLocation().getBlockZ();
            return Tag.selfClosingInserting((Component)Component.text((int)z));
        }).tag("direction", (arguments, context) -> {
            Player player = (Player)context.targetAsType(Player.class);
            float yaw = player.getLocation().getYaw();
            String direction = "?";
            if ((double)yaw >= -22.5 && (double)yaw < 22.5 || (double)yaw >= 337.5 || (double)yaw < -337.5) {
                direction = "S";
            } else if ((double)yaw >= 22.5 && (double)yaw < 67.5) {
                direction = "SW";
            } else if ((double)yaw >= 67.5 && (double)yaw < 112.5) {
                direction = "W";
            } else if ((double)yaw >= 112.5 && (double)yaw < 157.5) {
                direction = "NW";
            } else if ((double)yaw >= 157.5 && yaw <= 180.0f || yaw >= -180.0f && (double)yaw < -157.5) {
                direction = "N";
            } else if ((double)yaw >= -157.5 && (double)yaw < -112.5) {
                direction = "NE";
            } else if ((double)yaw >= -112.5 && (double)yaw < -67.5) {
                direction = "E";
            } else if ((double)yaw >= -67.5 && (double)yaw < -22.5) {
                direction = "SE";
            }
            return Tag.selfClosingInserting((Component)Component.text((String)direction));
        }).build();
    }
}

