/*
 * Decompiled with CFR 0.152.
 */
package com.uravgcode.survivalunlocked.module.customshapedportals;

import com.uravgcode.survivalunlocked.annotation.ConfigModule;
import com.uravgcode.survivalunlocked.annotation.ConfigValue;
import com.uravgcode.survivalunlocked.module.PluginModule;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.bukkit.Axis;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Server;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Orientable;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.BlockIgniteEvent;
import org.bukkit.event.world.PortalCreateEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.util.BoundingBox;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ConfigModule(path="custom-shaped-portals")
public final class CustomShapedPortalsModule
extends PluginModule {
    @ConfigValue(path="minimum-portal-size")
    private int minPortalSize = 6;
    @ConfigValue(path="maximum-portal-width")
    private int maxWidth = 21;
    @ConfigValue(path="maximum-portal-height")
    private int maxHeight = 21;
    private final Set<Material> portalBlocks = Set.of(Material.OBSIDIAN, Material.CRYING_OBSIDIAN);

    public CustomShapedPortalsModule(@NotNull JavaPlugin plugin) {
        super(plugin);
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onBlockIgnite(BlockIgniteEvent event) {
        Block fireBlock = event.getBlock();
        if (!this.portalBlocks.contains(fireBlock.getRelative(BlockFace.DOWN).getType())) {
            return;
        }
        World world = fireBlock.getWorld();
        if (world.getEnvironment() == World.Environment.THE_END) {
            return;
        }
        Entity entity = event.getIgnitingEntity();
        Location location = fireBlock.getLocation();
        for (Axis axis : new Axis[]{Axis.X, Axis.Z}) {
            Optional<Set<Block>> portalBlocks = this.getPortalBlocks(fireBlock, axis);
            if (!portalBlocks.isPresent()) continue;
            this.buildPortal(portalBlocks.get(), axis, world, entity, location);
            break;
        }
    }

    @NotNull
    private Optional<Set<Block>> getPortalBlocks(@NotNull Block fireBlock, @NotNull Axis axis) {
        BlockFace[] blockFaceArray;
        HashSet<Block> visited = new HashSet<Block>(Collections.singletonList(fireBlock));
        ArrayDeque<Block> queue = new ArrayDeque<Block>(Collections.singletonList(fireBlock));
        if (axis == Axis.Z) {
            BlockFace[] blockFaceArray2 = new BlockFace[4];
            blockFaceArray2[0] = BlockFace.UP;
            blockFaceArray2[1] = BlockFace.DOWN;
            blockFaceArray2[2] = BlockFace.NORTH;
            blockFaceArray = blockFaceArray2;
            blockFaceArray2[3] = BlockFace.SOUTH;
        } else {
            BlockFace[] blockFaceArray3 = new BlockFace[4];
            blockFaceArray3[0] = BlockFace.UP;
            blockFaceArray3[1] = BlockFace.DOWN;
            blockFaceArray3[2] = BlockFace.EAST;
            blockFaceArray = blockFaceArray3;
            blockFaceArray3[3] = BlockFace.WEST;
        }
        BlockFace[] directions = blockFaceArray;
        BoundingBox bounds = new BoundingBox((double)fireBlock.getX(), (double)fireBlock.getY(), (double)fireBlock.getZ(), (double)fireBlock.getX(), (double)fireBlock.getY(), (double)fireBlock.getZ());
        while (!queue.isEmpty()) {
            Block current = queue.poll();
            for (BlockFace direction : directions) {
                Block neighbor = current.getRelative(direction);
                if (visited.contains(neighbor)) continue;
                Material material = neighbor.getType();
                if (!material.equals((Object)Material.AIR) && !material.equals((Object)Material.FIRE)) {
                    if (this.portalBlocks.contains(material)) continue;
                    return Optional.empty();
                }
                visited.add(neighbor);
                queue.add(neighbor);
                bounds.union((double)neighbor.getX(), (double)neighbor.getY(), (double)neighbor.getZ());
                double width = axis == Axis.X ? bounds.getWidthX() : bounds.getWidthZ();
                double height = bounds.getHeight();
                if (!(width >= (double)this.maxWidth) && !(height >= (double)this.maxHeight)) continue;
                return Optional.empty();
            }
        }
        return visited.size() < this.minPortalSize ? Optional.empty() : Optional.of(visited);
    }

    private void buildPortal(@NotNull Set<Block> blocks, @NotNull Axis axis, @NotNull World world, @Nullable Entity entity, @NotNull Location location) {
        Server server = this.plugin.getServer();
        server.getRegionScheduler().execute((Plugin)this.plugin, location, () -> {
            Orientable portalData = (Orientable)Material.NETHER_PORTAL.createBlockData();
            portalData.setAxis(axis);
            ArrayList<BlockState> blockStates = new ArrayList<BlockState>(blocks.size());
            for (Block block : blocks) {
                BlockState state2 = block.getState();
                state2.setBlockData((BlockData)portalData);
                blockStates.add(state2);
            }
            PortalCreateEvent event = new PortalCreateEvent(blockStates, world, entity, PortalCreateEvent.CreateReason.FIRE);
            server.getPluginManager().callEvent((Event)event);
            if (!event.isCancelled()) {
                blockStates.forEach(state -> state.update(true));
            }
        });
    }
}

