/*
 * Decompiled with CFR 0.152.
 */
package com.uravgcode.survivalunlocked.module.silktouchspawners;

import com.uravgcode.survivalunlocked.annotation.ConfigModule;
import com.uravgcode.survivalunlocked.module.PluginModule;
import io.papermc.paper.datacomponent.DataComponentType;
import io.papermc.paper.datacomponent.DataComponentTypes;
import io.papermc.paper.datacomponent.item.TooltipDisplay;
import io.papermc.paper.registry.keys.DataComponentTypeKeys;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.Registry;
import org.bukkit.block.Block;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

@ConfigModule(path="silk-touch-spawners")
public final class SilkTouchSpawnersModule
extends PluginModule {
    public SilkTouchSpawnersModule(@NotNull JavaPlugin plugin) {
        super(plugin);
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onBlockBreak(BlockBreakEvent event) {
        Block block = event.getBlock();
        if (block.getType() != Material.SPAWNER) {
            return;
        }
        Player player = event.getPlayer();
        if (player.getGameMode() == GameMode.CREATIVE) {
            return;
        }
        ItemStack tool = player.getInventory().getItemInMainHand();
        if (!tool.containsEnchantment(Enchantment.SILK_TOUCH)) {
            return;
        }
        if (!block.isPreferredTool(tool)) {
            return;
        }
        ItemStack item = ItemStack.of((Material)Material.SPAWNER);
        DataComponentType dataComponentType = (DataComponentType)Registry.DATA_COMPONENT_TYPE.get(DataComponentTypeKeys.BLOCK_ENTITY_DATA);
        if (dataComponentType != null) {
            TooltipDisplay tooltipDisplay = (TooltipDisplay)TooltipDisplay.tooltipDisplay().addHiddenComponents(new DataComponentType[]{dataComponentType}).build();
            item.setData(DataComponentTypes.TOOLTIP_DISPLAY, (Object)tooltipDisplay);
        }
        block.getWorld().dropItemNaturally(block.getLocation(), item);
        event.setExpToDrop(0);
    }
}

