/*
 * Decompiled with CFR 0.152.
 */
package com.uravgcode.survivalunlocked.module.throwablefireballs;

import com.uravgcode.survivalunlocked.annotation.ConfigModule;
import com.uravgcode.survivalunlocked.module.PluginModule;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.entity.SmallFireball;
import org.bukkit.event.EventHandler;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.projectiles.ProjectileSource;
import org.jetbrains.annotations.NotNull;

@ConfigModule(path="throwable-fireballs")
public final class ThrowableFireballsModule
extends PluginModule {
    public ThrowableFireballsModule(@NotNull JavaPlugin plugin) {
        super(plugin);
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (event.getAction() != Action.RIGHT_CLICK_AIR) {
            return;
        }
        Player player = event.getPlayer();
        EquipmentSlot hand = event.getHand();
        if (hand == null) {
            return;
        }
        ItemStack item = player.getInventory().getItem(hand);
        if (item.getType() != Material.FIRE_CHARGE) {
            return;
        }
        player.swingHand(hand);
        player.getWorld().playSound(player.getEyeLocation(), Sound.ITEM_FIRECHARGE_USE, 1.0f, 1.0f);
        SmallFireball fireball = (SmallFireball)player.getWorld().spawn(player.getEyeLocation(), SmallFireball.class);
        fireball.setDirection(player.getEyeLocation().getDirection());
        fireball.setShooter((ProjectileSource)player);
        if (player.getGameMode() != GameMode.CREATIVE) {
            item.subtract();
        }
        event.setCancelled(true);
    }
}

