/*
 * Decompiled with CFR 0.152.
 */
package com.uravgcode.survivalunlocked.module.transferyourpets;

import com.uravgcode.survivalunlocked.annotation.ConfigModule;
import com.uravgcode.survivalunlocked.module.PluginModule;
import io.papermc.paper.dialog.Dialog;
import io.papermc.paper.entity.Leashable;
import io.papermc.paper.registry.data.dialog.ActionButton;
import io.papermc.paper.registry.data.dialog.DialogBase;
import io.papermc.paper.registry.data.dialog.DialogRegistryEntry;
import io.papermc.paper.registry.data.dialog.action.DialogAction;
import io.papermc.paper.registry.data.dialog.action.DialogActionCallback;
import io.papermc.paper.registry.data.dialog.body.DialogBody;
import io.papermc.paper.registry.data.dialog.type.DialogType;
import java.util.List;
import java.util.UUID;
import net.kyori.adventure.dialog.DialogLike;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.event.ClickCallback;
import org.bukkit.entity.AnimalTamer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Tameable;
import org.bukkit.event.EventHandler;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

@ConfigModule(path="transfer-your-pets")
public final class TransferYourPetsModule
extends PluginModule {
    public TransferYourPetsModule(@NotNull JavaPlugin plugin) {
        super(plugin);
    }

    @EventHandler
    public void onPetTransfer(PlayerInteractEntityEvent event) {
        Entity entity2 = event.getRightClicked();
        if (!(entity2 instanceof Player)) {
            return;
        }
        Player target = (Player)entity2;
        Player player = event.getPlayer();
        UUID playerId = player.getUniqueId();
        if (!player.isSneaking()) {
            return;
        }
        List<Leashable> leashedEntities = player.getNearbyEntities(16.0, 16.0, 16.0).stream().filter(entity -> entity instanceof Leashable).map(entity -> (Leashable)entity).filter(Leashable::isLeashed).filter(leashable -> playerId.equals(leashable.getLeashHolder().getUniqueId())).toList();
        if (leashedEntities.isEmpty()) {
            return;
        }
        if (leashedEntities.stream().filter(leashable -> leashable instanceof Tameable).map(leashable -> (Tameable)leashable).noneMatch(tameable -> playerId.equals(tameable.getOwnerUniqueId()))) {
            leashedEntities.forEach(leashable -> leashable.setLeashHolder((Entity)target));
            return;
        }
        this.showConfirmationDialog(player, target, (response, audience) -> {
            if (player.getLocation().distance(target.getLocation()) > 10.0) {
                player.sendActionBar((Component)Component.text((String)(target.getName() + " is too far away")));
                return;
            }
            for (Leashable leashedEntity : leashedEntities) {
                Tameable pet;
                if (!leashedEntity.isLeashed()) continue;
                leashedEntity.setLeashHolder((Entity)target);
                if (!(leashedEntity instanceof Tameable) || !playerId.equals((pet = (Tameable)leashedEntity).getOwnerUniqueId())) continue;
                pet.setOwner((AnimalTamer)target);
            }
        });
    }

    private void showConfirmationDialog(Player player, Player target, DialogActionCallback callback) {
        String title = "Transfer Ownership";
        String body = "You are about to transfer ownership of your animal to %s.\nDo you want to continue?\n".formatted(target.getName());
        Dialog dialog = Dialog.create(builder -> ((DialogRegistryEntry.Builder)builder.empty()).base(DialogBase.builder((Component)Component.text((String)title)).canCloseWithEscape(true).body(List.of(DialogBody.plainMessage((Component)Component.text((String)body)))).build()).type((DialogType)DialogType.confirmation((ActionButton)ActionButton.builder((Component)Component.translatable((String)"gui.yes")).action((DialogAction)DialogAction.customClick((DialogActionCallback)callback, (ClickCallback.Options)((ClickCallback.Options)ClickCallback.Options.builder().build()))).build(), (ActionButton)ActionButton.builder((Component)Component.translatable((String)"gui.no")).build())));
        player.showDialog((DialogLike)dialog);
    }
}

