/*
 * Decompiled with CFR 0.152.
 */
package gd.rf.adrianvictor.stuff;

import gd.rf.adrianvictor.lib.Log;
import java.util.List;
import org.bukkit.event.player.PlayerChatEvent;
import org.bukkit.event.player.PlayerListener;
import org.bukkit.plugin.java.JavaPlugin;

public class SkibidiBlocker
extends PlayerListener {
    JavaPlugin plugin;
    Log logger;

    public SkibidiBlocker(JavaPlugin _plugin, Log _logger) {
        this.plugin = _plugin;
        this.logger = _logger;
    }

    public void onPlayerChat(PlayerChatEvent event) {
        String message = event.getMessage();
        List blockedWords = this.plugin.getConfiguration().getStringList("skibidiBlockerWords", null);
        if (blockedWords == null) {
            this.logger.warning("Blocked words list is null!");
            return;
        }
        if (blockedWords.isEmpty()) {
            this.logger.warning("Blocked words list is empty!");
            return;
        }
        boolean caseSensitive = this.plugin.getConfiguration().getBoolean("skibidiBlockerCaseSensitive", true);
        for (String blockedWord : blockedWords) {
            if (!caseSensitive) {
                if (!message.toLowerCase().contains(blockedWord.toLowerCase())) continue;
                this.logger.info(String.valueOf(event.getPlayer().getDisplayName()) + " said a blocked word (case insensitive).");
                event.getPlayer().getWorld().strikeLightning(event.getPlayer().getLocation());
                return;
            }
            if (!message.contains(blockedWord)) continue;
            this.logger.info(String.valueOf(event.getPlayer().getDisplayName()) + " said a blocked word (case sensitive).");
            event.getPlayer().getWorld().strikeLightning(event.getPlayer().getLocation());
            return;
        }
    }
}

