/*
 * Decompiled with CFR 0.152.
 */
package me.aov.sellgui;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import me.aov.sellgui.SellGUIMain;
import me.aov.sellgui.commands.SellCommand;
import me.aov.sellgui.handlers.SoundHandler;
import me.aov.sellgui.listeners.InventoryListeners;
import me.aov.sellgui.managers.ItemNBTManager;
import me.aov.sellgui.managers.PriceManager;
import me.aov.sellgui.utils.ColorUtils;
import me.aov.sellgui.utils.ItemIdentifier;
import net.brcdev.shopgui.ShopGuiPlusApi;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.ShulkerBox;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.permissions.PermissionAttachmentInfo;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class SellGUI
implements Listener {
    private final SellGUIMain main;
    private final Player player;
    private static ItemStack sellItem;
    private static ItemStack filler;
    private String menuTitle;
    private static Inventory menu;
    private ItemStack confirmItem;
    private ItemStack noItemsItemStack;
    private int sellItemSlot;
    private int updateTaskId = -1;
    private boolean isConfirmMode = false;
    private final ItemNBTManager itemNBTManager;

    public SellGUI(SellGUIMain main, Player p, ItemNBTManager itemNBTManager) {
        this.main = main;
        this.player = p;
        this.itemNBTManager = itemNBTManager;
        this.createItems();
        this.createMenu();
        this.addCustomItems();
        p.openInventory(menu);
        this.startAutoUpdateTask();
    }

    private void createMenu() {
        FileConfiguration guiConfig = this.main.getConfigManager() != null ? this.main.getConfigManager().getGUIConfig() : null;
        int size = 54;
        if (guiConfig != null) {
            size = guiConfig.getInt("sell_gui.size", 54);
        }
        menu = Bukkit.createInventory((InventoryHolder)null, (int)size, (String)this.color(this.menuTitle));
        this.addFillerFromConfig();
        this.addSellItem();
    }

    private boolean isSellItem(ItemStack item) {
        return this.item(item, sellItem);
    }

    private boolean item(ItemStack item, ItemStack sellItem) {
        if (item == null || item.getType() != sellItem.getType()) {
            return false;
        }
        ItemMeta meta1 = item.getItemMeta();
        ItemMeta meta2 = sellItem.getItemMeta();
        return !(meta1.hasDisplayName() != meta2.hasDisplayName() || meta1.hasDisplayName() && !meta1.getDisplayName().equals(meta2.getDisplayName()) || meta1.hasLore() != meta2.hasLore() || meta1.hasLore() && !meta1.getLore().equals(meta2.getLore()) || meta1.hasCustomModelData() != meta2.hasCustomModelData() || meta1.hasCustomModelData() && meta1.getCustomModelData() != meta2.getCustomModelData());
    }

    private boolean isConfirmItem(ItemStack item) {
        return this.item(item, this.confirmItem);
    }

    private boolean isFillerItem(ItemStack item) {
        if (item == null || item.getType() != filler.getType()) {
            return false;
        }
        ItemMeta meta1 = filler.getItemMeta();
        ItemMeta meta2 = filler.getItemMeta();
        return meta1.hasCustomModelData() == meta2.hasCustomModelData() && (!meta1.hasCustomModelData() || meta1.getCustomModelData() == meta2.getCustomModelData());
    }

    private void addCustomItems() {
        for (String itemPath : this.main.getCustomMenuItemsConfig().getKeys(false)) {
            ItemStack customItem = new ItemStack(Material.valueOf((String)this.main.getCustomMenuItemsConfig().getString(itemPath + ".material")));
            ItemMeta itemMeta = customItem.getItemMeta();
            if (this.main.getCustomMenuItemsConfig().contains(itemPath + ".custom-model-data")) {
                itemMeta.setCustomModelData(Integer.valueOf(this.main.getCustomMenuItemsConfig().getInt(itemPath + ".custom-model-data")));
            }
            if (!this.main.getCustomMenuItemsConfig().getString(itemPath + ".name").isEmpty()) {
                itemMeta.setDisplayName(this.color(this.main.getCustomMenuItemsConfig().getString(itemPath + ".name")));
            }
            if (this.main.getCustomMenuItemsConfig().getBoolean(itemPath + ".glimmer")) {
                itemMeta.addEnchant(Enchantment.INFINITY, 1, false);
                itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
            }
            if (!this.main.getCustomMenuItemsConfig().getStringList(itemPath + ".lore").isEmpty()) {
                itemMeta.setLore(this.color(this.main.getCustomMenuItemsConfig().getStringList(itemPath + ".lore")));
            }
            NamespacedKey key = new NamespacedKey((Plugin)this.main, "custom-menu-item");
            StringBuilder sb = new StringBuilder();
            for (String command : this.main.getCustomMenuItemsConfig().getStringList(itemPath + ".commands")) {
                sb.append(command.replaceAll("%player%", this.player.getName())).append(";");
            }
            itemMeta.getPersistentDataContainer().set(key, PersistentDataType.STRING, (Object)sb.toString());
            customItem.setItemMeta(itemMeta);
            menu.setItem(this.main.getCustomMenuItemsConfig().getInt(itemPath + ".slot"), customItem);
        }
    }

    public void addSellItem() {
        FileConfiguration guiConfig = this.main.getConfigManager() != null ? this.main.getConfigManager().getGUIConfig() : null;
        int slot = 49;
        if (guiConfig != null) {
            slot = guiConfig.getInt("sell_gui.positions.sell-button", 49);
        }
        int maxSlot = menu.getSize() - 1;
        if (slot < 0 || slot > maxSlot) {
            this.player.sendMessage(this.color("&cInvalid sell-item slot! It must be between 0 and " + maxSlot + "."));
            return;
        }
        menu.setItem(slot, sellItem);
        this.sellItemSlot = slot;
        this.makeConfirmItem();
    }

    private void startAutoUpdateTask() {
        if (this.updateTaskId != -1) {
            this.main.getServer().getScheduler().cancelTask(this.updateTaskId);
        }
        long updateInterval = this.main.getConfig().getLong("performance.gui-update-interval", 20L);
        this.updateTaskId = this.main.getServer().getScheduler().runTaskTimer((Plugin)this.main, () -> {
            if (menu != null && this.player != null && this.player.isOnline() && !this.isConfirmMode) {
                this.updateSellItemTotal();
            } else if (!(this.player.isOnline() && menu != null || this.updateTaskId == -1)) {
                this.main.getServer().getScheduler().cancelTask(this.updateTaskId);
                this.updateTaskId = -1;
            }
        }, 0L, updateInterval).getTaskId();
    }

    public void updateSellItemTotal() {
        if (menu == null || this.isConfirmMode) {
            return;
        }
        double currentTotal = this.getTotal(menu);
        if (currentTotal > 0.0) {
            if (sellItem == null) {
                return;
            }
            ItemMeta meta = sellItem.getItemMeta();
            if (meta != null && meta.hasLore()) {
                ArrayList<String> lore = new ArrayList<String>(meta.getLore());
                for (int i = 0; i < lore.size(); ++i) {
                    String line = (String)lore.get(i);
                    if (!ChatColor.stripColor((String)line).contains("Total Value:")) continue;
                    boolean roundPrices = this.main.shouldRoundPrices();
                    double displayedTotal = currentTotal;
                    if (roundPrices) {
                        displayedTotal = Math.round(currentTotal);
                    }
                    lore.set(i, this.color("&eTotal Value: &a$" + String.format("%.2f", displayedTotal)));
                    break;
                }
                meta.setLore(this.color(lore));
                sellItem.setItemMeta(meta);
                if (this.sellItemSlot >= 0 && this.sellItemSlot < menu.getSize()) {
                    menu.setItem(this.sellItemSlot, sellItem);
                }
            }
        } else if (this.noItemsItemStack != null && this.sellItemSlot >= 0 && this.sellItemSlot < menu.getSize()) {
            menu.setItem(this.sellItemSlot, this.noItemsItemStack);
        }
    }

    public void updateButtonState() {
        if (menu == null) {
            return;
        }
        double currentTotal = this.getTotal(menu);
        if (currentTotal > 0.0) {
            this.makeConfirmItem();
            menu.setItem(this.sellItemSlot, this.confirmItem);
            this.isConfirmMode = true;
        } else {
            menu.setItem(this.sellItemSlot, this.noItemsItemStack);
            this.isConfirmMode = false;
        }
    }

    private void right(String z) {
        if (z.equalsIgnoreCase("left")) {
            menu.setItem(menu.getSize() - 1, (ItemStack)null);
            menu.setItem(menu.getSize() - 1, sellItem);
            this.sellItemSlot = menu.getSize() - 1;
        } else if (z.equalsIgnoreCase("middle")) {
            menu.setItem(8 + 9 * menu.getSize() / 9 / 2, (ItemStack)null);
            menu.setItem(8 + 9 * menu.getSize() / 9 / 2, sellItem);
            this.sellItemSlot = 8 + 9 * menu.getSize() / 9 / 2;
        } else if (z.equalsIgnoreCase("right")) {
            menu.setItem(8, (ItemStack)null);
            menu.setItem(8, sellItem);
            this.sellItemSlot = 8;
        }
    }

    public void cleanup() {
        if (this.updateTaskId != -1) {
            this.main.getServer().getScheduler().cancelTask(this.updateTaskId);
            this.updateTaskId = -1;
        }
    }

    private void createItems() {
        if (this.menuTitle == null || sellItem == null || filler == null) {
            Material noItemsMaterial;
            ItemMeta fillerMeta;
            Material fillerMat;
            ItemMeta sellItemMeta;
            Material material;
            FileConfiguration guiConfig = this.main.getConfigManager() != null ? this.main.getConfigManager().getGUIConfig() : null;
            this.menuTitle = guiConfig != null ? guiConfig.getString("sell_gui.title", "&6&l\u2726 &eSell GUI &6&l\u2726") : "&6&l\u2726 &eSell GUI &6&l\u2726";
            NamespacedKey guiKey = new NamespacedKey((Plugin)this.main, "sellgui");
            NamespacedKey actionKey = new NamespacedKey((Plugin)this.main, "guiAction");
            String sellItemMaterial = "EMERALD";
            if (guiConfig != null) {
                sellItemMaterial = guiConfig.getString("sell_gui.items.sell_button.material", "EMERALD");
            }
            if ((material = Material.getMaterial((String)sellItemMaterial)) == null) {
                material = Material.EMERALD;
                this.main.getLogger().warning("Invalid sell-item material: " + sellItemMaterial + ", using EMERALD");
            }
            if ((sellItemMeta = (sellItem = new ItemStack(material)).getItemMeta()) != null) {
                int modelData;
                ArrayList<String> lore;
                String itemName = "&a&lSell Items";
                if (guiConfig != null) {
                    itemName = guiConfig.getString("sell_gui.items.sell_button.name", "&a&lSell Items");
                }
                sellItemMeta.setDisplayName(this.color(itemName));
                if (guiConfig != null) {
                    List configLore = guiConfig.getStringList("sell_gui.items.sell_button.lore");
                    if (configLore.isEmpty()) {
                        lore = new ArrayList();
                        lore.add("&7Click to sell all items");
                        lore.add("&7in this GUI");
                        lore.add("");
                        lore.add("&eTotal Value: &a$0.00");
                    } else {
                        lore = configLore;
                    }
                } else {
                    lore = new ArrayList<String>();
                    lore.add("&7Click to sell all items");
                }
                sellItemMeta.setLore(this.color(lore));
                boolean addGlow = false;
                if (guiConfig != null) {
                    addGlow = guiConfig.getBoolean("sell_gui.items.sell_button.glow", true);
                }
                if (addGlow) {
                    sellItemMeta.addEnchant(Enchantment.INFINITY, 1, false);
                    sellItemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
                }
                if (guiConfig != null && guiConfig.contains("sell_gui.items.sell_button.custom_model_data") && (modelData = guiConfig.getInt("sell_gui.items.sell_button.custom_model_data")) > 0) {
                    sellItemMeta.setCustomModelData(Integer.valueOf(modelData));
                }
                sellItemMeta.getPersistentDataContainer().set(guiKey, PersistentDataType.BYTE, (Object)1);
                sellItemMeta.getPersistentDataContainer().set(actionKey, PersistentDataType.STRING, (Object)"sell");
                sellItem.setItemMeta(sellItemMeta);
            }
            String fillerMaterial = "GRAY_STAINED_GLASS_PANE";
            if (guiConfig != null) {
                fillerMaterial = guiConfig.getString("sell_gui.items.filler.material", "GRAY_STAINED_GLASS_PANE");
            }
            if ((fillerMat = Material.getMaterial((String)fillerMaterial)) == null) {
                fillerMat = Material.GRAY_STAINED_GLASS_PANE;
                this.main.getLogger().warning("Invalid filler material: " + fillerMaterial + ", using GRAY_STAINED_GLASS_PANE");
            }
            if ((fillerMeta = (filler = new ItemStack(fillerMat)).getItemMeta()) != null) {
                int modelData;
                String fillerName = " ";
                if (guiConfig != null) {
                    fillerName = guiConfig.getString("sell_gui.items.filler.name", " ");
                }
                fillerMeta.setDisplayName(this.color(fillerName));
                if (guiConfig != null && guiConfig.contains("sell_gui.items.filler.custom_model_data") && (modelData = guiConfig.getInt("sell_gui.items.filler.custom_model_data")) > 0) {
                    fillerMeta.setCustomModelData(Integer.valueOf(modelData));
                }
                fillerMeta.getPersistentDataContainer().set(guiKey, PersistentDataType.BYTE, (Object)1);
                filler.setItemMeta(fillerMeta);
            }
            String noItemsMaterialName = "BARRIER";
            if (guiConfig != null) {
                noItemsMaterialName = guiConfig.getString("sell_gui.items.no_items.material", "BARRIER");
            }
            if ((noItemsMaterial = Material.getMaterial((String)noItemsMaterialName)) == null) {
                noItemsMaterial = Material.BARRIER;
                this.main.getLogger().warning("Invalid no_items material: " + noItemsMaterialName + ", using BARRIER");
            }
            this.noItemsItemStack = new ItemStack(noItemsMaterial);
            ItemMeta noItemsMeta = this.noItemsItemStack.getItemMeta();
            if (noItemsMeta != null) {
                int modelData;
                List<String> noItemLore;
                String noItemsName = "&cNo items to sell!";
                if (guiConfig != null) {
                    noItemsName = guiConfig.getString("sell_gui.items.no_items.name", "&cNo items to sell!");
                }
                noItemsMeta.setDisplayName(this.color(noItemsName));
                if (guiConfig != null && guiConfig.contains("sell_gui.items.no_items.lore")) {
                    noItemLore = guiConfig.getStringList("sell_gui.items.no_items.lore");
                } else {
                    noItemLore = new ArrayList<String>();
                    noItemLore.add("&7Place items in the GUI");
                    noItemLore.add("&7to sell them.");
                }
                noItemsMeta.setLore(this.color(noItemLore));
                if (guiConfig != null && guiConfig.contains("sell_gui.items.no_items.custom_model_data") && (modelData = guiConfig.getInt("sell_gui.items.no_items.custom_model_data")) > 0) {
                    noItemsMeta.setCustomModelData(Integer.valueOf(modelData));
                }
                noItemsMeta.getPersistentDataContainer().set(guiKey, PersistentDataType.BYTE, (Object)1);
                this.noItemsItemStack.setItemMeta(noItemsMeta);
            }
        }
    }

    private void addFillerFromConfig() {
        List fillerSlots;
        FileConfiguration guiConfig;
        FileConfiguration fileConfiguration = guiConfig = this.main.getConfigManager() != null ? this.main.getConfigManager().getGUIConfig() : null;
        if (guiConfig != null && !(fillerSlots = guiConfig.getIntegerList("sell_gui.positions.filler_slots")).isEmpty()) {
            Iterator iterator = fillerSlots.iterator();
            while (iterator.hasNext()) {
                int slot = (Integer)iterator.next();
                if (slot < 0 || slot >= menu.getSize()) continue;
                menu.setItem(slot, filler);
            }
            return;
        }
        this.addFiller("border");
    }

    private ItemStack createSystemItem(Material material, String name, List<String> lore) {
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            if (name != null) {
                meta.setDisplayName(this.color(name));
            }
            if (lore != null) {
                meta.setLore(this.color(lore));
            }
            meta.getPersistentDataContainer().set(new NamespacedKey((Plugin)SellGUIMain.getInstance(), "system_item"), PersistentDataType.INTEGER, (Object)1);
            item.setItemMeta(meta);
        }
        return item;
    }

    private void addFiller(String s) {
        block9: {
            int i;
            block12: {
                block11: {
                    block10: {
                        block8: {
                            if (!s.equalsIgnoreCase("bottom")) break block8;
                            for (int i2 = menu.getSize() - 9; i2 < menu.getSize(); ++i2) {
                                menu.setItem(i2, filler);
                            }
                            break block9;
                        }
                        if (!s.equalsIgnoreCase("left")) break block10;
                        for (int i3 = 0; i3 < menu.getSize(); i3 += 9) {
                            menu.setItem(i3, filler);
                        }
                        break block9;
                    }
                    if (!s.equalsIgnoreCase("right")) break block11;
                    for (int i4 = 8; i4 < menu.getSize(); i4 += 9) {
                        menu.setItem(i4, filler);
                    }
                    break block9;
                }
                if (!s.equalsIgnoreCase("top")) break block12;
                for (int i5 = 0; i5 < 9; ++i5) {
                    menu.setItem(i5, filler);
                }
                break block9;
            }
            if (!s.equalsIgnoreCase("round")) break block9;
            for (i = menu.getSize() - 9; i < menu.getSize(); ++i) {
                menu.setItem(i, filler);
            }
            for (i = 0; i < menu.getSize(); i += 9) {
                menu.setItem(i, filler);
            }
            for (i = 8; i < menu.getSize(); i += 9) {
                menu.setItem(i, filler);
            }
            for (i = 0; i < 9; ++i) {
                menu.setItem(i, filler);
            }
        }
    }

    public void makeConfirmItem() {
        Material material;
        FileConfiguration guiConfig = this.main.getConfigManager() != null ? this.main.getConfigManager().getGUIConfig() : null;
        String confirmMaterial = "GREEN_CONCRETE";
        if (guiConfig != null) {
            confirmMaterial = guiConfig.getString("sell_gui.items.confirm_button.material", "GREEN_CONCRETE");
        }
        if ((material = Material.getMaterial((String)confirmMaterial)) == null) {
            material = Material.GREEN_CONCRETE;
            this.main.getLogger().warning("Invalid confirm-item material: " + confirmMaterial + ", using GREEN_CONCRETE");
        }
        this.confirmItem = new ItemStack(material);
        ItemMeta itemMeta = this.confirmItem.getItemMeta();
        if (itemMeta != null) {
            int modelData;
            String itemName = "&a&lConfirm Sale";
            if (guiConfig != null) {
                itemName = guiConfig.getString("sell_gui.items.confirm_button.name", "&a&lConfirm Sale");
            }
            itemMeta.setDisplayName(this.color(itemName));
            boolean addGlow = false;
            if (guiConfig != null) {
                addGlow = guiConfig.getBoolean("sell_gui.items.confirm_button.glow", true);
            }
            if (addGlow) {
                itemMeta.addEnchant(Enchantment.POWER, 1, false);
                itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
            }
            itemMeta.setLore(this.makeLore());
            if (guiConfig != null && guiConfig.contains("sell_gui.items.confirm_button.custom_model_data") && (modelData = guiConfig.getInt("sell_gui.items.confirm_button.custom_model_data")) > 0) {
                itemMeta.setCustomModelData(Integer.valueOf(modelData));
            }
            NamespacedKey guiKey = new NamespacedKey((Plugin)this.main, "sellgui");
            NamespacedKey actionKey = new NamespacedKey((Plugin)this.main, "guiAction");
            itemMeta.getPersistentDataContainer().set(guiKey, PersistentDataType.BYTE, (Object)1);
            itemMeta.getPersistentDataContainer().set(actionKey, PersistentDataType.STRING, (Object)"confirm");
            this.confirmItem.setItemMeta(itemMeta);
        }
    }

    public ArrayList<String> makeLore() {
        HashMap<Object, Integer> itemCounts = new HashMap<Object, Integer>();
        HashMap<Object, Double> itemTotals = new HashMap<Object, Double>();
        HashMap<Object, Integer> itemsNeedingEvaluation = new HashMap<Object, Integer>();
        HashMap<String, String> itemDisplayNames = new HashMap<String, String>();
        ItemStack[] contents = this.getMenu().getContents();
        String calculationMethod = this.main.getConfig().getString("prices.calculation-method", "auto").toLowerCase();
        for (ItemStack item : contents) {
            boolean needsEvaluation;
            if (item == null || InventoryListeners.sellGUIItem(item, this.player) || this.isCustomMenuItem(item)) continue;
            Object itemIdentifierKey = ItemIdentifier.getItemIdentifier(item);
            String itemDisplayName = ItemIdentifier.getItemDisplayName(item);
            itemDisplayNames.put((String)itemIdentifierKey, itemDisplayName);
            boolean bl = needsEvaluation = this.main.getRandomPriceManager() != null && this.main.getRandomPriceManager().requiresEvaluation(item) && !this.main.getRandomPriceManager().isEvaluated(item);
            if (needsEvaluation) {
                itemsNeedingEvaluation.put(itemIdentifierKey, itemsNeedingEvaluation.getOrDefault(itemIdentifierKey, 0) + item.getAmount());
                continue;
            }
            double price = this.getPrice(item, this.player);
            if (!(price > 0.0)) continue;
            itemCounts.put(itemIdentifierKey, itemCounts.getOrDefault(itemIdentifierKey, 0) + item.getAmount());
            if (calculationMethod.equals("shopguiplus")) {
                itemTotals.put(itemIdentifierKey, itemTotals.getOrDefault(itemIdentifierKey, 0.0) + price);
                continue;
            }
            itemTotals.put(itemIdentifierKey, itemTotals.getOrDefault(itemIdentifierKey, 0.0) + price * (double)item.getAmount());
        }
        ArrayList<String> lore = new ArrayList<String>();
        FileConfiguration guiConfig = this.main.getConfigManager() != null ? this.main.getConfigManager().getGUIConfig() : null;
        String format = "&7%amount%x &f%item% &8= &e$%total%";
        if (guiConfig != null) {
            format = guiConfig.getString("sell_gui.item_total_format", format);
        }
        for (Object itemIdentifierKey : itemCounts.keySet()) {
            double total = (Double)itemTotals.get(itemIdentifierKey);
            int amount = (Integer)itemCounts.get(itemIdentifierKey);
            double averagePrice = amount > 0 ? total / (double)amount : 0.0;
            String displayedItemName = (String)itemDisplayNames.get(itemIdentifierKey);
            String formatted = format.replace("%item%", displayedItemName).replace("%amount%", String.valueOf(amount)).replace("%price%", String.valueOf(averagePrice)).replace("%total%", String.valueOf(total));
            lore.add(formatted);
            lore.add(" ");
        }
        String evaluationFormat = "&7%amount%x &f%item% &c\u26a0 Needs Evaluation";
        if (guiConfig != null) {
            evaluationFormat = guiConfig.getString("sell_gui.evaluation_required_format", evaluationFormat);
        }
        for (String itemIdentifierKey : itemsNeedingEvaluation.keySet()) {
            String displayedItemName = (String)itemDisplayNames.get(itemIdentifierKey);
            String formatted = evaluationFormat.replace("%item%", displayedItemName).replace("%amount%", String.valueOf(itemsNeedingEvaluation.get(itemIdentifierKey)));
            lore.add(formatted);
            lore.add(" ");
        }
        String totalFormat = "&6&lTotal: &e$%total%";
        if (guiConfig != null) {
            totalFormat = guiConfig.getString("sell_gui.total_format", totalFormat);
        }
        String totalFormatted = totalFormat.replace("%total%", String.valueOf(this.getTotal(menu)));
        lore.add(totalFormatted);
        if (!itemsNeedingEvaluation.isEmpty()) {
            lore.add("");
            lore.add(this.color("&c\u26a0 Some items need evaluation"));
            lore.add(this.color("&7Use /sellgui evaluate"));
        }
        return (ArrayList)this.color(lore);
    }

    public boolean hasUnevaluatedItems() {
        if (this.main.getRandomPriceManager() == null) {
            return false;
        }
        for (ItemStack item : this.getMenu().getContents()) {
            if (item == null || this.isCustomMenuItem(item) || InventoryListeners.sellGUIItem(item, this.player) || !this.main.getRandomPriceManager().requiresEvaluation(item) || this.main.getRandomPriceManager().isEvaluated(item)) continue;
            return true;
        }
        return false;
    }

    public void setConfirmItem() {
        menu.setItem(this.sellItemSlot, (ItemStack)null);
        menu.setItem(this.sellItemSlot, this.confirmItem);
        this.isConfirmMode = true;
    }

    public void setSellItem() {
        menu.setItem(this.sellItemSlot, (ItemStack)null);
        menu.setItem(this.sellItemSlot, sellItem);
        this.isConfirmMode = false;
    }

    public double getPrice(ItemStack itemStack, @Nullable Player player) {
        double totalPrice;
        PriceManager priceManager;
        ItemMeta meta;
        BlockStateMeta meta2;
        double contentsPrice = 0.0;
        if (itemStack == null || itemStack.getType() == Material.AIR) {
            return 0.0;
        }
        if (itemStack.getType().name().endsWith("_SHULKER_BOX") && itemStack.hasItemMeta() && itemStack.getItemMeta() instanceof BlockStateMeta && (meta2 = (BlockStateMeta)itemStack.getItemMeta()).getBlockState() instanceof ShulkerBox) {
            ShulkerBox shulker = (ShulkerBox)meta2.getBlockState();
            String calculationMethod = this.main.getConfig().getString("prices.calculation-method", "auto").toLowerCase();
            for (ItemStack contained : shulker.getInventory().getContents()) {
                if (contained == null || contained.getType().isAir()) continue;
                double price = this.getPrice(contained, player);
                if (calculationMethod.equals("shopguiplus")) {
                    contentsPrice += price;
                    continue;
                }
                contentsPrice += price * (double)contained.getAmount();
            }
        }
        double itemPrice = 0.0;
        ItemStack itemToPrice = itemStack;
        if (itemStack.getType().name().endsWith("_SHULKER_BOX")) {
            itemToPrice = itemStack.clone();
            itemToPrice.setAmount(1);
        }
        if (itemToPrice.hasItemMeta() && (meta = itemToPrice.getItemMeta()) != null) {
            NamespacedKey key = new NamespacedKey((Plugin)this.main, "current_price");
            if (meta.getPersistentDataContainer().has(key, PersistentDataType.DOUBLE)) {
                itemPrice = (Double)meta.getPersistentDataContainer().get(key, PersistentDataType.DOUBLE);
            }
        }
        if (itemPrice == 0.0 && (itemPrice = (priceManager = new PriceManager(this.main)).getItemPriceWithPlayer(itemToPrice, player)) == 0.0) {
            double essentialsPrice;
            if (this.main.hasEssentials() && this.main.getConfig().getBoolean("use-essentials-price") && (essentialsPrice = SellGUI.round(this.main.getEssentialsHolder().getPrice(itemToPrice).doubleValue(), this.main.getConfig().getInt("places-to-round"))) > 0.0) {
                itemPrice = essentialsPrice;
            }
            if (itemPrice == 0.0 && this.main.getItemPricesConfig().contains(itemToPrice.getType().name())) {
                itemPrice = this.main.getItemPricesConfig().getDouble(itemToPrice.getType().name());
            }
        }
        if (itemPrice == 0.0 && player != null && this.main.getServer().getPluginManager().getPlugin("ShopGuiPlus") != null && this.main.getServer().getPluginManager().getPlugin("ShopGuiPlus").isEnabled()) {
            try {
                double shopGuiPrice = ShopGuiPlusApi.getItemStackPriceSell((Player)player, (ItemStack)itemToPrice);
                if (shopGuiPrice > 0.0) {
                    itemPrice = shopGuiPrice;
                }
            }
            catch (NoClassDefFoundError e) {
                this.main.getLogger().warning("ShopGuiPlusApi class not found, skipping ShopGuiPlus pricing. Error: " + e.getMessage());
            }
            catch (Exception e) {
                this.main.getLogger().warning("An error occurred while getting price from ShopGuiPlus: " + e.getMessage());
            }
        }
        if (itemPrice == 0.0 && this.main instanceof SellGUIMain) {
            Object rpm = null;
            try {
                rpm = ((Object)((Object)this.main)).getClass().getMethod("getRandomPriceManager", new Class[0]).invoke((Object)this.main, new Object[0]);
            }
            catch (Exception essentialsPrice) {
                // empty catch block
            }
            if (rpm != null) {
                try {
                    boolean canSell = (Boolean)rpm.getClass().getMethod("canBeSold", ItemStack.class).invoke(rpm, itemToPrice);
                    if (!canSell) {
                        itemPrice = 0.0;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if ((totalPrice = contentsPrice + itemPrice) > 0.0) {
            totalPrice = this.applyPermissionBonuses(player, totalPrice);
        }
        return SellGUI.round(totalPrice, this.main.getConfig().getInt("places-to-round"));
    }

    private double applyPermissionBonuses(Player player, double price) {
        if (player == null || price <= 0.0) {
            return price;
        }
        double bonusPercent = 0.0;
        double multiplier = 1.0;
        for (PermissionAttachmentInfo pai : player.getEffectivePermissions()) {
            if (pai.getPermission().startsWith("sellgui.bonus.") && pai.getValue()) {
                double percent = Double.parseDouble(pai.getPermission().replace("sellgui.bonus.", ""));
                bonusPercent += percent;
            }
            if (!pai.getPermission().startsWith("sellgui.multiplier.") || !pai.getValue()) continue;
            multiplier *= Double.parseDouble(pai.getPermission().replace("sellgui.multiplier.", ""));
        }
        price = price * (1.0 + bonusPercent / 100.0) * multiplier;
        return price;
    }

    public double getTotal(Inventory inventory) {
        double total = 0.0;
        String calculationMethod = this.main.getConfig().getString("prices.calculation-method", "auto").toLowerCase();
        for (ItemStack itemStack : inventory.getContents()) {
            double price;
            boolean canSell;
            if (itemStack == null || itemStack.getType().isAir() || this.isCustomMenuItem(itemStack) || InventoryListeners.sellGUIItem(itemStack, this.player)) continue;
            boolean bl = canSell = this.main.getRandomPriceManager() == null || this.main.getRandomPriceManager().canBeSold(itemStack);
            if (!canSell || this.main.getRandomPriceManager() != null && this.main.getRandomPriceManager().hasRandomPrice(itemStack) && !this.main.getRandomPriceManager().isEvaluated(itemStack) || !((price = this.getPrice(itemStack, this.player)) > 0.0)) continue;
            if (calculationMethod.equals("shopguiplus")) {
                total += price;
                continue;
            }
            total += price * (double)itemStack.getAmount();
        }
        return total;
    }

    private boolean isCustomMenuItem(ItemStack item) {
        if (item == null || !item.hasItemMeta()) {
            return false;
        }
        return item.getItemMeta().getPersistentDataContainer().has(new NamespacedKey((Plugin)this.main, "custom-menu-item"), PersistentDataType.STRING);
    }

    public void logSell(ItemStack itemStack) {
        if (itemStack != null) {
            try (BufferedWriter writer = new BufferedWriter(new FileWriter(this.getMain().getLog(), true));){
                Date now = new Date();
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                ItemIdentifier.ItemType itemTypeEnum = ItemIdentifier.getItemType(itemStack);
                String itemType = itemTypeEnum.name();
                String itemId = ItemIdentifier.getItemIdentifier(itemStack);
                String displayName = ChatColor.stripColor((String)ItemIdentifier.getItemDisplayName(itemStack));
                double unitPrice = this.getPrice(itemStack, this.player);
                String calculationMethod = this.getMain().getConfig().getString("prices.calculation-method", "auto").toLowerCase();
                double totalPrice = calculationMethod.equals("shopguiplus") ? unitPrice : unitPrice * (double)itemStack.getAmount();
                String playerName = this.getPlayer().getName();
                String logEntry = String.format("[SELLGUI] %s|%s|%s|%d|%.2f|%.2f|%s|%s", itemType, itemId, displayName, itemStack.getAmount(), unitPrice, totalPrice, playerName, format.format(now));
                writer.append(logEntry + " ");
                writer.flush();
            }
            catch (IOException e) {
                this.getMain().getLogger().severe("Failed to write to sell log: " + e.getMessage());
                e.printStackTrace();
            }
        }
    }

    public void sellItems(Inventory inventory) {
        boolean hasRandomPriceNotEvaluated = false;
        for (ItemStack itemStack : inventory.getContents()) {
            if (itemStack == null || itemStack.getType().isAir() || this.isCustomMenuItem(itemStack) || InventoryListeners.sellGUIItem(itemStack, this.player) || this.main.getRandomPriceManager() == null || !this.main.getRandomPriceManager().hasRandomPrice(itemStack) || this.main.getRandomPriceManager().isEvaluated(itemStack)) continue;
            hasRandomPriceNotEvaluated = true;
            break;
        }
        if (hasRandomPriceNotEvaluated) {
            String message = this.main.getMessagesConfig().getString("sell.evaluation_required", "&cSome items must be evaluated before selling.");
            this.player.sendMessage(this.color(message));
            this.setSellItem();
            return;
        }
        double total = this.getTotal(inventory);
        if (total <= 0.0) {
            String message = this.main.getMessagesConfig().getString("sell.no_items", "&cNothing to sell!");
            this.player.sendMessage(this.color(message));
            this.setSellItem();
            return;
        }
        this.main.getEcon().depositPlayer((OfflinePlayer)this.player, total);
        for (ItemStack item : inventory.getContents()) {
            boolean needsEvaluation;
            if (item == null || InventoryListeners.sellGUIItem(item, this.player) || this.isCustomMenuItem(item)) continue;
            boolean bl = needsEvaluation = this.main.getRandomPriceManager() != null && this.main.getRandomPriceManager().hasRandomPrice(item) && !this.main.getRandomPriceManager().isEvaluated(item);
            if (needsEvaluation || !(this.getPrice(item, this.player) > 0.0)) continue;
            if (this.main.getConfig().getBoolean("logging.enabled")) {
                this.logSell(item);
            }
            inventory.remove(item);
        }
        if (this.main.getConfig().getBoolean("general.close-after-sell")) {
            this.player.closeInventory();
            SellCommand.getSellGUIs().remove(this);
        } else {
            this.setSellItem();
            this.updateSellItemTotal();
        }
        String soldMessage = "&a\u2705 Sold items for &e$%total%!";
        if (this.main.getMessagesConfig() != null) {
            soldMessage = this.main.getMessagesConfig().getString("sell.sold_success", soldMessage);
        }
        this.player.sendMessage(this.color(soldMessage.replace("%total%", String.format("%.2f", total))));
        SoundHandler.playConfigSound(this.player, "sounds.feedback.success");
    }

    public ItemStack getConfirmItem() {
        return this.confirmItem;
    }

    public Player getPlayer() {
        return this.player;
    }

    public static ItemStack getSellItem() {
        return sellItem;
    }

    public static ItemStack getFiller() {
        return filler;
    }

    public String getMenuTitle() {
        return this.menuTitle;
    }

    public Inventory getMenu() {
        return menu;
    }

    public SellGUIMain getMain() {
        return this.main;
    }

    public String color(String s) {
        if (s == null) {
            return "";
        }
        if (this.main.isPlaceholderAPIAvailable()) {
            s = this.main.setPlaceholders(this.player, s);
        }
        return ColorUtils.color(s);
    }

    public List<String> color(List<String> lore) {
        if (lore == null) {
            return new ArrayList<String>();
        }
        return lore.stream().map(this::color).collect(Collectors.toList());
    }

    public static double round(double value, int places) {
        if (places < 0) {
            throw new IllegalArgumentException();
        }
        BigDecimal bd = new BigDecimal("" + value);
        bd = bd.setScale(places, RoundingMode.HALF_UP);
        return bd.doubleValue();
    }

    public static double round(String value, int places) {
        if (places < 0) {
            throw new IllegalArgumentException();
        }
        BigDecimal bd = new BigDecimal(value);
        bd = bd.setScale(places, RoundingMode.HALF_UP);
        return bd.doubleValue();
    }

    public static String roundString(String value, int places) {
        if (places < 0) {
            throw new IllegalArgumentException();
        }
        BigDecimal bd = new BigDecimal(value);
        bd = bd.setScale(places, RoundingMode.HALF_UP);
        return bd.toPlainString();
    }
}

