/*
 * Decompiled with CFR 0.152.
 */
package me.aov.sellgui;

import java.math.BigDecimal;
import java.math.RoundingMode;
import javax.annotation.Nullable;
import me.aov.sellgui.SellGUI;
import me.aov.sellgui.SellGUIMain;
import me.aov.sellgui.commands.SellCommand;
import me.aov.sellgui.managers.PriceManager;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.permissions.PermissionAttachmentInfo;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class SellGUIAPI {
    private SellGUIMain main;

    public SellGUIAPI(SellGUIMain sellGUIMain) {
        this.main = sellGUIMain;
    }

    public double getPrice(ItemStack itemStack, @Nullable Player player) {
        PriceManager priceManager;
        ItemMeta meta;
        if (itemStack == null || itemStack.getType() == Material.AIR) {
            return 0.0;
        }
        double price = 0.0;
        if (itemStack.hasItemMeta() && (meta = itemStack.getItemMeta()) != null) {
            NamespacedKey key = new NamespacedKey((Plugin)this.main, "current_price");
            if (meta.getPersistentDataContainer().has(key, PersistentDataType.DOUBLE)) {
                price = (Double)meta.getPersistentDataContainer().get(key, PersistentDataType.DOUBLE);
            }
        }
        if (price == 0.0 && (price = (priceManager = new PriceManager(this.main)).getItemPrice(itemStack)) == 0.0) {
            double essentialsPrice;
            BigDecimal essentialsPriceBd;
            if (this.main.hasEssentials() && this.main.getConfig().getBoolean("use-essentials-price") && this.main.getEssentialsHolder() != null && this.main.getEssentialsHolder().getEssentials() != null && (essentialsPriceBd = this.main.getEssentialsHolder().getPrice(itemStack)) != null && (essentialsPrice = SellGUIAPI.round(essentialsPriceBd.doubleValue(), this.main.getConfig().getInt("places-to-round", 2))) > 0.0) {
                price = essentialsPrice;
            }
            if (price == 0.0 && this.main.getItemPricesConfig() != null && this.main.getItemPricesConfig().contains(itemStack.getType().name())) {
                price = this.main.getItemPricesConfig().getDouble(itemStack.getType().name());
            }
        }
        if (price > 0.0) {
            return this.applyPlayerBonuses(price, player);
        }
        return SellGUIAPI.round(price, this.main.getConfig().getInt("places-to-round", 2));
    }

    private double applyPlayerBonuses(double price, @Nullable Player player) {
        if (player == null || price <= 0.0) {
            return SellGUIAPI.round(price, this.main.getConfig().getInt("places-to-round", 2));
        }
        for (PermissionAttachmentInfo pai : player.getEffectivePermissions()) {
            String perm = pai.getPermission();
            if (!pai.getValue()) continue;
            if (perm.startsWith("sellgui.bonus.")) {
                try {
                    double bonusValue = Double.parseDouble(perm.substring("sellgui.bonus.".length()));
                    price += bonusValue;
                }
                catch (IndexOutOfBoundsException | NumberFormatException bonusValue) {}
                continue;
            }
            if (!perm.startsWith("sellgui.multiplier.")) continue;
            try {
                double multiplierValue = Double.parseDouble(perm.substring("sellgui.multiplier.".length()));
                if (!(multiplierValue > 0.0)) continue;
                price *= multiplierValue;
            }
            catch (IndexOutOfBoundsException | NumberFormatException runtimeException) {}
        }
        return SellGUIAPI.round(price, this.main.getConfig().getInt("places-to-round", 2));
    }

    public double getPurePrice(ItemStack itemStack) {
        double price = 0.0;
        if (itemStack != null && itemStack.getType() != Material.AIR && this.main.getItemPricesConfig() != null && this.main.getItemPricesConfig().contains(itemStack.getType().name())) {
            price = this.main.getItemPricesConfig().getDouble(itemStack.getType().name());
        }
        return price;
    }

    public void openSellGUI(Player player) {
        SellCommand.getSellGUIs().add(new SellGUI(this.main, player, this.main.getItemNBTManager()));
    }

    private static double round(double value, int places) {
        if (places < 0) {
            return value;
        }
        if (Double.isNaN(value) || Double.isInfinite(value)) {
            return 0.0;
        }
        try {
            BigDecimal bd = BigDecimal.valueOf(value);
            bd = bd.setScale(places, RoundingMode.HALF_UP);
            return bd.doubleValue();
        }
        catch (NumberFormatException e) {
            return value;
        }
    }
}

