/*
 * Decompiled with CFR 0.152.
 */
package me.aov.sellgui.gui;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import me.aov.sellgui.SellGUIMain;
import me.aov.sellgui.gui.PriceEvaluationGUI;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;

public class GUIManager {
    private final SellGUIMain plugin;
    private final Map<UUID, PriceEvaluationGUI> activeEvaluationGUIs = new HashMap<UUID, PriceEvaluationGUI>();

    public GUIManager(SellGUIMain plugin) {
        this.plugin = plugin;
    }

    public void openPriceEvaluationGUI(Player player) {
        if (this.activeEvaluationGUIs.containsKey(player.getUniqueId())) {
            player.closeInventory();
        }
        PriceEvaluationGUI gui = new PriceEvaluationGUI(this.plugin, player, this.plugin.getNBTPriceManager());
        this.activeEvaluationGUIs.put(player.getUniqueId(), gui);
        player.openInventory(gui.getInventory());
    }

    public PriceEvaluationGUI getActivePriceEvaluationGUI(Player player) {
        return this.activeEvaluationGUIs.get(player.getUniqueId());
    }

    public PriceEvaluationGUI getActivePriceEvaluationGUI(Inventory inventory) {
        for (PriceEvaluationGUI gui : this.activeEvaluationGUIs.values()) {
            if (!gui.getInventory().equals((Object)inventory)) continue;
            return gui;
        }
        return null;
    }

    public void removePlayer(Player player) {
        this.activeEvaluationGUIs.remove(player.getUniqueId());
    }

    public void reload() {
        for (UUID playerUUID : Set.copyOf(this.activeEvaluationGUIs.keySet())) {
            Player player = this.plugin.getServer().getPlayer(playerUUID);
            if (player == null || !(player.getOpenInventory().getTopInventory().getHolder() instanceof PriceEvaluationGUI)) continue;
            player.closeInventory();
        }
        this.activeEvaluationGUIs.clear();
    }
}

