/*
 * Decompiled with CFR 0.152.
 */
package me.aov.sellgui.managers;

import io.lumine.mythic.lib.api.item.NBTItem;
import me.aov.sellgui.managers.ItemNBTManager;
import org.bukkit.inventory.ItemStack;

public class MythicLibNBTManager
implements ItemNBTManager {
    private static final String SELL_PRICE_TAG = "sellPrice";
    private static final String NEEDS_EVALUATION_TAG = "needsEvaluation";

    @Override
    public double getSellPrice(ItemStack item) {
        if (item == null || item.getItemMeta() == null) {
            return 0.0;
        }
        NBTItem nbtItem = NBTItem.get((ItemStack)item);
        return nbtItem.getDouble(SELL_PRICE_TAG);
    }

    @Override
    public void setSellPrice(ItemStack item, double price) {
        if (item == null || item.getItemMeta() == null) {
            return;
        }
        NBTItem nbtItem = NBTItem.get((ItemStack)item);
        nbtItem.setDouble(SELL_PRICE_TAG, price);
    }

    @Override
    public boolean needsEvaluation(ItemStack item) {
        if (item == null || item.getItemMeta() == null) {
            return false;
        }
        NBTItem nbtItem = NBTItem.get((ItemStack)item);
        return nbtItem.getBoolean(NEEDS_EVALUATION_TAG);
    }

    @Override
    public void setNeedsEvaluation(ItemStack item, boolean needsEvaluation) {
        if (item == null || item.getItemMeta() == null) {
            return;
        }
        NBTItem nbtItem = NBTItem.get((ItemStack)item);
        nbtItem.setBoolean(NEEDS_EVALUATION_TAG, needsEvaluation);
    }

    @Override
    public String getItemName(ItemStack item) {
        if (item == null) {
            return "Unknown Item";
        }
        if (item.hasItemMeta() && item.getItemMeta().hasDisplayName()) {
            return item.getItemMeta().getDisplayName();
        }
        return item.getType().name().replace("_", " ").toLowerCase();
    }
}

