/*
 * Decompiled with CFR 0.152.
 */
package me.aov.sellgui.managers;

import io.lumine.mythic.lib.api.item.ItemTag;
import io.lumine.mythic.lib.api.item.NBTItem;
import java.util.ArrayList;
import java.util.Random;
import me.aov.sellgui.SellGUIMain;
import org.bukkit.ChatColor;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class NBTPriceManager {
    private final SellGUIMain main;
    private final Random random;
    private static final String PRICE_NBT_KEY = "sellgui:price";
    private static final String PRICE_TYPE_NBT_KEY = "sellgui:price_type";
    private static final String PRICE_TYPE_FIXED = "FIXED";
    private static final String PRICE_TYPE_RANDOM = "RANDOM";

    public NBTPriceManager(SellGUIMain main) {
        this.main = main;
        this.random = new Random();
    }

    public ItemStack setFixedPrice(ItemStack itemStack, double price) {
        if (itemStack == null) {
            return itemStack;
        }
        try {
            NBTItem nbtItem = NBTItem.get((ItemStack)itemStack);
            nbtItem.addTag(new ItemTag[]{new ItemTag(PRICE_NBT_KEY, (Object)price)});
            nbtItem.addTag(new ItemTag[]{new ItemTag(PRICE_TYPE_NBT_KEY, (Object)PRICE_TYPE_FIXED)});
            ItemStack result = nbtItem.toItem();
            return this.updateWorthLore(result, price);
        }
        catch (Exception e) {
            this.main.getLogger().warning("Failed to set fixed price: " + e.getMessage());
            return itemStack;
        }
    }

    public ItemStack setRandomPrice(ItemStack itemStack, double minPrice, double maxPrice) {
        if (itemStack == null) {
            return itemStack;
        }
        try {
            double finalPrice = this.calculateRandomPrice(minPrice, maxPrice);
            NBTItem nbtItem = NBTItem.get((ItemStack)itemStack);
            nbtItem.addTag(new ItemTag[]{new ItemTag(PRICE_NBT_KEY, (Object)finalPrice)});
            nbtItem.addTag(new ItemTag[]{new ItemTag(PRICE_TYPE_NBT_KEY, (Object)PRICE_TYPE_RANDOM)});
            nbtItem.addTag(new ItemTag[]{new ItemTag("sellgui:min_price", (Object)minPrice)});
            nbtItem.addTag(new ItemTag[]{new ItemTag("sellgui:max_price", (Object)maxPrice)});
            ItemStack result = nbtItem.toItem();
            return this.updateWorthLore(result, finalPrice);
        }
        catch (Exception e) {
            this.main.getLogger().warning("Failed to set random price: " + e.getMessage());
            return itemStack;
        }
    }

    private double calculateRandomPrice(double minPrice, double maxPrice) {
        if (minPrice >= maxPrice) {
            return minPrice;
        }
        return minPrice + this.random.nextDouble() * (maxPrice - minPrice);
    }

    public double getPriceFromNBT(ItemStack itemStack) {
        if (itemStack == null) {
            return 0.0;
        }
        try {
            NBTItem nbtItem = NBTItem.get((ItemStack)itemStack);
            if (nbtItem.hasTag(PRICE_NBT_KEY)) {
                return nbtItem.getDouble(PRICE_NBT_KEY);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0.0;
    }

    public boolean hasNBTPrice(ItemStack itemStack) {
        if (itemStack == null) {
            return false;
        }
        try {
            NBTItem nbtItem = NBTItem.get((ItemStack)itemStack);
            return nbtItem.hasTag(PRICE_NBT_KEY);
        }
        catch (Exception e) {
            return false;
        }
    }

    public String getPriceType(ItemStack itemStack) {
        if (itemStack == null) {
            return null;
        }
        try {
            NBTItem nbtItem = NBTItem.get((ItemStack)itemStack);
            if (nbtItem.hasTag(PRICE_TYPE_NBT_KEY)) {
                return nbtItem.getString(PRICE_TYPE_NBT_KEY);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private ItemStack updateWorthLore(ItemStack itemStack, double price) {
        if (itemStack == null || !itemStack.hasItemMeta()) {
            return itemStack;
        }
        ItemMeta meta = itemStack.getItemMeta();
        ArrayList<Object> lore = meta.hasLore() ? new ArrayList<Object>(meta.getLore()) : new ArrayList();
        lore.removeIf(line -> ChatColor.stripColor((String)line).startsWith("Worth:"));
        String worthLine = String.valueOf(ChatColor.GOLD) + "Worth: " + String.valueOf(ChatColor.GREEN) + "$" + String.format("%.2f", price);
        lore.add(worthLine);
        meta.setLore(lore);
        itemStack.setItemMeta(meta);
        return itemStack;
    }

    public ItemStack removePricing(ItemStack itemStack) {
        if (itemStack == null) {
            return itemStack;
        }
        try {
            ItemMeta meta;
            NBTItem nbtItem = NBTItem.get((ItemStack)itemStack);
            nbtItem.removeTag(new String[]{PRICE_NBT_KEY});
            nbtItem.removeTag(new String[]{PRICE_TYPE_NBT_KEY});
            nbtItem.removeTag(new String[]{"sellgui:min_price"});
            nbtItem.removeTag(new String[]{"sellgui:max_price"});
            ItemStack result = nbtItem.toItem();
            if (result.hasItemMeta() && (meta = result.getItemMeta()).hasLore()) {
                ArrayList<String> lore = new ArrayList<String>(meta.getLore());
                lore.removeIf(line -> ChatColor.stripColor((String)line).startsWith("Worth:"));
                meta.setLore(lore);
                result.setItemMeta(meta);
            }
            return result;
        }
        catch (Exception e) {
            this.main.getLogger().warning("Failed to remove pricing: " + e.getMessage());
            return itemStack;
        }
    }

    public double[] getRandomPriceRange(ItemStack itemStack) {
        if (itemStack == null) {
            return null;
        }
        try {
            NBTItem nbtItem = NBTItem.get((ItemStack)itemStack);
            if (nbtItem.hasTag("sellgui:min_price") && nbtItem.hasTag("sellgui:max_price")) {
                return new double[]{nbtItem.getDouble("sellgui:min_price"), nbtItem.getDouble("sellgui:max_price")};
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public boolean isAvailable() {
        try {
            Class.forName("io.lumine.mythic.lib.api.item.NBTItem");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public ItemStack regenerateRandomPrice(ItemStack itemStack) {
        if (itemStack == null) {
            return itemStack;
        }
        double[] range = this.getRandomPriceRange(itemStack);
        if (range != null) {
            return this.setRandomPrice(itemStack, range[0], range[1]);
        }
        return itemStack;
    }
}

