/*
 * Decompiled with CFR 0.152.
 */
package me.aov.sellgui.managers;

import me.aov.sellgui.SellGUIMain;
import me.aov.sellgui.managers.ItemNBTManager;
import org.apache.commons.lang.WordUtils;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class PersistentDataNBTManager
implements ItemNBTManager {
    private final NamespacedKey sellPriceKey;
    private final NamespacedKey needsEvaluationKey;

    public PersistentDataNBTManager(SellGUIMain plugin) {
        this.sellPriceKey = new NamespacedKey((Plugin)plugin, "sellgui_sell_price");
        this.needsEvaluationKey = new NamespacedKey((Plugin)plugin, "sellgui_needs_evaluation");
    }

    @Override
    public double getSellPrice(ItemStack item) {
        if (item == null || item.getType().isAir() || !item.hasItemMeta()) {
            return 0.0;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta != null && meta.getPersistentDataContainer().has(this.sellPriceKey, PersistentDataType.DOUBLE)) {
            return (Double)meta.getPersistentDataContainer().get(this.sellPriceKey, PersistentDataType.DOUBLE);
        }
        return 0.0;
    }

    @Override
    public void setSellPrice(ItemStack item, double price) {
        if (item == null || item.getType().isAir() || !item.hasItemMeta()) {
            return;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.getPersistentDataContainer().set(this.sellPriceKey, PersistentDataType.DOUBLE, (Object)price);
            item.setItemMeta(meta);
        }
    }

    @Override
    public boolean needsEvaluation(ItemStack item) {
        if (item == null || item.getType().isAir() || !item.hasItemMeta()) {
            return false;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta != null && meta.getPersistentDataContainer().has(this.needsEvaluationKey, PersistentDataType.BOOLEAN)) {
            return (Boolean)meta.getPersistentDataContainer().get(this.needsEvaluationKey, PersistentDataType.BOOLEAN);
        }
        return false;
    }

    @Override
    public void setNeedsEvaluation(ItemStack item, boolean needsEvaluation) {
        if (item == null || item.getType().isAir() || !item.hasItemMeta()) {
            return;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.getPersistentDataContainer().set(this.needsEvaluationKey, PersistentDataType.BOOLEAN, (Object)needsEvaluation);
            item.setItemMeta(meta);
        }
    }

    @Override
    public String getItemName(ItemStack item) {
        if (item == null) {
            return "Unknown Item";
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return WordUtils.capitalizeFully((String)item.getType().name().replace('_', ' '));
        }
        if (meta.hasDisplayName()) {
            return meta.getDisplayName();
        }
        if (meta.hasItemName()) {
            return meta.getItemName();
        }
        return WordUtils.capitalizeFully((String)item.getType().name().replace('_', ' '));
    }
}

