/*
 * Decompiled with CFR 0.152.
 */
package me.aov.sellgui.listeners;

import me.aov.sellgui.SellGUIMain;
import me.aov.sellgui.gui.PriceEvaluationGUI;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class PriceEvaluationListener
implements Listener {
    private final SellGUIMain main;

    public PriceEvaluationListener(SellGUIMain main) {
        this.main = main;
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        PriceEvaluationGUI gui = this.main.getGUIManager().getActivePriceEvaluationGUI(player);
        if (gui == null || !event.getInventory().equals((Object)gui.getInventory())) {
            return;
        }
        int slot = event.getRawSlot();
        if (slot >= gui.getInventory().getSize()) {
            return;
        }
        if (gui.isLocked()) {
            event.setCancelled(true);
            player.sendMessage("\u00a7cEvaluation in progress! Please wait...");
            return;
        }
        if (slot == gui.getItemSlot()) {
            return;
        }
        event.setCancelled(true);
        ItemStack clickedItem = event.getCurrentItem();
        if (clickedItem == null || !clickedItem.hasItemMeta()) {
            return;
        }
        ItemMeta meta = clickedItem.getItemMeta();
        NamespacedKey key = new NamespacedKey((Plugin)this.main, "sellgui-nbt-id");
        if (meta.getPersistentDataContainer().has(key, PersistentDataType.STRING)) {
            String nbtId = (String)meta.getPersistentDataContainer().get(key, PersistentDataType.STRING);
            this.handleButtonClick(player, gui, nbtId);
        }
    }

    private void handleButtonClick(Player player, PriceEvaluationGUI gui, String nbtId) {
        if (nbtId == null) {
            return;
        }
        switch (nbtId) {
            case "evaluate_button": {
                gui.startEvaluation();
                break;
            }
            case "cancel_button": {
                player.closeInventory();
            }
        }
    }

    @EventHandler
    public void onInventoryDrag(InventoryDragEvent event) {
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        PriceEvaluationGUI gui = this.main.getGUIManager().getActivePriceEvaluationGUI(player);
        if (gui == null || !event.getInventory().equals((Object)gui.getInventory())) {
            return;
        }
        if (gui.isLocked()) {
            event.setCancelled(true);
            return;
        }
        boolean allowStack = this.main.getConfigManager().getConfig("config").getBoolean("general.allow-player-evaluation-stack", true);
        if (event.getRawSlots().contains(gui.getItemSlot())) {
            event.setCancelled(true);
            ItemStack currentItemInSlot = gui.getInventory().getItem(gui.getItemSlot());
            if (currentItemInSlot != null && currentItemInSlot.getType() != Material.AIR) {
                return;
            }
            ItemStack draggedStack = event.getOldCursor();
            if (draggedStack != null && draggedStack.getType() != Material.AIR) {
                if (!allowStack && draggedStack.getAmount() > 1) {
                    String errorMessage = this.main.getConfigManager().getConfig("messages").getString("price-evaluation.drag-stack-not-allowed", "&cYou can't Evaluate more than 1 amount at a time.");
                    player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)errorMessage));
                    return;
                }
                gui.getInventory().setItem(gui.getItemSlot(), draggedStack.clone());
                player.setItemOnCursor(null);
            }
        } else {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        if (!(event.getPlayer() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getPlayer();
        PriceEvaluationGUI gui = this.main.getGUIManager().getActivePriceEvaluationGUI(player);
        if (gui != null && event.getInventory().equals((Object)gui.getInventory())) {
            gui.cleanup();
            gui.returnItemToPlayer();
            this.main.getGUIManager().removePlayer(player);
        }
    }
}

