/*
 * Decompiled with CFR 0.152.
 */
package me.aov.sellgui.cache;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import me.aov.sellgui.SellGUIMain;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class PriceCache {
    private final SellGUIMain plugin;
    private final ConcurrentHashMap<String, CachedPrice> priceCache;
    private final ScheduledExecutorService scheduler;
    private final boolean cacheEnabled;
    private final long cacheDuration;

    public PriceCache(SellGUIMain plugin) {
        this.plugin = plugin;
        this.priceCache = new ConcurrentHashMap();
        this.scheduler = Executors.newScheduledThreadPool(1);
        this.cacheEnabled = plugin.getConfig().getBoolean("performance.cache-prices", true);
        this.cacheDuration = plugin.getConfig().getLong("performance.cache-duration", 300L) * 1000L;
        if (this.cacheEnabled) {
            this.startCleanupTask();
        }
    }

    public Double getCachedPrice(ItemStack item, Player player) {
        if (!this.cacheEnabled) {
            return null;
        }
        String cacheKey = this.generateCacheKey(item, player);
        CachedPrice cached = this.priceCache.get(cacheKey);
        if (cached != null && !cached.isExpired()) {
            return cached.getPrice();
        }
        if (cached != null) {
            this.priceCache.remove(cacheKey);
        }
        return null;
    }

    public void cachePrice(ItemStack item, Player player, double price) {
        if (!this.cacheEnabled || price <= 0.0) {
            return;
        }
        String cacheKey = this.generateCacheKey(item, player);
        CachedPrice cachedPrice = new CachedPrice(price, System.currentTimeMillis() + this.cacheDuration);
        this.priceCache.put(cacheKey, cachedPrice);
    }

    private String generateCacheKey(ItemStack item, Player player) {
        StringBuilder key = new StringBuilder();
        key.append(item.getType().name());
        if (item.hasItemMeta()) {
            if (item.getItemMeta().hasDisplayName()) {
                key.append("_").append(item.getItemMeta().getDisplayName().hashCode());
            }
            if (item.getItemMeta().hasLore()) {
                key.append("_").append(item.getItemMeta().getLore().hashCode());
            }
        }
        if (player != null) {
            key.append("_player_").append(player.getUniqueId().toString());
        }
        return key.toString();
    }

    public void clearCache() {
        this.priceCache.clear();
    }

    public CacheStats getStats() {
        return new CacheStats(this.priceCache.size(), this.cacheEnabled, this.cacheDuration);
    }

    private void startCleanupTask() {
        this.scheduler.scheduleAtFixedRate(() -> {
            long currentTime = System.currentTimeMillis();
            this.priceCache.entrySet().removeIf(entry -> ((CachedPrice)entry.getValue()).isExpired(currentTime));
        }, 60L, 60L, TimeUnit.SECONDS);
    }

    public void shutdown() {
        this.scheduler.shutdown();
        this.priceCache.clear();
    }

    private static class CachedPrice {
        private final double price;
        private final long expiryTime;

        public CachedPrice(double price, long expiryTime) {
            this.price = price;
            this.expiryTime = expiryTime;
        }

        public double getPrice() {
            return this.price;
        }

        public boolean isExpired() {
            return this.isExpired(System.currentTimeMillis());
        }

        public boolean isExpired(long currentTime) {
            return currentTime > this.expiryTime;
        }
    }

    public static class CacheStats {
        private final int size;
        private final boolean enabled;
        private final long duration;

        public CacheStats(int size, boolean enabled, long duration) {
            this.size = size;
            this.enabled = enabled;
            this.duration = duration;
        }

        public int getSize() {
            return this.size;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public long getDuration() {
            return this.duration;
        }
    }
}

