/*
 * Decompiled with CFR 0.152.
 */
package me.aov.sellgui.commands;

import java.util.ArrayList;
import me.aov.sellgui.SellGUIMain;
import me.aov.sellgui.utils.ColorUtils;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class CustomItemsCommand
implements CommandExecutor {
    private static SellGUIMain main;
    private static Inventory menu;
    private static ArrayList<ItemStack> customItems;
    private static ArrayList<Double> prices;
    private static int page;
    private static ItemStack filler;
    private static ItemStack delete;
    private static ItemStack next;
    private static ItemStack back;

    public CustomItemsCommand(SellGUIMain main) {
        CustomItemsCommand.main = main;
        page = 0;
        customItems = new ArrayList();
        prices = new ArrayList();
        this.importStuff();
        this.makeMenu();
    }

    public boolean onCommand(CommandSender commandSender, Command command, String s, String[] strings) {
        if (!(commandSender instanceof Player)) {
            commandSender.sendMessage("Players only");
            return true;
        }
        Player p = ((Player)commandSender).getPlayer();
        if (strings.length == 0) {
            p.openInventory(menu);
            page = 0;
            CustomItemsCommand.display();
        } else {
            try {
                p.getWorld().dropItem(p.getLocation(), CustomItemsCommand.getPriceItem(Double.parseDouble(strings[0])));
            }
            catch (NullPointerException e) {
                p.sendMessage("Error");
            }
            catch (NumberFormatException e) {
                p.sendMessage("Try using a number.");
            }
        }
        return true;
    }

    private void importStuff() {
        if (main.getCustomItemsConfig().getList("items") == null) {
            main.getCustomItemsConfig().set("items", customItems);
        }
        if (main.getCustomItemsConfig().getList("prices") == null) {
            main.getCustomItemsConfig().set("prices", prices);
        }
        customItems.clear();
        prices.clear();
        for (ItemStack itemStack : (ArrayList)main.getCustomItemsConfig().getList("items")) {
            customItems.add(itemStack);
        }
        for (Double dubs : (ArrayList)main.getCustomItemsConfig().getList("prices")) {
            prices.add(dubs);
        }
    }

    private void makeMenu() {
        int i;
        menu = Bukkit.createInventory(null, (int)45, (String)ColorUtils.color("&c&lCustom Items"));
        filler = new ItemStack(Material.BLACK_STAINED_GLASS_PANE);
        delete = new ItemStack(Material.BARRIER);
        next = new ItemStack(Material.GREEN_WOOL);
        back = new ItemStack(Material.RED_WOOL);
        ItemMeta meta = filler.getItemMeta();
        meta.setDisplayName(" ");
        filler.setItemMeta(meta);
        meta = delete.getItemMeta();
        meta.setDisplayName(ColorUtils.color("&c&lDelete Item"));
        delete.setItemMeta(meta);
        meta = next.getItemMeta();
        meta.setDisplayName(ColorUtils.color("&2&lNext"));
        next.setItemMeta(meta);
        meta = back.getItemMeta();
        meta.setDisplayName(ColorUtils.color("&c&lBack"));
        back.setItemMeta(meta);
        for (i = 0; i < 9; ++i) {
            menu.setItem(i, filler);
        }
        for (i = 18; i < 27; ++i) {
            menu.setItem(i, filler);
        }
        for (i = 36; i < 45; ++i) {
            menu.setItem(i, filler);
        }
        menu.setItem(9, filler);
        menu.setItem(17, filler);
        menu.setItem(35, filler);
        menu.setItem(27, filler);
    }

    private static void display() {
        int i;
        for (i = 0; i < 9; ++i) {
            menu.setItem(i, filler);
        }
        for (i = 10; i < 17; ++i) {
            menu.clear(i);
            menu.clear(i + 18);
        }
        for (i = 0 + 7 * page; i < 7 + 7 * page; ++i) {
            try {
                int slot = CustomItemsCommand.getFreeSlot();
                menu.setItem(slot, customItems.get(i));
                menu.setItem(slot - 9, delete);
                menu.setItem(slot + 18, CustomItemsCommand.getPriceItem(CustomItemsCommand.getPrice(customItems.get(i))));
                continue;
            }
            catch (IndexOutOfBoundsException e) {
                // empty catch block
            }
        }
        if (page > 0) {
            menu.setItem(36, back);
        } else {
            menu.setItem(36, filler);
        }
        menu.setItem(44, next);
    }

    private static boolean doesntHave(ItemStack itemStack) {
        for (ItemStack s : customItems) {
            if (!s.isSimilar(itemStack)) continue;
            return false;
        }
        return true;
    }

    private static ItemStack getPriceItem(double dub) {
        ItemStack paper = new ItemStack(Material.PAPER);
        ItemMeta meta = paper.getItemMeta();
        meta.setDisplayName("price: " + dub);
        paper.setItemMeta(meta);
        return paper;
    }

    private static int getFreeSlot() {
        for (int i = 10; i < 18; ++i) {
            if (menu.getItem(i) != null) continue;
            return i;
        }
        return -1;
    }

    public static void addToList() {
        for (int i = 10; i < 17; ++i) {
            if (menu.getItem(i) == null || !CustomItemsCommand.doesntHave(menu.getItem(i))) continue;
            customItems.add(menu.getItem(i));
            if (menu.getItem(i + 18) != null && CustomItemsCommand.isPrice(menu.getItem(i + 18))) {
                prices.add(CustomItemsCommand.getPricePrice(menu.getItem(i + 18)));
                continue;
            }
            prices.add(0.0);
        }
    }

    public static void saveStuff() {
        main.getCustomItemsConfig().set("items", customItems);
        main.getCustomItemsConfig().set("prices", prices);
        main.saveCustom();
    }

    private static boolean isPrice(ItemStack itemStack) {
        return itemStack != null && itemStack.getItemMeta().getDisplayName().contains("price: ") && CustomItemsCommand.getPricePrice(itemStack) != -1.0;
    }

    public static double getPricePrice(ItemStack itemStack) {
        if (itemStack != null && itemStack.getType().equals((Object)Material.PAPER)) {
            return Double.parseDouble(itemStack.getItemMeta().getDisplayName().replaceAll("price: ", ""));
        }
        return -1.0;
    }

    public static void nextPage() {
        ++page;
        CustomItemsCommand.addToList();
        CustomItemsCommand.display();
    }

    public static void lastPage() {
        --page;
        CustomItemsCommand.addToList();
        CustomItemsCommand.display();
    }

    public static double getPrice(ItemStack stack) {
        int index = 0;
        for (ItemStack itemStack : customItems) {
            if (stack != null && itemStack.isSimilar(stack)) {
                return prices.get(index);
            }
            ++index;
        }
        return -1.0;
    }

    public static void removeItem(int slot) {
        int index = 0;
        ItemStack temp = null;
        for (ItemStack itemStack : customItems) {
            if (menu.getItem(slot) != null && menu.getItem(slot).isSimilar(itemStack)) {
                temp = itemStack;
            } else {
                ++index;
            }
            if (temp == null) continue;
        }
        menu.remove(temp);
        customItems.remove(temp);
        menu.setItem(slot + 18, null);
        menu.setItem(slot - 9, filler);
        prices.remove(index);
        CustomItemsCommand.saveStuff();
        CustomItemsCommand.display();
    }

    public static boolean clickable(ItemStack itemStack) {
        return !itemStack.isSimilar(delete) && !itemStack.isSimilar(filler) && !itemStack.isSimilar(next) && !itemStack.isSimilar(back);
    }

    public static Inventory getMenu() {
        return menu;
    }

    public static ItemStack getFiller() {
        return filler;
    }

    public static ItemStack getDelete() {
        return delete;
    }

    public static ArrayList<ItemStack> getCustomItems() {
        return customItems;
    }

    public static ArrayList<Double> getPrices() {
        return prices;
    }

    public static int getPage() {
        return page;
    }

    public static ItemStack getNext() {
        return next;
    }

    public static ItemStack getBack() {
        return back;
    }
}

