/*
 * Decompiled with CFR 0.152.
 */
package me.aov.sellgui.gui;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import me.aov.sellgui.SellGUIMain;
import me.aov.sellgui.managers.NBTPriceManager;
import me.aov.sellgui.utils.ColorUtils;
import me.aov.sellgui.utils.ItemIdentifier;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class PriceEvaluationGUI
implements InventoryHolder {
    private final SellGUIMain main;
    private final Player player;
    private final Inventory inventory;
    private final NBTPriceManager nbtPriceManager;
    private final Random random;
    private int ITEM_SLOT;
    private int ANIMATION_SLOT;
    private int RESULT_SLOT;
    private int EVALUATE_BUTTON;
    private int CANCEL_BUTTON;
    private int INSTRUCTION_SLOT;
    private BukkitTask animationTask;
    private boolean isLocked = false;
    private EvaluationMode evaluationMode = EvaluationMode.NONE;
    private double minPrice = 0.0;
    private double maxPrice = 0.0;

    public PriceEvaluationGUI(SellGUIMain main, Player player) {
        this.main = main;
        this.player = player;
        this.nbtPriceManager = new NBTPriceManager(main);
        this.random = new Random();
        FileConfiguration guiConfig = main.getConfigManager().getGUIConfig();
        String title = ColorUtils.color(guiConfig.getString("price_evaluation_gui.title", "&6&lPrice Evaluation"));
        int size = guiConfig.getInt("price_evaluation_gui.size", 54);
        this.loadLayoutFromConfig(guiConfig);
        this.inventory = Bukkit.createInventory((InventoryHolder)this, (int)size, (String)title);
        this.setupGUI();
    }

    private void loadLayoutFromConfig(FileConfiguration guiConfig) {
        if (guiConfig != null) {
            String path = "price_evaluation_gui.positions.";
            this.ITEM_SLOT = guiConfig.getInt(path + "item_slot", 22);
            this.EVALUATE_BUTTON = guiConfig.getInt(path + "evaluate_button", 33);
            this.CANCEL_BUTTON = guiConfig.getInt(path + "cancel_button", 48);
            this.INSTRUCTION_SLOT = guiConfig.getInt(path + "instruction_slot", 4);
            this.ANIMATION_SLOT = guiConfig.getInt(path + "animation_slot", 20);
            this.RESULT_SLOT = guiConfig.getInt(path + "result_slot", 20);
        } else {
            this.ITEM_SLOT = 22;
            this.ANIMATION_SLOT = 20;
            this.RESULT_SLOT = 20;
            this.EVALUATE_BUTTON = 33;
            this.CANCEL_BUTTON = 48;
            this.INSTRUCTION_SLOT = 4;
        }
    }

    private void setupGUI() {
        ItemStack filler = this.createItemFromConfig("filler", Material.GRAY_STAINED_GLASS_PANE, " ", new ArrayList<String>());
        List fillerSlots = this.main.getConfigManager().getGUIConfig().getIntegerList("price_evaluation_gui.positions.filler");
        if (fillerSlots.isEmpty()) {
            for (int i = 0; i < this.inventory.getSize(); ++i) {
                this.inventory.setItem(i, filler);
            }
        } else {
            Iterator i = fillerSlots.iterator();
            while (i.hasNext()) {
                int slot = (Integer)i.next();
                if (slot < 0 || slot >= this.inventory.getSize()) continue;
                this.inventory.setItem(slot, filler);
            }
        }
        this.inventory.setItem(this.ITEM_SLOT, null);
        ItemStack instruction = this.createItemFromConfig("instruction", Material.BOOK, "&e&l\ud83d\udccb How to Use", new ArrayList<String>());
        this.inventory.setItem(this.INSTRUCTION_SLOT, instruction);
        this.updateButtons();
    }

    public void updateButtons() {
        ItemStack evaluateButton = this.createItemFromConfig("evaluate_button", Material.NETHER_STAR, "&6&l\u26a1 Evaluate", new ArrayList<String>());
        this.inventory.setItem(this.EVALUATE_BUTTON, evaluateButton);
        ItemStack cancelButton = this.createItemFromConfig("cancel_button", Material.BARRIER, "&c&l\u274c Cancel", new ArrayList<String>());
        this.inventory.setItem(this.CANCEL_BUTTON, cancelButton);
    }

    public void setFixedPrice(double price) {
        this.evaluationMode = EvaluationMode.FIXED;
        this.minPrice = price;
        this.maxPrice = price;
        this.player.sendMessage(ColorUtils.color(this.getMessage("fixed_price_set", "&a\u2705 Fixed price set to &e$%price%").replace("%price%", String.format("%.2f", price))));
        this.updateButtons();
    }

    public void setRandomPrice(double min, double max) {
        if (min >= max) {
            this.player.sendMessage(ColorUtils.color(this.getMessage("invalid_range", "&c\u274c Invalid price range! Minimum must be less than maximum.")));
            return;
        }
        this.evaluationMode = EvaluationMode.RANDOM;
        this.minPrice = min;
        this.maxPrice = max;
        this.player.sendMessage(ColorUtils.color(this.getMessage("random_range_set", "&a\u2705 Random price range set to &e$%min% - $%max%").replace("%min%", String.format("%.2f", min)).replace("%max%", String.format("%.2f", max))));
        this.updateButtons();
    }

    public void startEvaluation() {
        if (this.isLocked) {
            this.player.sendMessage(ColorUtils.color(this.getMessage("evaluation_in_progress", "&c\u274c Evaluation already in progress!")));
            return;
        }
        ItemStack item = this.inventory.getItem(this.ITEM_SLOT);
        if (item == null || item.getType() == Material.AIR) {
            this.player.sendMessage(ColorUtils.color(this.getMessage("no_item", "&c\u274c No item to evaluate!")));
            return;
        }
        if (!this.main.getConfigManager().getConfig("config").getBoolean("general.allow-player-evaluation-stack", true) && item.getAmount() > 1) {
            this.player.sendMessage(ColorUtils.color(this.getMessage("price_evaluation.stack_evaluation_disabled", "&c\u274c You cannot evaluate stacked items.")));
            this.player.playSound(this.player.getLocation(), Sound.BLOCK_ANVIL_LAND, 1.0f, 1.0f);
            return;
        }
        if (item.hasItemMeta() && item.getItemMeta().getPersistentDataContainer().has(new NamespacedKey((Plugin)this.main, "current_price"), PersistentDataType.DOUBLE)) {
            this.player.sendMessage(ColorUtils.color(this.getMessage("item_already_evaluated", "&c\u26a0\ufe0f This item has already been evaluated!")));
            return;
        }
        String itemIdentifier = ItemIdentifier.getItemIdentifier(item);
        if (itemIdentifier == null) {
            this.player.sendMessage(ColorUtils.color(this.getMessage("could_not_identify", "&c\u274c Could not identify the item to evaluate.")));
            return;
        }
        FileConfiguration randomPricesConfig = this.main.getConfigManager().getRandomPricesConfig();
        if (randomPricesConfig.isConfigurationSection(itemIdentifier)) {
            double savedMin = randomPricesConfig.getDouble(itemIdentifier + ".min_price", 0.0);
            double savedMax = randomPricesConfig.getDouble(itemIdentifier + ".max_price", 0.0);
            if (savedMin > 0.0 && savedMax > savedMin) {
                this.minPrice = savedMin;
                this.maxPrice = savedMax;
                this.startRandomAnimation();
            } else {
                this.player.sendMessage(ColorUtils.color(this.getMessage("invalid_range_in_config", "&c\u274c The stored price range for this item is invalid. Please reset it.")));
            }
        } else {
            switch (this.evaluationMode.ordinal()) {
                case 1: {
                    if (this.minPrice > 0.0) {
                        this.applyFixedPrice();
                        break;
                    }
                    this.player.sendMessage(ColorUtils.color(this.getMessage("no_price_set", "&c\u274c Set a price first!")));
                    break;
                }
                case 2: {
                    if (this.minPrice > 0.0 && this.maxPrice > this.minPrice) {
                        this.startRandomAnimation();
                        break;
                    }
                    this.player.sendMessage(ColorUtils.color(this.getMessage("no_price_set", "&c\u274c Set a price range first!")));
                    break;
                }
                default: {
                    this.player.sendMessage(ColorUtils.color(this.getMessage("no_price_configured", "&c\u274c No price is configured for this item. Please set a price range for it first.")));
                }
            }
        }
    }

    private void startRandomAnimation() {
        this.isLocked = true;
        final ItemStack itemToEvaluate = this.inventory.getItem(this.ITEM_SLOT).clone();
        this.player.sendMessage(ColorUtils.color(this.getMessage("evaluation_started", "&a\u26a1 Evaluation started!")));
        this.player.playSound(this.player.getLocation(), Sound.BLOCK_NOTE_BLOCK_PLING, 1.0f, 1.0f);
        final double finalPrice = this.calculateRandomPrice(this.minPrice, this.maxPrice);
        final boolean isMaxPrice = Math.abs(finalPrice - this.maxPrice) < 0.01;
        this.animationTask = new BukkitRunnable(this){
            int ticks = 0;
            final int maxTicks;
            final /* synthetic */ PriceEvaluationGUI this$0;
            {
                this.this$0 = this$0;
                this.maxTicks = this.this$0.main.getConfigManager().getGUIConfig().getInt("price_evaluation_gui.animation.duration", 60);
            }

            public void run() {
                if (this.ticks >= this.maxTicks) {
                    this.this$0.completeRandomEvaluation(itemToEvaluate, finalPrice, isMaxPrice);
                    this.cancel();
                    return;
                }
                double animPrice = this.this$0.minPrice + this.this$0.random.nextDouble() * (this.this$0.maxPrice - this.this$0.minPrice);
                this.this$0.updateAnimationDisplay(animPrice);
                if (this.ticks % 5 == 0) {
                    this.this$0.player.playSound(this.this$0.player.getLocation(), Sound.BLOCK_NOTE_BLOCK_PLING, 0.5f, 1.0f + (float)this.ticks * 0.02f);
                }
                ++this.ticks;
            }
        }.runTaskTimer((Plugin)this.main, 0L, (long)this.main.getConfigManager().getGUIConfig().getInt("price_evaluation_gui.animation.update_interval", 5));
    }

    private void updateAnimationDisplay(double price) {
        ItemStack animItem = this.createItemFromConfig("animation", Material.GOLD_NUGGET, "&e&l\ud83c\udfb2 Evaluating...", new ArrayList<String>());
        ItemMeta meta = animItem.getItemMeta();
        if (meta != null) {
            String name = meta.hasDisplayName() ? meta.getDisplayName() : "";
            name = name.replace("%current%", String.format("%.2f", price));
            meta.setDisplayName(name);
            if (meta.hasLore()) {
                List lore = meta.getLore().stream().map(line -> this.replacePricePlaceholders((String)line)).map(line -> line.replace("%current%", String.format("%.2f", price))).collect(Collectors.toList());
                meta.setLore(lore);
            }
            animItem.setItemMeta(meta);
        }
        this.inventory.setItem(this.ANIMATION_SLOT, animItem);
    }

    private void completeRandomEvaluation(ItemStack originalItem, double finalPrice, boolean isMaxPrice) {
        this.isLocked = false;
        ItemStack pricedItem = this.addEvaluationInfo(originalItem.clone(), finalPrice);
        this.inventory.setItem(this.ITEM_SLOT, pricedItem);
        this.inventory.setItem(this.ANIMATION_SLOT, null);
        if (isMaxPrice) {
            this.player.playSound(this.player.getLocation(), Sound.ENTITY_FIREWORK_ROCKET_BLAST, 1.0f, 1.0f);
            this.player.sendMessage(ColorUtils.color(this.getMessage("jackpot_message", "&6\ud83c\udf89 JACKPOT! You got the maximum price!")));
        } else {
            this.player.playSound(this.player.getLocation(), Sound.ENTITY_PLAYER_LEVELUP, 1.0f, 1.0f);
        }
        this.player.sendMessage(ColorUtils.color(this.getMessage("evaluation_complete_chat", "&a\u2705 Price evaluation complete! Final price: &e$%price%").replace("%price%", String.format("%.2f", finalPrice))));
        this.showTemporaryResult();
        this.evaluationMode = EvaluationMode.NONE;
        this.updateButtons();
    }

    private void applyFixedPrice() {
        this.isLocked = true;
        ItemStack item = this.inventory.getItem(this.ITEM_SLOT);
        if (item != null) {
            ItemStack pricedItem = this.addEvaluationInfo(item.clone(), this.minPrice);
            this.inventory.setItem(this.ITEM_SLOT, pricedItem);
            this.player.sendMessage(ColorUtils.color(this.getMessage("evaluation_complete", "&a\u2705 Price set: &e$%price%").replace("%price%", String.format("%.2f", this.minPrice))));
            this.player.playSound(this.player.getLocation(), Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 1.0f, 1.0f);
            this.showTemporaryResult();
        }
        this.isLocked = false;
        this.evaluationMode = EvaluationMode.NONE;
        this.updateButtons();
    }

    private void showTemporaryResult() {
        final ItemStack resultItem = this.createItemFromConfig("result", Material.EMERALD, "&a&l\u2705 Evaluation Complete!", new ArrayList<String>());
        this.inventory.setItem(this.RESULT_SLOT, resultItem);
        new BukkitRunnable(this){
            final /* synthetic */ PriceEvaluationGUI this$0;
            {
                this.this$0 = this$0;
            }

            public void run() {
                ItemStack currentItem = this.this$0.inventory.getItem(this.this$0.RESULT_SLOT);
                if (currentItem != null && currentItem.isSimilar(resultItem)) {
                    ItemStack filler = this.this$0.createItemFromConfig("filler", Material.GRAY_STAINED_GLASS_PANE, " ", new ArrayList<String>());
                    this.this$0.inventory.setItem(this.this$0.RESULT_SLOT, filler);
                }
            }
        }.runTaskLater((Plugin)this.main, 100L);
    }

    private ItemStack createItem(Material material, String name, List<String> lore) {
        return this.createItem(material, name, lore, -1);
    }

    private ItemStack createItem(Material material, String name, List<String> lore, int customModelData) {
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            String processedName = this.main.setPlaceholders(this.player, name);
            meta.setDisplayName(ColorUtils.color(processedName));
            if (lore != null) {
                List<String> processedLore = this.main.setPlaceholders(this.player, lore);
                meta.setLore(processedLore.stream().map(ColorUtils::color).collect(Collectors.toList()));
            }
            if (customModelData != -1) {
                meta.setCustomModelData(Integer.valueOf(customModelData));
            }
            item.setItemMeta(meta);
        }
        return item;
    }

    private ItemStack createItemFromConfig(String itemKey, Material defaultMaterial, String defaultName, List<String> defaultLore) {
        ItemMeta meta;
        String path;
        FileConfiguration guiConfig = this.main.getConfigManager().getGUIConfig();
        if (!guiConfig.contains(path = "price_evaluation_gui.items." + itemKey)) {
            return this.createItem(defaultMaterial, defaultName, defaultLore);
        }
        Material material = Material.getMaterial((String)guiConfig.getString(path + ".material", defaultMaterial.name()).toUpperCase());
        String name = guiConfig.getString(path + ".name", defaultName);
        List<String> lore = guiConfig.getStringList(path + ".lore");
        if (lore.isEmpty()) {
            lore = defaultLore;
        }
        int customModelData = guiConfig.getInt(path + ".custom-model-data", -1);
        String nbtId = guiConfig.getString(path + ".nbt-id");
        name = this.replacePricePlaceholders(name);
        lore = lore.stream().map(this::replacePricePlaceholders).collect(Collectors.toList());
        ItemStack item = this.createItem(material, name, lore, customModelData);
        if (nbtId != null && !nbtId.isEmpty() && (meta = item.getItemMeta()) != null) {
            NamespacedKey key = new NamespacedKey((Plugin)this.main, "sellgui-nbt-id");
            meta.getPersistentDataContainer().set(key, PersistentDataType.STRING, (Object)nbtId);
            item.setItemMeta(meta);
        }
        return item;
    }

    private String replacePricePlaceholders(String text) {
        if (text == null) {
            return "";
        }
        return text.replace("%min%", String.format("%.2f", this.minPrice)).replace("%max%", String.format("%.2f", this.maxPrice)).replace("%price%", String.format("%.2f", this.minPrice)).replace("%jackpot_chance%", String.format("%.1f", this.main.getConfigManager().getGUIConfig().getDouble("price_evaluation_gui.random_calculation.jackpot_chance", 20.0)));
    }

    private String getMessage(String key, String defaultMessage) {
        FileConfiguration msgConfig = this.main.getConfigManager().getMessagesConfig();
        String path = "price_evaluation." + key;
        return msgConfig.getString(path, defaultMessage);
    }

    private double calculateRandomPrice(double minPrice, double maxPrice) {
        FileConfiguration guiConfig = this.main.getConfigManager().getGUIConfig();
        String path = "price_evaluation_gui.random_calculation.";
        double jackpotChance = guiConfig.getDouble(path + "jackpot_chance", 0.0);
        if (this.random.nextDouble() * 100.0 < jackpotChance) {
            return maxPrice;
        }
        String distribution = guiConfig.getString(path + "distribution", "uniform").toLowerCase();
        if ("weighted".equals(distribution)) {
            double highWeight;
            double midWeight;
            double lowWeight = guiConfig.getDouble(path + "weighted.low_range_weight", 33.3);
            double totalWeight = lowWeight + (midWeight = guiConfig.getDouble(path + "weighted.mid_range_weight", 33.3)) + (highWeight = guiConfig.getDouble(path + "weighted.high_range_weight", 33.3));
            if (totalWeight <= 0.0) {
                return minPrice + this.random.nextDouble() * (maxPrice - minPrice);
            }
            double roll = this.random.nextDouble() * totalWeight;
            double priceRange = maxPrice - minPrice;
            if (roll < lowWeight) {
                return minPrice + this.random.nextDouble() * (priceRange * 0.33);
            }
            if (roll < lowWeight + midWeight) {
                return minPrice + priceRange * 0.33 + this.random.nextDouble() * (priceRange * 0.34);
            }
            return minPrice + priceRange * 0.67 + this.random.nextDouble() * (priceRange * 0.33);
        }
        return minPrice + this.random.nextDouble() * (maxPrice - minPrice);
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    private ItemStack addEvaluationInfo(ItemStack item, double price) {
        if (item == null) {
            return item;
        }
        try {
            ItemMeta meta = item.getItemMeta();
            if (meta == null) {
                return item;
            }
            NamespacedKey worthKey = new NamespacedKey((Plugin)this.main, "current_price");
            meta.getPersistentDataContainer().set(worthKey, PersistentDataType.DOUBLE, (Object)price);
            String evaluationLoreFormat = this.main.getConfigManager().getGUIConfig().getString("price_evaluation_gui.evaluation_lore_format", "&a\u2705 Evaluated: &f$%price%");
            String evaluationLore = evaluationLoreFormat.replace("%price%", String.format("%.2f", price));
            ArrayList<String> lore = meta.hasLore() ? new ArrayList<String>(meta.getLore()) : new ArrayList();
            String evaluationLorePrefix = ChatColor.stripColor((String)this.main.getConfigManager().getGUIConfig().getString("price_evaluation_gui.evaluation_lore_format", "&a\u2705 Evaluated: &f$%price%")).replace("%price%", "").trim();
            lore.removeIf(line -> ChatColor.stripColor((String)line).startsWith(evaluationLorePrefix));
            lore.add("");
            lore.add(ColorUtils.color(evaluationLore));
            meta.setLore(lore);
            item.setItemMeta(meta);
        }
        catch (Exception e) {
            this.main.getLogger().warning("Failed to add evaluation info to item: " + e.getMessage());
        }
        return item;
    }

    public void cleanup() {
        if (this.animationTask != null && !this.animationTask.isCancelled()) {
            this.animationTask.cancel();
        }
    }

    public boolean isLocked() {
        return this.isLocked;
    }

    public int getItemSlot() {
        return this.ITEM_SLOT;
    }

    public void returnItemToPlayer() {
        ItemStack item = this.inventory.getItem(this.ITEM_SLOT);
        if (item != null && item.getType() != Material.AIR) {
            this.inventory.clear(this.ITEM_SLOT);
            this.player.getInventory().addItem(new ItemStack[]{item}).values().forEach(leftover -> this.player.getWorld().dropItem(this.player.getLocation(), leftover));
            this.player.sendMessage(ColorUtils.color(this.getMessage("item_returned", "&eYour item has been returned to your inventory.")));
        }
    }

    public static enum EvaluationMode {
        NONE,
        FIXED,
        RANDOM;

    }
}

