/*
 * Decompiled with CFR 0.152.
 */
package me.aov.sellgui.managers;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import me.aov.sellgui.SellGUIMain;
import me.aov.sellgui.utils.ItemIdentifier;
import net.brcdev.shopgui.ShopGuiPlusApi;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class PriceManager {
    private final SellGUIMain main;

    public PriceManager(SellGUIMain main) {
        this.main = main;
    }

    private double getShopGUIPlusPrice(ItemStack itemStack, Player player) {
        if (!this.main.hasShopGUIPlus) {
            return 0.0;
        }
        try {
            return ShopGuiPlusApi.getItemStackPriceSell((Player)player, (ItemStack)itemStack);
        }
        catch (Throwable t) {
            return 0.0;
        }
    }

    public boolean setItemPrice(ItemStack itemStack, double price) {
        if (itemStack == null) {
            return false;
        }
        ItemIdentifier.ItemType type = ItemIdentifier.getItemType(itemStack);
        String identifier = ItemIdentifier.getItemIdentifier(itemStack);
        if (identifier == null) {
            return false;
        }
        try {
            switch (type) {
                case MMOITEMS: {
                    return this.setMMOItemPrice(itemStack, price);
                }
                case NEXO: {
                    return this.setNexoPrice(itemStack, price);
                }
                case VANILLA: {
                    return this.setVanillaPrice(itemStack, price);
                }
            }
            return false;
        }
        catch (Exception e) {
            this.main.getLogger().warning("Failed to set price for item: " + identifier + " - " + e.getMessage());
            return false;
        }
    }

    public double getItemPrice(ItemStack itemStack) {
        double price;
        if (itemStack == null) {
            return 0.0;
        }
        String calculationMethod = this.main.getConfig().getString("prices.calculation-method", "auto");
        boolean nbtPricingEnabled = this.main.getConfig().getBoolean("prices.nbt-pricing", true);
        if (nbtPricingEnabled && itemStack.hasItemMeta() && itemStack.getItemMeta().getPersistentDataContainer() != null) {
            try {
                double worthPrice;
                NamespacedKey worthKey = new NamespacedKey((Plugin)this.main, "worth");
                if (itemStack.getItemMeta().getPersistentDataContainer().has(worthKey, PersistentDataType.DOUBLE) && (worthPrice = ((Double)itemStack.getItemMeta().getPersistentDataContainer().get(worthKey, PersistentDataType.DOUBLE)).doubleValue()) > 0.0) {
                    if (this.main.getConfig().getBoolean("general.debug", false)) {
                        this.main.getLogger().info("Using worth NBT price for " + String.valueOf(itemStack.getType()) + ": $" + worthPrice);
                    }
                    return worthPrice;
                }
            }
            catch (Exception worthKey) {
                // empty catch block
            }
        }
        if (!calculationMethod.equals("auto") && (price = this.getSpecificMethodPrice(itemStack, calculationMethod, null)) > 0.0) {
            return this.applyRandomVariation(price);
        }
        if (this.main.getRandomPriceManager() != null) {
            try {
                double randomPrice;
                if (this.main.getRandomPriceManager().hasRandomPrice(itemStack) && (randomPrice = this.main.getRandomPriceManager().getRandomPrice(itemStack)) > 0.0) {
                    if (this.main.getConfig().getBoolean("general.debug", false)) {
                        this.main.getLogger().info("Using random price for " + String.valueOf(itemStack.getType()) + ": $" + randomPrice);
                    }
                    return randomPrice;
                }
            }
            catch (Exception randomPrice) {
                // empty catch block
            }
        }
        if (this.main.getNBTPriceManager() != null) {
            try {
                double nbtPrice = this.main.getNBTPriceManager().getPriceFromNBT(itemStack);
                if (nbtPrice > 0.0) {
                    return nbtPrice;
                }
            }
            catch (Exception nbtPrice) {
                // empty catch block
            }
        }
        ItemIdentifier.ItemType type = ItemIdentifier.getItemType(itemStack);
        switch (type) {
            case MMOITEMS: {
                double mmoPrice = this.getMMOItemPrice(itemStack);
                return this.applyRandomVariation(mmoPrice);
            }
            case NEXO: {
                double nexoPrice = this.getNexoPrice(itemStack);
                return this.applyRandomVariation(nexoPrice);
            }
            case VANILLA: {
                double vanillaPrice = this.getVanillaPrice(itemStack);
                return this.applyRandomVariation(vanillaPrice);
            }
        }
        double defaultPrice = this.main.getConfig().getDouble("prices.default-price", 0.0);
        return this.applyRandomVariation(defaultPrice);
    }

    public double getItemPriceWithPlayer(ItemStack itemStack, Player player) {
        String calculationMethod = this.main.getConfig().getString("prices.calculation-method", "auto");
        if ("shopguiplus".equalsIgnoreCase(calculationMethod)) {
            double price = this.getSpecificMethodPrice(itemStack, "shopguiplus", player);
            return price > 0.0 ? price : 0.0;
        }
        double basePrice = this.getItemPrice(itemStack);
        if (basePrice <= 0.0 || player == null) {
            return basePrice;
        }
        double multiplier = this.getPlayerMultiplier(player);
        return basePrice * multiplier;
    }

    private double getSpecificMethodPrice(ItemStack itemStack, String method, Player player) {
        switch (method.toLowerCase()) {
            case "config": {
                return this.getConfigPrice(itemStack);
            }
            case "essentials": {
                return this.getEssentialsPrice(itemStack);
            }
            case "nbt": {
                if (this.main.getNBTPriceManager() != null) {
                    return this.main.getNBTPriceManager().getPriceFromNBT(itemStack);
                }
                return 0.0;
            }
            case "shopguiplus": {
                return this.getShopGUIPlusPrice(itemStack, player);
            }
        }
        return 0.0;
    }

    private double getConfigPrice(ItemStack itemStack) {
        ItemIdentifier.ItemType type = ItemIdentifier.getItemType(itemStack);
        switch (type) {
            case MMOITEMS: {
                return this.getMMOItemPrice(itemStack);
            }
            case NEXO: {
                return this.getNexoPrice(itemStack);
            }
            case VANILLA: {
                return this.getVanillaPrice(itemStack);
            }
        }
        return this.main.getConfig().getDouble("prices.default-price", 0.0);
    }

    private double getEssentialsPrice(ItemStack itemStack) {
        return 0.0;
    }

    private double applyMultipliers(double basePrice, ItemStack itemStack) {
        if (basePrice <= 0.0) {
            return basePrice;
        }
        boolean multipliersEnabled = this.main.getConfig().getBoolean("prices.multipliers.enabled", true);
        if (!multipliersEnabled) {
            return basePrice;
        }
        double multiplier = this.getMultiplier(itemStack);
        double finalPrice = basePrice * multiplier;
        finalPrice = this.applyRandomVariation(finalPrice);
        return finalPrice;
    }

    private double getMultiplier(ItemStack itemStack) {
        double defaultMultiplier = this.main.getConfig().getDouble("prices.multipliers.default-multiplier", 1.0);
        double maxMultiplier = this.main.getConfig().getDouble("prices.multipliers.max-multiplier", 5.0);
        return Math.min(defaultMultiplier, maxMultiplier);
    }

    public double getPlayerMultiplier(Player player) {
        if (player == null) {
            return 1.0;
        }
        boolean permissionBasedEnabled = this.main.getConfig().getBoolean("prices.multipliers.permission-based", true);
        if (!permissionBasedEnabled) {
            return this.main.getConfig().getDouble("prices.multipliers.default-multiplier", 1.0);
        }
        double maxMultiplier = this.main.getConfig().getDouble("prices.multipliers.max-multiplier", 5.0);
        double multiplier = 1.0;
        for (double testMultiplier = 0.1; testMultiplier <= maxMultiplier; testMultiplier += 0.1) {
            String permission = "sellgui.multiplier." + String.format("%.1f", testMultiplier).replace(",", ".");
            if (!player.hasPermission(permission)) continue;
            multiplier = Math.max(multiplier, testMultiplier);
        }
        if (player.hasPermission("sellgui.vip")) {
            multiplier = Math.max(multiplier, 1.5);
        }
        if (player.hasPermission("sellgui.premium")) {
            multiplier = Math.max(multiplier, 2.0);
        }
        if (player.hasPermission("sellgui.elite")) {
            multiplier = Math.max(multiplier, 3.0);
        }
        return Math.min(multiplier, maxMultiplier);
    }

    private double applyRandomVariation(double price) {
        boolean randomPricingEnabled = this.main.getConfig().getBoolean("prices.random-pricing.enabled", false);
        if (!randomPricingEnabled) {
            return price;
        }
        double variationPercent = this.main.getConfig().getDouble("prices.random-pricing.variation-percent", 10.0);
        double variation = (Math.random() - 0.5) * 2.0 * (variationPercent / 100.0);
        return price * (1.0 + variation);
    }

    public boolean removeItemPrice(ItemStack itemStack) {
        return this.setItemPrice(itemStack, 0.0);
    }

    private boolean setVanillaPrice(ItemStack itemStack, double price) {
        try {
            this.main.getItemPricesConfig().set(itemStack.getType().name(), (Object)price);
            this.main.getItemPricesConfig().save(this.getItemPricesFile());
            return true;
        }
        catch (IOException e) {
            this.main.getLogger().warning("Failed to save vanilla item price: " + e.getMessage());
            return false;
        }
    }

    private File getMMOItemsPricesFile() {
        return new File(this.main.getDataFolder(), "mmoitems.yml");
    }

    private File getNexoPricesFile() {
        return new File(this.main.getDataFolder(), "nexo.yml");
    }

    private File getItemPricesFile() {
        return new File(this.main.getDataFolder(), "itemprices.yml");
    }

    private double getVanillaPrice(ItemStack itemStack) {
        return this.main.getItemPricesConfig().getDouble(itemStack.getType().name(), 0.0);
    }

    private boolean setMMOItemPrice(ItemStack itemStack, double price) {
        try {
            String identifier = ItemIdentifier.getItemIdentifier(itemStack);
            if (identifier == null || !identifier.startsWith("MMOITEMS:")) {
                return false;
            }
            String[] parts = identifier.substring("MMOITEMS:".length()).split("\\.");
            if (parts.length != 2) {
                return false;
            }
            String itemType = parts[0];
            String itemId = parts[1];
            this.main.getMMOItemsPricesFileConfig().set("mmoitems." + itemType + "." + itemId, (Object)price);
            this.main.getMMOItemsPricesFileConfig().save(this.getMMOItemsPricesFile());
            Map<String, Double> loadedPrices = this.main.getLoadedMMOItemPrices();
            if (loadedPrices != null) {
                loadedPrices.put(itemType + "." + itemId, price);
            }
            return true;
        }
        catch (IOException e) {
            this.main.getLogger().warning("Failed to save MMOItem price: " + e.getMessage());
            return false;
        }
    }

    private double getMMOItemPrice(ItemStack itemStack) {
        String identifier = ItemIdentifier.getItemIdentifier(itemStack);
        if (identifier == null || !identifier.startsWith("MMOITEMS:")) {
            return 0.0;
        }
        String key = identifier.substring("MMOITEMS:".length());
        Map<String, Double> loadedPrices = this.main.getLoadedMMOItemPrices();
        if (loadedPrices != null && loadedPrices.containsKey(key)) {
            return loadedPrices.get(key);
        }
        return 0.0;
    }

    private boolean setNexoPrice(ItemStack itemStack, double price) {
        try {
            String identifier = ItemIdentifier.getItemIdentifier(itemStack);
            if (identifier == null || !identifier.startsWith("NEXO:")) {
                return false;
            }
            String nexoId = identifier.substring("NEXO:".length());
            this.main.getNexoPricesFileConfig().set("nexo." + nexoId, (Object)price);
            this.main.getNexoPricesFileConfig().save(this.getNexoPricesFile());
            Map<String, Double> loadedPrices = this.main.getLoadedNexoPrices();
            if (loadedPrices != null) {
                loadedPrices.put(nexoId, price);
            }
            return true;
        }
        catch (IOException e) {
            this.main.getLogger().warning("Failed to save Nexo item price: " + e.getMessage());
            return false;
        }
    }

    private double getNexoPrice(ItemStack itemStack) {
        String identifier = ItemIdentifier.getItemIdentifier(itemStack);
        if (identifier == null || !identifier.startsWith("NEXO:")) {
            return 0.0;
        }
        String nexoId = identifier.substring("NEXO:".length());
        Map<String, Double> loadedPrices = this.main.getLoadedNexoPrices();
        if (loadedPrices != null && loadedPrices.containsKey(nexoId)) {
            return loadedPrices.get(nexoId);
        }
        return 0.0;
    }

    public Map<String, Double> getAllPricesForType(ItemIdentifier.ItemType type) {
        HashMap<String, Double> prices = new HashMap<String, Double>();
        switch (type) {
            case MMOITEMS: {
                Map<String, Double> mmoItems = this.main.getLoadedMMOItemPrices();
                if (mmoItems == null) break;
                for (Map.Entry<String, Double> entry : mmoItems.entrySet()) {
                    if (!(entry.getValue() > 0.0)) continue;
                    prices.put("MMOITEMS:" + entry.getKey(), entry.getValue());
                }
                break;
            }
            case NEXO: {
                ConfigurationSection nexoSection = this.main.getNexoPricesFileConfig().getConfigurationSection("nexo");
                if (nexoSection == null) break;
                for (String key : nexoSection.getKeys(false)) {
                    double price = nexoSection.getDouble(key);
                    if (!(price > 0.0)) continue;
                    prices.put("NEXO:" + key, price);
                }
                break;
            }
            case VANILLA: {
                for (String key : this.main.getItemPricesConfig().getKeys(false)) {
                    double price;
                    if (key.equals("flat-enchantment-bonus") || key.equals("multiplier-enchantment-bonus") || !((price = this.main.getItemPricesConfig().getDouble(key)) > 0.0)) continue;
                    prices.put("VANILLA:" + key, price);
                }
                break;
            }
        }
        return prices;
    }
}

