/*
 * Decompiled with CFR 0.152.
 */
package me.aov.sellgui;

import io.lumine.mythic.lib.api.item.NBTItem;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import me.aov.sellgui.SellGUIMain;
import me.aov.sellgui.commands.SellCommand;
import me.aov.sellgui.listeners.InventoryListeners;
import me.aov.sellgui.managers.PriceManager;
import net.Indyuce.mmoitems.MMOItems;
import net.Indyuce.mmoitems.api.Type;
import net.Indyuce.mmoitems.api.item.mmoitem.MMOItem;
import org.apache.commons.lang.WordUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.permissions.PermissionAttachmentInfo;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class SellGUI
implements Listener {
    private final SellGUIMain main;
    private final Player player;
    private static ItemStack sellItem;
    private static ItemStack filler;
    private String menuTitle;
    private static Inventory menu;
    private ItemStack confirmItem;
    private int sellItemSlot;

    public SellGUI(SellGUIMain main, Player p) {
        this.main = main;
        this.player = p;
        this.createItems();
        this.createMenu();
        this.addCustomItems();
        p.openInventory(menu);
    }

    private void createMenu() {
        menu = Bukkit.createInventory((InventoryHolder)null, (int)this.main.getConfig().getInt("menu-size"), (String)SellGUI.color(this.main.getLangConfig().getString("menu-title")));
        this.addFiller(Objects.requireNonNull(this.main.getConfig().getString("menu-filler-location")));
        this.addSellItem();
    }

    private boolean isSellItem(ItemStack item) {
        return this.item(item, sellItem);
    }

    private boolean item(ItemStack item, ItemStack sellItem) {
        if (item == null || item.getType() != sellItem.getType()) {
            return false;
        }
        ItemMeta meta1 = item.getItemMeta();
        ItemMeta meta2 = sellItem.getItemMeta();
        return !(meta1.hasDisplayName() != meta2.hasDisplayName() || meta1.hasDisplayName() && !meta1.getDisplayName().equals(meta2.getDisplayName()) || meta1.hasLore() != meta2.hasLore() || meta1.hasLore() && !meta1.getLore().equals(meta2.getLore()) || meta1.hasCustomModelData() != meta2.hasCustomModelData() || meta1.hasCustomModelData() && meta1.getCustomModelData() != meta2.getCustomModelData());
    }

    private boolean isConfirmItem(ItemStack item) {
        return this.item(item, this.confirmItem);
    }

    private boolean isFillerItem(ItemStack item) {
        if (item == null || item.getType() != filler.getType()) {
            return false;
        }
        ItemMeta meta1 = item.getItemMeta();
        ItemMeta meta2 = filler.getItemMeta();
        return meta1.hasCustomModelData() == meta2.hasCustomModelData() && (!meta1.hasCustomModelData() || meta1.getCustomModelData() == meta2.getCustomModelData());
    }

    private void addCustomItems() {
        for (String itemPath : this.main.getCustomMenuItemsConfig().getKeys(false)) {
            ItemStack customItem = new ItemStack(Material.valueOf((String)this.main.getCustomMenuItemsConfig().getString(itemPath + ".material")));
            ItemMeta itemMeta = customItem.getItemMeta();
            if (this.main.getCustomMenuItemsConfig().contains(itemPath + ".custom-model-data")) {
                itemMeta.setCustomModelData(Integer.valueOf(this.main.getCustomMenuItemsConfig().getInt(itemPath + ".custom-model-data")));
            }
            if (!this.main.getCustomMenuItemsConfig().getString(itemPath + ".name").isEmpty()) {
                itemMeta.setDisplayName(SellGUI.color(this.main.getCustomMenuItemsConfig().getString(itemPath + ".name")));
            }
            if (this.main.getCustomMenuItemsConfig().getBoolean(itemPath + ".glimmer")) {
                itemMeta.addEnchant(Enchantment.INFINITY, 1, false);
                itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
            }
            if (!this.main.getCustomMenuItemsConfig().getStringList(itemPath + ".lore").isEmpty()) {
                ArrayList<String> lore = new ArrayList<String>();
                for (String s : this.main.getCustomMenuItemsConfig().getStringList(itemPath + ".lore")) {
                    lore.add(SellGUI.color(s));
                }
                itemMeta.setLore(lore);
            }
            NamespacedKey key = new NamespacedKey((Plugin)this.main, "custom-menu-item");
            StringBuilder sb = new StringBuilder();
            for (String command : this.main.getCustomMenuItemsConfig().getStringList(itemPath + ".commands")) {
                sb.append(command.replaceAll("%player%", this.player.getName())).append(";");
            }
            itemMeta.getPersistentDataContainer().set(key, PersistentDataType.STRING, (Object)sb.toString());
            customItem.setItemMeta(itemMeta);
            menu.setItem(this.main.getCustomMenuItemsConfig().getInt(itemPath + ".slot"), customItem);
        }
    }

    public void addSellItem() {
        int slot = this.main.getConfig().getInt("sell-item-slot", 4);
        int maxSlot = menu.getSize() - 1;
        if (slot < 0 || slot > maxSlot) {
            this.player.sendMessage(String.valueOf(ChatColor.RED) + "Invalid sell-item slot! It must be between 0 and " + maxSlot + ".");
            return;
        }
        menu.setItem(slot, sellItem);
        this.sellItemSlot = slot;
        this.makeConfirmItem();
    }

    private void right(String z) {
        if (z.equalsIgnoreCase("left")) {
            menu.setItem(menu.getSize() - 1, (ItemStack)null);
            menu.setItem(menu.getSize() - 1, sellItem);
            this.sellItemSlot = menu.getSize() - 1;
        } else if (z.equalsIgnoreCase("middle")) {
            menu.setItem(8 + 9 * menu.getSize() / 9 / 2, (ItemStack)null);
            menu.setItem(8 + 9 * menu.getSize() / 9 / 2, sellItem);
            this.sellItemSlot = 8 + 9 * menu.getSize() / 9 / 2;
        } else if (z.equalsIgnoreCase("right")) {
            menu.setItem(8, (ItemStack)null);
            menu.setItem(8, sellItem);
            this.sellItemSlot = 8;
        }
    }

    private void createItems() {
        if (this.menuTitle == null || sellItem == null || filler == null) {
            this.menuTitle = this.main.getLangConfig().getString("menu-title");
            NamespacedKey key = new NamespacedKey((Plugin)this.main, "sellgui-item");
            sellItem = new ItemStack(Objects.requireNonNull(Material.getMaterial((String)Objects.requireNonNull(this.main.getConfig().getString("sell-item")))));
            ItemMeta sellItemMeta = sellItem.getItemMeta();
            sellItemMeta.setDisplayName(SellGUI.color(this.main.getLangConfig().getString("sell-item-name")));
            ArrayList<String> lore = new ArrayList<String>();
            for (String s : this.main.getLangConfig().getStringList("sell-item-lore")) {
                lore.add(SellGUI.color(s));
            }
            sellItemMeta.setLore(lore);
            if (this.main.getConfig().getBoolean("sell-item-glimmer")) {
                sellItemMeta.addEnchant(Enchantment.INFINITY, 1, false);
                sellItemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
            }
            if (this.main.getConfig().contains("sell-item-custom-model-data")) {
                sellItemMeta.setCustomModelData(Integer.valueOf(this.main.getConfig().getInt("sell-item-custom-model-data")));
            }
            sellItemMeta.getPersistentDataContainer().set(key, PersistentDataType.BYTE, (Object)1);
            sellItem.setItemMeta(sellItemMeta);
            filler = new ItemStack(Material.valueOf((String)this.main.getConfig().getString("menu-filler-type")));
            ItemMeta fillerMeta = filler.getItemMeta();
            fillerMeta.setDisplayName(" ");
            if (this.main.getConfig().contains("menu-filler-custom-model-data")) {
                fillerMeta.setCustomModelData(Integer.valueOf(this.main.getConfig().getInt("menu-filler-custom-model-data")));
            }
            fillerMeta.getPersistentDataContainer().set(key, PersistentDataType.BYTE, (Object)1);
            filler.setItemMeta(fillerMeta);
        }
    }

    private void addFiller(String s) {
        block9: {
            int i;
            block12: {
                block11: {
                    block10: {
                        block8: {
                            if (!s.equalsIgnoreCase("bottom")) break block8;
                            for (int i2 = menu.getSize() - 9; i2 < menu.getSize(); ++i2) {
                                menu.setItem(i2, filler);
                            }
                            break block9;
                        }
                        if (!s.equalsIgnoreCase("left")) break block10;
                        for (int i3 = 0; i3 < menu.getSize(); i3 += 9) {
                            menu.setItem(i3, filler);
                        }
                        break block9;
                    }
                    if (!s.equalsIgnoreCase("right")) break block11;
                    for (int i4 = 8; i4 < menu.getSize(); i4 += 9) {
                        menu.setItem(i4, filler);
                    }
                    break block9;
                }
                if (!s.equalsIgnoreCase("top")) break block12;
                for (int i5 = 0; i5 < 9; ++i5) {
                    menu.setItem(i5, filler);
                }
                break block9;
            }
            if (!s.equalsIgnoreCase("round")) break block9;
            for (i = menu.getSize() - 9; i < menu.getSize(); ++i) {
                menu.setItem(i, filler);
            }
            for (i = 0; i < menu.getSize(); i += 9) {
                menu.setItem(i, filler);
            }
            for (i = 8; i < menu.getSize(); i += 9) {
                menu.setItem(i, filler);
            }
            for (i = 0; i < 9; ++i) {
                menu.setItem(i, filler);
            }
        }
    }

    public void makeConfirmItem() {
        this.confirmItem = new ItemStack(Objects.requireNonNull(Material.matchMaterial((String)this.main.getConfig().getString("confirm-item"))));
        ItemMeta itemMeta = this.confirmItem.getItemMeta();
        itemMeta.setDisplayName(SellGUI.color(this.main.getLangConfig().getString("confirm-item-name")));
        if (this.main.getConfig().getBoolean("confirm-item-glimmer")) {
            itemMeta.addEnchant(Enchantment.POWER, 1, false);
            itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        }
        itemMeta.setLore(this.makeLore());
        if (this.main.getConfig().contains("confirm-item-custom-model-data")) {
            itemMeta.setCustomModelData(Integer.valueOf(this.main.getConfig().getInt("confirm-item-custom-model-data")));
        }
        itemMeta.getPersistentDataContainer().set(new NamespacedKey((Plugin)this.main, "sellgui-item"), PersistentDataType.BYTE, (Object)1);
        this.confirmItem.setItemMeta(itemMeta);
    }

    public ArrayList<String> makeLore() {
        ItemStack[] contents;
        HashMap<String, Integer> itemCounts = new HashMap<String, Integer>();
        HashMap<String, Double> itemPrices = new HashMap<String, Double>();
        for (ItemStack item : contents = this.getMenu().getContents()) {
            if (item == null || InventoryListeners.sellGUIItem(item, this.player) || this.isCustomMenuItem(item)) continue;
            String itemName = this.getItemName(item);
            double price = this.getPrice(item, this.player);
            itemCounts.put(itemName, itemCounts.getOrDefault(itemName, 0) + item.getAmount());
            itemPrices.put(itemName, price);
        }
        ArrayList<String> lore = new ArrayList<String>();
        for (String itemName : itemCounts.keySet()) {
            String formatted = this.main.getLangConfig().getString("item-total-format").replace("%item%", itemName).replace("%amount%", String.valueOf(itemCounts.get(itemName))).replace("%price%", String.valueOf(itemPrices.get(itemName))).replace("%total%", String.valueOf((Double)itemPrices.get(itemName) * (double)((Integer)itemCounts.get(itemName)).intValue()));
            lore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)formatted));
        }
        String totalFormatted = this.main.getLangConfig().getString("total-format").replace("%total%", String.valueOf(this.getTotal(menu)));
        lore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)totalFormatted));
        return lore;
    }

    public void setConfirmItem() {
        menu.setItem(this.sellItemSlot, (ItemStack)null);
        menu.setItem(this.sellItemSlot, this.confirmItem);
    }

    public String getItemName(ItemStack itemStack) {
        MMOItem mmoItem;
        if (itemStack == null) {
            return "Unknown Item";
        }
        NBTItem nbtItem = NBTItem.get((ItemStack)itemStack);
        if (nbtItem.hasTag("MMOITEMS_ITEM_ID") && (mmoItem = MMOItems.plugin.getMMOItem(Type.get((String)nbtItem.getType()), nbtItem.getString("MMOITEMS_ITEM_ID"))) != null) {
            return String.valueOf(ChatColor.GREEN) + itemStack.getItemMeta().getDisplayName();
        }
        return itemStack.hasItemMeta() && itemStack.getItemMeta().hasDisplayName() ? itemStack.getItemMeta().getDisplayName() : WordUtils.capitalizeFully((String)itemStack.getType().name().replace('_', ' '));
    }

    public double getPrice(ItemStack itemStack, @Nullable Player player) {
        double price = 0.0;
        if (itemStack == null || itemStack.getType() == Material.AIR) {
            return price;
        }
        PriceManager priceManager = new PriceManager(this.main);
        price = priceManager.getItemPrice(itemStack);
        if (price == 0.0) {
            double essentialsPrice;
            NBTItem nbtItem;
            if (this.main.isMMOItemsEnabled() && (nbtItem = NBTItem.get((ItemStack)itemStack)).hasTag("MMOITEMS_ITEM_ID")) {
                String mmoItemType = nbtItem.getType();
                String mmoItemId = nbtItem.getString("MMOITEMS_ITEM_ID");
                if (mmoItemType != null && !mmoItemType.isEmpty() && mmoItemId != null && !mmoItemId.isEmpty()) {
                    String fullItemId = mmoItemType.toUpperCase() + "." + mmoItemId.toUpperCase();
                    Map<String, Double> mmoPrices = this.main.getLoadedMMOItemPrices();
                    if (mmoPrices != null && mmoPrices.containsKey(fullItemId)) {
                        price = mmoPrices.get(fullItemId);
                    }
                }
            }
            if (price == 0.0 && this.main.hasEssentials() && this.main.getConfig().getBoolean("use-essentials-price") && (essentialsPrice = SellGUI.round(this.main.getEssentialsHolder().getPrice(itemStack).doubleValue(), this.main.getConfig().getInt("places-to-round"))) > 0.0) {
                price = essentialsPrice;
            }
            if (price == 0.0 && this.main.getItemPricesConfig().contains(itemStack.getType().name())) {
                price = this.main.getItemPricesConfig().getDouble(itemStack.getType().name());
            }
        }
        price = this.applyPermissionBonuses(player, price);
        return SellGUI.round(price, this.main.getConfig().getInt("places-to-round"));
    }

    private double applyPermissionBonuses(Player player, double price) {
        if (player == null || price <= 0.0) {
            return price;
        }
        double bonusPercent = 0.0;
        double multiplier = 1.0;
        for (PermissionAttachmentInfo pai : player.getEffectivePermissions()) {
            if (pai.getPermission().startsWith("sellgui.bonus.") && pai.getValue()) {
                double percent = Double.parseDouble(pai.getPermission().replace("sellgui.bonus.", ""));
                bonusPercent += percent;
            }
            if (!pai.getPermission().startsWith("sellgui.multiplier.") || !pai.getValue()) continue;
            multiplier *= Double.parseDouble(pai.getPermission().replace("sellgui.multiplier.", ""));
        }
        price = price * (1.0 + bonusPercent / 100.0) * multiplier;
        return price;
    }

    public double getTotal(Inventory inventory) {
        double total = 0.0;
        for (ItemStack itemStack : inventory.getContents()) {
            double price;
            if (itemStack == null || itemStack.getType().isAir() || this.isCustomMenuItem(itemStack) || InventoryListeners.sellGUIItem(itemStack, this.player) || !((price = this.getPrice(itemStack, this.player)) > 0.0)) continue;
            total += price * (double)itemStack.getAmount();
        }
        return total;
    }

    private boolean isCustomMenuItem(ItemStack item) {
        if (item == null || !item.hasItemMeta()) {
            return false;
        }
        return item.getItemMeta().getPersistentDataContainer().has(new NamespacedKey((Plugin)this.main, "custom-menu-item"), PersistentDataType.STRING);
    }

    public void logSell(ItemStack itemStack) {
        if (itemStack != null) {
            try (BufferedWriter writer = new BufferedWriter(new FileWriter(this.getMain().getLog(), true));){
                String itemName;
                Date now = new Date();
                SimpleDateFormat format = new SimpleDateFormat("dd-MM-yyyy HH:mm:ss");
                double itemPrice = this.getPrice(itemStack, this.player);
                String playerName = this.getPlayer().getName();
                if (this.getMain().isMMOItemsEnabled()) {
                    NBTItem nbtItem = NBTItem.get((ItemStack)itemStack);
                    if (nbtItem.hasTag("MMOITEMS_ITEM_ID")) {
                        itemName = nbtItem.getString("MMOITEMS_ITEM_ID");
                    } else {
                        itemName = this.getItemName(itemStack);
                        this.getMain().getLogger().warning("Item doesn't have MMOITEMS_ITEM_ID tag: " + String.valueOf(itemStack.getType()));
                    }
                } else {
                    itemName = this.getItemName(itemStack);
                }
                writer.append(itemName + "|" + itemStack.getAmount() + "|" + itemPrice + "|" + playerName + "|" + format.format(now) + "\n");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void sellItems(Inventory inventory) {
        double total = this.getTotal(inventory);
        this.main.getEcon().depositPlayer((OfflinePlayer)this.player, total);
        for (ItemStack item : inventory.getContents()) {
            if (item == null || InventoryListeners.sellGUIItem(item, this.player) || this.isCustomMenuItem(item)) continue;
            if (this.main.getConfig().getBoolean("log-transactions")) {
                this.logSell(item);
            }
            inventory.remove(item);
        }
        if (this.main.getConfig().getBoolean("close-after-sell")) {
            InventoryListeners.dropItems(this.getMenu(), this.player);
            this.player.closeInventory();
            SellCommand.getSellGUIs().remove(this);
        } else {
            this.addSellItem();
        }
        this.player.sendMessage(SellGUI.color(this.main.getLangConfig().getString("sold-message").replace("%total%", String.valueOf(total))));
    }

    public ItemStack getConfirmItem() {
        return this.confirmItem;
    }

    public Player getPlayer() {
        return this.player;
    }

    public static ItemStack getSellItem() {
        return sellItem;
    }

    public static ItemStack getFiller() {
        return filler;
    }

    public String getMenuTitle() {
        return this.menuTitle;
    }

    public Inventory getMenu() {
        return menu;
    }

    public SellGUIMain getMain() {
        return this.main;
    }

    public static String color(String s) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)s);
    }

    public static double round(double value, int places) {
        if (places < 0) {
            throw new IllegalArgumentException();
        }
        BigDecimal bd = new BigDecimal("" + value);
        bd = bd.setScale(places, RoundingMode.HALF_UP);
        return bd.doubleValue();
    }

    public static double round(String value, int places) {
        if (places < 0) {
            throw new IllegalArgumentException();
        }
        BigDecimal bd = new BigDecimal(value);
        bd = bd.setScale(places, RoundingMode.HALF_UP);
        return bd.doubleValue();
    }

    public static String roundString(String value, int places) {
        if (places < 0) {
            throw new IllegalArgumentException();
        }
        BigDecimal bd = new BigDecimal(value);
        bd = bd.setScale(places, RoundingMode.HALF_UP);
        return bd.toPlainString();
    }
}

