/*
 * Decompiled with CFR 0.152.
 */
package me.aov.sellgui;

import io.lumine.mythic.lib.api.item.NBTItem;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Map;
import javax.annotation.Nullable;
import me.aov.sellgui.SellGUI;
import me.aov.sellgui.SellGUIMain;
import me.aov.sellgui.commands.SellCommand;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.permissions.PermissionAttachmentInfo;

public class SellGUIAPI
extends PlaceholderExpansion {
    private SellGUIMain main;

    public SellGUIAPI(SellGUIMain sellGUIMain) {
        this.main = sellGUIMain;
    }

    public String getIdentifier() {
        return "sellgui";
    }

    public String getAuthor() {
        return "SaneNuyan";
    }

    public String getVersion() {
        return "2.2";
    }

    public boolean canRegister() {
        return true;
    }

    public void registerExpansion() {
        if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
            this.register();
        }
    }

    public String onPlaceholderRequest(Player player, String identifier) {
        if (player == null) {
            return "";
        }
        if (identifier.equals("pricehand")) {
            ItemStack item = player.getInventory().getItemInMainHand();
            return String.valueOf(this.getPrice(item, player));
        }
        if (identifier.equals("pricehandfull")) {
            ItemStack item = player.getInventory().getItemInMainHand();
            String itemName = item.getType().name();
            if (item.hasItemMeta() && item.getItemMeta().hasDisplayName()) {
                itemName = item.getItemMeta().getDisplayName();
            }
            return itemName + " - " + this.getPrice(item, player);
        }
        return null;
    }

    public double getPrice(ItemStack itemStack, @Nullable Player player) {
        double essentialsPrice;
        BigDecimal essentialsPriceBd;
        NBTItem nbtItem;
        double price = 0.0;
        if (itemStack == null || itemStack.getType() == Material.AIR) {
            return price;
        }
        if (this.main.isMMOItemsEnabled() && (nbtItem = NBTItem.get((ItemStack)itemStack)).hasTag("MMOITEMS_ITEM_ID")) {
            String mmoItemType = nbtItem.getType();
            String mmoItemId = nbtItem.getString("MMOITEMS_ITEM_ID");
            if (mmoItemType != null && !mmoItemType.isEmpty() && mmoItemId != null && !mmoItemId.isEmpty()) {
                String fullItemId = mmoItemType.toUpperCase() + "." + mmoItemId.toUpperCase();
                Map<String, Double> map = this.main.getLoadedMMOItemPrices();
                if (map != null && map.containsKey(fullItemId)) {
                    price = map.get(fullItemId);
                }
            }
        }
        if (price == 0.0 && this.main.hasEssentials() && this.main.getConfig().getBoolean("use-essentials-price") && this.main.getEssentialsHolder() != null && this.main.getEssentialsHolder().getEssentials() != null && (essentialsPriceBd = this.main.getEssentialsHolder().getPrice(itemStack)) != null && (essentialsPrice = SellGUIAPI.round(essentialsPriceBd.doubleValue(), this.main.getConfig().getInt("places-to-round", 2))) > 0.0) {
            price = essentialsPrice;
        }
        if (price == 0.0 && this.main.getItemPricesConfig() != null && this.main.getItemPricesConfig().contains(itemStack.getType().name())) {
            price = this.main.getItemPricesConfig().getDouble(itemStack.getType().name());
        }
        if (this.main.getConfig().getBoolean("sell-all-command-sell-enchanted", false) || itemStack.getEnchantments().isEmpty()) {
            boolean isEssentialsPriceSource;
            ArrayList flatBonus = new ArrayList();
            if (this.main.getItemPricesConfig() != null && this.main.getItemPricesConfig().isList("flat-enchantment-bonus")) {
                flatBonus.addAll(this.main.getItemPricesConfig().getStringList("flat-enchantment-bonus"));
            }
            ArrayList multiplierBonus = new ArrayList();
            if (this.main.getItemPricesConfig() != null && this.main.getItemPricesConfig().isList("multiplier-enchantment-bonus")) {
                multiplierBonus.addAll(this.main.getItemPricesConfig().getStringList("multiplier-enchantment-bonus"));
            }
            boolean bl = isEssentialsPriceSource = this.main.hasEssentials() && this.main.getConfig().getBoolean("use-essentials-price") && price > 0.0 && this.main.getEssentialsHolder() != null && this.main.getEssentialsHolder().getEssentials() != null && this.main.getEssentialsHolder().getPrice(itemStack) != null && this.main.getEssentialsHolder().getPrice(itemStack).doubleValue() > 0.0;
            if (isEssentialsPriceSource && !this.main.getConfig().getBoolean("use-permission-bonuses-on-essentials", true)) {
                return SellGUIAPI.round(price, this.main.getConfig().getInt("places-to-round", 2));
            }
            if (itemStack.hasItemMeta() && itemStack.getItemMeta().hasEnchants()) {
                for (Map.Entry entry : itemStack.getEnchantments().entrySet()) {
                    String[] temp;
                    Enchantment enchantment = (Enchantment)entry.getKey();
                    int level = (Integer)entry.getValue();
                    String enchantmentKey = enchantment.getKey().getKey();
                    for (String s : flatBonus) {
                        temp = s.split(":");
                        if (temp.length != 3 || !temp[0].equalsIgnoreCase(enchantmentKey) || !temp[1].equalsIgnoreCase(String.valueOf(level))) continue;
                        try {
                            price += Double.parseDouble(temp[2]);
                        }
                        catch (NumberFormatException numberFormatException) {}
                    }
                    for (String s : multiplierBonus) {
                        temp = s.split(":");
                        if (temp.length != 3 || !temp[0].equalsIgnoreCase(enchantmentKey) || !temp[1].equalsIgnoreCase(String.valueOf(level))) continue;
                        try {
                            price *= Double.parseDouble(temp[2]);
                        }
                        catch (NumberFormatException numberFormatException) {}
                    }
                }
            }
            if (player != null) {
                for (PermissionAttachmentInfo permissionAttachmentInfo : player.getEffectivePermissions()) {
                    String perm = permissionAttachmentInfo.getPermission();
                    if (!permissionAttachmentInfo.getValue()) continue;
                    if (perm.startsWith("sellgui.bonus.")) {
                        if (price == 0.0) continue;
                        try {
                            double bonusValue = Double.parseDouble(perm.substring("sellgui.bonus.".length()));
                            price += bonusValue;
                        }
                        catch (IndexOutOfBoundsException | NumberFormatException bonusValue) {}
                        continue;
                    }
                    if (!perm.startsWith("sellgui.multiplier.")) continue;
                    try {
                        double multiplierValue = Double.parseDouble(perm.substring("sellgui.multiplier.".length()));
                        if (!(multiplierValue > 0.0)) continue;
                        price *= multiplierValue;
                    }
                    catch (IndexOutOfBoundsException | NumberFormatException runtimeException) {}
                }
            }
            return SellGUIAPI.round(price, this.main.getConfig().getInt("places-to-round", 2));
        }
        return SellGUIAPI.round(price, this.main.getConfig().getInt("places-to-round", 2));
    }

    public double getPurePrice(ItemStack itemStack) {
        double price = 0.0;
        if (itemStack != null && itemStack.getType() != Material.AIR && this.main.getItemPricesConfig() != null && this.main.getItemPricesConfig().contains(itemStack.getType().name())) {
            price = this.main.getItemPricesConfig().getDouble(itemStack.getType().name());
        }
        return price;
    }

    public void openSellGUI(Player player) {
        SellCommand.getSellGUIs().add(new SellGUI(this.main, player));
    }

    private static double round(double value, int places) {
        if (places < 0) {
            return value;
        }
        if (Double.isNaN(value) || Double.isInfinite(value)) {
            return 0.0;
        }
        try {
            BigDecimal bd = BigDecimal.valueOf(value);
            bd = bd.setScale(places, RoundingMode.HALF_UP);
            return bd.doubleValue();
        }
        catch (NumberFormatException e) {
            return value;
        }
    }
}

