/*
 * Decompiled with CFR 0.152.
 */
package me.aov.sellgui.commands;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import me.aov.sellgui.SellGUIMain;
import me.aov.sellgui.gui.PriceSetterGUI;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.InventoryHolder;
import org.jetbrains.annotations.NotNull;

public class PriceSetterCommand
implements CommandExecutor {
    private final SellGUIMain main;
    private static final Map<UUID, PriceSetterGUI> openGUIs = new HashMap<UUID, PriceSetterGUI>();

    public PriceSetterCommand(SellGUIMain main) {
        this.main = main;
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.color(this.main.getLangConfig().getString("price-setter-players-only", "&cThis command can only be used by players!")));
            return true;
        }
        Player player = (Player)sender;
        if (command.getName().equalsIgnoreCase("sellguiprice")) {
            if (args.length == 0) {
                if (!player.hasPermission("sellgui.setprice")) {
                    player.sendMessage(this.color(this.main.getLangConfig().getString("price-setter-no-permission", "&cYou don't have permission to use this command!")));
                    return true;
                }
                PriceSetterGUI gui = new PriceSetterGUI(this.main, player);
                openGUIs.put(player.getUniqueId(), gui);
                return true;
            }
            if (args.length == 1) {
                return this.handlePriceSet(player, args[0]);
            }
            player.sendMessage(this.color("&cUsage: /sellguiprice [price]"));
            return true;
        }
        return false;
    }

    private boolean handlePriceSet(Player player, String priceString) {
        double price;
        PriceSetterGUI gui = openGUIs.get(player.getUniqueId());
        if (gui == null) {
            InventoryHolder holder = player.getOpenInventory().getTopInventory().getHolder();
            if (!(holder instanceof PriceSetterGUI)) {
                player.sendMessage(this.color("&cYou need to have the Price Setter GUI open to use this command!"));
                return true;
            }
            gui = (PriceSetterGUI)holder;
        }
        try {
            price = Double.parseDouble(priceString);
        }
        catch (NumberFormatException e) {
            player.sendMessage(this.color("&cInvalid price! Please enter a valid number."));
            return true;
        }
        if (price < 0.0) {
            player.sendMessage(this.color("&cPrice cannot be negative!"));
            return true;
        }
        boolean success = gui.savePrice(price);
        if (success) {
            player.sendMessage(this.color("&aPrice set successfully! Click the Save button to confirm."));
        }
        return true;
    }

    public static PriceSetterGUI getPriceSetterGUI(Player player) {
        return openGUIs.get(player.getUniqueId());
    }

    public static void removePriceSetterGUI(Player player) {
        openGUIs.remove(player.getUniqueId());
    }

    public static boolean hasPriceSetterGUI(Player player) {
        return openGUIs.containsKey(player.getUniqueId());
    }

    public static Map<UUID, PriceSetterGUI> getOpenGUIs() {
        return openGUIs;
    }

    private String color(String text) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)text);
    }
}

