/*
 * Decompiled with CFR 0.152.
 */
package me.aov.sellgui.commands;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import me.aov.sellgui.SellGUIMain;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.permissions.PermissionAttachmentInfo;
import org.jetbrains.annotations.NotNull;

public class SellAllCommand
implements CommandExecutor {
    private SellGUIMain main;

    public SellAllCommand(SellGUIMain main) {
        this.main = main;
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, String[] args) {
        if (!(sender instanceof Player)) {
            return true;
        }
        Player player = (Player)sender;
        if (args.length == 1 && args[0].equalsIgnoreCase("confirm")) {
            this.sellItems((Inventory)player.getInventory(), player);
        } else {
            player.sendMessage(SellAllCommand.color(this.main.getLangConfig().getString("sellall-confirm-message")));
        }
        return true;
    }

    public double getPrice(ItemStack itemStack, Player player) {
        double price = 0.0;
        if (!this.main.getConfig().getBoolean("sell-all-command-sell-enchanted") && itemStack.getEnchantments().size() > 0) {
            return price;
        }
        this.main.getItemPricesConfig().getStringList("flat-enchantment-bonus");
        ArrayList flatBonus = new ArrayList(this.main.getItemPricesConfig().getStringList("flat-enchantment-bonus"));
        this.main.getItemPricesConfig().getStringList("multiplier-enchantment-bonus");
        ArrayList multiplierBonus = new ArrayList(this.main.getItemPricesConfig().getStringList("multiplier-enchantment-bonus"));
        if (this.main.hasEssentials() && this.main.getConfig().getBoolean("use-essentials-price") && this.main.getEssentialsHolder().getEssentials() != null) {
            return SellAllCommand.round(this.main.getEssentialsHolder().getPrice(itemStack).doubleValue(), 3);
        }
        if (itemStack != null && itemStack.getType() != Material.AIR && this.main.getItemPricesConfig().contains(itemStack.getType().name())) {
            price = this.main.getItemPricesConfig().getDouble(itemStack.getType().name());
        }
        if (itemStack != null && itemStack.getItemMeta().hasEnchants()) {
            for (Enchantment enchantment : itemStack.getItemMeta().getEnchants().keySet()) {
                for (String s : flatBonus) {
                    String[] temp = s.split(":");
                    if (!temp[0].equalsIgnoreCase(enchantment.getKey().getKey()) || !temp[1].equalsIgnoreCase("" + itemStack.getEnchantmentLevel(enchantment))) continue;
                    price += Double.parseDouble(temp[2]);
                }
            }
            for (Enchantment enchantment : itemStack.getItemMeta().getEnchants().keySet()) {
                for (String s : multiplierBonus) {
                    String[] temp2 = s.split(":");
                    if (!temp2[0].equalsIgnoreCase(enchantment.getKey().getKey()) || !temp2[1].equalsIgnoreCase("" + itemStack.getEnchantmentLevel(enchantment))) continue;
                    price *= Double.parseDouble(temp2[2]);
                }
            }
        }
        for (PermissionAttachmentInfo pai : player.getEffectivePermissions()) {
            if (pai.getPermission().contains("sellgui.bonus.")) {
                if (price == 0.0) continue;
                price += Double.parseDouble(pai.getPermission().replaceAll("sellgui.bonus.", ""));
                continue;
            }
            if (!pai.getPermission().contains("sellgui.multiplier.")) continue;
            price *= Double.parseDouble(pai.getPermission().replaceAll("sellgui.multiplier.", ""));
        }
        return SellAllCommand.round(price, 3);
    }

    public double getTotal(Inventory inventory, Player player) {
        double total = 0.0;
        for (ItemStack itemStack : inventory.getContents()) {
            if (itemStack == null) continue;
            total += this.getPrice(itemStack, player) * (double)itemStack.getAmount();
        }
        return total;
    }

    public void sellItems(Inventory inventory, Player player) {
        this.main.getEcon().depositPlayer((OfflinePlayer)player, this.getTotal(inventory, player));
        player.sendMessage(SellAllCommand.color(this.main.getLangConfig().getString("sold-message").replaceAll("%total%", "" + SellAllCommand.round(this.getTotal(inventory, player), 3))));
        for (ItemStack itemStack : inventory) {
            if (itemStack == null || this.getPrice(itemStack, player) == 0.0) continue;
            inventory.remove(itemStack);
        }
    }

    public static String color(String s) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)s);
    }

    public static double round(double value, int places) {
        if (places < 0) {
            throw new IllegalArgumentException();
        }
        BigDecimal bd = BigDecimal.valueOf(value);
        bd = bd.setScale(places, RoundingMode.HALF_UP);
        return bd.doubleValue();
    }
}

