/*
 * Decompiled with CFR 0.152.
 */
package me.aov.sellgui.commands;

import java.util.ArrayList;
import me.aov.sellgui.SellGUI;
import me.aov.sellgui.SellGUIMain;
import me.aov.sellgui.managers.PriceManager;
import me.aov.sellgui.utils.ItemIdentifier;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class SellCommand
implements CommandExecutor {
    private final SellGUIMain main;
    private static ArrayList<SellGUI> sellGUIS;

    public SellCommand(SellGUIMain main) {
        this.main = main;
        sellGUIS = new ArrayList();
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (args.length == 1 && args[0].equalsIgnoreCase("reload")) {
            if (sender.hasPermission("sellgui.reload")) {
                this.main.reload();
                sender.sendMessage(SellCommand.color("&aConfigs reloaded successfully."));
            } else {
                sender.sendMessage(SellCommand.color("&cYou do not have permission to use this command."));
            }
            return true;
        }
        if (args.length == 1 && args[0].equalsIgnoreCase("debug")) {
            if (!(sender instanceof Player)) {
                sender.sendMessage(SellCommand.color("&cThis command can only be used by players!"));
                return true;
            }
            Player player = (Player)sender;
            if (!player.hasPermission("sellgui.setprice")) {
                player.sendMessage(SellCommand.color("&cYou don't have permission to use this command!"));
                return true;
            }
            ItemStack itemInHand = player.getInventory().getItemInMainHand();
            if (itemInHand == null || itemInHand.getType() == Material.AIR) {
                player.sendMessage(SellCommand.color("&cYou must be holding an item to debug!"));
                return true;
            }
            player.sendMessage(SellCommand.color("&eDebugging item in hand... Check console for details."));
            ItemIdentifier.debugItemNBT(itemInHand);
            ItemIdentifier.ItemType type = ItemIdentifier.getItemType(itemInHand);
            String identifier = ItemIdentifier.getItemIdentifier(itemInHand);
            String displayName = ItemIdentifier.getItemDisplayName(itemInHand);
            player.sendMessage(SellCommand.color("&aItem Type: &f" + type.name()));
            player.sendMessage(SellCommand.color("&aIdentifier: &f" + (identifier != null ? identifier : "null")));
            player.sendMessage(SellCommand.color("&aDisplay Name: &f" + displayName));
            return true;
        }
        if (args.length >= 1 && args[0].equalsIgnoreCase("setprice")) {
            if (!(sender instanceof Player)) {
                sender.sendMessage(SellCommand.color("&cThis command can only be used by players!"));
                return true;
            }
            Player player = (Player)sender;
            if (!player.hasPermission("sellgui.setprice")) {
                player.sendMessage(SellCommand.color("&cYou don't have permission to use this command!"));
                return true;
            }
            if (args.length == 1) {
                this.main.getPriceSetterCommand().onCommand(sender, command, "sellguiprice", new String[0]);
            } else {
                if (args.length == 2) {
                    return this.handleSetPriceInHand(player, args[1]);
                }
                player.sendMessage(SellCommand.color("&cUsage: /sellgui setprice [price]"));
            }
            return true;
        }
        if (!(sender instanceof Player)) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "This command can only be executed by a player.");
            return true;
        }
        Player player = (Player)sender;
        if (args.length == 0) {
            if (player.hasPermission("sellgui.use")) {
                sellGUIS.add(new SellGUI(this.main, player));
            } else {
                player.sendMessage(SellCommand.color("&cYou do not have permission to use this command."));
            }
            return true;
        }
        if (args.length == 1) {
            if (player.hasPermission("sellgui.others")) {
                Player target = this.main.getServer().getPlayer(args[0]);
                if (target != null) {
                    sellGUIS.add(new SellGUI(this.main, target));
                    player.sendMessage(SellCommand.color("&aSuccessfully opened SellGUI for " + target.getName() + "."));
                } else {
                    player.sendMessage(SellCommand.color("&cPlayer '" + args[0] + "' not found or is not online."));
                }
            } else {
                player.sendMessage(SellCommand.color("&cYou do not have permission to open SellGUI for other players."));
            }
            return true;
        }
        sender.sendMessage(SellCommand.color("&cInvalid command usage. Try: /" + label + " [reload|setprice|<playername>]"));
        return true;
    }

    private boolean handleSetPriceInHand(Player player, String priceString) {
        double price;
        ItemStack itemInHand = player.getInventory().getItemInMainHand();
        if (itemInHand == null || itemInHand.getType() == Material.AIR) {
            player.sendMessage(SellCommand.color("&cYou must be holding an item to set its price!"));
            return true;
        }
        try {
            price = Double.parseDouble(priceString);
        }
        catch (NumberFormatException e) {
            player.sendMessage(SellCommand.color("&cInvalid price! Please enter a valid number."));
            return true;
        }
        if (price < 0.0) {
            player.sendMessage(SellCommand.color("&cPrice cannot be negative!"));
            return true;
        }
        PriceManager priceManager = new PriceManager(this.main);
        boolean success = priceManager.setItemPrice(itemInHand, price);
        if (success) {
            String itemName = ItemIdentifier.getItemDisplayName(itemInHand);
            String itemType = ItemIdentifier.getItemType(itemInHand).name();
            if (price == 0.0) {
                player.sendMessage(SellCommand.color("&aSuccessfully removed price for &f" + itemName + " &7(" + itemType + ")"));
            } else {
                player.sendMessage(SellCommand.color("&aSuccessfully set price for &f" + itemName + " &7(" + itemType + ") &ato &e$" + String.format("%.2f", price)));
            }
        } else {
            player.sendMessage(SellCommand.color("&cFailed to set price! Check console for errors."));
        }
        return true;
    }

    public static String color(String s) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)s);
    }

    public static ArrayList<SellGUI> getSellGUIs() {
        return sellGUIS;
    }

    public static boolean isSellGUI(Inventory inventory) {
        for (SellGUI sellGUI : sellGUIS) {
            if (!sellGUI.getMenu().equals((Object)inventory)) continue;
            return true;
        }
        return false;
    }

    public static SellGUI getSellGUI(Inventory inventory) {
        for (SellGUI sellGUI : sellGUIS) {
            if (!sellGUI.getMenu().equals((Object)inventory)) continue;
            return sellGUI;
        }
        return null;
    }

    public static SellGUI getSellGUI(Player player) {
        for (SellGUI sellGUI : sellGUIS) {
            if (!sellGUI.getPlayer().equals((Object)player)) continue;
            return sellGUI;
        }
        return null;
    }

    public static boolean openSellGUI(Player player) {
        return sellGUIS.stream().anyMatch(sellGUI -> sellGUI.getPlayer().equals((Object)player));
    }
}

