/*
 * Decompiled with CFR 0.152.
 */
package me.aov.sellgui.listeners;

import me.aov.sellgui.SellGUI;
import me.aov.sellgui.SellGUIMain;
import me.aov.sellgui.commands.SellCommand;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class InventoryListeners
implements Listener {
    private static SellGUIMain main;

    public InventoryListeners(SellGUIMain main) {
        InventoryListeners.main = main;
    }

    @EventHandler
    public void inventoryClose(InventoryCloseEvent event) {
        if (SellCommand.isSellGUI(event.getInventory())) {
            InventoryListeners.dropItems(event.getInventory(), (Player)event.getPlayer());
            SellCommand.getSellGUIs().remove(SellCommand.getSellGUI(event.getInventory()));
        }
    }

    @EventHandler
    public void inventoryClick(InventoryClickEvent e) {
        String soundName = main.getLangConfig().getString("no-items-sound", "BLOCK_NOTE_BLOCK_BASS");
        float volume = (float)main.getLangConfig().getDouble("no-items-volume", 1.0);
        float pitch = (float)main.getLangConfig().getDouble("no-items-pitch", 1.0);
        Sound sound = Sound.valueOf((String)soundName);
        ItemStack cursorItem = e.getCursor();
        if (!(e.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)e.getWhoClicked();
        ItemStack currentItem = e.getCurrentItem();
        if (SellCommand.openSellGUI(player)) {
            SellGUI sellGUI = SellCommand.getSellGUI(player);
            ItemStack clickedItem = e.getCurrentItem();
            if (clickedItem == null || clickedItem.getType().isAir()) {
                return;
            }
            if (clickedItem.getItemMeta() != null && clickedItem.getItemMeta().getPersistentDataContainer().has(new NamespacedKey((Plugin)main, "custom-menu-item"), PersistentDataType.STRING)) {
                this.executeCommandFromItem(player, clickedItem);
                e.setCancelled(true);
                return;
            }
            if (clickedItem.hasItemMeta() && clickedItem.getItemMeta().getPersistentDataContainer().has(new NamespacedKey((Plugin)main, "sellgui"), PersistentDataType.BYTE)) {
                e.setCancelled(true);
                return;
            }
            sellGUI.addSellItem();
            if (clickedItem.isSimilar(sellGUI.getConfirmItem())) {
                this.executeCommandFromConfig(player, "confirm-item-command");
                sellGUI.sellItems(sellGUI.getMenu());
                e.setResult(Event.Result.DENY);
                e.setCancelled(true);
            } else if (clickedItem.isSimilar(SellGUI.getSellItem())) {
                if (sellGUI.getTotal(sellGUI.getMenu()) <= 0.0) {
                    String title = main.getLangConfig().getString("no-items-title", "&cNo items to sell!");
                    String subtitle = main.getLangConfig().getString("no-items-subtitle", "");
                    e.getWhoClicked().getWorld().playSound(e.getWhoClicked().getLocation(), sound, volume, pitch);
                    player.closeInventory();
                    player.sendTitle(ChatColor.translateAlternateColorCodes((char)'&', (String)title), ChatColor.translateAlternateColorCodes((char)'&', (String)subtitle), 10, 70, 20);
                    return;
                }
                this.executeCommandFromConfig(player, "sell-item-command");
                sellGUI.makeConfirmItem();
                sellGUI.setConfirmItem();
                e.setResult(Event.Result.DENY);
                e.setCancelled(true);
            } else if (clickedItem.isSimilar(SellGUI.getFiller())) {
                e.setResult(Event.Result.DENY);
                e.setCancelled(true);
            }
            if (e.getInventory().getHolder() instanceof SellGUI && cursorItem != null && cursorItem.getType() != Material.AIR) {
                e.getWhoClicked().getWorld().playSound(e.getWhoClicked().getLocation(), Sound.BLOCK_BARREL_OPEN, 0.8f, 1.2f);
            }
        }
    }

    private String colorize(String message) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)message.replace("\u00a7", "&"));
    }

    private void executeCommandFromItem(Player player, ItemStack item) {
        String commands = (String)item.getItemMeta().getPersistentDataContainer().get(new NamespacedKey((Plugin)main, "custom-menu-item"), PersistentDataType.STRING);
        if (commands == null) {
            return;
        }
        for (String command : commands.split(";")) {
            command = command.replace("%player%", player.getName());
            main.getServer().dispatchCommand((CommandSender)main.getServer().getConsoleSender(), command);
        }
    }

    private void executeCommandFromConfig(Player player, String commandKey) {
        String command = main.getConfig().getString(commandKey);
        if (command != null) {
            command = command.replace("%player%", player.getName());
            main.getServer().dispatchCommand((CommandSender)main.getServer().getConsoleSender(), command);
        }
    }

    public static void dropItems(Inventory inventory, Player player) {
        for (ItemStack itemStack : inventory.getContents()) {
            if (itemStack == null || InventoryListeners.sellGUIItem(itemStack, player) || itemStack.hasItemMeta() && itemStack.getItemMeta().getPersistentDataContainer().has(new NamespacedKey((Plugin)main, "custom-menu-item"), PersistentDataType.STRING)) continue;
            if (main.getConfig().getBoolean("drop-items-on-close")) {
                player.getWorld().dropItem(player.getLocation(), itemStack);
                continue;
            }
            if (player.getInventory().firstEmpty() != -1) {
                player.getInventory().addItem(new ItemStack[]{itemStack});
                inventory.remove(itemStack);
                continue;
            }
            player.getWorld().dropItem(player.getLocation(), itemStack);
            inventory.remove(itemStack);
        }
    }

    public static boolean sellGUIItem(ItemStack i, Player player) {
        return i != null && (i.isSimilar(SellGUI.getSellItem()) || i.isSimilar(SellGUI.getFiller()) || i.isSimilar(SellCommand.getSellGUI(player).getConfirmItem()));
    }
}

