/*
 * Decompiled with CFR 0.152.
 */
package me.aov.sellgui.listeners;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import me.aov.sellgui.SellGUIMain;
import me.aov.sellgui.gui.PriceSetterGUI;
import me.aov.sellgui.managers.PriceManager;
import me.aov.sellgui.utils.ItemIdentifier;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class PriceSetterChatListener
implements Listener {
    private final SellGUIMain main;
    private static final Map<UUID, Boolean> waitingForPrice = new HashMap<UUID, Boolean>();
    private static final Map<UUID, ItemStack> playerItems = new HashMap<UUID, ItemStack>();

    public PriceSetterChatListener(SellGUIMain main) {
        this.main = main;
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerChat(AsyncPlayerChatEvent event) {
        Player player = event.getPlayer();
        UUID playerId = player.getUniqueId();
        if (!waitingForPrice.getOrDefault(playerId, false).booleanValue()) {
            return;
        }
        String message = event.getMessage().trim();
        event.setCancelled(true);
        waitingForPrice.remove(playerId);
        this.main.getServer().getScheduler().runTask((Plugin)this.main, () -> this.handlePriceInput(player, message));
    }

    private void handlePriceInput(Player player, String input) {
        double price;
        UUID playerId = player.getUniqueId();
        ItemStack item = playerItems.get(playerId);
        if (input.equalsIgnoreCase("cancel") || input.equalsIgnoreCase("c")) {
            player.sendMessage(PriceSetterChatListener.color("&cPrice input cancelled."));
            playerItems.remove(playerId);
            new PriceSetterGUI(this.main, player);
            return;
        }
        if (item == null) {
            player.sendMessage(PriceSetterChatListener.color("&cNo item found! Please try again."));
            playerItems.remove(playerId);
            return;
        }
        try {
            price = Double.parseDouble(input);
        }
        catch (NumberFormatException e) {
            player.sendMessage(PriceSetterChatListener.color("&cInvalid price! Please enter a valid number or 'cancel' to cancel."));
            PriceSetterChatListener.startWaitingForPrice(player);
            return;
        }
        if (price < 0.0) {
            player.sendMessage(PriceSetterChatListener.color("&cPrice cannot be negative! Please enter a valid price or 'cancel' to cancel."));
            PriceSetterChatListener.startWaitingForPrice(player);
            return;
        }
        PriceManager priceManager = new PriceManager(this.main);
        boolean success = priceManager.setItemPrice(item, price);
        if (success) {
            String itemName = ItemIdentifier.getItemDisplayName(item);
            String itemType = ItemIdentifier.getItemType(item).name();
            if (price == 0.0) {
                player.sendMessage(PriceSetterChatListener.color("&aSuccessfully removed price for &f" + itemName + " &7(" + itemType + ")"));
            } else {
                player.sendMessage(PriceSetterChatListener.color("&aSuccessfully set price for &f" + itemName + " &7(" + itemType + ") &ato &e$" + String.format("%.2f", price)));
            }
            playerItems.remove(playerId);
            this.main.getServer().getScheduler().runTaskLater((Plugin)this.main, () -> {
                PriceSetterGUI gui = new PriceSetterGUI(this.main, player);
                gui.getInventory().setItem(PriceSetterGUI.getItemSlot(), item);
                gui.updateItemInfo();
            }, 1L);
        } else {
            player.sendMessage(PriceSetterChatListener.color("&cFailed to set price! Check console for errors."));
            playerItems.remove(playerId);
        }
    }

    public static void startWaitingForPrice(Player player) {
        waitingForPrice.put(player.getUniqueId(), true);
        player.sendMessage(PriceSetterChatListener.color("&eEnter the price in chat (or type 'cancel' to cancel):"));
    }

    public static void stopWaitingForPrice(Player player) {
        UUID playerId = player.getUniqueId();
        waitingForPrice.remove(playerId);
        playerItems.remove(playerId);
    }

    public static boolean isWaitingForPrice(Player player) {
        return waitingForPrice.getOrDefault(player.getUniqueId(), false);
    }

    public static void setPlayerItem(Player player, ItemStack item) {
        playerItems.put(player.getUniqueId(), item);
    }

    public static ItemStack getPlayerItem(Player player) {
        return playerItems.get(player.getUniqueId());
    }

    private static String color(String text) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)text);
    }
}

