/*
 * Decompiled with CFR 0.152.
 */
package me.aov.sellgui.managers;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import me.aov.sellgui.SellGUIMain;
import me.aov.sellgui.utils.ItemIdentifier;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.ItemStack;

public class PriceManager {
    private final SellGUIMain main;

    public PriceManager(SellGUIMain main) {
        this.main = main;
    }

    public boolean setItemPrice(ItemStack itemStack, double price) {
        if (itemStack == null) {
            return false;
        }
        ItemIdentifier.ItemType type = ItemIdentifier.getItemType(itemStack);
        String identifier = ItemIdentifier.getItemIdentifier(itemStack);
        if (identifier == null) {
            return false;
        }
        try {
            switch (type) {
                case VANILLA: {
                    return this.setVanillaPrice(itemStack, price);
                }
                case MMOITEMS: {
                    return this.setMMOItemPrice(itemStack, price);
                }
                case NEXO: {
                    return this.setNexoPrice(itemStack, price);
                }
            }
            return false;
        }
        catch (Exception e) {
            this.main.getLogger().warning("Failed to set price for item: " + identifier + " - " + e.getMessage());
            return false;
        }
    }

    public double getItemPrice(ItemStack itemStack) {
        if (itemStack == null) {
            return 0.0;
        }
        ItemIdentifier.ItemType type = ItemIdentifier.getItemType(itemStack);
        switch (type) {
            case VANILLA: {
                return this.getVanillaPrice(itemStack);
            }
            case MMOITEMS: {
                return this.getMMOItemPrice(itemStack);
            }
            case NEXO: {
                return this.getNexoPrice(itemStack);
            }
        }
        return 0.0;
    }

    public boolean removeItemPrice(ItemStack itemStack) {
        return this.setItemPrice(itemStack, 0.0);
    }

    private boolean setVanillaPrice(ItemStack itemStack, double price) {
        try {
            this.main.getItemPricesConfig().set(itemStack.getType().name(), (Object)price);
            this.main.getItemPricesConfig().save(this.getItemPricesFile());
            return true;
        }
        catch (IOException e) {
            this.main.getLogger().warning("Failed to save vanilla item price: " + e.getMessage());
            return false;
        }
    }

    private File getItemPricesFile() {
        return new File(this.main.getDataFolder(), "itemprices.yml");
    }

    private File getMMOItemsPricesFile() {
        return new File(this.main.getDataFolder(), "mmoitems.yml");
    }

    private File getNexoPricesFile() {
        return new File(this.main.getDataFolder(), "nexo.yml");
    }

    private double getVanillaPrice(ItemStack itemStack) {
        return this.main.getItemPricesConfig().getDouble(itemStack.getType().name(), 0.0);
    }

    private boolean setMMOItemPrice(ItemStack itemStack, double price) {
        try {
            String identifier = ItemIdentifier.getItemIdentifier(itemStack);
            if (identifier == null || !identifier.startsWith("MMOITEMS:")) {
                return false;
            }
            String[] parts = identifier.substring("MMOITEMS:".length()).split("\\.");
            if (parts.length != 2) {
                return false;
            }
            String itemType = parts[0];
            String itemId = parts[1];
            this.main.getMMOItemsPricesFileConfig().set("mmoitems." + itemType + "." + itemId, (Object)price);
            this.main.getMMOItemsPricesFileConfig().save(this.getMMOItemsPricesFile());
            Map<String, Double> loadedPrices = this.main.getLoadedMMOItemPrices();
            if (loadedPrices != null) {
                loadedPrices.put(itemType + "." + itemId, price);
            }
            return true;
        }
        catch (IOException e) {
            this.main.getLogger().warning("Failed to save MMOItem price: " + e.getMessage());
            return false;
        }
    }

    private double getMMOItemPrice(ItemStack itemStack) {
        String identifier = ItemIdentifier.getItemIdentifier(itemStack);
        if (identifier == null || !identifier.startsWith("MMOITEMS:")) {
            return 0.0;
        }
        String key = identifier.substring("MMOITEMS:".length());
        Map<String, Double> loadedPrices = this.main.getLoadedMMOItemPrices();
        if (loadedPrices != null && loadedPrices.containsKey(key)) {
            return loadedPrices.get(key);
        }
        return 0.0;
    }

    private boolean setNexoPrice(ItemStack itemStack, double price) {
        try {
            String identifier = ItemIdentifier.getItemIdentifier(itemStack);
            if (identifier == null || !identifier.startsWith("NEXO:")) {
                return false;
            }
            String nexoId = identifier.substring("NEXO:".length());
            this.main.getNexoPricesFileConfig().set("nexo." + nexoId, (Object)price);
            this.main.getNexoPricesFileConfig().save(this.getNexoPricesFile());
            Map<String, Double> loadedPrices = this.main.getLoadedNexoPrices();
            if (loadedPrices != null) {
                loadedPrices.put(nexoId, price);
            }
            return true;
        }
        catch (IOException e) {
            this.main.getLogger().warning("Failed to save Nexo item price: " + e.getMessage());
            return false;
        }
    }

    private double getNexoPrice(ItemStack itemStack) {
        String identifier = ItemIdentifier.getItemIdentifier(itemStack);
        if (identifier == null || !identifier.startsWith("NEXO:")) {
            return 0.0;
        }
        String nexoId = identifier.substring("NEXO:".length());
        Map<String, Double> loadedPrices = this.main.getLoadedNexoPrices();
        if (loadedPrices != null && loadedPrices.containsKey(nexoId)) {
            return loadedPrices.get(nexoId);
        }
        return 0.0;
    }

    public Map<String, Double> getAllPricesForType(ItemIdentifier.ItemType type) {
        HashMap<String, Double> prices = new HashMap<String, Double>();
        switch (type) {
            case VANILLA: {
                for (String key : this.main.getItemPricesConfig().getKeys(false)) {
                    double price;
                    if (key.equals("flat-enchantment-bonus") || key.equals("multiplier-enchantment-bonus") || !((price = this.main.getItemPricesConfig().getDouble(key)) > 0.0)) continue;
                    prices.put("VANILLA:" + key, price);
                }
                break;
            }
            case MMOITEMS: {
                Map<String, Double> mmoItems = this.main.getLoadedMMOItemPrices();
                if (mmoItems == null) break;
                for (Map.Entry<String, Double> entry : mmoItems.entrySet()) {
                    if (!(entry.getValue() > 0.0)) continue;
                    prices.put("MMOITEMS:" + entry.getKey(), entry.getValue());
                }
                break;
            }
            case NEXO: {
                ConfigurationSection nexoSection = this.main.getNexoPricesFileConfig().getConfigurationSection("nexo");
                if (nexoSection == null) break;
                for (String key : nexoSection.getKeys(false)) {
                    double price = nexoSection.getDouble(key);
                    if (!(price > 0.0)) continue;
                    prices.put("NEXO:" + key, price);
                }
                break;
            }
        }
        return prices;
    }
}

