/*
 * Decompiled with CFR 0.152.
 */
package me.aov.sellgui.commands;

import io.lumine.mythic.lib.api.item.ItemTag;
import io.lumine.mythic.lib.api.item.NBTCompound;
import io.lumine.mythic.lib.api.item.NBTItem;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import me.aov.sellgui.SellGUIMain;
import me.aov.sellgui.handlers.SoundHandler;
import org.apache.commons.lang.WordUtils;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.permissions.PermissionAttachmentInfo;
import org.jetbrains.annotations.NotNull;

public class SellAllCommand
implements CommandExecutor {
    private SellGUIMain main;

    public SellAllCommand(SellGUIMain main) {
        this.main = main;
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(SellAllCommand.color("&cThis command can only be used by players!"));
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission("sellgui.sellall")) {
            player.sendMessage(SellAllCommand.color("&cYou don't have permission to use this command!"));
            return true;
        }
        if (this.main.getEcon() == null) {
            player.sendMessage(SellAllCommand.color("&cEconomy system not available!"));
            return true;
        }
        double total = this.getTotal((Inventory)player.getInventory(), player);
        int evaluationRequiredCount = 0;
        for (ItemStack item : player.getInventory().getContents()) {
            if (item == null || item.getType() == Material.AIR || this.main.getRandomPriceManager() == null || !this.main.getRandomPriceManager().requiresEvaluation(item) || this.main.getRandomPriceManager().isEvaluated(item)) continue;
            evaluationRequiredCount += item.getAmount();
        }
        if (evaluationRequiredCount > 0) {
            String evaluationMessage = this.main.getMessagesConfig() != null ? this.main.getMessagesConfig().getString("sellall.evaluation_required", "&e\u26a0\ufe0f %count% items require evaluation before selling. Use /sellgui evaluate") : "&e\u26a0\ufe0f %count% items require evaluation before selling. Use /sellgui evaluate";
            evaluationMessage = evaluationMessage.replace("%count%", String.valueOf(evaluationRequiredCount));
            player.sendMessage(SellAllCommand.color(evaluationMessage));
        }
        if (this.main.getConfig().getBoolean("general.debug", false)) {
            this.main.getLogger().info("SellAll debug - Player: " + player.getName() + ", Total: $" + total);
            this.main.getLogger().info("  Items needing evaluation: " + evaluationRequiredCount);
            int itemCount = 0;
            for (ItemStack item : player.getInventory().getContents()) {
                double price;
                if (item == null || item.getType() == Material.AIR || !((price = this.getPrice(item, player)) > 0.0)) continue;
                ++itemCount;
                this.main.getLogger().info("  - " + String.valueOf(item.getType()) + " x" + item.getAmount() + " = $" + price);
            }
            this.main.getLogger().info("  Total sellable items: " + itemCount);
        }
        if (total <= 0.0) {
            player.sendMessage(SellAllCommand.color("&cNo items to sell in your inventory!"));
            return true;
        }
        if (args.length == 1 && args[0].equalsIgnoreCase("confirm")) {
            this.sellItems((Inventory)player.getInventory(), player);
        } else {
            player.sendMessage(SellAllCommand.color("&6&l=== SellAll Confirmation ==="));
            player.sendMessage("");
            String confirmMessage = "&e\u26a0\ufe0f You will receive &a$%total% &efor selling all items.";
            if (this.main.getMessagesConfig() != null) {
                confirmMessage = this.main.getMessagesConfig().getString("sellall.confirm-message", confirmMessage);
            }
            confirmMessage = confirmMessage.replace("%total%", String.format("%.2f", total));
            player.sendMessage(SellAllCommand.color(confirmMessage));
            player.sendMessage("");
            if (this.main.getConfig().getBoolean("sellall-show-preview", true)) {
                player.sendMessage(SellAllCommand.color("&7Items to be sold:"));
                player.sendMessage("");
                int previewCount = 0;
                for (ItemStack item : player.getInventory().getContents()) {
                    if (item == null || item.getType() == Material.AIR || !(this.getPrice(item, player) > 0.0) || previewCount >= 5) continue;
                    String itemName = item.getType().name().toLowerCase().replace("_", " ");
                    itemName = WordUtils.capitalizeFully((String)itemName);
                    player.sendMessage(SellAllCommand.color("&8- &f" + itemName + " &7x" + item.getAmount() + " &8= &e$" + String.format("%.2f", this.getPrice(item, player) * (double)item.getAmount())));
                    player.sendMessage("");
                    ++previewCount;
                }
                if (previewCount >= 5) {
                    player.sendMessage(SellAllCommand.color("&8... and more"));
                    player.sendMessage("");
                }
                player.sendMessage(SellAllCommand.color("&6&l========================="));
                player.sendMessage(SellAllCommand.color("&a&l\u2713 &f/sellall confirm &7- Proceed with sale"));
                player.sendMessage(SellAllCommand.color("&c&l\u2717 &7Any other action - Cancel"));
                player.sendMessage(SellAllCommand.color("&6&l========================="));
            }
        }
        return true;
    }

    public double getPrice(ItemStack itemStack, Player player) {
        if (itemStack == null || itemStack.getType() == Material.AIR) {
            return 0.0;
        }
        if (this.main.getRandomPriceManager() != null && !this.main.getRandomPriceManager().canBeSold(itemStack)) {
            return 0.0;
        }
        double price = 0.0;
        if (!this.main.getConfig().getBoolean("sell-all-command-sell-enchanted") && itemStack.getEnchantments().size() > 0) {
            return price;
        }
        this.main.getItemPricesConfig().getStringList("flat-enchantment-bonus");
        ArrayList flatBonus = new ArrayList(this.main.getItemPricesConfig().getStringList("flat-enchantment-bonus"));
        this.main.getItemPricesConfig().getStringList("multiplier-enchantment-bonus");
        ArrayList multiplierBonus = new ArrayList(this.main.getItemPricesConfig().getStringList("multiplier-enchantment-bonus"));
        if (this.main.getPriceManager() != null) {
            try {
                price = this.main.getPriceManager().getItemPriceWithPlayer(itemStack, player);
                if (price > 0.0) {
                    return SellAllCommand.round(price, 3);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.main.getNBTPriceManager() != null) {
            try {
                price = this.main.getNBTPriceManager().getPriceFromNBT(itemStack);
                if (price > 0.0) {
                    return SellAllCommand.round(price, 3);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.main.getRandomPriceManager() != null) {
            try {
                price = this.main.getRandomPriceManager().getRandomPrice(itemStack);
                if (price > 0.0) {
                    return SellAllCommand.round(price, 3);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.main.hasEssentials() && this.main.getConfig().getBoolean("use-essentials-price") && this.main.getEssentialsHolder().getEssentials() != null) {
            return SellAllCommand.round(this.main.getEssentialsHolder().getPrice(itemStack).doubleValue(), 3);
        }
        if (this.main.getItemPricesConfig().contains(itemStack.getType().name())) {
            price = this.main.getItemPricesConfig().getDouble(itemStack.getType().name());
        }
        if (itemStack != null && itemStack.getItemMeta().hasEnchants()) {
            for (Enchantment enchantment : itemStack.getItemMeta().getEnchants().keySet()) {
                for (String s : flatBonus) {
                    String[] temp = s.split(":");
                    if (!temp[0].equalsIgnoreCase(enchantment.getKey().getKey()) || !temp[1].equalsIgnoreCase("" + itemStack.getEnchantmentLevel(enchantment))) continue;
                    price += Double.parseDouble(temp[2]);
                }
            }
            for (Enchantment enchantment : itemStack.getItemMeta().getEnchants().keySet()) {
                for (String s : multiplierBonus) {
                    String[] temp2 = s.split(":");
                    if (!temp2[0].equalsIgnoreCase(enchantment.getKey().getKey()) || !temp2[1].equalsIgnoreCase("" + itemStack.getEnchantmentLevel(enchantment))) continue;
                    price *= Double.parseDouble(temp2[2]);
                }
            }
        }
        for (PermissionAttachmentInfo pai : player.getEffectivePermissions()) {
            if (pai.getPermission().contains("sellgui.bonus.")) {
                if (price == 0.0) continue;
                price += Double.parseDouble(pai.getPermission().replaceAll("sellgui.bonus.", ""));
                continue;
            }
            if (!pai.getPermission().contains("sellgui.multiplier.")) continue;
            price *= Double.parseDouble(pai.getPermission().replaceAll("sellgui.multiplier.", ""));
        }
        return SellAllCommand.round(price, 3);
    }

    public double getTotal(Inventory inventory, Player player) {
        double total = 0.0;
        for (ItemStack itemStack : inventory.getContents()) {
            double itemPrice;
            if (itemStack == null || itemStack.getType() == Material.AIR || !((itemPrice = this.getPrice(itemStack, player)) > 0.0)) continue;
            total += itemPrice * (double)itemStack.getAmount();
        }
        return SellAllCommand.round(total, 3);
    }

    public void sellItems(Inventory inventory, Player player) {
        double total = this.getTotal(inventory, player);
        int itemsSold = 0;
        if (total <= 0.0) {
            player.sendMessage(SellAllCommand.color("&cNo items to sell!"));
            return;
        }
        this.main.getEcon().depositPlayer((OfflinePlayer)player, total);
        for (ItemStack itemStack : inventory.getContents()) {
            if (itemStack == null || !(this.getPrice(itemStack, player) > 0.0)) continue;
            if (this.main.getConfig().getBoolean("log-transactions")) {
                this.logSellAll(itemStack, player);
            }
            itemsSold += itemStack.getAmount();
            inventory.remove(itemStack);
        }
        String soldMessage = "&a\u2705 Sold %count% items for &e$%total%!";
        if (this.main.getMessagesConfig() != null) {
            soldMessage = this.main.getMessagesConfig().getString("sellall.sold-message", soldMessage);
        }
        soldMessage = soldMessage.replace("%total%", String.format("%.2f", total));
        soldMessage = soldMessage.replace("%count%", String.valueOf(itemsSold));
        player.sendMessage(SellAllCommand.color(soldMessage));
        if (this.main.getServer().getPluginManager().getPlugin("SellGUI") != null) {
            try {
                SoundHandler.playSuccess(player);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void logSellAll(ItemStack itemStack, Player player) {
        if (itemStack != null) {
            try (BufferedWriter writer = new BufferedWriter(new FileWriter(this.main.getLog(), true));){
                Date now = new Date();
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                String itemType = "VANILLA";
                Object itemId = itemStack.getType().name();
                Object displayName = "Unknown Item";
                double unitPrice = this.getPrice(itemStack, player);
                double totalPrice = unitPrice * (double)itemStack.getAmount();
                String playerName = player.getName();
                NBTItem nbtItem = new NBTItem(itemStack){

                    public Object get(String s) {
                        return null;
                    }

                    public String getString(String s) {
                        return "";
                    }

                    public boolean hasTag(String s) {
                        return false;
                    }

                    public boolean getBoolean(String s) {
                        return false;
                    }

                    public double getDouble(String s) {
                        return 0.0;
                    }

                    public int getInteger(String s) {
                        return 0;
                    }

                    public NBTCompound getNBTCompound(String s) {
                        return null;
                    }

                    public NBTItem addTag(List<ItemTag> list) {
                        return null;
                    }

                    public NBTItem removeTag(String ... strings) {
                        return null;
                    }

                    public Set<String> getTags() {
                        return Set.of();
                    }

                    public ItemStack toItem() {
                        return null;
                    }

                    public int getTypeId(String s) {
                        return 0;
                    }
                };
                if (this.main.hasNexo && nbtItem.hasTag("nexo:id")) {
                    itemType = "NEXO";
                    String nexoId = nbtItem.getString("nexo:id");
                    if (nexoId != null && !nexoId.isEmpty()) {
                        itemId = nexoId;
                    }
                    displayName = itemStack.hasItemMeta() && itemStack.getItemMeta().hasDisplayName() ? ChatColor.stripColor((String)itemStack.getItemMeta().getDisplayName()) : "[Nexo] " + (String)itemId;
                } else if (this.main.isMMOItemsEnabled() && nbtItem.hasTag("MMOITEMS_ITEM_ID")) {
                    itemType = "MMOITEMS";
                    String mmoItemType = nbtItem.getType();
                    String mmoItemId = nbtItem.getString("MMOITEMS_ITEM_ID");
                    if (mmoItemType != null && mmoItemId != null) {
                        itemId = mmoItemType.toUpperCase() + "." + mmoItemId.toUpperCase();
                    }
                    displayName = itemStack.hasItemMeta() && itemStack.getItemMeta().hasDisplayName() ? ChatColor.stripColor((String)itemStack.getItemMeta().getDisplayName()) : "[MMOItems] " + (String)itemId;
                } else {
                    displayName = itemStack.hasItemMeta() && itemStack.getItemMeta().hasDisplayName() ? ChatColor.stripColor((String)itemStack.getItemMeta().getDisplayName()) : WordUtils.capitalizeFully((String)itemStack.getType().name().replace('_', ' '));
                }
                String logEntry = String.format("[SELLALL] %s|%s|%s|%d|%.2f|%.2f|%s|%s", itemType, itemId, displayName, itemStack.getAmount(), unitPrice, totalPrice, playerName, format.format(now));
                writer.append(logEntry + "\n");
                writer.flush();
            }
            catch (IOException e) {
                this.main.getLogger().severe("Failed to write to sell log: " + e.getMessage());
                e.printStackTrace();
            }
        }
    }

    public static String color(String s) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)s);
    }

    public static double round(double value, int places) {
        if (places < 0) {
            throw new IllegalArgumentException();
        }
        BigDecimal bd = BigDecimal.valueOf(value);
        bd = bd.setScale(places, RoundingMode.HALF_UP);
        return bd.doubleValue();
    }
}

