/*
 * Decompiled with CFR 0.152.
 */
package me.aov.sellgui.listeners;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import me.aov.sellgui.SellGUIMain;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.ItemStack;

public class PlayerLeaveListener
implements Listener {
    private final SellGUIMain plugin;
    private static final Map<UUID, ItemStack> pendingItems = new HashMap<UUID, ItemStack>();

    public PlayerLeaveListener(SellGUIMain plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        UUID playerId = event.getPlayer().getUniqueId();
        ItemStack pendingItem = pendingItems.remove(playerId);
        if (pendingItem != null) {
            if (event.getPlayer().getInventory().firstEmpty() != -1) {
                event.getPlayer().getInventory().addItem(new ItemStack[]{pendingItem});
            } else {
                event.getPlayer().getWorld().dropItemNaturally(event.getPlayer().getLocation(), pendingItem);
            }
            this.plugin.getLogger().info("Returned evaluation item to " + event.getPlayer().getName() + " on quit");
        }
    }

    public static void storePendingItem(UUID playerId, ItemStack item) {
        if (item != null) {
            pendingItems.put(playerId, item.clone());
        }
    }

    public static void removePendingItem(UUID playerId) {
        pendingItems.remove(playerId);
    }

    public static boolean hasPendingItem(UUID playerId) {
        return pendingItems.containsKey(playerId);
    }
}

