/*
 * Decompiled with CFR 0.152.
 */
package me.aov.sellgui.listeners;

import java.util.Iterator;
import me.aov.sellgui.SellGUIMain;
import me.aov.sellgui.commands.PriceSetterCommand;
import me.aov.sellgui.gui.PriceSetterGUI;
import me.aov.sellgui.handlers.InventoryHandler;
import me.aov.sellgui.handlers.SoundHandler;
import me.aov.sellgui.listeners.PriceSetterChatListener;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class PriceSetterListener
implements Listener {
    private final SellGUIMain main;

    public PriceSetterListener(SellGUIMain main) {
        this.main = main;
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        InventoryHolder topHolder = InventoryHandler.getTopInventoryHolder(event);
        if (!(topHolder instanceof PriceSetterGUI)) {
            return;
        }
        PriceSetterGUI gui = (PriceSetterGUI)topHolder;
        ItemStack clickedItem = event.getCurrentItem();
        int slot = event.getSlot();
        if (event.getClickedInventory() == null || !(event.getClickedInventory().getHolder() instanceof PriceSetterGUI)) {
            return;
        }
        this.handlePriceSetterGUIClick(event, gui, slot, clickedItem);
    }

    private void handlePriceSetterGUIClick(InventoryClickEvent event, PriceSetterGUI gui, int slot, ItemStack clickedItem) {
        ItemMeta meta;
        if (slot == PriceSetterGUI.getItemSlot()) {
            if (event.getCursor() != null && event.getCursor().getType() != Material.AIR) {
                SoundHandler.playItemPickup((Player)event.getWhoClicked());
                event.setCancelled(false);
                this.main.getServer().getScheduler().runTaskLater((Plugin)this.main, () -> gui.updateItemInfo(), 1L);
                return;
            }
            if (clickedItem != null && clickedItem.getType() != Material.AIR) {
                SoundHandler.playItemPickup((Player)event.getWhoClicked());
                event.setCancelled(false);
                this.main.getServer().getScheduler().runTaskLater((Plugin)this.main, () -> gui.updateItemInfo(), 1L);
                return;
            }
        }
        if (slot == PriceSetterGUI.getPriceInputSlot()) {
            event.setCancelled(true);
            return;
        }
        if (clickedItem != null && clickedItem.hasItemMeta() && (meta = clickedItem.getItemMeta()).getPersistentDataContainer().has(new NamespacedKey((Plugin)this.main, "price-setter-action"), PersistentDataType.STRING)) {
            event.setCancelled(true);
            String action = (String)meta.getPersistentDataContainer().get(new NamespacedKey((Plugin)this.main, "price-setter-action"), PersistentDataType.STRING);
            Player player = (Player)event.getWhoClicked();
            this.handleActionButton(player, gui, action);
            return;
        }
        event.setCancelled(true);
    }

    @EventHandler
    public void onInventoryDrag(InventoryDragEvent event) {
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        InventoryHolder topHolder = InventoryHandler.getTopInventoryHolder(event);
        if (!(topHolder instanceof PriceSetterGUI)) {
            return;
        }
        PriceSetterGUI gui = (PriceSetterGUI)topHolder;
        boolean dragInGUI = false;
        boolean dragToItemSlot = false;
        int topInventorySize = InventoryHandler.getTopInventorySize(event);
        Iterator iterator = event.getRawSlots().iterator();
        while (iterator.hasNext()) {
            int rawSlot = (Integer)iterator.next();
            if (rawSlot >= topInventorySize) continue;
            dragInGUI = true;
            if (rawSlot != PriceSetterGUI.getItemSlot()) continue;
            dragToItemSlot = true;
        }
        if (dragInGUI) {
            if (!dragToItemSlot) {
                event.setCancelled(true);
            } else {
                this.main.getServer().getScheduler().runTaskLater((Plugin)this.main, () -> gui.updateItemInfo(), 1L);
            }
        }
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        if (!(event.getPlayer() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getPlayer();
        InventoryHolder holder = event.getInventory().getHolder();
        if (holder instanceof PriceSetterGUI) {
            PriceSetterCommand.removePriceSetterGUI(player);
            ItemStack item = event.getInventory().getItem(PriceSetterGUI.getItemSlot());
            if (item != null && item.getType() != Material.AIR) {
                if (player.getInventory().firstEmpty() != -1) {
                    player.getInventory().addItem(new ItemStack[]{item});
                } else {
                    player.getWorld().dropItem(player.getLocation(), item);
                    player.sendMessage(this.color("&eItem dropped on ground as your inventory is full!"));
                }
            }
        }
    }

    private void handleActionButton(Player player, PriceSetterGUI gui, String action) {
        switch (action.toLowerCase()) {
            case "save": {
                ItemStack item = gui.getInventory().getItem(PriceSetterGUI.getItemSlot());
                if (item == null || item.getType() == Material.AIR) {
                    SoundHandler.playError(player);
                    player.sendMessage(this.color("&cNo item found to save price for!"));
                    return;
                }
                SoundHandler.playUIClick(player);
                player.sendMessage(this.color("&aUse &f/sellguiprice <price> &ato set the price for this item."));
                break;
            }
            case "cancel": {
                SoundHandler.playChestClose(player);
                player.closeInventory();
                player.sendMessage(this.color("&cPrice setting cancelled."));
                break;
            }
            case "delete": {
                boolean success = gui.deletePrice();
                if (success) {
                    SoundHandler.playSuccess(player);
                    player.sendMessage(this.color("&aPrice deleted successfully!"));
                    break;
                }
                SoundHandler.playError(player);
                break;
            }
            case "chat": {
                ItemStack e = gui.getInventory().getItem(PriceSetterGUI.getItemSlot());
                if (e == null || e.getType() == Material.AIR) {
                    SoundHandler.playError(player);
                    player.sendMessage(this.color("&cNo item found to set price for!"));
                    return;
                }
                PriceSetterChatListener.setPlayerItem(player, e.clone());
                SoundHandler.playUIClick(player);
                player.closeInventory();
                PriceSetterChatListener.startWaitingForPrice(player);
                break;
            }
            default: {
                player.sendMessage(this.color("&cUnknown action: " + action));
            }
        }
    }

    private String color(String text) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)text);
    }
}

