/*
 * Decompiled with CFR 0.152.
 */
package me.aov.sellgui.config;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import me.aov.sellgui.SellGUIMain;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class ConfigManager {
    private final SellGUIMain plugin;
    private final Map<String, FileConfiguration> configs;
    private final Map<String, File> configFiles;

    public ConfigManager(SellGUIMain plugin) {
        this.plugin = plugin;
        this.configs = new HashMap<String, FileConfiguration>();
        this.configFiles = new HashMap<String, File>();
    }

    public void initializeConfigs() {
        if (!this.plugin.getDataFolder().exists()) {
            this.plugin.getDataFolder().mkdirs();
        }
        this.loadConfig("config");
        this.loadConfig("sounds");
        this.loadConfig("gui");
        this.loadConfig("messages");
        this.loadConfig("itemprices");
        this.loadConfig("mmoitems");
        this.loadConfig("nexo");
        this.loadConfig("random-prices");
        this.plugin.getLogger().info("Loaded " + this.configs.size() + " configuration files");
    }

    private void loadConfig(String configName) {
        File configFile = new File(this.plugin.getDataFolder(), configName + ".yml");
        if (!configFile.exists()) {
            this.plugin.saveResource(configName + ".yml", false);
        }
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)configFile);
        this.configs.put(configName, (FileConfiguration)config);
        this.configFiles.put(configName, configFile);
        this.plugin.getLogger().info("Loaded config: " + configName + ".yml");
    }

    public FileConfiguration getConfig(String configName) {
        return this.configs.get(configName);
    }

    public FileConfiguration getMainConfig() {
        return this.getConfig("config");
    }

    public FileConfiguration getSoundsConfig() {
        return this.getConfig("sounds");
    }

    public FileConfiguration getGUIConfig() {
        return this.getConfig("gui");
    }

    public FileConfiguration getMessagesConfig() {
        return this.getConfig("messages");
    }

    public FileConfiguration getItemPricesConfig() {
        return this.getConfig("itemprices");
    }

    public FileConfiguration getMMOItemsConfig() {
        return this.getConfig("mmoitems");
    }

    public FileConfiguration getNexoConfig() {
        return this.getConfig("nexo");
    }

    public FileConfiguration getRandomPricesConfig() {
        return this.getConfig("random-prices");
    }

    public void saveConfig(String configName) {
        FileConfiguration config = this.configs.get(configName);
        File configFile = this.configFiles.get(configName);
        if (config != null && configFile != null) {
            try {
                config.save(configFile);
            }
            catch (IOException e) {
                this.plugin.getLogger().severe("Failed to save config " + configName + ".yml: " + e.getMessage());
            }
        }
    }

    public void saveAllConfigs() {
        for (String configName : this.configs.keySet()) {
            this.saveConfig(configName);
        }
    }

    public void reloadConfig(String configName) {
        File configFile = this.configFiles.get(configName);
        if (configFile != null && configFile.exists()) {
            YamlConfiguration config = YamlConfiguration.loadConfiguration((File)configFile);
            this.configs.put(configName, (FileConfiguration)config);
            this.plugin.getLogger().info("Reloaded config: " + configName + ".yml");
        }
    }

    public void reloadAllConfigs() {
        for (String configName : this.configs.keySet()) {
            this.reloadConfig(configName);
        }
        this.plugin.getLogger().info("Reloaded all configuration files");
    }

    public String getString(String configName, String path, String fallback) {
        FileConfiguration config = this.getConfig(configName);
        if (config != null) {
            return config.getString(path, fallback);
        }
        return fallback;
    }

    public double getDouble(String configName, String path, double fallback) {
        FileConfiguration config = this.getConfig(configName);
        if (config != null) {
            return config.getDouble(path, fallback);
        }
        return fallback;
    }

    public boolean getBoolean(String configName, String path, boolean fallback) {
        FileConfiguration config = this.getConfig(configName);
        if (config != null) {
            return config.getBoolean(path, fallback);
        }
        return fallback;
    }

    public int getInt(String configName, String path, int fallback) {
        FileConfiguration config = this.getConfig(configName);
        if (config != null) {
            return config.getInt(path, fallback);
        }
        return fallback;
    }
}

