/*
 * Decompiled with CFR 0.152.
 */
package me.aov.sellgui.gui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import me.aov.sellgui.SellGUIMain;
import me.aov.sellgui.managers.PriceManager;
import me.aov.sellgui.utils.ItemIdentifier;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class PriceSetterGUI
implements InventoryHolder {
    private final SellGUIMain main;
    private final Player player;
    private final Inventory inventory;
    private final PriceManager priceManager;
    private static final int ITEM_SLOT = 13;
    private static final int PRICE_INPUT_SLOT = 22;
    private static final int SAVE_BUTTON_SLOT = 29;
    private static final int CANCEL_BUTTON_SLOT = 33;
    private static final int DELETE_BUTTON_SLOT = 31;
    private static final int CHAT_INPUT_SLOT = 40;
    private static final int INFO_SLOT = 4;

    public PriceSetterGUI(SellGUIMain main, Player player) {
        this.main = main;
        this.player = player;
        this.priceManager = new PriceManager(main);
        this.inventory = Bukkit.createInventory((InventoryHolder)this, (int)45, (String)this.color("&6&lPrice Setter"));
        this.setupGUI();
        player.openInventory(this.inventory);
    }

    private void setupGUI() {
        ItemStack filler = this.createItem(Material.BLACK_STAINED_GLASS_PANE, " ", null);
        for (int i = 0; i < this.inventory.getSize(); ++i) {
            this.inventory.setItem(i, filler);
        }
        this.inventory.setItem(13, null);
        this.inventory.setItem(22, null);
        ItemStack infoItem = this.createItem(Material.BOOK, this.color("&e&lHow to use:"), Arrays.asList(this.color("&71. Drag an item to the center slot"), this.color("&72. Use /sellguiprice <price> to set price"), this.color("&73. Click Save to confirm"), this.color("&7"), this.color("&eSupports: Vanilla, MMOItems, Nexo")));
        this.inventory.setItem(4, infoItem);
        this.setupControlButtons();
    }

    private void setupControlButtons() {
        ItemStack saveButton = this.createItem(Material.GREEN_CONCRETE, this.color("&a&lSave Price"), Arrays.asList(this.color("&7Click to save the current price"), this.color("&7for the item in the center slot")));
        this.addPersistentData(saveButton, "price-setter-action", "save");
        this.inventory.setItem(29, saveButton);
        ItemStack cancelButton = this.createItem(Material.RED_CONCRETE, this.color("&c&lCancel"), Arrays.asList(this.color("&7Click to close without saving")));
        this.addPersistentData(cancelButton, "price-setter-action", "cancel");
        this.inventory.setItem(33, cancelButton);
        ItemStack deleteButton = this.createItem(Material.BARRIER, this.color("&4&lDelete Price"), Arrays.asList(this.color("&7Click to remove the price"), this.color("&7for the item in the center slot")));
        this.addPersistentData(deleteButton, "price-setter-action", "delete");
        this.inventory.setItem(31, deleteButton);
        ItemStack chatButton = this.createItem(Material.WRITABLE_BOOK, this.color("&b&lSet Price via Chat"), Arrays.asList(this.color("&7Click to close GUI and type price in chat"), this.color("&7GUI will reopen automatically after setting"), this.color("&7Type 'cancel' to cancel input")));
        this.addPersistentData(chatButton, "price-setter-action", "chat");
        this.inventory.setItem(40, chatButton);
    }

    public void updateItemInfo() {
        ItemStack item = this.inventory.getItem(13);
        if (item == null || item.getType() == Material.AIR) {
            this.inventory.setItem(22, null);
            return;
        }
        System.out.println("[SellGUI Debug] Updating item info for: " + item.getType().name());
        if (item.hasItemMeta() && item.getItemMeta().hasDisplayName()) {
            System.out.println("[SellGUI Debug] Item display name: " + item.getItemMeta().getDisplayName());
        }
        ItemIdentifier.debugItemNBT(item);
        double currentPrice = this.priceManager.getItemPrice(item);
        ItemIdentifier.ItemType itemType = ItemIdentifier.getItemType(item);
        String itemName = ItemIdentifier.getItemDisplayName(item);
        String identifier = ItemIdentifier.getItemIdentifier(item);
        System.out.println("[SellGUI Debug] Item type detected: " + String.valueOf((Object)itemType));
        System.out.println("[SellGUI Debug] Item identifier: " + identifier);
        System.out.println("[SellGUI Debug] Current price: " + currentPrice);
        ArrayList<String> lore = new ArrayList<String>();
        lore.add(this.color("&7Item: &f" + itemName));
        lore.add(this.color("&7Type: &f" + itemType.name()));
        lore.add(this.color("&7Identifier: &f" + (identifier != null ? identifier : "Unknown")));
        lore.add(this.color("&7"));
        lore.add(this.color("&7Current Price: &e$" + String.format("%.2f", currentPrice)));
        lore.add(this.color("&7"));
        lore.add(this.color("&eUse: &f/sellguiprice <price>"));
        lore.add(this.color("&eto set a new price"));
        ItemStack priceInfo = this.createItem(Material.GOLD_INGOT, this.color("&6&lPrice Information"), lore);
        this.inventory.setItem(22, priceInfo);
    }

    public boolean savePrice(double price) {
        ItemStack item = this.inventory.getItem(13);
        if (item == null || item.getType() == Material.AIR) {
            this.player.sendMessage(this.color("&cNo item found to set price for!"));
            return false;
        }
        if (price < 0.0) {
            this.player.sendMessage(this.color("&cPrice cannot be negative!"));
            return false;
        }
        boolean success = this.priceManager.setItemPrice(item, price);
        if (success) {
            String itemName = ItemIdentifier.getItemDisplayName(item);
            this.player.sendMessage(this.color("&aSuccessfully set price for &f" + itemName + " &ato &e$" + String.format("%.2f", price)));
            this.updateItemInfo();
            return true;
        }
        this.player.sendMessage(this.color("&cFailed to set price! Check console for errors."));
        return false;
    }

    public boolean deletePrice() {
        ItemStack item = this.inventory.getItem(13);
        if (item == null || item.getType() == Material.AIR) {
            this.player.sendMessage(this.color("&cNo item found to delete price for!"));
            return false;
        }
        boolean success = this.priceManager.removeItemPrice(item);
        if (success) {
            String itemName = ItemIdentifier.getItemDisplayName(item);
            this.player.sendMessage(this.color("&aSuccessfully removed price for &f" + itemName));
            this.updateItemInfo();
            return true;
        }
        this.player.sendMessage(this.color("&cFailed to remove price! Check console for errors."));
        return false;
    }

    private ItemStack createItem(Material material, String name, List<String> lore) {
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(name);
            if (lore != null) {
                meta.setLore(lore);
            }
            item.setItemMeta(meta);
        }
        return item;
    }

    private void addPersistentData(ItemStack item, String key, String value) {
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.getPersistentDataContainer().set(new NamespacedKey((Plugin)this.main, key), PersistentDataType.STRING, (Object)value);
            item.setItemMeta(meta);
        }
    }

    private String color(String text) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)text);
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    public Player getPlayer() {
        return this.player;
    }

    public static int getItemSlot() {
        return 13;
    }

    public static int getPriceInputSlot() {
        return 22;
    }
}

