/*
 * Decompiled with CFR 0.152.
 */
package me.aov.sellgui.managers;

import java.lang.reflect.Method;
import java.util.Random;
import me.aov.sellgui.SellGUIMain;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class RandomPriceManager {
    private final SellGUIMain plugin;
    private final Random random;

    public RandomPriceManager(SellGUIMain plugin) {
        this.plugin = plugin;
        this.random = new Random();
    }

    public void setRandomPriceRange(ItemStack item, double minPrice, double maxPrice, String playerName) {
        if (item == null) {
            return;
        }
        String itemKey = this.getItemKey(item);
        String itemType = this.getItemType(item);
        FileConfiguration config = this.getRandomPricesConfig();
        if (config == null) {
            return;
        }
        String path = "prices." + itemKey;
        config.set(path + ".min_price", (Object)minPrice);
        config.set(path + ".max_price", (Object)maxPrice);
        config.set(path + ".last_updated", (Object)System.currentTimeMillis());
        config.set(path + ".set_by", (Object)playerName);
        config.set(path + ".item_type", (Object)itemType);
        this.saveConfig();
        this.plugin.getLogger().info("Set random price range for " + itemKey + ": $" + minPrice + " - $" + maxPrice);
    }

    public double getRandomPrice(ItemStack item) {
        double maxPrice;
        if (item == null) {
            return 0.0;
        }
        String itemKey = this.getItemKey(item);
        FileConfiguration config = this.getRandomPricesConfig();
        if (config == null) {
            return 0.0;
        }
        String path = "prices." + itemKey;
        if (!config.contains(path)) {
            return 0.0;
        }
        double minPrice = config.getDouble(path + ".min_price", 0.0);
        if (minPrice >= (maxPrice = config.getDouble(path + ".max_price", 0.0))) {
            return minPrice;
        }
        return minPrice + this.random.nextDouble() * (maxPrice - minPrice);
    }

    public double[] getPriceRange(ItemStack item) {
        if (item == null) {
            return null;
        }
        String itemKey = this.getItemKey(item);
        FileConfiguration config = this.getRandomPricesConfig();
        if (config == null) {
            return null;
        }
        String path = "prices." + itemKey;
        if (!config.contains(path)) {
            return null;
        }
        double minPrice = config.getDouble(path + ".min_price", 0.0);
        double maxPrice = config.getDouble(path + ".max_price", 0.0);
        return new double[]{minPrice, maxPrice};
    }

    public boolean hasRandomPrice(ItemStack item) {
        if (item == null) {
            return false;
        }
        String itemKey = this.getItemKey(item);
        FileConfiguration config = this.getRandomPricesConfig();
        if (config == null) {
            return false;
        }
        return config.contains("prices." + itemKey);
    }

    public void removeRandomPrice(ItemStack item) {
        if (item == null) {
            return;
        }
        String itemKey = this.getItemKey(item);
        FileConfiguration config = this.getRandomPricesConfig();
        if (config == null) {
            return;
        }
        config.set("prices." + itemKey, null);
        this.saveConfig();
        this.plugin.getLogger().info("Removed random price range for " + itemKey);
    }

    private String getItemKey(ItemStack item) {
        if (this.hasMMOItems()) {
            try {
                String mmoId = this.getMMOItemsId(item);
                if (mmoId != null) {
                    return "mmoitems:" + mmoId;
                }
            }
            catch (Exception mmoId) {
                // empty catch block
            }
        }
        if (this.hasNexo()) {
            try {
                String nexoId = this.getNexoId(item);
                if (nexoId != null) {
                    return "nexo:" + nexoId;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return item.getType().name();
    }

    private String getItemType(ItemStack item) {
        if (this.hasMMOItems()) {
            try {
                String mmoId = this.getMMOItemsId(item);
                if (mmoId != null) {
                    return "MMOITEMS";
                }
            }
            catch (Exception mmoId) {
                // empty catch block
            }
        }
        if (this.hasNexo()) {
            try {
                String nexoId = this.getNexoId(item);
                if (nexoId != null) {
                    return "NEXO";
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return "VANILLA";
    }

    private boolean hasMMOItems() {
        try {
            return this.plugin.getServer().getPluginManager().getPlugin("MMOItems") != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean hasNexo() {
        try {
            return this.plugin.getServer().getPluginManager().getPlugin("Nexo") != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    private String getMMOItemsId(ItemStack item) {
        try {
            if (item.hasItemMeta() && item.getItemMeta().hasDisplayName()) {
                String displayName = item.getItemMeta().getDisplayName();
                return null;
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    private String getNexoId(ItemStack item) {
        try {
            try {
                Class<?> nexoItemsClass = Class.forName("com.nexomc.nexo.api.NexoItems");
                Method getIdMethod = nexoItemsClass.getMethod("idFromItem", ItemStack.class);
                Object result = getIdMethod.invoke(null, item);
                if (result != null) {
                    return result.toString();
                }
            }
            catch (Exception nexoItemsClass) {
                // empty catch block
            }
            return null;
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Error detecting Nexo item: " + e.getMessage());
            return null;
        }
    }

    private FileConfiguration getRandomPricesConfig() {
        if (this.plugin.getConfigManager() != null) {
            return this.plugin.getConfigManager().getConfig("random-prices");
        }
        return null;
    }

    private void saveConfig() {
        if (this.plugin.getConfigManager() != null) {
            this.plugin.getConfigManager().saveConfig("random-prices");
        }
    }

    public void cleanupOldEntries() {
        FileConfiguration config = this.getRandomPricesConfig();
        if (config == null) {
            return;
        }
        boolean autoCleanup = config.getBoolean("config.auto_cleanup", true);
        if (!autoCleanup) {
            return;
        }
        int cleanupDays = config.getInt("config.cleanup_days", 30);
        long cutoffTime = System.currentTimeMillis() - (long)(cleanupDays * 24 * 60 * 60) * 1000L;
        if (config.contains("prices")) {
            for (String key : config.getConfigurationSection("prices").getKeys(false)) {
                long lastUpdated = config.getLong("prices." + key + ".last_updated", 0L);
                if (lastUpdated >= cutoffTime) continue;
                config.set("prices." + key, null);
                this.plugin.getLogger().info("Cleaned up old random price entry: " + key);
            }
        }
        this.saveConfig();
    }

    public int getStoredPricesCount() {
        FileConfiguration config = this.getRandomPricesConfig();
        if (config == null || !config.contains("prices")) {
            return 0;
        }
        return config.getConfigurationSection("prices").getKeys(false).size();
    }

    public boolean requiresEvaluation(ItemStack item) {
        return this.hasRandomPrice(item);
    }

    public boolean isEvaluated(ItemStack item) {
        if (item == null || !item.hasItemMeta()) {
            return false;
        }
        if (item.getItemMeta().getPersistentDataContainer() != null) {
            try {
                NamespacedKey worthKey = new NamespacedKey((Plugin)this.plugin, "worth");
                if (item.getItemMeta().getPersistentDataContainer().has(worthKey, PersistentDataType.DOUBLE)) {
                    return true;
                }
            }
            catch (Exception worthKey) {
                // empty catch block
            }
        }
        if (item.hasItemMeta() && item.getItemMeta().getPersistentDataContainer() != null) {
            try {
                NamespacedKey evaluatedKey = new NamespacedKey((Plugin)this.plugin, "evaluated");
                if (item.getItemMeta().getPersistentDataContainer().has(evaluatedKey, PersistentDataType.BYTE)) {
                    return true;
                }
            }
            catch (Exception evaluatedKey) {
                // empty catch block
            }
        }
        try {
            if (this.plugin.getNBTPriceManager() != null) {
                double nbtPrice = this.plugin.getNBTPriceManager().getPriceFromNBT(item);
                return nbtPrice > 0.0;
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Error checking NBT price: " + e.getMessage());
        }
        return false;
    }

    public boolean canBeSold(ItemStack item) {
        if (!this.requiresEvaluation(item)) {
            return true;
        }
        return this.isEvaluated(item);
    }
}

