/*
 * Decompiled with CFR 0.152.
 */
package me.aov.sellgui.commands;

import java.util.ArrayList;
import me.aov.sellgui.SellGUI;
import me.aov.sellgui.SellGUIMain;
import me.aov.sellgui.gui.PriceEvaluationGUI;
import me.aov.sellgui.managers.PriceManager;
import me.aov.sellgui.utils.ItemIdentifier;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class SellCommand
implements CommandExecutor {
    private final SellGUIMain main;
    private static ArrayList<SellGUI> sellGUIS;

    public SellCommand(SellGUIMain main) {
        this.main = main;
        sellGUIS = new ArrayList();
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (args.length > 0) {
            switch (args[0].toLowerCase()) {
                case "reload": {
                    if (!sender.hasPermission("sellgui.reload")) {
                        sender.sendMessage(SellCommand.color("&cYou do not have permission."));
                        return true;
                    }
                    this.main.reload();
                    sender.sendMessage(SellCommand.color("&aSellGUI configs and GUIs have been reloaded."));
                    return true;
                }
                case "evaluate": {
                    if (!(sender instanceof Player)) {
                        sender.sendMessage(SellCommand.color("&cOnly players can use this command."));
                        return true;
                    }
                    if (!sender.hasPermission("sellgui.evaluate")) {
                        sender.sendMessage(SellCommand.color("&cYou do not have permission."));
                        return true;
                    }
                    this.main.getGUIManager().openPriceEvaluationGUI((Player)sender);
                    return true;
                }
                case "setprice": {
                    if (!(sender instanceof Player)) {
                        sender.sendMessage(SellCommand.color("&cOnly players can use this command."));
                        return true;
                    }
                    if (!sender.hasPermission("sellgui.setprice")) {
                        sender.sendMessage(SellCommand.color("&cYou do not have permission."));
                        return true;
                    }
                    if (args.length != 2) {
                        sender.sendMessage(SellCommand.color("&cUsage: /sellgui setprice <amount>"));
                        return true;
                    }
                    return this.handleSetPriceInHand((Player)sender, args[1]);
                }
                case "setrange": {
                    if (!(sender instanceof Player)) {
                        sender.sendMessage(SellCommand.color("&cOnly players can use this command."));
                        return true;
                    }
                    if (!sender.hasPermission("sellgui.setrange")) {
                        sender.sendMessage(SellCommand.color("&cYou do not have permission."));
                        return true;
                    }
                    if (args.length != 3) {
                        sender.sendMessage(SellCommand.color("&cUsage: /sellgui setrange <min> <max>"));
                        return true;
                    }
                    return this.handleSetRandomPrice((Player)sender, args[1], args[2]);
                }
                case "help": {
                    return this.handleHelpCommand(sender);
                }
            }
        }
        if (!(sender instanceof Player)) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "This command can only be executed by a player.");
            return true;
        }
        Player player = (Player)sender;
        if (args.length == 0) {
            if (player.hasPermission("sellgui.use")) {
                sellGUIS.add(new SellGUI(this.main, player));
            } else {
                player.sendMessage(SellCommand.color("&cYou do not have permission to use this command."));
            }
            return true;
        }
        if (args.length == 1) {
            if (player.hasPermission("sellgui.others")) {
                Player target = this.main.getServer().getPlayer(args[0]);
                if (target != null) {
                    sellGUIS.add(new SellGUI(this.main, target));
                    player.sendMessage(SellCommand.color("&aSuccessfully opened SellGUI for " + target.getName() + "."));
                } else {
                    player.sendMessage(SellCommand.color("&cPlayer '" + args[0] + "' not found or is not online."));
                }
            } else {
                player.sendMessage(SellCommand.color("&cYou do not have permission to open SellGUI for other players."));
            }
            return true;
        }
        sender.sendMessage(SellCommand.color("&cInvalid command usage. Try: /" + label + " help"));
        return true;
    }

    private boolean handleSetPriceInHand(Player player, String priceString) {
        double price;
        ItemStack itemInHand = player.getInventory().getItemInMainHand();
        if (itemInHand.getType() == Material.AIR) {
            player.sendMessage(SellCommand.color("&cYou must be holding an item to set its price!"));
            return true;
        }
        try {
            price = Double.parseDouble(priceString);
        }
        catch (NumberFormatException e) {
            player.sendMessage(SellCommand.color("&cInvalid price! Please enter a valid number."));
            return true;
        }
        if (price < 0.0) {
            player.sendMessage(SellCommand.color("&cPrice cannot be negative!"));
            return true;
        }
        PriceManager priceManager = new PriceManager(this.main);
        boolean success = priceManager.setItemPrice(itemInHand, price);
        if (success) {
            String itemName = ItemIdentifier.getItemDisplayName(itemInHand);
            String itemType = ItemIdentifier.getItemType(itemInHand).name();
            if (price == 0.0) {
                player.sendMessage(SellCommand.color("&aSuccessfully removed price for &f" + itemName + " &7(" + itemType + ")"));
            } else {
                player.sendMessage(SellCommand.color("&aSuccessfully set price for &f" + itemName + " &7(" + itemType + ") &ato &e$" + String.format("%.2f", price)));
            }
        } else {
            player.sendMessage(SellCommand.color("&cFailed to set price! Check console for errors."));
        }
        return true;
    }

    private boolean handleSetRandomPrice(Player player, String minString, String maxString) {
        try {
            double minPrice = Double.parseDouble(minString);
            double maxPrice = Double.parseDouble(maxString);
            if (minPrice < 0.0 || maxPrice < 0.0) {
                player.sendMessage(SellCommand.color("&cPrices cannot be negative!"));
                return true;
            }
            if (minPrice >= maxPrice) {
                player.sendMessage(SellCommand.color("&cMinimum price must be less than maximum price!"));
                return true;
            }
            ItemStack item = player.getInventory().getItemInMainHand();
            if (item.getType() == Material.AIR) {
                player.sendMessage(SellCommand.color("&cYou must be holding an item to set its price range."));
                return true;
            }
            String itemIdentifier = ItemIdentifier.getItemIdentifier(item);
            if (itemIdentifier == null) {
                player.sendMessage(SellCommand.color("&cCould not identify the item you are holding."));
                return true;
            }
            String key = itemIdentifier;
            FileConfiguration randomPricesConfig = this.main.getConfigManager().getRandomPricesConfig();
            randomPricesConfig.set(key + ".min_price", (Object)minPrice);
            randomPricesConfig.set(key + ".max_price", (Object)maxPrice);
            randomPricesConfig.set(key + ".last_updated", (Object)System.currentTimeMillis());
            randomPricesConfig.set(key + ".set_by", (Object)player.getName());
            randomPricesConfig.set(key + ".item_type", (Object)ItemIdentifier.getItemType(item).name());
            this.main.getConfigManager().saveConfig("random-prices");
            player.sendMessage(SellCommand.color("&aRandom price range for &e" + ItemIdentifier.getItemDisplayName(item) + " &aset to &e$" + String.format("%.2f", minPrice) + " &ato &e$" + String.format("%.2f", maxPrice)));
            PriceEvaluationGUI gui = this.main.getGUIManager().getActivePriceEvaluationGUI(player);
            if (gui != null) {
                gui.setRandomPrice(minPrice, maxPrice);
            }
        }
        catch (NumberFormatException e) {
            player.sendMessage(SellCommand.color("&cInvalid price format! Use numbers only."));
        }
        return true;
    }

    private boolean handleHelpCommand(CommandSender sender) {
        sender.sendMessage(SellCommand.color("&6&l=== SellGUI Help ===="));
        sender.sendMessage("");
        sender.sendMessage(SellCommand.color("&e/sellgui &7- Open the sell GUI"));
        sender.sendMessage(SellCommand.color("&e/sellgui help &7- Show this help message"));
        if (sender.hasPermission("sellgui.evaluate")) {
            sender.sendMessage(SellCommand.color("&e/sellgui evaluate &7- Open the Price Evaluation GUI."));
        }
        if (sender.hasPermission("sellgui.setprice")) {
            sender.sendMessage(SellCommand.color("&e/sellgui setprice <amount> &7- Set fixed price in Evaluation GUI."));
        }
        if (sender.hasPermission("sellgui.setrange")) {
            sender.sendMessage(SellCommand.color("&e/sellgui setrange <min> <max> &7- Set random range in Evaluation GUI."));
        }
        if (sender.hasPermission("sellgui.reload")) {
            sender.sendMessage(SellCommand.color("&c/sellgui reload &7- Reload plugin configuration."));
        }
        sender.sendMessage(SellCommand.color("&6&l=================="));
        return true;
    }

    public static String color(String s) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)s);
    }

    public static ArrayList<SellGUI> getSellGUIs() {
        return sellGUIS;
    }

    public static boolean isSellGUI(Inventory inventory) {
        for (SellGUI sellGUI : sellGUIS) {
            if (!sellGUI.getMenu().equals((Object)inventory)) continue;
            return true;
        }
        return false;
    }

    public static SellGUI getSellGUI(Player player) {
        for (SellGUI sellGUI : sellGUIS) {
            if (!sellGUI.getPlayer().equals((Object)player)) continue;
            return sellGUI;
        }
        return null;
    }

    public static boolean openSellGUI(Player player) {
        return sellGUIS.stream().anyMatch(sellGUI -> sellGUI.getPlayer().equals((Object)player));
    }
}

