/*
 * Decompiled with CFR 0.152.
 */
package me.aov.sellgui;

import io.lumine.mythic.lib.api.item.ItemTag;
import io.lumine.mythic.lib.api.item.NBTCompound;
import io.lumine.mythic.lib.api.item.NBTItem;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import me.aov.sellgui.SellGUIMain;
import me.aov.sellgui.commands.SellCommand;
import me.aov.sellgui.handlers.SoundHandler;
import me.aov.sellgui.listeners.InventoryListeners;
import me.aov.sellgui.managers.PriceManager;
import me.aov.sellgui.utils.ItemIdentifier;
import net.Indyuce.mmoitems.MMOItems;
import net.Indyuce.mmoitems.api.Type;
import net.Indyuce.mmoitems.api.item.mmoitem.MMOItem;
import net.brcdev.shopgui.ShopGuiPlusApi;
import org.apache.commons.lang.WordUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.ShulkerBox;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.permissions.PermissionAttachmentInfo;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class SellGUI
implements Listener {
    private final SellGUIMain main;
    private final Player player;
    private static ItemStack sellItem;
    private static ItemStack filler;
    private String menuTitle;
    private static Inventory menu;
    private ItemStack confirmItem;
    private ItemStack noItemsItemStack;
    private int sellItemSlot;
    private int updateTaskId = -1;
    private boolean isConfirmMode = false;

    public SellGUI(SellGUIMain main, Player p) {
        this.main = main;
        this.player = p;
        this.createItems();
        this.createMenu();
        this.addCustomItems();
        p.openInventory(menu);
        this.startAutoUpdateTask();
    }

    private void createMenu() {
        FileConfiguration guiConfig = this.main.getConfigManager() != null ? this.main.getConfigManager().getGUIConfig() : null;
        int size = 54;
        if (guiConfig != null) {
            size = guiConfig.getInt("sell_gui.size", 54);
        }
        menu = Bukkit.createInventory((InventoryHolder)null, (int)size, (String)SellGUI.color(this.menuTitle));
        this.addFillerFromConfig();
        this.addSellItem();
    }

    private boolean isSellItem(ItemStack item) {
        return this.item(item, sellItem);
    }

    private boolean item(ItemStack item, ItemStack sellItem) {
        if (item == null || item.getType() != sellItem.getType()) {
            return false;
        }
        ItemMeta meta1 = item.getItemMeta();
        ItemMeta meta2 = sellItem.getItemMeta();
        return !(meta1.hasDisplayName() != meta2.hasDisplayName() || meta1.hasDisplayName() && !meta1.getDisplayName().equals(meta2.getDisplayName()) || meta1.hasLore() != meta2.hasLore() || meta1.hasLore() && !meta1.getLore().equals(meta2.getLore()) || meta1.hasCustomModelData() != meta2.hasCustomModelData() || meta1.hasCustomModelData() && meta1.getCustomModelData() != meta2.getCustomModelData());
    }

    private boolean isConfirmItem(ItemStack item) {
        return this.item(item, this.confirmItem);
    }

    private boolean isFillerItem(ItemStack item) {
        if (item == null || item.getType() != filler.getType()) {
            return false;
        }
        ItemMeta meta1 = filler.getItemMeta();
        ItemMeta meta2 = filler.getItemMeta();
        return meta1.hasCustomModelData() == meta2.hasCustomModelData() && (!meta1.hasCustomModelData() || meta1.getCustomModelData() == meta2.getCustomModelData());
    }

    private void addCustomItems() {
        for (String itemPath : this.main.getCustomMenuItemsConfig().getKeys(false)) {
            ItemStack customItem = new ItemStack(Material.valueOf((String)this.main.getCustomMenuItemsConfig().getString(itemPath + ".material")));
            ItemMeta itemMeta = customItem.getItemMeta();
            if (this.main.getCustomMenuItemsConfig().contains(itemPath + ".custom-model-data")) {
                itemMeta.setCustomModelData(Integer.valueOf(this.main.getCustomMenuItemsConfig().getInt(itemPath + ".custom-model-data")));
            }
            if (!this.main.getCustomMenuItemsConfig().getString(itemPath + ".name").isEmpty()) {
                itemMeta.setDisplayName(SellGUI.color(this.main.getCustomMenuItemsConfig().getString(itemPath + ".name")));
            }
            if (this.main.getCustomMenuItemsConfig().getBoolean(itemPath + ".glimmer")) {
                itemMeta.addEnchant(Enchantment.INFINITY, 1, false);
                itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
            }
            if (!this.main.getCustomMenuItemsConfig().getStringList(itemPath + ".lore").isEmpty()) {
                ArrayList<String> lore = new ArrayList<String>();
                for (String s : this.main.getCustomMenuItemsConfig().getStringList(itemPath + ".lore")) {
                    lore.add(SellGUI.color(s));
                }
                itemMeta.setLore(lore);
            }
            NamespacedKey key = new NamespacedKey((Plugin)this.main, "custom-menu-item");
            StringBuilder sb = new StringBuilder();
            for (String command : this.main.getCustomMenuItemsConfig().getStringList(itemPath + ".commands")) {
                sb.append(command.replaceAll("%player%", this.player.getName())).append(";");
            }
            itemMeta.getPersistentDataContainer().set(key, PersistentDataType.STRING, (Object)sb.toString());
            customItem.setItemMeta(itemMeta);
            menu.setItem(this.main.getCustomMenuItemsConfig().getInt(itemPath + ".slot"), customItem);
        }
    }

    public void addSellItem() {
        FileConfiguration guiConfig = this.main.getConfigManager() != null ? this.main.getConfigManager().getGUIConfig() : null;
        int slot = 49;
        if (guiConfig != null) {
            slot = guiConfig.getInt("sell_gui.positions.sell-button", 49);
        }
        int maxSlot = menu.getSize() - 1;
        if (slot < 0 || slot > maxSlot) {
            this.player.sendMessage(String.valueOf(ChatColor.RED) + "Invalid sell-item slot! It must be between 0 and " + maxSlot + ".");
            return;
        }
        menu.setItem(slot, sellItem);
        this.sellItemSlot = slot;
        this.makeConfirmItem();
    }

    private void startAutoUpdateTask() {
        if (this.updateTaskId != -1) {
            this.main.getServer().getScheduler().cancelTask(this.updateTaskId);
        }
        long updateInterval = this.main.getConfig().getLong("performance.gui-update-interval", 20L);
        this.updateTaskId = this.main.getServer().getScheduler().runTaskTimer((Plugin)this.main, () -> {
            if (menu != null && this.player != null && this.player.isOnline() && !this.isConfirmMode) {
                this.updateSellItemTotal();
            } else if (!(this.player.isOnline() && menu != null || this.updateTaskId == -1)) {
                this.main.getServer().getScheduler().cancelTask(this.updateTaskId);
                this.updateTaskId = -1;
            }
        }, 0L, updateInterval).getTaskId();
    }

    public void updateSellItemTotal() {
        if (menu == null || this.isConfirmMode) {
            return;
        }
        double currentTotal = this.getTotal(menu);
        if (currentTotal > 0.0) {
            if (sellItem == null) {
                return;
            }
            ItemMeta meta = sellItem.getItemMeta();
            if (meta != null && meta.hasLore()) {
                ArrayList<String> lore = new ArrayList<String>(meta.getLore());
                for (int i = 0; i < lore.size(); ++i) {
                    String line = (String)lore.get(i);
                    if (!ChatColor.stripColor((String)line).contains("Total Value:")) continue;
                    boolean roundPrices = this.main.shouldRoundPrices();
                    double displayedTotal = currentTotal;
                    if (roundPrices) {
                        displayedTotal = Math.round(currentTotal);
                    }
                    lore.set(i, SellGUI.color("&eTotal Value: &a$" + String.format("%.2f", displayedTotal)));
                    break;
                }
                meta.setLore(lore);
                sellItem.setItemMeta(meta);
                if (this.sellItemSlot >= 0 && this.sellItemSlot < menu.getSize()) {
                    menu.setItem(this.sellItemSlot, sellItem);
                }
            }
        } else if (this.noItemsItemStack != null && this.sellItemSlot >= 0 && this.sellItemSlot < menu.getSize()) {
            menu.setItem(this.sellItemSlot, this.noItemsItemStack);
        }
    }

    public void updateButtonState() {
        if (menu == null) {
            return;
        }
        double currentTotal = this.getTotal(menu);
        if (currentTotal > 0.0) {
            this.makeConfirmItem();
            menu.setItem(this.sellItemSlot, this.confirmItem);
            this.isConfirmMode = true;
        } else {
            menu.setItem(this.sellItemSlot, this.noItemsItemStack);
            this.isConfirmMode = false;
        }
    }

    private void right(String z) {
        if (z.equalsIgnoreCase("left")) {
            menu.setItem(menu.getSize() - 1, (ItemStack)null);
            menu.setItem(menu.getSize() - 1, sellItem);
            this.sellItemSlot = menu.getSize() - 1;
        } else if (z.equalsIgnoreCase("middle")) {
            menu.setItem(8 + 9 * menu.getSize() / 9 / 2, (ItemStack)null);
            menu.setItem(8 + 9 * menu.getSize() / 9 / 2, sellItem);
            this.sellItemSlot = 8 + 9 * menu.getSize() / 9 / 2;
        } else if (z.equalsIgnoreCase("right")) {
            menu.setItem(8, (ItemStack)null);
            menu.setItem(8, sellItem);
            this.sellItemSlot = 8;
        }
    }

    public void cleanup() {
        if (this.updateTaskId != -1) {
            this.main.getServer().getScheduler().cancelTask(this.updateTaskId);
            this.updateTaskId = -1;
        }
    }

    private void createItems() {
        if (this.menuTitle == null || sellItem == null || filler == null) {
            Material noItemsMaterial;
            ItemMeta fillerMeta;
            Material fillerMat;
            ItemMeta sellItemMeta;
            Material material;
            FileConfiguration guiConfig = this.main.getConfigManager() != null ? this.main.getConfigManager().getGUIConfig() : null;
            this.menuTitle = guiConfig != null ? guiConfig.getString("sell_gui.title", "&6&l\u2726 &eSell GUI &6&l\u2726") : "&6&l\u2726 &eSell GUI &6&l\u2726";
            NamespacedKey guiKey = new NamespacedKey((Plugin)this.main, "sellgui");
            NamespacedKey actionKey = new NamespacedKey((Plugin)this.main, "guiAction");
            String sellItemMaterial = "EMERALD";
            if (guiConfig != null) {
                sellItemMaterial = guiConfig.getString("sell_gui.items.sell_button.material", "EMERALD");
            }
            if ((material = Material.getMaterial((String)sellItemMaterial)) == null) {
                material = Material.EMERALD;
                this.main.getLogger().warning("Invalid sell-item material: " + sellItemMaterial + ", using EMERALD");
            }
            if ((sellItemMeta = (sellItem = new ItemStack(material)).getItemMeta()) != null) {
                int modelData;
                String itemName = "&a&lSell Items";
                if (guiConfig != null) {
                    itemName = guiConfig.getString("sell_gui.items.sell_button.name", "&a&lSell Items");
                }
                sellItemMeta.setDisplayName(SellGUI.color(itemName));
                ArrayList<String> lore = new ArrayList<String>();
                if (guiConfig != null) {
                    List configLore = guiConfig.getStringList("sell_gui.items.sell_button.lore");
                    if (configLore.isEmpty()) {
                        lore.add(SellGUI.color("&7Click to sell all items"));
                        lore.add(SellGUI.color("&7in this GUI"));
                        lore.add(SellGUI.color(""));
                        lore.add(SellGUI.color("&eTotal Value: &a$0.00"));
                    } else {
                        for (String s : configLore) {
                            lore.add(SellGUI.color(s));
                        }
                    }
                } else {
                    lore.add(SellGUI.color("&7Click to sell all items"));
                }
                sellItemMeta.setLore(lore);
                boolean addGlow = false;
                if (guiConfig != null) {
                    addGlow = guiConfig.getBoolean("sell_gui.items.sell_button.glow", true);
                }
                if (addGlow) {
                    sellItemMeta.addEnchant(Enchantment.INFINITY, 1, false);
                    sellItemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
                }
                if (guiConfig != null && guiConfig.contains("sell_gui.items.sell_button.custom_model_data") && (modelData = guiConfig.getInt("sell_gui.items.sell_button.custom_model_data")) > 0) {
                    sellItemMeta.setCustomModelData(Integer.valueOf(modelData));
                }
                sellItemMeta.getPersistentDataContainer().set(guiKey, PersistentDataType.BYTE, (Object)1);
                sellItemMeta.getPersistentDataContainer().set(actionKey, PersistentDataType.STRING, (Object)"sell");
                sellItem.setItemMeta(sellItemMeta);
            }
            String fillerMaterial = "GRAY_STAINED_GLASS_PANE";
            if (guiConfig != null) {
                fillerMaterial = guiConfig.getString("sell_gui.items.filler.material", "GRAY_STAINED_GLASS_PANE");
            }
            if ((fillerMat = Material.getMaterial((String)fillerMaterial)) == null) {
                fillerMat = Material.GRAY_STAINED_GLASS_PANE;
                this.main.getLogger().warning("Invalid filler material: " + fillerMaterial + ", using GRAY_STAINED_GLASS_PANE");
            }
            if ((fillerMeta = (filler = new ItemStack(fillerMat)).getItemMeta()) != null) {
                int modelData;
                String fillerName = " ";
                if (guiConfig != null) {
                    fillerName = guiConfig.getString("sell_gui.items.filler.name", " ");
                }
                fillerMeta.setDisplayName(SellGUI.color(fillerName));
                if (guiConfig != null && guiConfig.contains("sell_gui.items.filler.custom_model_data") && (modelData = guiConfig.getInt("sell_gui.items.filler.custom_model_data")) > 0) {
                    fillerMeta.setCustomModelData(Integer.valueOf(modelData));
                }
                fillerMeta.getPersistentDataContainer().set(guiKey, PersistentDataType.BYTE, (Object)1);
                filler.setItemMeta(fillerMeta);
            }
            String noItemsMaterialName = "BARRIER";
            if (guiConfig != null) {
                noItemsMaterialName = guiConfig.getString("sell_gui.items.no_items.material", "BARRIER");
            }
            if ((noItemsMaterial = Material.getMaterial((String)noItemsMaterialName)) == null) {
                noItemsMaterial = Material.BARRIER;
                this.main.getLogger().warning("Invalid no_items material: " + noItemsMaterialName + ", using BARRIER");
            }
            this.noItemsItemStack = new ItemStack(noItemsMaterial);
            ItemMeta noItemsMeta = this.noItemsItemStack.getItemMeta();
            if (noItemsMeta != null) {
                int modelData;
                String noItemsName = "&cNo items to sell!";
                if (guiConfig != null) {
                    noItemsName = guiConfig.getString("sell_gui.items.no_items.name", "&cNo items to sell!");
                }
                noItemsMeta.setDisplayName(SellGUI.color(noItemsName));
                ArrayList<String> noItemLore = new ArrayList<String>();
                if (guiConfig != null && guiConfig.contains("sell_gui.items.no_itemslore")) {
                    for (String s : guiConfig.getStringList("sell_gui.items.no_items.lore")) {
                        noItemLore.add(SellGUI.color(s));
                    }
                } else {
                    noItemLore.add(SellGUI.color("&7Place items in the GUI"));
                    noItemLore.add(SellGUI.color("&7to sell them."));
                }
                noItemsMeta.setLore(noItemLore);
                if (guiConfig != null && guiConfig.contains("sell_gui.items.no_items.custom_model_data") && (modelData = guiConfig.getInt("sell_gui.items.no_items.custom_model_data")) > 0) {
                    noItemsMeta.setCustomModelData(Integer.valueOf(modelData));
                }
                noItemsMeta.getPersistentDataContainer().set(guiKey, PersistentDataType.BYTE, (Object)1);
                this.noItemsItemStack.setItemMeta(noItemsMeta);
            }
        }
    }

    private void addFillerFromConfig() {
        List fillerSlots;
        FileConfiguration guiConfig;
        FileConfiguration fileConfiguration = guiConfig = this.main.getConfigManager() != null ? this.main.getConfigManager().getGUIConfig() : null;
        if (guiConfig != null && !(fillerSlots = guiConfig.getIntegerList("sell_gui.positions.filler_slots")).isEmpty()) {
            Iterator iterator = fillerSlots.iterator();
            while (iterator.hasNext()) {
                int slot = (Integer)iterator.next();
                if (slot < 0 || slot >= menu.getSize()) continue;
                menu.setItem(slot, filler);
            }
            return;
        }
        this.addFiller("border");
    }

    private ItemStack createSystemItem(Material material, String name, List<String> lore) {
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            if (name != null) {
                meta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)name));
            }
            if (lore != null) {
                meta.setLore(lore.stream().map(line -> ChatColor.translateAlternateColorCodes((char)'&', (String)line)).toList());
            }
            meta.getPersistentDataContainer().set(new NamespacedKey((Plugin)SellGUIMain.getInstance(), "system_item"), PersistentDataType.INTEGER, (Object)1);
            item.setItemMeta(meta);
        }
        return item;
    }

    private void addFiller(String s) {
        block9: {
            int i;
            block12: {
                block11: {
                    block10: {
                        block8: {
                            if (!s.equalsIgnoreCase("bottom")) break block8;
                            for (int i2 = menu.getSize() - 9; i2 < menu.getSize(); ++i2) {
                                menu.setItem(i2, filler);
                            }
                            break block9;
                        }
                        if (!s.equalsIgnoreCase("left")) break block10;
                        for (int i3 = 0; i3 < menu.getSize(); i3 += 9) {
                            menu.setItem(i3, filler);
                        }
                        break block9;
                    }
                    if (!s.equalsIgnoreCase("right")) break block11;
                    for (int i4 = 8; i4 < menu.getSize(); i4 += 9) {
                        menu.setItem(i4, filler);
                    }
                    break block9;
                }
                if (!s.equalsIgnoreCase("top")) break block12;
                for (int i5 = 0; i5 < 9; ++i5) {
                    menu.setItem(i5, filler);
                }
                break block9;
            }
            if (!s.equalsIgnoreCase("round")) break block9;
            for (i = menu.getSize() - 9; i < menu.getSize(); ++i) {
                menu.setItem(i, filler);
            }
            for (i = 0; i < menu.getSize(); i += 9) {
                menu.setItem(i, filler);
            }
            for (i = 8; i < menu.getSize(); i += 9) {
                menu.setItem(i, filler);
            }
            for (i = 0; i < 9; ++i) {
                menu.setItem(i, filler);
            }
        }
    }

    public void makeConfirmItem() {
        Material material;
        FileConfiguration guiConfig = this.main.getConfigManager() != null ? this.main.getConfigManager().getGUIConfig() : null;
        String confirmMaterial = "GREEN_CONCRETE";
        if (guiConfig != null) {
            confirmMaterial = guiConfig.getString("sell_gui.items.confirm_button.material", "GREEN_CONCRETE");
        }
        if ((material = Material.getMaterial((String)confirmMaterial)) == null) {
            material = Material.GREEN_CONCRETE;
            this.main.getLogger().warning("Invalid confirm-item material: " + confirmMaterial + ", using GREEN_CONCRETE");
        }
        this.confirmItem = new ItemStack(material);
        ItemMeta itemMeta = this.confirmItem.getItemMeta();
        if (itemMeta != null) {
            int modelData;
            String itemName = "&a&lConfirm Sale";
            if (guiConfig != null) {
                itemName = guiConfig.getString("sell_gui.items.confirm_button.name", "&a&lConfirm Sale");
            }
            itemMeta.setDisplayName(SellGUI.color(itemName));
            boolean addGlow = false;
            if (guiConfig != null) {
                addGlow = guiConfig.getBoolean("sell_gui.items.confirm_button.glow", true);
            }
            if (addGlow) {
                itemMeta.addEnchant(Enchantment.POWER, 1, false);
                itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
            }
            itemMeta.setLore(this.makeLore());
            if (guiConfig != null && guiConfig.contains("sell_gui.items.confirm_button.custom_model_data") && (modelData = guiConfig.getInt("sell_gui.items.confirm_button.custom_model_data")) > 0) {
                itemMeta.setCustomModelData(Integer.valueOf(modelData));
            }
            NamespacedKey guiKey = new NamespacedKey((Plugin)this.main, "sellgui");
            NamespacedKey actionKey = new NamespacedKey((Plugin)this.main, "guiAction");
            itemMeta.getPersistentDataContainer().set(guiKey, PersistentDataType.BYTE, (Object)1);
            itemMeta.getPersistentDataContainer().set(actionKey, PersistentDataType.STRING, (Object)"confirm");
            this.confirmItem.setItemMeta(itemMeta);
        }
    }

    public ArrayList<String> makeLore() {
        HashMap<Object, Integer> itemCounts = new HashMap<Object, Integer>();
        HashMap<Object, Double> itemTotals = new HashMap<Object, Double>();
        HashMap<String, Integer> itemsNeedingEvaluation = new HashMap<String, Integer>();
        ItemStack[] contents = this.getMenu().getContents();
        String calculationMethod = this.main.getConfig().getString("prices.calculation-method", "auto").toLowerCase();
        for (ItemStack item : contents) {
            boolean needsEvaluation;
            if (item == null || InventoryListeners.sellGUIItem(item, this.player) || this.isCustomMenuItem(item)) continue;
            Object itemName = this.getItemName(item);
            boolean bl = needsEvaluation = this.main.getRandomPriceManager() != null && this.main.getRandomPriceManager().requiresEvaluation(item) && !this.main.getRandomPriceManager().isEvaluated(item);
            if (needsEvaluation) {
                itemsNeedingEvaluation.put((String)itemName, itemsNeedingEvaluation.getOrDefault(itemName, 0) + item.getAmount());
                continue;
            }
            double price = this.getPrice(item, this.player);
            if (!(price > 0.0)) continue;
            itemCounts.put(itemName, itemCounts.getOrDefault(itemName, 0) + item.getAmount());
            if (calculationMethod.equals("shopguiplus")) {
                itemTotals.put(itemName, itemTotals.getOrDefault(itemName, 0.0) + price);
                continue;
            }
            itemTotals.put(itemName, itemTotals.getOrDefault(itemName, 0.0) + price * (double)item.getAmount());
        }
        ArrayList<String> lore = new ArrayList<String>();
        FileConfiguration guiConfig = this.main.getConfigManager() != null ? this.main.getConfigManager().getGUIConfig() : null;
        String format = "&7%amount%x &f%item% &8= &e$%total%";
        if (guiConfig != null) {
            format = guiConfig.getString("sell_gui.item_total_format", format);
        }
        for (Object itemName : itemCounts.keySet()) {
            double total = (Double)itemTotals.get(itemName);
            int amount = (Integer)itemCounts.get(itemName);
            double averagePrice = amount > 0 ? total / (double)amount : 0.0;
            String formatted = format.replace("%item%", (CharSequence)itemName).replace("%amount%", String.valueOf(amount)).replace("%price%", String.valueOf(averagePrice)).replace("%total%", String.valueOf(total));
            lore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)formatted));
            lore.add(" ");
        }
        String evaluationFormat = "&7%amount%x &f%item% &c\u26a0 Needs Evaluation";
        if (guiConfig != null) {
            evaluationFormat = guiConfig.getString("sell_gui.evaluation_required_format", evaluationFormat);
        }
        for (String itemName : itemsNeedingEvaluation.keySet()) {
            String formatted = evaluationFormat.replace("%item%", itemName).replace("%amount%", String.valueOf(itemsNeedingEvaluation.get(itemName)));
            lore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)formatted));
            lore.add(" ");
        }
        String totalFormat = "&6&lTotal: &e$%total%";
        if (guiConfig != null) {
            totalFormat = guiConfig.getString("sell_gui.total_format", totalFormat);
        }
        String totalFormatted = totalFormat.replace("%total%", String.valueOf(this.getTotal(menu)));
        lore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)totalFormatted));
        if (!itemsNeedingEvaluation.isEmpty()) {
            lore.add("");
            lore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)"&c\u26a0 Some items need evaluation"));
            lore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)"&7Use /sellgui evaluate"));
        }
        return lore;
    }

    public boolean hasUnevaluatedItems() {
        if (this.main.getRandomPriceManager() == null) {
            return false;
        }
        for (ItemStack item : this.getMenu().getContents()) {
            if (item == null || this.isCustomMenuItem(item) || InventoryListeners.sellGUIItem(item, this.player) || !this.main.getRandomPriceManager().requiresEvaluation(item) || this.main.getRandomPriceManager().isEvaluated(item)) continue;
            return true;
        }
        return false;
    }

    public void setConfirmItem() {
        menu.setItem(this.sellItemSlot, (ItemStack)null);
        menu.setItem(this.sellItemSlot, this.confirmItem);
        this.isConfirmMode = true;
    }

    public void setSellItem() {
        menu.setItem(this.sellItemSlot, (ItemStack)null);
        menu.setItem(this.sellItemSlot, sellItem);
        this.isConfirmMode = false;
    }

    public String getItemName(ItemStack itemStack) {
        if (itemStack == null) {
            return "Unknown Item";
        }
        try {
            MMOItem mmoItem;
            String nexoId;
            NBTItem nbtItem = new NBTItem(itemStack){

                public Object get(String s) {
                    return null;
                }

                public String getString(String s) {
                    return "";
                }

                public boolean hasTag(String s) {
                    return false;
                }

                public boolean getBoolean(String s) {
                    return false;
                }

                public double getDouble(String s) {
                    return 0.0;
                }

                public int getInteger(String s) {
                    return 0;
                }

                public NBTCompound getNBTCompound(String s) {
                    return null;
                }

                public NBTItem addTag(List<ItemTag> list) {
                    return null;
                }

                public NBTItem removeTag(String ... strings) {
                    return null;
                }

                public Set<String> getTags() {
                    return Set.of();
                }

                public ItemStack toItem() {
                    return null;
                }

                public int getTypeId(String s) {
                    return 0;
                }
            };
            if (this.main.hasNexo && nbtItem.hasTag("nexo:id") && (nexoId = nbtItem.getString("nexo:id")) != null && !nexoId.isEmpty()) {
                if (itemStack.hasItemMeta() && itemStack.getItemMeta().hasDisplayName()) {
                    return String.valueOf(ChatColor.AQUA) + itemStack.getItemMeta().getDisplayName();
                }
                return String.valueOf(ChatColor.AQUA) + "[Nexo] " + nexoId;
            }
            if (this.main.isMMOItemsEnabled() && nbtItem.hasTag("MMOITEMS_ITEM_ID") && (mmoItem = MMOItems.plugin.getMMOItem(Type.get((String)nbtItem.getType()), nbtItem.getString("MMOITEMS_ITEM_ID"))) != null) {
                return String.valueOf(ChatColor.GREEN) + itemStack.getItemMeta().getDisplayName();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return itemStack.hasItemMeta() && itemStack.getItemMeta().hasDisplayName() ? itemStack.getItemMeta().getDisplayName() : WordUtils.capitalizeFully((String)itemStack.getType().name().replace('_', ' '));
    }

    public double getPrice(ItemStack itemStack, @Nullable Player player) {
        double totalPrice;
        double shopGuiPrice;
        PriceManager priceManager;
        ItemMeta meta;
        BlockStateMeta meta2;
        double contentsPrice = 0.0;
        if (itemStack == null || itemStack.getType() == Material.AIR) {
            return 0.0;
        }
        if (itemStack.getType().name().endsWith("_SHULKER_BOX") && itemStack.hasItemMeta() && itemStack.getItemMeta() instanceof BlockStateMeta && (meta2 = (BlockStateMeta)itemStack.getItemMeta()).getBlockState() instanceof ShulkerBox) {
            ShulkerBox shulker = (ShulkerBox)meta2.getBlockState();
            String calculationMethod = this.main.getConfig().getString("prices.calculation-method", "auto").toLowerCase();
            for (ItemStack contained : shulker.getInventory().getContents()) {
                if (contained == null || contained.getType().isAir()) continue;
                double price = this.getPrice(contained, player);
                if (calculationMethod.equals("shopguiplus")) {
                    contentsPrice += price;
                    continue;
                }
                contentsPrice += price * (double)contained.getAmount();
            }
        }
        double itemPrice = 0.0;
        ItemStack itemToPrice = itemStack;
        if (itemStack.getType().name().endsWith("_SHULKER_BOX")) {
            itemToPrice = itemStack.clone();
            itemToPrice.setAmount(1);
        }
        if (itemToPrice.hasItemMeta() && (meta = itemToPrice.getItemMeta()) != null) {
            NamespacedKey key = new NamespacedKey((Plugin)this.main, "current_price");
            if (meta.getPersistentDataContainer().has(key, PersistentDataType.DOUBLE)) {
                itemPrice = (Double)meta.getPersistentDataContainer().get(key, PersistentDataType.DOUBLE);
            }
        }
        if (itemPrice == 0.0 && (itemPrice = (priceManager = new PriceManager(this.main)).getItemPriceWithPlayer(itemToPrice, player)) == 0.0) {
            double essentialsPrice;
            if (this.main.hasEssentials() && this.main.getConfig().getBoolean("use-essentials-price") && (essentialsPrice = SellGUI.round(this.main.getEssentialsHolder().getPrice(itemToPrice).doubleValue(), this.main.getConfig().getInt("places-to-round"))) > 0.0) {
                itemPrice = essentialsPrice;
            }
            if (itemPrice == 0.0 && this.main.getItemPricesConfig().contains(itemToPrice.getType().name())) {
                itemPrice = this.main.getItemPricesConfig().getDouble(itemToPrice.getType().name());
            }
        }
        if (itemPrice == 0.0 && player != null && (shopGuiPrice = ShopGuiPlusApi.getItemStackPriceSell((Player)player, (ItemStack)itemToPrice)) > 0.0) {
            itemPrice = shopGuiPrice;
        }
        if (itemPrice == 0.0 && this.main instanceof SellGUIMain) {
            Object rpm = null;
            try {
                rpm = ((Object)((Object)this.main)).getClass().getMethod("getRandomPriceManager", new Class[0]).invoke((Object)this.main, new Object[0]);
            }
            catch (Exception essentialsPrice) {
                // empty catch block
            }
            if (rpm != null) {
                try {
                    boolean canSell = (Boolean)rpm.getClass().getMethod("canBeSold", ItemStack.class).invoke(rpm, itemToPrice);
                    if (!canSell) {
                        itemPrice = 0.0;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if ((totalPrice = contentsPrice + itemPrice) > 0.0) {
            totalPrice = this.applyPermissionBonuses(player, totalPrice);
        }
        return SellGUI.round(totalPrice, this.main.getConfig().getInt("places-to-round"));
    }

    private double applyPermissionBonuses(Player player, double price) {
        if (player == null || price <= 0.0) {
            return price;
        }
        double bonusPercent = 0.0;
        double multiplier = 1.0;
        for (PermissionAttachmentInfo pai : player.getEffectivePermissions()) {
            if (pai.getPermission().startsWith("sellgui.bonus.") && pai.getValue()) {
                double percent = Double.parseDouble(pai.getPermission().replace("sellgui.bonus.", ""));
                bonusPercent += percent;
            }
            if (!pai.getPermission().startsWith("sellgui.multiplier.") || !pai.getValue()) continue;
            multiplier *= Double.parseDouble(pai.getPermission().replace("sellgui.multiplier.", ""));
        }
        price = price * (1.0 + bonusPercent / 100.0) * multiplier;
        return price;
    }

    public double getTotal(Inventory inventory) {
        double total = 0.0;
        String calculationMethod = this.main.getConfig().getString("prices.calculation-method", "auto").toLowerCase();
        for (ItemStack itemStack : inventory.getContents()) {
            double price;
            boolean canSell;
            if (itemStack == null || itemStack.getType().isAir() || this.isCustomMenuItem(itemStack) || InventoryListeners.sellGUIItem(itemStack, this.player)) continue;
            boolean bl = canSell = this.main.getRandomPriceManager() == null || this.main.getRandomPriceManager().canBeSold(itemStack);
            if (!canSell || this.main.getRandomPriceManager() != null && this.main.getRandomPriceManager().hasRandomPrice(itemStack) && !this.main.getRandomPriceManager().isEvaluated(itemStack) || !((price = this.getPrice(itemStack, this.player)) > 0.0)) continue;
            if (calculationMethod.equals("shopguiplus")) {
                total += price;
                continue;
            }
            total += price * (double)itemStack.getAmount();
        }
        return total;
    }

    private boolean isCustomMenuItem(ItemStack item) {
        if (item == null || !item.hasItemMeta()) {
            return false;
        }
        return item.getItemMeta().getPersistentDataContainer().has(new NamespacedKey((Plugin)this.main, "custom-menu-item"), PersistentDataType.STRING);
    }

    public void logSell(ItemStack itemStack) {
        if (itemStack != null) {
            try (BufferedWriter writer = new BufferedWriter(new FileWriter(this.getMain().getLog(), true));){
                Date now = new Date();
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                ItemIdentifier.ItemType itemTypeEnum = ItemIdentifier.getItemType(itemStack);
                String itemType = itemTypeEnum.name();
                String itemId = ItemIdentifier.getItemIdentifier(itemStack);
                String displayName = ChatColor.stripColor((String)ItemIdentifier.getItemDisplayName(itemStack));
                double unitPrice = this.getPrice(itemStack, this.player);
                String calculationMethod = this.getMain().getConfig().getString("prices.calculation-method", "auto").toLowerCase();
                double totalPrice = calculationMethod.equals("shopguiplus") ? unitPrice : unitPrice * (double)itemStack.getAmount();
                String playerName = this.getPlayer().getName();
                String logEntry = String.format("[SELLGUI] %s|%s|%s|%d|%.2f|%.2f|%s|%s", itemType, itemId, displayName, itemStack.getAmount(), unitPrice, totalPrice, playerName, format.format(now));
                writer.append(logEntry + "\n");
                writer.flush();
            }
            catch (IOException e) {
                this.getMain().getLogger().severe("Failed to write to sell log: " + e.getMessage());
                e.printStackTrace();
            }
        }
    }

    public void sellItems(Inventory inventory) {
        boolean hasRandomPriceNotEvaluated = false;
        for (ItemStack itemStack : inventory.getContents()) {
            if (itemStack == null || itemStack.getType().isAir() || this.isCustomMenuItem(itemStack) || InventoryListeners.sellGUIItem(itemStack, this.player) || this.main.getRandomPriceManager() == null || !this.main.getRandomPriceManager().hasRandomPrice(itemStack) || this.main.getRandomPriceManager().isEvaluated(itemStack)) continue;
            hasRandomPriceNotEvaluated = true;
            break;
        }
        if (hasRandomPriceNotEvaluated) {
            String message = this.main.getMessagesConfig().getString("sell.evaluation_required", "&cSome items must be evaluated before selling.");
            this.player.sendMessage(SellGUI.color(message));
            this.setSellItem();
            return;
        }
        double total = this.getTotal(inventory);
        if (total <= 0.0) {
            String message = this.main.getMessagesConfig().getString("sell.no_items", "&cNothing to sell!");
            this.player.sendMessage(SellGUI.color(message));
            this.setSellItem();
            return;
        }
        this.main.getEcon().depositPlayer((OfflinePlayer)this.player, total);
        for (ItemStack item : inventory.getContents()) {
            boolean needsEvaluation;
            if (item == null || InventoryListeners.sellGUIItem(item, this.player) || this.isCustomMenuItem(item)) continue;
            boolean hasSetPriceItem = false;
            for (ItemStack checkItem : inventory.getContents()) {
                if (!(this.getPrice(checkItem, this.player) > 0.0) || InventoryListeners.sellGUIItem(checkItem, this.player) || this.isCustomMenuItem(checkItem)) continue;
                hasSetPriceItem = true;
                break;
            }
            NBTItem nbtItem = new NBTItem(item){

                public Object get(String s) {
                    return null;
                }

                public String getString(String s) {
                    return "";
                }

                public boolean hasTag(String s) {
                    return false;
                }

                public boolean getBoolean(String s) {
                    return false;
                }

                public double getDouble(String s) {
                    return 0.0;
                }

                public int getInteger(String s) {
                    return 0;
                }

                public NBTCompound getNBTCompound(String s) {
                    return null;
                }

                public NBTItem addTag(List<ItemTag> list) {
                    return null;
                }

                public NBTItem removeTag(String ... strings) {
                    return null;
                }

                public Set<String> getTags() {
                    return Set.of();
                }

                public ItemStack toItem() {
                    return null;
                }

                public int getTypeId(String s) {
                    return 0;
                }
            };
            boolean isNexo = this.main.hasNexo && nbtItem.hasTag("nexo:id");
            boolean isMMO = this.main.isMMOItemsEnabled() && nbtItem.hasTag("MMOITEMS_ITEM_ID");
            boolean bl = needsEvaluation = this.main.getRandomPriceManager() != null && this.main.getRandomPriceManager().hasRandomPrice(item) && !this.main.getRandomPriceManager().isEvaluated(item);
            if (needsEvaluation || !(this.getPrice(item, this.player) > 0.0) || (isNexo || isMMO) && hasSetPriceItem) continue;
            if (this.main.getConfig().getBoolean("logging.enabled")) {
                this.logSell(item);
            }
            inventory.remove(item);
        }
        if (this.main.getConfig().getBoolean("general.close-after-sell")) {
            this.player.closeInventory();
            SellCommand.getSellGUIs().remove(this);
        } else {
            this.setSellItem();
            this.updateSellItemTotal();
        }
        String soldMessage = "&a\u2705 Sold items for &e$%total%!";
        if (this.main.getMessagesConfig() != null) {
            soldMessage = this.main.getMessagesConfig().getString("sell.sold_success", soldMessage);
        }
        this.player.sendMessage(SellGUI.color(soldMessage.replace("%total%", String.format("%.2f", total))));
        SoundHandler.playConfigSound(this.player, "sounds.feedback.success");
    }

    public ItemStack getConfirmItem() {
        return this.confirmItem;
    }

    public Player getPlayer() {
        return this.player;
    }

    public static ItemStack getSellItem() {
        return sellItem;
    }

    public static ItemStack getFiller() {
        return filler;
    }

    public String getMenuTitle() {
        return this.menuTitle;
    }

    public Inventory getMenu() {
        return menu;
    }

    public SellGUIMain getMain() {
        return this.main;
    }

    public static String color(String s) {
        if (s == null) {
            return "";
        }
        return ChatColor.translateAlternateColorCodes((char)'&', (String)s);
    }

    public static double round(double value, int places) {
        if (places < 0) {
            throw new IllegalArgumentException();
        }
        BigDecimal bd = new BigDecimal("" + value);
        bd = bd.setScale(places, RoundingMode.HALF_UP);
        return bd.doubleValue();
    }

    public static double round(String value, int places) {
        if (places < 0) {
            throw new IllegalArgumentException();
        }
        BigDecimal bd = new BigDecimal(value);
        bd = bd.setScale(places, RoundingMode.HALF_UP);
        return bd.doubleValue();
    }

    public static String roundString(String value, int places) {
        if (places < 0) {
            throw new IllegalArgumentException();
        }
        BigDecimal bd = new BigDecimal(value);
        bd = bd.setScale(places, RoundingMode.HALF_UP);
        return bd.toPlainString();
    }
}

