/*
 * Decompiled with CFR 0.152.
 */
package me.aov.sellgui.commands;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import me.aov.sellgui.SellGUIMain;
import me.aov.sellgui.handlers.SoundHandler;
import me.aov.sellgui.utils.ItemIdentifier;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.permissions.PermissionAttachmentInfo;
import org.jetbrains.annotations.NotNull;

public class SellAllCommand
implements CommandExecutor {
    private SellGUIMain main;

    public SellAllCommand(SellGUIMain main) {
        this.main = main;
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, String[] args) {
        String NoPerm = this.main.getMessagesConfig().getString("general.no_permission", "&c\u274c You don't have permission to use this command!");
        if (!(sender instanceof Player)) {
            sender.sendMessage(SellAllCommand.color("&cThis command can only be used by players!"));
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission("sellgui.sellall")) {
            player.sendMessage(SellAllCommand.color(NoPerm));
            return true;
        }
        if (this.main.getEcon() == null) {
            player.sendMessage(SellAllCommand.color("&cEconomy system not available!"));
            return true;
        }
        double total = this.getTotal((Inventory)player.getInventory(), player);
        int evaluationRequiredCount = 0;
        for (ItemStack item : player.getInventory().getContents()) {
            if (item == null || item.getType() == Material.AIR || this.main.getRandomPriceManager() == null || !this.main.getRandomPriceManager().requiresEvaluation(item) || this.main.getRandomPriceManager().isEvaluated(item)) continue;
            evaluationRequiredCount += item.getAmount();
        }
        if (evaluationRequiredCount > 0) {
            String evaluationMessage = this.main.getMessagesConfig() != null ? this.main.getMessagesConfig().getString("sellall.evaluation_required", "&e\u26a0\ufe0f %count% items require evaluation before selling. Use /sellgui evaluate") : "&e\u26a0\ufe0f %count% items require evaluation before selling. Use /sellgui evaluate";
            evaluationMessage = evaluationMessage.replace("%count%", String.valueOf(evaluationRequiredCount));
            player.sendMessage(SellAllCommand.color(evaluationMessage));
        }
        if (this.main.getConfig().getBoolean("general.debug", false)) {
            this.main.getLogger().info("SellAll debug - Player: " + player.getName() + ", Total: $" + total);
            this.main.getLogger().info("  Items needing evaluation: " + evaluationRequiredCount);
            int itemCount = 0;
            for (ItemStack item : player.getInventory().getContents()) {
                double price;
                if (item == null || item.getType() == Material.AIR || !((price = this.getPrice(item, player)) > 0.0)) continue;
                ++itemCount;
                this.main.getLogger().info("  - " + String.valueOf(item.getType()) + " x" + item.getAmount() + " = $" + price);
            }
            this.main.getLogger().info("  Total sellable items: " + itemCount);
        }
        if (total <= 0.0) {
            String NoItemMessage = this.main.getMessagesConfig().getString("sellall.no-items", "&c\u274c No items to sell in your inventory!");
            player.sendMessage(SellAllCommand.color(NoItemMessage));
            return true;
        }
        if (args.length == 1 && args[0].equalsIgnoreCase("confirm")) {
            this.sellItems((Inventory)player.getInventory(), player);
        } else {
            player.sendMessage(SellAllCommand.color("&6&l=== SellAll Confirmation ==="));
            player.sendMessage("");
            String previewMore = this.main.getMessagesConfig().getString("sellall.preview-more", "&8... and more");
            String separator = this.main.getMessagesConfig().getString("sellall.separator", "&6&l=========================");
            String confirmProceed = this.main.getMessagesConfig().getString("sellall.confirm-proceed", "&a&l\u2713 &f/sellall confirm &7- Proceed with sale");
            String confirmCancel = this.main.getMessagesConfig().getString("sellall.confirm-cancel", "&c&l\u2717 &7Any other action - Cancel");
            String confirmMessage = "&e\u26a0\ufe0f You will receive &a$%total% &efor selling all items.";
            String itemToBeSold = this.main.getMessagesConfig().getString("sellall.item-to-be-sold", "&7Items to be sold:");
            if (this.main.getMessagesConfig() != null) {
                confirmMessage = this.main.getMessagesConfig().getString("sellall.confirm-message", confirmMessage);
            }
            confirmMessage = confirmMessage.replace("%total%", String.format("%.2f", total));
            player.sendMessage(SellAllCommand.color(confirmMessage));
            player.sendMessage("");
            if (this.main.getConfig().getBoolean("sellall-show-preview", true)) {
                player.sendMessage(SellAllCommand.color(itemToBeSold));
                player.sendMessage("");
                int previewCount = 0;
                for (ItemStack item : player.getInventory().getContents()) {
                    double itemPrice;
                    if (item == null || item.getType() == Material.AIR || !(this.getPrice(item, player) > 0.0) || previewCount >= 5) continue;
                    String itemName = ItemIdentifier.getItemDisplayName(item);
                    String calculationMethod = this.main.getConfig().getString("prices.calculation-method", "auto");
                    double displayPrice = itemPrice = this.getPrice(item, player);
                    if (!calculationMethod.equalsIgnoreCase("shopguiplus")) {
                        displayPrice *= (double)item.getAmount();
                    }
                    player.sendMessage(SellAllCommand.color("&8- &f" + itemName + " &7x" + item.getAmount() + " &8= &e$" + String.format("%.2f", displayPrice)));
                    player.sendMessage("");
                    ++previewCount;
                }
                if (previewCount >= 5) {
                    player.sendMessage(SellAllCommand.color(previewMore));
                    player.sendMessage("");
                }
                player.sendMessage(SellAllCommand.color(separator));
                player.sendMessage(SellAllCommand.color(confirmProceed));
                player.sendMessage(SellAllCommand.color(confirmCancel));
                player.sendMessage(SellAllCommand.color(separator));
            }
        }
        return true;
    }

    public double getPrice(ItemStack itemStack, Player player) {
        if (itemStack == null || itemStack.getType() == Material.AIR) {
            return 0.0;
        }
        if (this.main.getRandomPriceManager() != null && !this.main.getRandomPriceManager().canBeSold(itemStack)) {
            return 0.0;
        }
        double price = 0.0;
        if (!this.main.getConfig().getBoolean("sell-all-command-sell-enchanted") && itemStack.getEnchantments().size() > 0) {
            return price;
        }
        this.main.getItemPricesConfig().getStringList("flat-enchantment-bonus");
        ArrayList flatBonus = new ArrayList(this.main.getItemPricesConfig().getStringList("flat-enchantment-bonus"));
        this.main.getItemPricesConfig().getStringList("multiplier-enchantment-bonus");
        ArrayList multiplierBonus = new ArrayList(this.main.getItemPricesConfig().getStringList("multiplier-enchantment-bonus"));
        if (this.main.getPriceManager() != null) {
            try {
                price = this.main.getPriceManager().getItemPriceWithPlayer(itemStack, player);
                if (price > 0.0) {
                    return SellAllCommand.round(price, 3);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.main.getNBTPriceManager() != null) {
            try {
                price = this.main.getNBTPriceManager().getPriceFromNBT(itemStack);
                if (price > 0.0) {
                    return SellAllCommand.round(price, 3);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.main.getRandomPriceManager() != null) {
            try {
                price = this.main.getRandomPriceManager().getRandomPrice(itemStack);
                if (price > 0.0) {
                    return SellAllCommand.round(price, 3);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.main.hasEssentials() && this.main.getConfig().getBoolean("use-essentials-price") && this.main.getEssentialsHolder().getEssentials() != null) {
            return SellAllCommand.round(this.main.getEssentialsHolder().getPrice(itemStack).doubleValue(), 3);
        }
        if (this.main.getItemPricesConfig().contains(itemStack.getType().name())) {
            price = this.main.getItemPricesConfig().getDouble(itemStack.getType().name());
        }
        if (itemStack != null && itemStack.getItemMeta().hasEnchants()) {
            for (Enchantment enchantment : itemStack.getItemMeta().getEnchants().keySet()) {
                for (String s : flatBonus) {
                    String[] temp = s.split(":");
                    if (!temp[0].equalsIgnoreCase(enchantment.getKey().getKey()) || !temp[1].equalsIgnoreCase("" + itemStack.getEnchantmentLevel(enchantment))) continue;
                    price += Double.parseDouble(temp[2]);
                }
            }
            for (Enchantment enchantment : itemStack.getItemMeta().getEnchants().keySet()) {
                for (String s : multiplierBonus) {
                    String[] temp2 = s.split(":");
                    if (!temp2[0].equalsIgnoreCase(enchantment.getKey().getKey()) || !temp2[1].equalsIgnoreCase("" + itemStack.getEnchantmentLevel(enchantment))) continue;
                    price *= Double.parseDouble(temp2[2]);
                }
            }
        }
        for (PermissionAttachmentInfo pai : player.getEffectivePermissions()) {
            if (pai.getPermission().contains("sellgui.bonus.")) {
                if (price == 0.0) continue;
                price += Double.parseDouble(pai.getPermission().replaceAll("sellgui.bonus.", ""));
                continue;
            }
            if (!pai.getPermission().contains("sellgui.multiplier.")) continue;
            price *= Double.parseDouble(pai.getPermission().replaceAll("sellgui.multiplier.", ""));
        }
        return SellAllCommand.round(price, 3);
    }

    public double getTotal(Inventory inventory, Player player) {
        double total = 0.0;
        String calculationMethod = this.main.getConfig().getString("prices.calculation-method", "auto");
        for (ItemStack itemStack : inventory.getContents()) {
            double itemPrice;
            if (itemStack == null || itemStack.getType() == Material.AIR || !((itemPrice = this.getPrice(itemStack, player)) > 0.0)) continue;
            if (calculationMethod.equalsIgnoreCase("shopguiplus")) {
                total += itemPrice;
                continue;
            }
            total += itemPrice * (double)itemStack.getAmount();
        }
        return SellAllCommand.round(total, 3);
    }

    public void sellItems(Inventory inventory, Player player) {
        double total = this.getTotal(inventory, player);
        int itemsSold = 0;
        if (total <= 0.0) {
            player.sendMessage(SellAllCommand.color("&cNo items to sell!"));
            return;
        }
        this.main.getEcon().depositPlayer((OfflinePlayer)player, total);
        for (ItemStack itemStack : inventory.getContents()) {
            if (itemStack == null || !(this.getPrice(itemStack, player) > 0.0)) continue;
            if (this.main.getConfig().getBoolean("log-transactions")) {
                this.logSellAll(itemStack, player);
            }
            itemsSold += itemStack.getAmount();
            inventory.remove(itemStack);
        }
        String soldMessage = "&a\u2705 Sold %count% items for &e$%total%!";
        if (this.main.getMessagesConfig() != null) {
            soldMessage = this.main.getMessagesConfig().getString("sellall.sold-message", soldMessage);
        }
        soldMessage = soldMessage.replace("%total%", String.format("%.2f", total));
        soldMessage = soldMessage.replace("%count%", String.valueOf(itemsSold));
        player.sendMessage(SellAllCommand.color(soldMessage));
        if (this.main.getServer().getPluginManager().getPlugin("SellGUI") != null) {
            try {
                SoundHandler.playSuccess(player);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void logSellAll(ItemStack itemStack, Player player) {
        if (itemStack != null) {
            try (BufferedWriter writer = new BufferedWriter(new FileWriter(this.main.getLog(), true));){
                Date now = new Date();
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                ItemIdentifier.ItemType itemTypeEnum = ItemIdentifier.getItemType(itemStack);
                String itemType = itemTypeEnum.name();
                String itemId = ItemIdentifier.getItemIdentifier(itemStack);
                String displayName = ChatColor.stripColor((String)ItemIdentifier.getItemDisplayName(itemStack));
                double unitPrice = this.getPrice(itemStack, player);
                String calculationMethod = this.main.getConfig().getString("prices.calculation-method", "auto");
                double totalPrice = calculationMethod.equalsIgnoreCase("shopguiplus") ? unitPrice : unitPrice * (double)itemStack.getAmount();
                String playerName = player.getName();
                String logEntry = String.format("[SELLALL] %s|%s|%s|%d|%.2f|%.2f|%s|%s", itemType, itemId, displayName, itemStack.getAmount(), unitPrice, totalPrice, playerName, format.format(now));
                writer.append(logEntry + "\n");
                writer.flush();
            }
            catch (IOException e) {
                this.main.getLogger().severe("Failed to write to sell log: " + e.getMessage());
                e.printStackTrace();
            }
        }
    }

    public static String color(String s) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)s);
    }

    public static double round(double value, int places) {
        if (places < 0) {
            throw new IllegalArgumentException();
        }
        BigDecimal bd = BigDecimal.valueOf(value);
        bd = bd.setScale(places, RoundingMode.HALF_UP);
        return bd.doubleValue();
    }
}

