/*
 * Decompiled with CFR 0.152.
 */
package me.aov.sellgui.listeners;

import java.util.HashMap;
import java.util.List;
import me.aov.sellgui.SellGUI;
import me.aov.sellgui.SellGUIMain;
import me.aov.sellgui.commands.SellCommand;
import me.aov.sellgui.handlers.SoundHandler;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class InventoryListeners
implements Listener {
    private final SellGUIMain main;

    public InventoryListeners(SellGUIMain main) {
        this.main = main;
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        if (!(event.getPlayer() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getPlayer();
        SellGUI sellGUI = SellCommand.getSellGUI(player);
        if (sellGUI != null && event.getInventory().equals((Object)sellGUI.getMenu())) {
            this.dropItems(event.getInventory(), player);
            sellGUI.cleanup();
            SellCommand.getSellGUIs().remove(sellGUI);
        }
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent e) {
        if (!(e.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)e.getWhoClicked();
        Inventory clickedInventory = e.getClickedInventory();
        ItemStack currentItem = e.getCurrentItem();
        SellGUI sellGUI = SellCommand.getSellGUI(player);
        if (sellGUI == null || !e.getView().getTopInventory().equals((Object)sellGUI.getMenu())) {
            return;
        }
        NamespacedKey guiKey = new NamespacedKey((Plugin)this.main, "sellgui");
        NamespacedKey actionKey = new NamespacedKey((Plugin)this.main, "guiAction");
        if (currentItem != null && currentItem.hasItemMeta() && currentItem.getItemMeta().getPersistentDataContainer().has(guiKey, PersistentDataType.BYTE)) {
            e.setCancelled(true);
            String action = (String)currentItem.getItemMeta().getPersistentDataContainer().get(actionKey, PersistentDataType.STRING);
            if (action == null) {
                return;
            }
            switch (action) {
                case "confirm": {
                    if (sellGUI.hasUnevaluatedItems()) {
                        player.closeInventory();
                        String message = this.main.getMessagesConfig().getString("messages.evaluation-required", "&cYou have items that need to be evaluated before selling.");
                        player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)message));
                        return;
                    }
                    SoundHandler.playConfigSound(player, "sounds.ui.confirm");
                    sellGUI.sellItems(sellGUI.getMenu());
                    break;
                }
                case "sell": {
                    if (sellGUI.getTotal(sellGUI.getMenu()) <= 0.0) {
                        String soundName = this.main.getSoundsConfig().getString("legacy.no-items-sound", "BLOCK_NOTE_BLOCK_BASS");
                        float volume = (float)this.main.getSoundsConfig().getDouble("legacy.no-items-volume", 1.0);
                        float pitch = (float)this.main.getSoundsConfig().getDouble("legacy.no-items-pitch", 1.0);
                        try {
                            Sound sound = Sound.valueOf((String)soundName);
                            player.playSound(player.getLocation(), sound, volume, pitch);
                        }
                        catch (IllegalArgumentException ex) {
                            this.main.getLogger().warning("Invalid sound name: " + soundName);
                        }
                        player.closeInventory();
                        player.sendTitle(this.main.getMessagesConfig().getString("titles.no-items-title", "&cNo items to sell!"), this.main.getMessagesConfig().getString("titles.no-items-subtitle", ""), 10, 70, 20);
                        return;
                    }
                    SoundHandler.playUIClick(player);
                    sellGUI.makeConfirmItem();
                    sellGUI.setConfirmItem();
                }
            }
        } else if (currentItem != null && this.isCustomMenuItem(currentItem)) {
            e.setCancelled(true);
            this.handleCustomMenuItemClick(player, currentItem);
        } else if (clickedInventory != null && clickedInventory.equals((Object)sellGUI.getMenu())) {
            if (this.isGUIControlItem(currentItem, sellGUI)) {
                e.setCancelled(true);
                return;
            }
            if (e.isShiftClick() && this.wouldGoToReservedSlot(e.getSlot(), sellGUI)) {
                e.setCancelled(true);
                return;
            }
            if (e.getCursor() != null && e.getCursor().getType() != Material.AIR && (e.getCurrentItem() == null || e.getCurrentItem().getType() == Material.AIR)) {
                SoundHandler.playConfigSound(player, "sounds.items.place");
            }
            Bukkit.getScheduler().runTaskLater((Plugin)this.main, () -> {
                if (sellGUI.getMenu() != null && player.isOnline() && SellCommand.getSellGUI(player) != null) {
                    sellGUI.updateButtonState();
                }
            }, 1L);
        } else if (clickedInventory != null && clickedInventory.equals((Object)player.getInventory())) {
            if (e.isShiftClick() && currentItem != null && currentItem.getType() != Material.AIR) {
                SoundHandler.playConfigSound(player, "sounds.items.place");
            }
            Bukkit.getScheduler().runTaskLater((Plugin)this.main, () -> {
                if (sellGUI.getMenu() != null && player.isOnline() && SellCommand.getSellGUI(player) != null) {
                    sellGUI.updateButtonState();
                }
            }, 1L);
        }
    }

    private boolean isGUIControlItem(ItemStack item, SellGUI sellGUI) {
        if (item == null) {
            return false;
        }
        NamespacedKey guiKey = new NamespacedKey((Plugin)this.main, "sellgui");
        return item.hasItemMeta() && item.getItemMeta().getPersistentDataContainer().has(guiKey, PersistentDataType.BYTE);
    }

    private boolean wouldGoToReservedSlot(int slot, SellGUI sellGUI) {
        if (this.main.getConfigManager() != null && this.main.getConfigManager().getGUIConfig() != null) {
            FileConfiguration guiConfig = this.main.getConfigManager().getGUIConfig();
            List fillerSlots = guiConfig.getIntegerList("sell_gui.positions.filler_slots");
            int sellButtonSlot = guiConfig.getInt("sell_gui.positions.sell-button", 49);
            int confirmButtonSlot = guiConfig.getInt("sell_gui.positions.confirm_button", 53);
            return fillerSlots.contains(slot) || slot == sellButtonSlot || slot == confirmButtonSlot;
        }
        return slot < 9 || slot > 44 || slot % 9 == 0 || slot % 9 == 8;
    }

    private void handleCustomMenuItemClick(Player player, ItemStack item) {
        NamespacedKey key = new NamespacedKey((Plugin)this.main, "custom-menu-item");
        String commands = (String)item.getItemMeta().getPersistentDataContainer().get(key, PersistentDataType.STRING);
        if (commands != null && !commands.isEmpty()) {
            String[] commandArray;
            for (String command : commandArray = commands.split(";")) {
                if (command.trim().isEmpty()) continue;
                String finalCommand = command.trim().replace("%player%", player.getName());
                Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)finalCommand);
            }
        }
    }

    private void dropItems(Inventory inventory, Player player) {
        for (ItemStack itemStack : inventory.getContents()) {
            if (itemStack == null || itemStack.getType() == Material.AIR) continue;
            NamespacedKey guiKey = new NamespacedKey((Plugin)this.main, "sellgui");
            if (itemStack.hasItemMeta() && itemStack.getItemMeta().getPersistentDataContainer().has(guiKey, PersistentDataType.BYTE) || this.isCustomMenuItem(itemStack)) continue;
            if (this.main.getConfig().getBoolean("drop-items-on-close", false)) {
                player.getWorld().dropItem(player.getLocation(), itemStack);
                continue;
            }
            HashMap notAdded = player.getInventory().addItem(new ItemStack[]{itemStack});
            if (notAdded.isEmpty()) continue;
            for (ItemStack leftover : notAdded.values()) {
                player.getWorld().dropItem(player.getLocation(), leftover);
            }
        }
    }

    private boolean isCustomMenuItem(ItemStack item) {
        if (item == null || !item.hasItemMeta()) {
            return false;
        }
        return item.getItemMeta().getPersistentDataContainer().has(new NamespacedKey((Plugin)this.main, "custom-menu-item"), PersistentDataType.STRING);
    }

    public static boolean sellGUIItem(ItemStack item, Player player) {
        if (item == null || !item.hasItemMeta()) {
            return false;
        }
        SellGUIMain instance = SellGUIMain.getInstance();
        if (instance == null) {
            return false;
        }
        NamespacedKey guiKey = new NamespacedKey((Plugin)instance, "sellgui");
        return item.getItemMeta().getPersistentDataContainer().has(guiKey, PersistentDataType.BYTE);
    }
}

