/*
 * Decompiled with CFR 0.152.
 */
package com.joshiegemfinder.serveridplugin;

import com.google.inject.Inject;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.connection.PluginMessageEvent;
import com.velocitypowered.api.event.player.configuration.PlayerEnterConfigurationEvent;
import com.velocitypowered.api.event.proxy.ProxyInitializeEvent;
import com.velocitypowered.api.plugin.Plugin;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ProxyServer;
import com.velocitypowered.api.proxy.ServerConnection;
import com.velocitypowered.api.proxy.messages.ChannelIdentifier;
import com.velocitypowered.api.proxy.messages.ChannelMessageSink;
import com.velocitypowered.api.proxy.messages.ChannelMessageSource;
import com.velocitypowered.api.proxy.messages.MinecraftChannelIdentifier;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.slf4j.Logger;

@Plugin(id="server-id", name="Server Id", version="1.0.0", authors={"JoshieGemFinder"}, description="Informs client of the server id they're connected to via the worldinfo:world_id packet. Main feature is that it supports the configuration phase")
public class ServerIdPlugin {
    public static final String ID = "server-id";
    public static final String NAME = "Server Id";
    public static final String VERSION = "1.0.0";
    public static final ChannelIdentifier WORLD_ID_CHANNEL = MinecraftChannelIdentifier.create((String)"worldinfo", (String)"world_id");
    public static final ChannelIdentifier CUSTOM_REGISTER_CHANNEL = MinecraftChannelIdentifier.create((String)"minecraft", (String)"register");
    public final ProxyServer server;
    public final Logger logger;

    @Inject
    public ServerIdPlugin(ProxyServer server, Logger logger) {
        this.server = server;
        this.logger = logger;
    }

    @Subscribe
    public void onProxyInitialization(ProxyInitializeEvent event) {
        this.server.getChannelRegistrar().register(new ChannelIdentifier[]{WORLD_ID_CHANNEL});
    }

    @Subscribe
    public void onEnterConfiguration(PlayerEnterConfigurationEvent event) {
        Player player = event.player();
        player.sendPluginMessage(CUSTOM_REGISTER_CHANNEL, WORLD_ID_CHANNEL.getId().getBytes(StandardCharsets.US_ASCII));
    }

    @Subscribe(priority=120)
    public void onPluginMessage(PluginMessageEvent event) {
        if (Objects.equals(event.getIdentifier(), WORLD_ID_CHANNEL)) {
            this.handleWorldIdMessage(event);
        }
    }

    public void handleWorldIdMessage(PluginMessageEvent event) {
        ChannelMessageSource source = event.getSource();
        ChannelMessageSink target = event.getTarget();
        if (source instanceof Player) {
            Player player = (Player)source;
            if (target instanceof ServerConnection) {
                ServerConnection connection2 = (ServerConnection)target;
                this.sendPlayerQueryResponse(player, connection2, event);
            } else {
                player.getCurrentServer().ifPresent(connection -> this.sendPlayerQueryResponse(player, (ServerConnection)connection, event));
            }
        } else if (source instanceof ServerConnection) {
            ServerConnection connection3 = (ServerConnection)source;
            if (target instanceof Player) {
                Player player = (Player)target;
                this.interceptServerResponse(player, connection3, event);
            }
        }
    }

    public void sendPlayerQueryResponse(Player player, ServerConnection connection, PluginMessageEvent event) {
        this.sendWorldIdToPlayer(player, connection, event, false);
    }

    public void interceptServerResponse(Player player, ServerConnection connection, PluginMessageEvent event) {
        this.sendWorldIdToPlayer(player, connection, event, true);
    }

    public void sendWorldIdToPlayer(Player player, ServerConnection connection, PluginMessageEvent event, boolean isComingFromServer) {
        boolean isBadVoxelmap;
        ByteArrayInputStream data = event.dataAsInputStream();
        int zeroCount = 0;
        int magic = 0;
        while (data.available() > 0 && (magic = data.read()) == 0) {
            ++zeroCount;
        }
        if (magic != 42) {
            return;
        }
        if (isComingFromServer) {
            isBadVoxelmap = zeroCount == 0;
        } else {
            boolean bl = isBadVoxelmap = zeroCount == 3;
        }
        if (zeroCount != 1 && !isBadVoxelmap) {
            return;
        }
        player.sendPluginMessage(WORLD_ID_CHANNEL, ServerIdPlugin.formatResponse(connection.getServerInfo().getName(), isBadVoxelmap));
        event.setResult(PluginMessageEvent.ForwardResult.handled());
    }

    public static byte[] formatResponse(String worldName, boolean isBadVoxelmap) {
        byte[] worldNameBytes = worldName.getBytes(StandardCharsets.UTF_8);
        ByteArrayOutputStream buf = new ByteArrayOutputStream(isBadVoxelmap ? worldNameBytes.length + 2 : worldNameBytes.length + 3);
        if (!isBadVoxelmap) {
            buf.write(0);
        }
        buf.write(42);
        buf.write(worldNameBytes.length);
        buf.writeBytes(worldNameBytes);
        return buf.toByteArray();
    }
}

