include(Resources.id("mtrsteamloco:scripts/display_helper.js"));
importPackage(java.awt);
importPackage(java.awt.geom);
function assyukuDraw(g,text,textSize,drawPos,width,font,textColor){
    let nextStaScale = 1.0;
    // 文字の幅を測定
    if (g.getFontMetrics(font.deriveFont(Font.PLAIN, textSize)).stringWidth(text) > width / 12 * 7) {
         nextStaScale = (width / 12 * 7) / g.getFontMetrics(font.deriveFont(Font.PLAIN, textSize)).stringWidth(text);
    }
    // 描画
    g.setFont(font.deriveFont(AffineTransform.getScaleInstance(nextStaScale, 1.0)).deriveFont(Font.PLAIN, textSize));             
    g.setColor(textColor);
    g.drawString(text, (((width / 12 * 7) - (g.getFontMetrics(font.deriveFont(AffineTransform.getScaleInstance(nextStaScale, 1.0)).deriveFont(Font.PLAIN, textSize)).stringWidth(text))) / 2) + (width / 12 * 5), drawPos);
}
function ikisakiMain(g,train){
    //変数
    let font = Resources.readFont(Resources.id("mtr:font/notosansjp/notosansjp.ttf"));
    let next = train.getThisRoutePlatformsNextIndex();
    let platformList = train.getThisRoutePlatforms();
    let nextSta = (next + 1 < platformList.size()) ? platformList[next + 1].station.name : "";
    let nextStaJpn = TextUtil.getCjkParts(nextSta);
    let nextStaEng = TextUtil.getNonCjkParts(nextSta);
    let finalSta = platformList[next].destinationName;
    let finalStaJpn = TextUtil.getCjkParts(finalSta);
    let finalStaEng = TextUtil.getNonCjkParts(finalSta);
    let route = platformList[next].route.name;
    let routeExtra =  TextUtil.getExtraParts(route);
    let routeType = platformList[next].route.lightRailRouteNumber;
    let routeTypeJpn = TextUtil.getCjkParts(routeType);
    let routeColor = new Color(platformList[next].route.color);
    let routeTypeColor;
    let nisW = g.getFontMetrics(font.deriveFont(Font.PLAIN, 100)).stringWidth("回　 送");
    let nisEngW = g.getFontMetrics(font.deriveFont(Font.PLAIN, 50)).stringWidth("Not In Service");
    let ledImage = Resources.readBufferedImage(Resources.id("mtr:tx_3000_lcd/images/led.png"));
    let backGround = new Color(0.188, 0.188, 0.188);
    let width = 480;
    let height = 160;
    g.setColor(backGround);
    g.fillRect(0, 0, width, height);
    //回送
    if (train.isOnRoute()){
        //種別
        if (routeTypeJpn == "快速"){
            routeTypeColor = Color.red;
            g.setColor(routeTypeColor);
            g.fillRect(0, 0, width / 12 * 5, height);
            g.setColor(Color.white);
            g.setFont(font.deriveFont(Font.PLAIN, 80));
            g.drawString("快 速", 5, 80);
            g.setFont(font.deriveFont(Font.PLAIN, 60));
            g.drawString("Rapid", 5, 140);
        } else if (routeTypeJpn == "区間快速"){
            routeTypeColor = Color.blue;
            g.setColor(routeTypeColor);
            g.fillRect(0, 0, width / 12 * 5, height);
            g.setColor(Color.white);
            g.setFont(font.deriveFont(Font.PLAIN, 80));
            g.drawString("区 快", 5, 80);
            g.setFont(font.deriveFont(Font.PLAIN, 40));
            g.drawString("Semi", 5, 120);
            g.drawString("Rapid", 85, 150);
        } else if (routeTypeJpn == "普通" || routeTypeJpn == "各停" || routeTypeJpn == "各駅停車"){
            routeTypeColor = Color.lightGray;
            g.setColor(routeTypeColor);
            g.fillRect(0, 0, width / 12 * 5, height);
            g.setColor(Color.white);
            g.setFont(font.deriveFont(Font.PLAIN, 80));
            g.drawString("普 通", 5, 80);
            g.setFont(font.deriveFont(Font.PLAIN, 60));
            g.drawString("Local", 5, 140);
        } else if (routeTypeJpn == "通勤快速"){
            routeTypeColor = Color.orange;
            g.setColor(routeTypeColor);
            g.fillRect(0, 0, width / 12 * 5, height);
            g.setColor(Color.white);
            g.setFont(font.deriveFont(Font.PLAIN, 80));
            g.drawString("通快", 5, 80);
            g.setFont(font.deriveFont(Font.PLAIN, 40));
            g.drawString("Com.", 5, 120);
            g.setFont(font.deriveFont(Font.PLAIN, 40));
            g.drawString("Rapid", 85, 150);
        } else {
            routeTypeColor = routeColor;
            g.setColor(routeTypeColor);
            g.fillRect(0, 0, width / 12 * 5, height);
        }
        if ((train.speed() < 0.27777) && (next + 1 != platformList.size())){
            if (Date.now()% 9000 < 3000){
                //日本語
                assyukuDraw(g,finalStaJpn + " 行",85,85,width,font,Color.white);
                assyukuDraw(g,"次は " + nextStaJpn,50,150,width,font,Color.yellow);
            } else if (Date.now()% 9000 < 6000 && Date.now()% 9000 >= 3000){
                //英語
                assyukuDraw(g,"For " + finalStaEng,65,75,width,font,Color.white);
                assyukuDraw(g,"Next " + nextStaEng,40,140,width,font,Color.yellow);
            } else {
                //号車表示
                g.setColor(backGround);
                g.fillRect(0, 0, width, height);
                g.setColor(Color.white);
                g.setFont(font.deriveFont(Font.PLAIN, 100));
                g.drawString(train.trainCars() + "両編成", (width - g.getFontMetrics(font.deriveFont(Font.PLAIN, 100)).stringWidth(train.trainCars() + "両編成")) / 2, 120);
            }
        } else {
            assyukuDraw(g,finalStaJpn,85,85,width,font,Color.white);
            //英語
            assyukuDraw(g,finalStaEng,65,150,width,font,Color.white);
        }
    } else {
        g.setColor(Color.white);
        g.setFont(font.deriveFont(Font.PLAIN, 100));
        g.drawString("回　 送", (width / 2) - (nisW / 2), 100);
        g.setColor(Color.yellow);
        g.setFont(font.deriveFont(Font.PLAIN, 50));
        g.drawString("Not In Service", (width / 2) - (nisEngW / 2), 160);
    }
    g.drawImage(ledImage, 0, 0, 480, 160, null);
}
function ikisakiFront(g,train){
    //変数
    let font = Resources.readFont(Resources.id("mtr:font/notosansjp/notosansjp.ttf"));
    let next = train.getThisRoutePlatformsNextIndex();
    let platformList = train.getThisRoutePlatforms();
    let finalSta = platformList[next].destinationName;
    let finalStaJpn = TextUtil.getCjkParts(finalSta);
    let finalStaEng = TextUtil.getNonCjkParts(finalSta);
    let routeType = platformList[next].route.lightRailRouteNumber;
    let routeTypeJpn = TextUtil.getCjkParts(routeType);
    let routeColor = new Color(platformList[next].route.color);
    let routeTypeColor;
    let nisW = g.getFontMetrics(font.deriveFont(Font.PLAIN, 100)).stringWidth("回　 送");
    let nisEngW = g.getFontMetrics(font.deriveFont(Font.PLAIN, 50)).stringWidth("Not In Service");
    let ledImage = Resources.readBufferedImage(Resources.id("mtr:tx_3000_lcd/images/led.png"));
    let backGround = new Color(0.188, 0.188, 0.188);
    let width = 480;
    let height = 160;
    g.setColor(backGround);
    g.fillRect(0, 0, width, height);
    //回送
    if (train.isOnRoute()){
        //種別
        if (routeTypeJpn == "快速"){
            routeTypeColor = Color.red;
            g.setColor(routeTypeColor);
            g.fillRect(0, 0, width / 12 * 5, height);
            g.setColor(Color.white);
            g.setFont(font.deriveFont(Font.PLAIN, 80));
            g.drawString("快 速", 5, 80);
            g.setFont(font.deriveFont(Font.PLAIN, 60));
            g.drawString("Rapid", 5, 140);
        } else if (routeTypeJpn == "区間快速"){
            routeTypeColor = Color.blue;
            g.setColor(routeTypeColor);
            g.fillRect(0, 0, width / 12 * 5, height);
            g.setColor(Color.white);
            g.setFont(font.deriveFont(Font.PLAIN, 80));
            g.drawString("区 快", 5, 80);
            g.setFont(font.deriveFont(Font.PLAIN, 40));
            g.drawString("Semi", 5, 120);
            g.drawString("Rapid", 85, 150);
        } else if (routeTypeJpn == "普通" || routeTypeJpn == "各停" || routeTypeJpn == "各駅停車"){
            routeTypeColor = Color.lightGray;
            g.setColor(routeTypeColor);
            g.fillRect(0, 0, width / 12 * 5, height);
            g.setColor(Color.white);
            g.setFont(font.deriveFont(Font.PLAIN, 80));
            g.drawString("普 通", 5, 80);
            g.setFont(font.deriveFont(Font.PLAIN, 60));
            g.drawString("Local", 5, 140);
        } else if (routeTypeJpn == "通勤快速"){
            routeTypeColor = Color.orange;
            g.setColor(routeTypeColor);
            g.fillRect(0, 0, width / 12 * 5, height);
            g.setColor(Color.white);
            g.setFont(font.deriveFont(Font.PLAIN, 80));
            g.drawString("通快", 5, 80);
            g.setFont(font.deriveFont(Font.PLAIN, 40));
            g.drawString("Com.", 5, 120);
            g.setFont(font.deriveFont(Font.PLAIN, 40));
            g.drawString("Rapid", 85, 150);
        } else {
            routeTypeColor = routeColor;
            g.setColor(routeTypeColor);
            g.fillRect(0, 0, width / 12 * 5, height);
        }

        assyukuDraw(g,finalStaJpn,85,85,width,font,Color.white);
        //英語
        assyukuDraw(g,finalStaEng,65,150,width,font,Color.white);
    } else {
        g.setColor(Color.white);
        g.setFont(font.deriveFont(Font.PLAIN, 100));
        g.drawString("回　 送", (width / 2) - (nisW / 2), 100);
        g.setColor(Color.yellow);
        g.setFont(font.deriveFont(Font.PLAIN, 50));
        g.drawString("Not In Service", (width / 2) - (nisEngW / 2), 160);
    }
    g.drawImage(ledImage, 0, 0, 480, 160, null);
}