include(Resources.id("mtrsteamloco:scripts/display_helper.js"));
importPackage(java.awt);
importPackage(java.awt.geom);
//左右同じ表示
function lcdmain(g, train){
    //変数
    let font = Resources.readFont(Resources.id("mtr:font/notosansjp/notosansjp.ttf"));
    let next = train.getThisRoutePlatformsNextIndex();
    let platformList = train.getThisRoutePlatforms();
    let nextSta = platformList.get(next).station.name;
    let nextStaDistance = platformList[next].distance;
    let railProgress = train.getRailProgress(0);
    let nextStaJpn = TextUtil.getCjkParts(nextSta);
    let nextStaEng = TextUtil.getNonCjkParts(nextSta);
    let finalSta = platformList.get(platformList.size()-1).station.name;
    let finalStaJpn = TextUtil.getCjkParts(finalSta);
    let finalStaEng = TextUtil.getNonCjkParts(finalSta);
    let routeType = platformList[next].route.lightRailRouteNumber;
    let routeTypeJpn = TextUtil.getCjkParts(routeType);
    let routeTypeEng = TextUtil.getNonCjkParts(routeType);
    let routeColor = new Color(platformList[next].route.color);
    //背景
    g.setColor(Color.white);
    g.fillRect(0, 100, 896, 280.44803);
    g.setColor(Color.darkGray);
    g.fillRect(0, 0, 896, 100);
    //上部分表示
    if(Date.now()% 10000 > 5000){
        if (platformList.size()-1 == next){
            if (train.doorValue() > 0){
                g.setColor(Color.lightGray);
                g.setFont(font.deriveFont(Font.PLAIN, 30));
                g.drawString("終点", 10, 40);
            } else if(nextStaDistance - railProgress < 500){
                g.setColor(Color.lightGray);
                g.setFont(font.deriveFont(Font.PLAIN, 30));
                g.drawString("まもなく終点", 10, 40);
            } else{
                g.setColor(Color.lightGray);
                g.setFont(font.deriveFont(Font.PLAIN, 30));
                g.drawString("つぎは終点", 10, 40);
            }
        } else {
            if (train.doorValue() > 0){
                g.setColor(Color.lightGray);
                g.setFont(font.deriveFont(Font.PLAIN, 30));
                g.drawString("ただいま", 10, 40);
                } else if(nextStaDistance - railProgress < 500){
                g.setColor(Color.lightGray);
                g.setFont(font.deriveFont(Font.PLAIN, 30));
                g.drawString("まもなく", 10, 40);
                } else{
                g.setColor(Color.lightGray);
                g.setFont(font.deriveFont(Font.PLAIN, 30));
                g.drawString("つぎは", 10, 40);
            }
        }
        //次駅・行先
        g.setColor(Color.white);
        g.setFont(font.deriveFont(Font.BOLD, 60));
        g.drawString(nextStaJpn, 130, 95);
        g.setColor(Color.lightGray);
        g.setFont(font.deriveFont(Font.PLAIN, 30));
        let forJpnW = g.getFontMetrics(font.deriveFont(Font.PLAIN, 30)).stringWidth("ゆき");
        g.drawString("ゆき", 896 - forJpnW - 10, 40);
        let finalStaJpnW = g.getFontMetrics(font.deriveFont(Font.PLAIN, 40)).stringWidth(finalStaJpn);
        g.setColor(Color.white);
        g.setFont(font.deriveFont(Font.PLAIN, 40));
        g.drawString(finalStaJpn, 896 - forJpnW - 20 - finalStaJpnW, 40);
        //種別
        if (routeType != null){
            if (routeTypeJpn == "快速"){
                routeTypeColor = Color.red;
            } else if (routeTypeJpn == "区間快速"){
                routeTypeColor = Color.blue;
            } else if (routeTypeJpn == "普通" || routeTypeJpn == "各停" || routeTypeJpn == "各駅停車"){
                routeTypeColor = Color.lightGray;
            } else if (routeTypeJpn == "通勤快速"){
                routeTypeColor = Color.orange;
            } else {
                routeTypeColor = routeColor
            }
        //種別の横幅を取得
        let routeTypeJpnW = g.getFontMetrics(font.deriveFont(Font.PLAIN, 40)).stringWidth(routeTypeJpn);
        //種別描画
        g.setColor(routeTypeColor);
        g.fillRect( 896 - forJpnW - finalStaJpnW - 40 - routeTypeJpnW, 5 ,routeTypeJpnW + 20 ,40);
        g.setColor(Color.white);
        g.setFont(font.deriveFont(Font.PLAIN, 40));
        g.drawString(routeTypeJpn, 896 - forJpnW - finalStaJpnW - 30 - routeTypeJpnW, 40);
        }
    } else {
        if (platformList.size()-1 == next){
            if (train.doorValue() > 0){
                g.setColor(Color.lightGray);
                g.setFont(font.deriveFont(Font.PLAIN, 30));
                g.drawString("Final stop", 10, 40);
                } else if(nextStaDistance - railProgress < 500){
                g.setColor(Color.lightGray);
                g.setFont(font.deriveFont(Font.PLAIN, 30));
                g.drawString("Arriving at final stop", 10, 40);
                } else{
                g.setColor(Color.lightGray);
                g.setFont(font.deriveFont(Font.PLAIN, 30));
                g.drawString("Next final stop", 10, 40);
            }
        } else {
            if (train.doorValue() > 0){
                g.setColor(Color.lightGray);
                g.setFont(font.deriveFont(Font.PLAIN, 30));
                g.drawString("Now stopping at", 10, 40);
                } else if(nextStaDistance - railProgress < 500){
                g.setColor(Color.lightGray);
                g.setFont(font.deriveFont(Font.PLAIN, 30));
                g.drawString("Arriving at", 10, 40);
                } else{
                g.setColor(Color.lightGray);
                g.setFont(font.deriveFont(Font.PLAIN, 30));
                g.drawString("Next", 10, 40);
            }
        }
        //英語次駅・行先
        g.setColor(Color.white);
        g.setFont(font.deriveFont(Font.BOLD, 60));
        g.drawString(nextStaEng, 130, 95);
        let finalStaEngW = g.getFontMetrics(font.deriveFont(Font.PLAIN, 45)).stringWidth(finalStaEng);
        g.setColor(Color.white);
        g.setFont(font.deriveFont(Font.PLAIN, 45));
        g.drawString(finalStaEng, 896 - finalStaEngW - 10, 40);
        g.setColor(Color.lightGray);
        g.setFont(font.deriveFont(Font.PLAIN, 30));
        let forEngW = g.getFontMetrics(font.deriveFont(Font.PLAIN, 30)).stringWidth("For");
        g.drawString("For", 896 - finalStaEngW - 20 - forEngW, 40);
        //英語種別
        if (routeType != null){
            if (routeTypeEng == "Rapid"){
                routeTypeColor = Color.red;
            } else if (routeTypeEng == "Semi Rapid"){
                routeTypeColor = Color.blue;
            } else if (routeTypeEng == "Local"){
                routeTypeColor = Color.lightGray;
            } else if (routeTypeEng == "Commuter Rapid"){
                routeTypeColor = Color.orange;
            } else {
                routeTypeColor = routeColor;
            }
        //英語の種別の横幅取得
        let routeTypeEngW = g.getFontMetrics(font.deriveFont(Font.PLAIN, 40)).stringWidth(routeTypeEng);
        //英語種別の描画
        g.setColor(routeTypeColor);
        g.fillRect( 896 - forEngW - finalStaEngW - 40 - routeTypeEngW, 5 ,routeTypeEngW + 20 ,40);
        g.setColor(Color.white);
        g.setFont(font.deriveFont(Font.PLAIN, 40));
        g.drawString(routeTypeEng, 896 - forEngW - finalStaEngW - 30 - routeTypeEngW, 40);
        }
    }
}
//左のみ
function lcdleft(g, train){
    //変数
    let font = Resources.readFont(Resources.id("mtr:font/notosansjp/notosansjp.ttf"));
    let next = train.getThisRoutePlatformsNextIndex();
    let platformList = train.getThisRoutePlatforms();
    let routeColor = new Color(platformList[next].route.color);
    let staBaseXLeft = 50;
    let staIncrementX = 50;
    let baseXLeft = staBaseXLeft - 20;
    let incrementX = 50;
    if(Date.now()% 10000 > 5000){
        g.setFont(font.deriveFont(Font.PLAIN, 20));
        g.setColor(Color.black);
        for (let routemapSta = 0; routemapSta <= 15; routemapSta++) {
            let staXPositionLeft = staBaseXLeft + (routemapSta * staIncrementX);
            g.rotate(Math.PI / 180 * -60, staXPositionLeft, 200.0);
            if (platformList.size()-1 == (15 - routemapSta)) {
                g.drawString(TextUtil.getCjkParts(platformList.get(0).station.name), staXPositionLeft, 200);
            } else if (platformList.size()-1 >= (16 - routemapSta)) {
                if (platformList.size()-1 <= (next + 15)) {
                    g.drawString(TextUtil.getCjkParts(platformList.get(platformList.size() - 16 + routemapSta).station.name), staXPositionLeft, 200);
                } else if (train.doorValue() > 0) {
                    g.drawString(TextUtil.getCjkParts(platformList.get(next + routemapSta).station.name), staXPositionLeft, 200);
                } else {
                    g.drawString(TextUtil.getCjkParts(platformList.get(next - 1 + routemapSta).station.name), staXPositionLeft, 200);
                }
            }
            g.rotate(Math.PI / 180 * 60, staXPositionLeft, 200.0);
        }
    } else {
        g.setFont(font.deriveFont(Font.PLAIN, 20));
        g.setColor(Color.black);
        for (let routemapSta = 0; routemapSta <= 15; routemapSta++) {
            let staXPositionLeft = staBaseXLeft + (routemapSta * staIncrementX);
            g.rotate(Math.PI / 180 * -60, staXPositionLeft, 200.0);
            if (platformList.size()-1 == (15 - routemapSta)) {
                g.drawString(TextUtil.getNonCjkParts(platformList.get(0).station.name), staXPositionLeft, 200);
            } else if (platformList.size()-1 >= (16 - routemapSta)) {
                if (platformList.size()-1 <= (next + 15)) {
                    g.drawString(TextUtil.getNonCjkParts(platformList.get(platformList.size() - 16 + routemapSta).station.name), staXPositionLeft, 200);
                } else if (train.doorValue() > 0) {
                    g.drawString(TextUtil.getNonCjkParts(platformList.get(next + routemapSta).station.name), staXPositionLeft, 200);
                } else {
                    g.drawString(TextUtil.getNonCjkParts(platformList.get(next - 1 + routemapSta).station.name), staXPositionLeft, 200);
                }
            }
        g.rotate(Math.PI / 180 * 60, staXPositionLeft, 200.0);
        }
    }
    
    //路線カラー描画
    g.setColor(routeColor);
    g.fillRect(25, 200, 775, 30);
    let xPs = [800, 825.98076, 800];
    let yPs = [200, 215, 230];
    g.fillPolygon(xPs, yPs, 3);
    //駅の円を描画
    for (let cycleCount = 0; cycleCount <= 14; cycleCount++) {
        //各円のX座標
        let xPositionLeft = baseXLeft + (cycleCount * incrementX);
        if (platformList.size()-1 <= (14 - cycleCount)) {
            g.setColor(routeColor);
            g.fillOval(xPositionLeft, 205, 20, 20);
        } else if (platformList.size()-1 - next + 1 <= (15 - cycleCount)) {
            g.setColor(Color.gray);
            g.fillOval(xPositionLeft, 205, 20, 20);
        } else {
            if (cycleCount == 0) {
                if (train.doorValue() > 0) {
                    g.setColor(Color.white);
                    g.fillOval(xPositionLeft, 205, 20, 20);
                } else {
                    g.setColor(Color.gray);
                g.fillOval(xPositionLeft, 205, 20, 20);
                }
            } else {
                g.setColor(Color.white);
                g.fillOval(xPositionLeft, 205, 20, 20);
            }
        }
    }
    g.setColor(Color.white);
    g.fillOval(780, 205, 20, 20);
    //矢印
    let xYajirushi;
    let yYajirushi;
    if (platformList.size()-1 - next <= 15) {
        if (train.doorValue() > 0) {
            xYajirushi = [baseXLeft + ((15 - (platformList.size()-1 - next)) * incrementX) + 5, baseXLeft + ((15 - (platformList.size()-1 - next)) * incrementX) + 10, baseXLeft + ((15 - (platformList.size()-1 - next)) * incrementX) + 15, baseXLeft + ((15 - (platformList.size()-1 - next)) * incrementX) + 10, baseXLeft + ((15 - (platformList.size()-1 - next)) * incrementX) + 5, baseXLeft + ((15 - (platformList.size()-1 - next)) * incrementX) + 10];
            yYajirushi = [205, 205, 215, 225, 225, 215];
        } else {
            xYajirushi = [baseXLeft + ((15 - (platformList.size()-1 - next)) * incrementX) - 20, baseXLeft + ((15 - (platformList.size()-1 - next)) * incrementX) - 15, baseXLeft + ((15 - (platformList.size()-1 - next)) * incrementX) - 10, baseXLeft + ((15 - (platformList.size()-1 - next)) * incrementX) - 15, baseXLeft + ((15 - (platformList.size()-1 - next)) * incrementX) - 20, baseXLeft + ((15 - (platformList.size()-1 - next)) * incrementX) - 15];
            yYajirushi = [205, 205, 215, 225, 225, 215];
        }
    } else {
        if (train.doorValue() > 0) {
            xYajirushi = [35, 40, 45, 40, 35, 40];
            yYajirushi = [205, 205, 215, 225, 225, 215];
        } else {
            xYajirushi = [60, 65, 70, 65, 60, 65];
            yYajirushi = [205, 205, 215, 225, 225, 215];
        }
    }
    if(Date.now()% 2000 > 1000) {
        g.setColor(Color.orange);
    } else {
        g.setColor(Color.blue);
    }
    g.fillPolygon(xYajirushi, yYajirushi, 6);
}
//右のみ
function lcdright(g, train){
    //変数
    let font = Resources.readFont(Resources.id("mtr:font/notosansjp/notosansjp.ttf"));
    let next = train.getThisRoutePlatformsNextIndex();
    let platformList = train.getThisRoutePlatforms();
    let routeColor = new Color(platformList[next].route.color);
    let staBaseXRight = 866;
    let staIncrementX = 50;
    let baseXRight = staBaseXRight - 20;
    let incrementX = 50;
    if(Date.now()% 10000 > 5000){
        g.setFont(font.deriveFont(Font.PLAIN, 20));
        g.setColor(Color.black);
        for (let routemapSta = 0; routemapSta <= 15; routemapSta++) {
            let staXPositionRight = staBaseXRight - (routemapSta * staIncrementX);
            g.rotate(Math.PI / 180 * -60, staXPositionRight, 200.0);
            if (platformList.size()-1 == (15 - routemapSta)) {
                g.drawString(TextUtil.getCjkParts(platformList.get(0).station.name), staXPositionRight, 200);
            } else if (platformList.size()-1 >= (16 - routemapSta)) {
                if (platformList.size()-1 <= (next + 15)) {
                    g.drawString(TextUtil.getCjkParts(platformList.get(platformList.size() - 16 + routemapSta).station.name), staXPositionRight, 200);
                } else if (train.doorValue() > 0) {
                    g.drawString(TextUtil.getCjkParts(platformList.get(next + routemapSta).station.name), staXPositionRight, 200);
                } else {
                    g.drawString(TextUtil.getCjkParts(platformList.get(next - 1 + routemapSta).station.name), staXPositionRight, 200);
                }
            }
        
            g.rotate(Math.PI / 180 * 60, staXPositionRight, 200.0);
        }
    } else {
        g.setFont(font.deriveFont(Font.PLAIN, 20));
        g.setColor(Color.black);
        for (let routemapSta = 0; routemapSta <= 15; routemapSta++) {
            let staXPositionRight = staBaseXRight - (routemapSta * staIncrementX);
            g.rotate(Math.PI / 180 * -60, staXPositionRight, 200.0);
            if (platformList.size()-1 == (15 - routemapSta)) {
                g.drawString(TextUtil.getNonCjkParts(platformList.get(0).station.name), staXPositionRight, 200);
            } else if (platformList.size()-1 >= (16 - routemapSta)) {
                if (platformList.size()-1 <= (next + 15)) {
                    g.drawString(TextUtil.getNonCjkParts(platformList.get(platformList.size() - 16 + routemapSta).station.name), staXPositionRight, 200);
                } else if (train.doorValue() > 0) {
                    g.drawString(TextUtil.getNonCjkParts(platformList.get(next + routemapSta).station.name), staXPositionRight, 200);
                } else {
                    g.drawString(TextUtil.getNonCjkParts(platformList.get(next - 1 + routemapSta).station.name), staXPositionRight, 200);
                }
            }
        g.rotate(Math.PI / 180 * 60, staXPositionRight, 200.0);
        }
    }
    
    //路線カラー描画
    g.setColor(routeColor);
    g.fillRect(96, 200, 775, 30);
    let xPs = [96, 70.01924, 96];
    let yPs = [200, 215, 230];
    g.fillPolygon(xPs, yPs, 3);
    //駅の円を描画
    for (let cycleCount = 0; cycleCount <= 14; cycleCount++) {
        //各円のX座標
        let xPositionRight = baseXRight - (cycleCount * incrementX);
        if (platformList.size()-1 <= (14 - cycleCount)) {
            g.setColor(routeColor);
            g.fillOval(xPositionRight, 205, 20, 20);
        } else if (platformList.size()-1 - next + 1 <= (15 - cycleCount)) {
            g.setColor(Color.gray);
            g.fillOval(xPositionRight, 205, 20, 20);
        } else {
            if (cycleCount == 0) {
                if (train.doorValue() > 0) {
                    g.setColor(Color.white);
                    g.fillOval(xPositionRight, 205, 20, 20);
                } else {
                    g.setColor(Color.gray);
                g.fillOval(xPositionRight, 205, 20, 20);
                }
            } else {
                g.setColor(Color.white);
                g.fillOval(xPositionRight, 205, 20, 20);
            }
        }
    }
    g.setColor(Color.white);
    g.fillOval(96, 205, 20, 20);
    //矢印
    let xYajirushi;
    let yYajirushi;
    if (platformList.size()-1 - next <= 15) {
        if (train.doorValue() > 0) {
            xYajirushi = [baseXRight - ((15 - (platformList.size()-1 - next)) * incrementX) + 10, baseXRight - ((15 - (platformList.size()-1 - next)) * incrementX) + 15, baseXRight - ((15 - (platformList.size()-1 - next)) * incrementX) + 10, baseXRight - ((15 - (platformList.size()-1 - next)) * incrementX) + 15, baseXRight - ((15 - (platformList.size()-1 - next)) * incrementX) + 10, baseXRight - ((15 - (platformList.size()-1 - next)) * incrementX) + 5];
            yYajirushi = [205, 205, 215, 225, 225, 215];
        } else {
            xYajirushi = [baseXRight - ((15 - (platformList.size()-1 - next)) * incrementX) + 35, baseXRight - ((15 - (platformList.size()-1 - next)) * incrementX) + 40, baseXRight - ((15 - (platformList.size()-1 - next)) * incrementX) + 35, baseXRight - ((15 - (platformList.size()-1 - next)) * incrementX) + 40, baseXRight - ((15 - (platformList.size()-1 - next)) * incrementX) + 35, baseXRight - ((15 - (platformList.size()-1 - next)) * incrementX) + 30];
            yYajirushi = [205, 205, 215, 225, 225, 215];
        }
    } else {
        if (train.doorValue() > 0) {
            xYajirushi = [856, 861, 856, 861, 856, 851];
            yYajirushi = [205, 205, 215, 225, 225, 215];
        } else {
            xYajirushi = [831, 836, 831, 836, 831, 826];
            yYajirushi = [205, 205, 215, 225, 225, 215];
        }
    }
    if(Date.now()% 2000 > 1000) {
        g.setColor(Color.orange);
    } else {
        g.setColor(Color.blue);
    }
    g.fillPolygon(xYajirushi, yYajirushi, 6);
}