/*
 * Decompiled with CFR 0.152.
 */
package io.github.mikip98.humilityafm.datagen;

import io.github.mikip98.humilityafm.datagen.AFMRecipieProvider;
import io.github.mikip98.humilityafm.registries.BlockRegistry;
import io.github.mikip98.humilityafm.registries.ItemRegistry;
import io.github.mikip98.humilityafm.util.Pair;
import io.github.mikip98.humilityafm.util.generation_data.ActiveGenerationData;
import io.github.mikip98.humilityafm.util.generation_data.RawGenerationData;
import io.github.mikip98.humilityafm.util.generation_data.material_management.MaterialArrayCombiner;
import io.github.mikip98.humilityafm.util.generation_data.material_management.MaterialMultiArrayIterable;
import io.github.mikip98.humilityafm.util.generation_data.material_management.material.BlockMaterial;
import io.github.mikip98.humilityafm.util.generation_data.material_management.material.MaterialType;
import io.github.mikip98.humilityafm.util.mod_support.SupportedMods;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricRecipeProvider;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2446;
import net.minecraft.class_2960;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8790;

public class AFMRecipeGenerator
extends FabricRecipeProvider {
    public AFMRecipeGenerator(FabricDataOutput output, CompletableFuture<class_7225.class_7874> registriesFuture) {
        super(output, registriesFuture);
    }

    protected class_2446 method_62766(class_7225.class_7874 registryLookup, class_8790 exporter) {
        return new AFMRecipieProvider(this, registryLookup, exporter){

            public void method_10419() {
                class_7225.class_7226 itemLookup = this.field_48981.method_46762(class_7924.field_41197);
                this.offerCabinetRecipe((class_7225.class_7226<class_1792>)itemLookup, this.field_53721, (class_1935)ItemRegistry.CABINET_ITEM, (class_1935)class_1802.field_8060, (class_1935)class_1802.field_8850, "cabinets/");
                this.offerIlluminatedCabinetRecipe((class_7225.class_7226<class_1792>)itemLookup, this.field_53721, (class_1935)ItemRegistry.ILLUMINATED_CABINET_ITEM, (class_1935)ItemRegistry.CABINET_ITEM);
                this.generateCabinetRecipies((class_7225.class_7226<class_1792>)itemLookup);
                this.generateWoodenMosaicRecipies((class_7225.class_7226<class_1792>)itemLookup);
                this.generateTerracottaTileRecipies((class_7225.class_7226<class_1792>)itemLookup);
                this.generateForcedCornerStairsRecipies((class_7225.class_7226<class_1792>)itemLookup);
                this.generateSpecialJackOLanternRecipies((class_7225.class_7226<class_1792>)itemLookup);
                this.generateCandlestickRecipies((class_7225.class_7226<class_1792>)itemLookup);
                this.generateGlowingPowderRecipies((class_7225.class_7226<class_1792>)itemLookup);
                this.generateLightStripRecipies((class_7225.class_7226<class_1792>)itemLookup);
                this.generateColouredTorchRecipies((class_7225.class_7226<class_1792>)itemLookup);
                this.generateColouredJackOLanternRecipies((class_7225.class_7226<class_1792>)itemLookup);
            }

            private void generateCabinetRecipies(class_7225.class_7226<class_1792> itemLookup) {
                String colourName;
                HashMap<Pair, List> perWoodCabinets = new HashMap<Pair, List>();
                HashMap<Pair, List> perWoodIlluminatedCabinets = new HashMap<Pair, List>();
                int i = 0;
                for (BlockMaterial material : ActiveGenerationData.cabinetVariantMaterials) {
                    Pair<SupportedMods, String> key = new Pair<SupportedMods, String>(material.layers()[0].metadata().sourceMod(), material.layers()[0].name());
                    colourName = material.layers()[1].name();
                    perWoodCabinets.computeIfAbsent(key, k -> new ArrayList()).add(Pair.of(ItemRegistry.CABINET_ITEM_VARIANTS[i], colourName));
                    perWoodIlluminatedCabinets.computeIfAbsent(key, k -> new ArrayList()).add(Pair.of(ItemRegistry.ILLUMINATED_CABINET_ITEM_VARIANTS[i], colourName));
                    ++i;
                }
                i = 0;
                for (BlockMaterial material : ActiveGenerationData.cabinetVariantMaterials) {
                    if (material.layers().length != 2) {
                        throw new IllegalStateException("Cabinet material must have exactly two layers, but found: " + Arrays.toString(material.layers()));
                    }
                    BlockMaterial.Layer woodLayer = material.layers()[0];
                    colourName = material.layers()[1].name();
                    SupportedMods woodSourceMod = woodLayer.metadata().sourceMod();
                    Pair<SupportedMods, String> key = new Pair<SupportedMods, String>(woodSourceMod, woodLayer.name());
                    class_1935[] sameWoodOtherColourCabinets = (class_1935[])((List)perWoodCabinets.get(key)).stream().filter(entry -> !((String)entry.second()).equals(colourName)).map(Pair::first).toArray(class_1935[]::new);
                    class_1935[] sameWoodOtherColourIlluminatedCabinets = (class_1935[])((List)perWoodIlluminatedCabinets.get(key)).stream().filter(entry -> !((String)entry.second()).equals(colourName)).map(Pair::first).toArray(class_1935[]::new);
                    class_1792 cabinetBlockItemVariant = ItemRegistry.CABINET_ITEM_VARIANTS[i];
                    class_1792 illuminatedCabinetBlockItemVariant = ItemRegistry.ILLUMINATED_CABINET_ITEM_VARIANTS[i];
                    this.offerCabinetRecipe(itemLookup, this.field_53721, (class_1935)cabinetBlockItemVariant, (class_1935)AFMRecipeGenerator.getItemFromName(woodLayer.name() + "_slab", woodSourceMod), (class_1935)AFMRecipeGenerator.getItemFromName(colourName + "_carpet"), "cabinets/");
                    this.offerIlluminatedCabinetRecipe(itemLookup, this.field_53721, (class_1935)illuminatedCabinetBlockItemVariant, (class_1935)cabinetBlockItemVariant);
                    class_1792 currentDye = AFMRecipeGenerator.getItemFromName(colourName + "_dye");
                    this.offerColorChangeRecipie(itemLookup, this.field_53721, (class_1935)cabinetBlockItemVariant, class_1856.method_8091((class_1935[])sameWoodOtherColourCabinets), (class_1935)currentDye, "humility-afm/cabinets", "cabinets/color_change/");
                    this.offerColorChangeRecipie(itemLookup, this.field_53721, (class_1935)illuminatedCabinetBlockItemVariant, class_1856.method_8091((class_1935[])sameWoodOtherColourIlluminatedCabinets), (class_1935)currentDye, "humility-afm/illuminated_cabinets", "illuminated_cabinets/color_change/");
                    ++i;
                }
            }

            private void generateWoodenMosaicRecipies(class_7225.class_7226<class_1792> itemLookup) {
                MaterialArrayCombiner woodenMosaicMaterials = ActiveGenerationData.woodenMosaicVariantMaterials;
                int i = 0;
                for (BlockMaterial material : woodenMosaicMaterials) {
                    BlockMaterial.Layer woodMaterial1 = material.layers()[0];
                    BlockMaterial.Layer woodMaterial2 = material.layers()[1];
                    SupportedMods sourceMod1 = woodMaterial1.metadata().sourceMod();
                    SupportedMods sourceMod2 = woodMaterial2.metadata().sourceMod();
                    class_1792 plank1 = AFMRecipeGenerator.getItemFromName(woodMaterial1.name() + "_planks", sourceMod1);
                    class_1792 plank2 = AFMRecipeGenerator.getItemFromName(woodMaterial2.name() + "_planks", sourceMod2);
                    this.offerWoodenMosaicRecipe(itemLookup, this.field_53721, (class_1935)BlockRegistry.WOODEN_MOSAIC_VARIANTS[i], (class_1935)plank1, (class_1935)plank2, "wooden_mosaics/");
                    int j = 1.getMirrorIndex(i, RawGenerationData.allWoodTypes.size());
                    this.offerChangeRecipie(itemLookup, this.field_53721, (class_1935)BlockRegistry.WOODEN_MOSAIC_VARIANTS[i], (class_1935)BlockRegistry.WOODEN_MOSAIC_VARIANTS[j], "humility-afm/wooden_mosaics", "wooden_mosaics/rotation/");
                    this.offerAlternateWoodenMosaicRecipe(itemLookup, this.field_53721, (class_1935)BlockRegistry.WOODEN_MOSAIC_VARIANTS[i], (class_1935)plank1, (class_1935)plank2, "datapack/wooden_mosaics/alternative/");
                    ++i;
                }
            }

            private void generateTerracottaTileRecipies(class_7225.class_7226<class_1792> itemLookup) {
                int i = 0;
                for (BlockMaterial material : ActiveGenerationData.terracottaTilesMaterials) {
                    class_1792 terracotta1 = AFMRecipeGenerator.getItemFromName(material.layers()[0].name() + "_terracotta");
                    class_1792 terracotta2 = AFMRecipeGenerator.getItemFromName(material.layers()[1].name() + "_terracotta");
                    this.offerTerracottaTileRecipe(itemLookup, this.field_53721, (class_1935)BlockRegistry.TERRACOTTA_TILE_VARIANTS[i], (class_1935)terracotta1, (class_1935)terracotta2, "terracotta_tiles/");
                    int j = 1.getMirrorIndex(i, RawGenerationData.vanillaColorPallet.length);
                    this.offerChangeRecipie(itemLookup, this.field_53721, (class_1935)BlockRegistry.TERRACOTTA_TILE_VARIANTS[i], (class_1935)BlockRegistry.TERRACOTTA_TILE_VARIANTS[j], "humility-afm/terracotta_tiles", "terracotta_tiles/rotation/");
                    ++i;
                }
            }

            private static int getMirrorIndex(int index, int n) {
                int mirrorOffset;
                int j_offset = index % (n - 1);
                int i = index / (n - 1);
                int j = j_offset >= i ? j_offset + 1 : j_offset;
                int result = j * (n - 1) + (mirrorOffset = i < j ? i : i - 1);
                if (result >= n * (n - 1)) {
                    throw new IllegalStateException("Calculated mirror index out of bounds: " + result + " for index: " + index + " and n: " + n);
                }
                return result;
            }

            private void generateForcedCornerStairsRecipies(class_7225.class_7226<class_1792> itemLookup) {
                int i = 0;
                for (BlockMaterial stairMaterial : ActiveGenerationData.forcedCornerStairsVariantMaterials) {
                    if (stairMaterial.layers().length != 1) {
                        throw new IllegalArgumentException("Forced corner stairs material must have exactly one layer, but found: " + Arrays.toString(stairMaterial.layers()));
                    }
                    BlockMaterial.Layer materialLayer = stairMaterial.layers()[0];
                    MaterialType materialType = materialLayer.metadata().type();
                    Object materialName = materialLayer.name();
                    if (materialType == MaterialType.STONY && ((String)materialName).endsWith("bricks")) {
                        materialName = ((String)materialName).substring(0, ((String)materialName).length() - 6) + "brick";
                    }
                    SupportedMods sourceMod = materialLayer.metadata().sourceMod();
                    class_1792 stairs = AFMRecipeGenerator.getItemFromName((String)materialName + "_stairs", sourceMod);
                    String modId = sourceMod != null ? sourceMod.modId : "vanilla";
                    class_2248 inner_stairs = BlockRegistry.INNER_STAIRS_BLOCK_VARIANTS[i];
                    class_2248 outer_stairs = BlockRegistry.OUTER_STAIRS_BLOCK_VARIANTS[i];
                    this.offerChangeRecipie(itemLookup, this.field_53721, (class_1935)inner_stairs, (class_1935)stairs, "humility-afm/stairs", "stairs/" + modId + "/inner/");
                    this.offerChangeRecipie(itemLookup, this.field_53721, (class_1935)outer_stairs, (class_1935)inner_stairs, "humility-afm/stairs", "stairs/" + modId + "/outer/");
                    this.offerChangeRecipie(itemLookup, this.field_53721, (class_1935)stairs, (class_1935)outer_stairs, "humility-afm/stairs", "stairs/" + modId + "/normal/");
                    ++i;
                }
            }

            private void generateSpecialJackOLanternRecipies(class_7225.class_7226<class_1792> itemLookup) {
                class_1792 carved_pumpkin = class_1802.field_17519;
                this.offerDoubleInputShapelessRecipe(itemLookup, this.field_53721, (class_1935)BlockRegistry.JACK_O_LANTERN_REDSTONE, (class_1935)carved_pumpkin, (class_1935)class_1802.field_8530, "humility-afm/jack_o_lanterns", 1, "jack_o_lanterns/");
                this.offerDoubleInputShapelessRecipe(itemLookup, this.field_53721, (class_1935)BlockRegistry.JACK_O_LANTERN_SOUL, (class_1935)carved_pumpkin, (class_1935)class_1802.field_22001, "humility-afm/jack_o_lanterns", 1, "jack_o_lanterns/");
            }

            private void generateColouredJackOLanternRecipies(class_7225.class_7226<class_1792> itemLookup) {
                class_1792 carved_pumpkin = class_1802.field_17519;
                for (int i = 0; i < RawGenerationData.vanillaColorPallet.length; ++i) {
                    class_2248 jackOLantern = BlockRegistry.COLOURED_JACK_O_LANTERNS[i];
                    class_2248 torch = BlockRegistry.COLOURED_TORCH_VARIANTS[i];
                    this.offerDoubleInputShapelessRecipe(itemLookup, this.field_53721, (class_1935)jackOLantern, (class_1935)carved_pumpkin, (class_1935)torch, "humility-afm/jack_o_lanterns", 1, "jack_o_lanterns/normal/");
                }
            }

            private void generateGlowingPowderRecipies(class_7225.class_7226<class_1792> itemLookup) {
                class_1792 glowstoneDust = class_1802.field_8601;
                class_1792 redstone = class_1802.field_8725;
                int i = 0;
                for (String color : RawGenerationData.vanillaColorPallet) {
                    class_1792 glowingPowder = ItemRegistry.GLOWING_POWDER_VARIANTS[i];
                    class_1792 dye = AFMRecipeGenerator.getItemFromName(color + "_dye");
                    this.offerTripleInputShapelessRecipe(itemLookup, this.field_53721, (class_1935)glowingPowder, (class_1935)glowstoneDust, (class_1935)redstone, (class_1935)dye, "humility-afm/glowing_powder", 1, "glowing_powder/");
                    ++i;
                }
            }

            private void generateColouredTorchRecipies(class_7225.class_7226<class_1792> itemLookup) {
                int length = ActiveGenerationData.colouredFeatureSetMaterials.size();
                for (int i = 0; i < length; ++i) {
                    class_2248 colouredTorch = BlockRegistry.COLOURED_TORCH_VARIANTS[i];
                    class_1792 glowingPowder = ItemRegistry.GLOWING_POWDER_VARIANTS[i];
                    this.offerColouredTorchRecipe(itemLookup, this.field_53721, (class_1935)colouredTorch, (class_1935)glowingPowder, 3, "humility-afm/coloured_torches", "coloured_torches/");
                }
            }

            private void generateCandlestickRecipies(class_7225.class_7226<class_1792> itemLookup) {
                int i = 0;
                for (BlockMaterial material : ActiveGenerationData.simpleCandlestickMaterials) {
                    String metal = material.layers()[0].name();
                    class_1792 ingot = AFMRecipeGenerator.getItemFromName(metal + "_ingot");
                    this.offerCandlestickRecipie(itemLookup, this.field_53721, (class_1935)ItemRegistry.CANDLESTICK_ITEM_VARIANTS[i], (class_1935)ingot, "candlesticks/");
                    ++i;
                }
                i = 0;
                for (MaterialMultiArrayIterable meterials : ActiveGenerationData.rustingCandlestickMaterials) {
                    String metal = ((BlockMaterial)meterials.iterator().next()).layers()[0].name();
                    class_1792 ingot = AFMRecipeGenerator.getItemFromName(metal + "_ingot");
                    this.offerCandlestickRecipie(itemLookup, this.field_53721, (class_1935)ItemRegistry.RUSTABLE_CANDLESTICK_ITEM_VARIANTS[i][0], (class_1935)ingot, "candlesticks/");
                    ++i;
                }
            }

            private void generateLightStripRecipies(class_7225.class_7226<class_1792> itemLookup) {
                for (int i = 0; i < RawGenerationData.vanillaColorPallet.length; ++i) {
                    this.offerLightStripRecipie(itemLookup, this.field_53721, (class_1935)BlockRegistry.LIGHT_STRIP_VARIANTS[i], (class_1935)ItemRegistry.GLOWING_POWDER_VARIANTS[i], "light_strips/");
                }
            }
        };
    }

    protected static class_1792 getItemFromName(String name) {
        return (class_1792)class_7923.field_41178.method_63535(class_2960.method_60654((String)name));
    }

    protected static class_1792 getItemFromName(String name, SupportedMods mod) {
        class_1792 item = mod == null ? (class_1792)class_7923.field_41178.method_63535(class_2960.method_60654((String)name)) : (class_1792)class_7923.field_41178.method_63535(class_2960.method_60655((String)mod.modId, (String)name));
        if (item == class_1802.field_8162) {
            throw new IllegalStateException("Item not found: " + name + " in mod: " + (mod != null ? mod.modId : "vanilla"));
        }
        return item;
    }

    public String method_10321() {
        return "AFMRecipeGenerator";
    }
}

