/*
 * Decompiled with CFR 0.152.
 */
package io.github.mikip98.humilityafm.datagen;

import io.github.mikip98.humilityafm.HumilityAFM;
import io.github.mikip98.humilityafm.content.properties.ModProperties;
import io.github.mikip98.humilityafm.content.properties.enums.CandleColor;
import io.github.mikip98.humilityafm.registries.BlockRegistry;
import io.github.mikip98.humilityafm.registries.ItemRegistry;
import io.github.mikip98.humilityafm.util.Pair;
import io.github.mikip98.humilityafm.util.generation_data.ActiveGenerationData;
import io.github.mikip98.humilityafm.util.generation_data.RawGenerationData;
import io.github.mikip98.humilityafm.util.generation_data.material_management.material.BlockMaterial;
import io.github.mikip98.humilityafm.util.generation_data.material_management.material.MaterialType;
import io.github.mikip98.humilityafm.util.mod_support.SupportedMods;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.datagen.v1.provider.FabricModelProvider;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_2760;
import net.minecraft.class_2769;
import net.minecraft.class_2778;
import net.minecraft.class_2960;
import net.minecraft.class_4910;
import net.minecraft.class_4915;
import net.minecraft.class_4918;
import net.minecraft.class_4922;
import net.minecraft.class_4925;
import net.minecraft.class_4926;
import net.minecraft.class_4935;
import net.minecraft.class_4936;
import net.minecraft.class_4942;
import net.minecraft.class_4943;
import net.minecraft.class_4944;
import net.minecraft.class_4945;

@Environment(value=EnvType.CLIENT)
public class ModelGenerator
extends FabricModelProvider {
    protected static final class_4942 CABINET_BLOCK_MODEL = ModelGenerator.getModel("block/cabinet_block");
    protected static final class_4942 CABINET_BLOCK_OPEN_MODEL = ModelGenerator.getModel("block/cabinet_block_open");
    protected static final class_4942 FLOOR_CABINET_BLOCK_MODEL = ModelGenerator.getModel("block/floor_cabinet_block");
    protected static final class_4942 FLOOR_CABINET_BLOCK_OPEN_MODEL = ModelGenerator.getModel("block/floor_cabinet_block_open");
    protected static final class_4942 CHECKER_2X2_MODEL = ModelGenerator.getModel("block/checker_2x2");
    protected static final class_4942 INNER_CORNER_STAIRS_MODEL = ModelGenerator.getModel("block/stairs_inner");
    protected static final class_4942 OUTER_CORNER_STAIRS_MODEL = ModelGenerator.getModel("block/stairs_outer");
    protected static final class_4942 TORCH_TEMPLATE_MODEL = ModelGenerator.getModel("block/torch_template");
    protected static final class_4942 TORCH_WALL_TEMPLATE_MODEL = ModelGenerator.getModel("block/torch_wall_template");
    protected static final class_4942 CANDLESTICK_STANDING_MODEL = ModelGenerator.getModel("block/candlestick");
    protected static final class_4942 CANDLESTICK_STANDING_WITH_CANDLE_MODEL = ModelGenerator.getModel("block/candlestick_candle");
    protected static final class_4942 CANDLESTICK_STANDING_WITH_CANDLE_LIT_MODEL = ModelGenerator.getModel("block/candlestick_candle_lit");
    protected static final class_4942 CANDLESTICK_WALL_MODEL = ModelGenerator.getModel("block/candlestick_wall");
    protected static final class_4942 CANDLESTICK_WALL_WITH_CANDLE_MODEL = ModelGenerator.getModel("block/candlestick_wall_candle");
    protected static final class_4942 CANDLESTICK_WALL_WITH_CANDLE_LIT_MODEL = ModelGenerator.getModel("block/candlestick_wall_candle_lit");
    protected static final class_4942 LIGHT_STRIP_STRAIGHT_MODEL = ModelGenerator.getModel("block/light_strip");
    protected static final class_4942 LIGHT_STRIP_INNER_MODEL = ModelGenerator.getModel("block/light_strip_inner");
    protected static final class_4942 LIGHT_STRIP_OUTER_MODEL = ModelGenerator.getModel("block/light_strip_outer");
    protected static final class_4942 JACK_O_LANTERN_TEMPLATE_MODEL = ModelGenerator.getModel("block/jack_o_lantern_template");

    public ModelGenerator(FabricDataOutput output) {
        super(output);
    }

    public void generateBlockStateModels(class_4910 blockStateModelGenerator) {
        blockStateModelGenerator.method_65399(ItemRegistry.CABINET_ITEM, HumilityAFM.getId("block/cabinet_block"));
        blockStateModelGenerator.method_65399(ItemRegistry.ILLUMINATED_CABINET_ITEM, HumilityAFM.getId("block/cabinet_block"));
        blockStateModelGenerator.field_22830.accept(ModelGenerator.getCabinetBlockstate(BlockRegistry.CABINET_BLOCK, HumilityAFM.getId("block/cabinet_block"), HumilityAFM.getId("block/cabinet_block_open")));
        blockStateModelGenerator.field_22830.accept(ModelGenerator.getCabinetBlockstate(BlockRegistry.ILLUMINATED_CABINET_BLOCK, HumilityAFM.getId("block/cabinet_block"), HumilityAFM.getId("block/cabinet_block_open")));
        blockStateModelGenerator.field_22830.accept(ModelGenerator.getFloorCabinetBlockstate(BlockRegistry.FLOOR_CABINET_BLOCK, HumilityAFM.getId("block/floor_cabinet_block"), HumilityAFM.getId("block/floor_cabinet_block_open")));
        blockStateModelGenerator.field_22830.accept(ModelGenerator.getFloorCabinetBlockstate(BlockRegistry.FLOOR_ILLUMINATED_CABINET_BLOCK, HumilityAFM.getId("block/floor_cabinet_block"), HumilityAFM.getId("block/floor_cabinet_block_open")));
        ModelGenerator.generateCabinetModelsAndBlockStates(blockStateModelGenerator);
        ModelGenerator.generateWoodenMosaicModelsAndBlockStates(blockStateModelGenerator);
        ModelGenerator.generateTerracottaTilesModelsAndBlockStates(blockStateModelGenerator);
        ModelGenerator.generateForcedCornerStairsModelsAndBlockstates(blockStateModelGenerator);
        ModelGenerator.generateCandlestickModelsAndBlockStates(blockStateModelGenerator);
        ModelGenerator.generateColouredTorchModelsAndBlockStates(blockStateModelGenerator);
        ModelGenerator.generateLightStripModelsAndBlockStates(blockStateModelGenerator);
        ModelGenerator.generateColouredJackOLanternModelsAndBlockStates(blockStateModelGenerator);
    }

    protected static void generateColouredJackOLanternModelsAndBlockStates(class_4910 blockStateModelGenerator) {
        int i = 0;
        for (String color : RawGenerationData.vanillaColorPallet) {
            class_2960 colouredJackOLanternTexture = HumilityAFM.getId("block/coloured_jack_o_lantern/coloured_jack_o_lantern_" + color);
            class_4944 textureMap = new class_4944().method_35909(class_4945.field_23016, colouredJackOLanternTexture);
            class_2960 jackOLanternModelId = JACK_O_LANTERN_TEMPLATE_MODEL.method_25852(HumilityAFM.getId("block/coloured_jack_o_lantern/coloured_jack_o_lantern_" + color), textureMap, blockStateModelGenerator.field_22831);
            blockStateModelGenerator.method_25623(BlockRegistry.COLOURED_JACK_O_LANTERNS[i], jackOLanternModelId);
            blockStateModelGenerator.field_22830.accept(ModelGenerator.getOrientableBlockState(BlockRegistry.COLOURED_JACK_O_LANTERNS[i], jackOLanternModelId));
            ++i;
        }
    }

    protected static class_4925 getOrientableBlockState(class_2248 block, class_2960 modelId) {
        return class_4925.method_25769((class_2248)block).method_25775((class_4926)class_4926.method_25783((class_2769)class_2741.field_12481).method_25793((Comparable)class_2350.field_11043, ModelGenerator.getVariant(modelId)).method_25793((Comparable)class_2350.field_11035, ModelGenerator.getUVLockedVariantY(modelId, class_4936.class_4937.field_22892)).method_25793((Comparable)class_2350.field_11039, ModelGenerator.getUVLockedVariantY(modelId, class_4936.class_4937.field_22893)).method_25793((Comparable)class_2350.field_11034, ModelGenerator.getUVLockedVariantY(modelId, class_4936.class_4937.field_22891)));
    }

    protected static class_4925 getTorchOrientableBlockState(class_2248 block, class_2960 modelId) {
        return class_4925.method_25769((class_2248)block).method_25775((class_4926)class_4926.method_25783((class_2769)class_2741.field_12481).method_25793((Comparable)class_2350.field_11043, ModelGenerator.getVariantY(modelId, class_4936.class_4937.field_22893)).method_25793((Comparable)class_2350.field_11035, ModelGenerator.getVariantY(modelId, class_4936.class_4937.field_22891)).method_25793((Comparable)class_2350.field_11039, ModelGenerator.getVariantY(modelId, class_4936.class_4937.field_22892)).method_25793((Comparable)class_2350.field_11034, ModelGenerator.getVariant(modelId)));
    }

    protected static void generateColouredTorchModelsAndBlockStates(class_4910 blockStateModelGenerator) {
        int i = 0;
        for (String color : RawGenerationData.vanillaColorPallet) {
            class_2960 coloured_torch_texture = HumilityAFM.getId("block/coloured_torch/coloured_torch_" + color);
            class_4944 textureMap = new class_4944().method_35909(class_4945.field_23005, coloured_torch_texture);
            class_2960 torchModelId = TORCH_TEMPLATE_MODEL.method_25852(HumilityAFM.getId("block/coloured_torch/coloured_torch_" + color), textureMap, blockStateModelGenerator.field_22831);
            class_2960 wallTorchModelId = TORCH_WALL_TEMPLATE_MODEL.method_25852(HumilityAFM.getId("block/coloured_torch/coloured_torch_wall_" + color), textureMap, blockStateModelGenerator.field_22831);
            blockStateModelGenerator.method_65399(ItemRegistry.COLOURED_TORCH_ITEM_VARIANTS[i], torchModelId);
            blockStateModelGenerator.field_22830.accept(ModelGenerator.getDefaultBlockstate(BlockRegistry.COLOURED_TORCH_VARIANTS[i], torchModelId));
            blockStateModelGenerator.field_22830.accept(ModelGenerator.getTorchOrientableBlockState(BlockRegistry.COLOURED_WALL_TORCH_VARIANTS[i], wallTorchModelId));
            ++i;
        }
    }

    protected static void generateLightStripModelsAndBlockStates(class_4910 blockStateModelGenerator) {
        int i = 0;
        for (BlockMaterial material : ActiveGenerationData.colouredFeatureSetMaterials) {
            String color = material.layers()[0].name();
            class_2960 coloured_concrete = class_2960.method_60654((String)("block/" + color + "_concrete"));
            class_4944 textureMap = new class_4944().method_35909(class_4945.method_27043((String)"0"), coloured_concrete);
            String pathPrefix = "block/light_strip/";
            class_2960 lightStripStraightModelId = LIGHT_STRIP_STRAIGHT_MODEL.method_25852(HumilityAFM.getId("block/light_strip/straight/light_strip_" + material.getSafeName()), textureMap, blockStateModelGenerator.field_22831);
            class_2960 lightStripInnerModelId = LIGHT_STRIP_INNER_MODEL.method_25852(HumilityAFM.getId("block/light_strip/inner/light_strip_inner_" + material.getSafeName()), textureMap, blockStateModelGenerator.field_22831);
            class_2960 lightStripOuterModelId = LIGHT_STRIP_OUTER_MODEL.method_25852(HumilityAFM.getId("block/light_strip/outer/light_strip_outer_" + material.getSafeName()), textureMap, blockStateModelGenerator.field_22831);
            blockStateModelGenerator.method_25623(BlockRegistry.LIGHT_STRIP_VARIANTS[i], lightStripStraightModelId);
            blockStateModelGenerator.field_22830.accept(ModelGenerator.getLightStripBlockstate(BlockRegistry.LIGHT_STRIP_VARIANTS[i], lightStripStraightModelId, lightStripInnerModelId, lightStripOuterModelId));
            ++i;
        }
    }

    protected static void generateCandlestickModelsAndBlockStates(class_4910 blockStateModelGenerator) {
        ModelGenerator.generateCandlestickModelsAndBlockstatesForMetals(blockStateModelGenerator, ActiveGenerationData.simpleCandlestickMaterials, ItemRegistry.CANDLESTICK_ITEM_VARIANTS, BlockRegistry.SIMPLE_CANDLESTICK_WALL_VARIANTS, BlockRegistry.SIMPLE_CANDLESTICK_FLOOR_VARIANTS);
        for (int i = 0; i < ItemRegistry.RUSTABLE_CANDLESTICK_ITEM_VARIANTS.length; ++i) {
            ModelGenerator.generateCandlestickModelsAndBlockstatesForMetals(blockStateModelGenerator, ActiveGenerationData.rustingCandlestickMaterials[i], ItemRegistry.RUSTABLE_CANDLESTICK_ITEM_VARIANTS[i], BlockRegistry.RUSTABLE_CANDLESTICK_WALL_VARIANTS[i], BlockRegistry.RUSTABLE_CANDLESTICK_FLOOR_VARIANTS[i]);
        }
    }

    protected static void generateCandlestickModelsAndBlockstatesForMetals(class_4910 blockStateModelGenerator, Iterable<BlockMaterial> materials, class_1792[] items, class_2248[] wallBlocks, class_2248[] standingBlocks) {
        int i = 0;
        Set<String> block_suffix_metals = Set.of("copper", "gold", "iron");
        for (BlockMaterial material : materials) {
            String metal = material.layers()[0].name();
            String suffix = block_suffix_metals.contains(metal) ? "_block" : "";
            class_4944 metalTextureMap = new class_4944().method_35909(class_4945.method_27043((String)"metal"), class_2960.method_60654((String)("block/" + metal + suffix)));
            class_2960 candlestickStandingMetalModelId = CANDLESTICK_STANDING_MODEL.method_25852(HumilityAFM.getId("block/candlestick/standing/" + metal + "/candlestick_" + metal), metalTextureMap, blockStateModelGenerator.field_22831);
            class_2960 candlestickWallMetalModelId = CANDLESTICK_WALL_MODEL.method_25852(HumilityAFM.getId("block/candlestick/wall/" + metal + "/candlestick_wall_" + metal), metalTextureMap, blockStateModelGenerator.field_22831);
            class_2960 candlestickWithCandleStandingMetalModelId = CANDLESTICK_STANDING_WITH_CANDLE_MODEL.method_25852(HumilityAFM.getId("block/candlestick/standing/" + metal + "/candlestick_" + metal + "_candle"), metalTextureMap, blockStateModelGenerator.field_22831);
            class_2960 candlestickWithCandleLitStandingMetalModelId = CANDLESTICK_STANDING_WITH_CANDLE_LIT_MODEL.method_25852(HumilityAFM.getId("block/candlestick/standing/" + metal + "/candlestick_" + metal + "_candle_lit"), metalTextureMap, blockStateModelGenerator.field_22831);
            class_2960 candlestickWithCandleWallMetalModelId = CANDLESTICK_WALL_WITH_CANDLE_MODEL.method_25852(HumilityAFM.getId("block/candlestick/wall/" + metal + "/candlestick_wall_" + metal + "_candle"), metalTextureMap, blockStateModelGenerator.field_22831);
            class_2960 candlestickWithCandleLitWallMetalModelId = CANDLESTICK_WALL_WITH_CANDLE_LIT_MODEL.method_25852(HumilityAFM.getId("block/candlestick/wall/" + metal + "/candlestick_wall_" + metal + "_candle_lit"), metalTextureMap, blockStateModelGenerator.field_22831);
            class_4942 candlestickWithCandleStandingMetalModel = new class_4942(Optional.of(candlestickWithCandleStandingMetalModelId), Optional.empty(), new class_4945[0]);
            class_4942 candlestickWithCandleLitStandingMetalModel = new class_4942(Optional.of(candlestickWithCandleLitStandingMetalModelId), Optional.empty(), new class_4945[0]);
            class_4942 candlestickWithCandleWallMetalModel = new class_4942(Optional.of(candlestickWithCandleWallMetalModelId), Optional.empty(), new class_4945[0]);
            class_4942 candlestickWithCandleLitWallMetalModel = new class_4942(Optional.of(candlestickWithCandleLitWallMetalModelId), Optional.empty(), new class_4945[0]);
            HashMap<CandleColor, class_2960> wallCandleColorModelMap = new HashMap<CandleColor, class_2960>();
            HashMap<CandleColor, class_2960> wallLitCandleColorModelMap = new HashMap<CandleColor, class_2960>();
            HashMap<CandleColor, class_2960> standingCandleColorModelMap = new HashMap<CandleColor, class_2960>();
            HashMap<CandleColor, class_2960> standingLitCandleColorModelMap = new HashMap<CandleColor, class_2960>();
            for (String color : RawGenerationData.vanillaColorPallet) {
                CandleColor candleColor = CandleColor.getColor(color);
                class_4944 candleColorTextureMap = new class_4944().method_35909(class_4945.method_27043((String)"candle"), class_2960.method_60654((String)("block/" + color + "_candle_lit")));
                String id = "block/candlestick/standing/" + metal + "/candlestick_" + metal + "_" + color;
                class_2960 standingCandlestickColoredModelId = candlestickWithCandleStandingMetalModel.method_25852(HumilityAFM.getId(id), candleColorTextureMap, blockStateModelGenerator.field_22831);
                standingCandleColorModelMap.put(candleColor, standingCandlestickColoredModelId);
                class_2960 standingCandlestickLitColoredModelId = candlestickWithCandleLitStandingMetalModel.method_25852(HumilityAFM.getId(id + "_lit"), candleColorTextureMap, blockStateModelGenerator.field_22831);
                standingLitCandleColorModelMap.put(candleColor, standingCandlestickLitColoredModelId);
                id = "block/candlestick/wall/" + metal + "/candlestick_wall_" + metal + "_" + color;
                class_2960 wallCandlestickColoredModelId = candlestickWithCandleWallMetalModel.method_25852(HumilityAFM.getId(id), candleColorTextureMap, blockStateModelGenerator.field_22831);
                wallCandleColorModelMap.put(candleColor, wallCandlestickColoredModelId);
                class_2960 wallCandlestickLitColoredModelId = candlestickWithCandleLitWallMetalModel.method_25852(HumilityAFM.getId(id + "_lit"), candleColorTextureMap, blockStateModelGenerator.field_22831);
                wallLitCandleColorModelMap.put(candleColor, wallCandlestickLitColoredModelId);
            }
            blockStateModelGenerator.method_65399(items[i], candlestickStandingMetalModelId);
            blockStateModelGenerator.field_22830.accept(ModelGenerator.getWallCandlestickBlockstate(wallBlocks[i], candlestickWallMetalModelId, candlestickWithCandleWallMetalModelId, candlestickWithCandleLitWallMetalModelId, wallCandleColorModelMap, wallLitCandleColorModelMap));
            blockStateModelGenerator.field_22830.accept(ModelGenerator.getStandingCandlestickBlockstate(standingBlocks[i], candlestickStandingMetalModelId, candlestickWithCandleStandingMetalModelId, candlestickWithCandleLitStandingMetalModelId, standingCandleColorModelMap, standingLitCandleColorModelMap));
            ++i;
        }
    }

    protected static void generateForcedCornerStairsModelsAndBlockstates(class_4910 blockStateModelGenerator) {
        int i = 0;
        for (BlockMaterial stairMaterial : ActiveGenerationData.forcedCornerStairsVariantMaterials) {
            class_2960 sideTextureId;
            class_2960 topTextureId;
            if (stairMaterial.layers().length != 1) {
                throw new IllegalArgumentException("Forced corner stairs material must have exactly one materialLayer, but found: " + stairMaterial.layers().length);
            }
            BlockMaterial.Layer materialLayer = stairMaterial.layers()[0];
            SupportedMods sourceMod = materialLayer.metadata().sourceMod();
            String textureAtlasPrefix = (String)(sourceMod != null ? sourceMod.modId + ":" : "") + "block/";
            MaterialType materialType = materialLayer.metadata().type();
            if (materialType == null) {
                throw new IllegalStateException("Material type is null for forced corner stairs material layer: " + materialLayer.name());
            }
            class_2960 bottomTextureId = switch (materialType) {
                case MaterialType.BURNABLE_WOOD, MaterialType.FIREPROOF_WOOD -> {
                    class_2960 textureId;
                    Object textureBlockName = materialLayer.name() + "_planks";
                    topTextureId = textureId = class_2960.method_60654((String)(textureAtlasPrefix + (String)textureBlockName));
                    sideTextureId = textureId;
                    yield textureId;
                }
                case MaterialType.STONY -> {
                    Object textureBlockName;
                    Object topTextureName = textureBlockName = materialLayer.name();
                    Object sideTextureName = textureBlockName;
                    Object bottomTextureName = textureBlockName;
                    String suffix = "";
                    switch (textureBlockName) {
                        case "quartz": {
                            suffix = "_block_side";
                            break;
                        }
                        case "sandstone": 
                        case "red_sandstone": {
                            topTextureName = (String)topTextureName + "_top";
                            bottomTextureName = (String)bottomTextureName + "_bottom";
                            break;
                        }
                        case "polished_blackstone_brick": 
                        case "stone_brick": 
                        case "mossy_stone_brick": 
                        case "brick": 
                        case "nether_brick": 
                        case "red_nether_brick": 
                        case "end_stone_brick": 
                        case "deepslate_brick": 
                        case "deepslate_tile": {
                            suffix = "s";
                            break;
                        }
                        case "purpur": {
                            suffix = "_block";
                            break;
                        }
                        case "smooth_quartz": {
                            topTextureName = bottomTextureName = "quartz_block_bottom";
                            sideTextureName = bottomTextureName;
                            break;
                        }
                        case "smooth_sandstone": {
                            bottomTextureName = topTextureName = "sandstone_top";
                            sideTextureName = topTextureName;
                            break;
                        }
                        case "smooth_red_sandstone": {
                            bottomTextureName = topTextureName = "red_sandstone_top";
                            sideTextureName = topTextureName;
                        }
                    }
                    topTextureId = class_2960.method_60654((String)(textureAtlasPrefix + (String)topTextureName + suffix));
                    sideTextureId = class_2960.method_60654((String)(textureAtlasPrefix + (String)sideTextureName + suffix));
                    yield class_2960.method_60654((String)(textureAtlasPrefix + (String)bottomTextureName + suffix));
                }
                default -> throw new IllegalArgumentException("Unsupported material type for forced corner stairs: " + String.valueOf((Object)materialType));
            };
            class_2960 innerStairsModelId = INNER_CORNER_STAIRS_MODEL.method_25852(HumilityAFM.getId("block/corner_stairs/inner_stairs/inner_stairs_" + stairMaterial.getSafeName()), new class_4944().method_35909(class_4945.field_23015, topTextureId).method_35909(class_4945.field_23014, bottomTextureId).method_35909(class_4945.field_23018, sideTextureId), blockStateModelGenerator.field_22831);
            class_2960 outerStairsModelId = OUTER_CORNER_STAIRS_MODEL.method_25852(HumilityAFM.getId("block/corner_stairs/outer_stairs/outer_stairs_" + stairMaterial.getSafeName()), new class_4944().method_35909(class_4945.field_23015, topTextureId).method_35909(class_4945.field_23014, bottomTextureId).method_35909(class_4945.field_23018, sideTextureId), blockStateModelGenerator.field_22831);
            blockStateModelGenerator.method_25623(BlockRegistry.INNER_STAIRS_BLOCK_VARIANTS[i], innerStairsModelId);
            blockStateModelGenerator.method_25623(BlockRegistry.OUTER_STAIRS_BLOCK_VARIANTS[i], outerStairsModelId);
            blockStateModelGenerator.field_22830.accept(ModelGenerator.getForcedCornerStairsBlockstate(BlockRegistry.INNER_STAIRS_BLOCK_VARIANTS[i], innerStairsModelId));
            blockStateModelGenerator.field_22830.accept(ModelGenerator.getForcedCornerStairsBlockstate(BlockRegistry.OUTER_STAIRS_BLOCK_VARIANTS[i], outerStairsModelId));
            ++i;
        }
    }

    protected static void generateWoodenMosaicModelsAndBlockStates(class_4910 blockStateModelGenerator) {
        int i = 0;
        for (BlockMaterial variantMaterial : ActiveGenerationData.woodenMosaicVariantMaterials) {
            if (variantMaterial.layers().length != 2) {
                throw new IllegalArgumentException("Wooden mosaic material must have exactly two materialLayers, but found: " + variantMaterial.layers().length);
            }
            BlockMaterial.Layer layer1 = variantMaterial.layers()[0];
            BlockMaterial.Layer layer2 = variantMaterial.layers()[1];
            SupportedMods mod1 = layer1.metadata().sourceMod();
            SupportedMods mod2 = layer2.metadata().sourceMod();
            class_2960 planks1Id = class_2960.method_60654((String)((String)(mod1 != null ? mod1.modId + ":" : "") + "block/" + layer1.name() + "_planks"));
            class_2960 planks2Id = class_2960.method_60654((String)((String)(mod2 != null ? mod2.modId + ":" : "") + "block/" + layer2.name() + "_planks"));
            Object modFolders = "";
            if (mod1 != null) {
                modFolders = (String)modFolders + mod1.modId;
            }
            if (mod1 != null && mod2 != null) {
                modFolders = (String)modFolders + "_";
            }
            if (mod2 != null) {
                modFolders = (String)modFolders + mod2.modId;
            }
            if (!((String)modFolders).isEmpty()) {
                modFolders = (String)modFolders + "/";
            }
            class_2960 modelLocationId = HumilityAFM.getId("block/wooden_mosaic/" + (String)modFolders + "wooden_mosaic_" + variantMaterial.getSafeName());
            class_2960 woodenMosaicModelId = CHECKER_2X2_MODEL.method_25852(modelLocationId, new class_4944().method_35909(class_4945.method_27043((String)"1"), planks1Id).method_35909(class_4945.method_27043((String)"2"), planks2Id), blockStateModelGenerator.field_22831);
            blockStateModelGenerator.method_25623(BlockRegistry.WOODEN_MOSAIC_VARIANTS[i], woodenMosaicModelId);
            blockStateModelGenerator.field_22830.accept(ModelGenerator.getDefaultBlockstate(BlockRegistry.WOODEN_MOSAIC_VARIANTS[i], woodenMosaicModelId));
            ++i;
        }
    }

    protected static void generateTerracottaTilesModelsAndBlockStates(class_4910 blockStateModelGenerator) {
        int i = 0;
        for (String color : RawGenerationData.vanillaColorPallet) {
            for (String color2 : RawGenerationData.vanillaColorPallet) {
                if (color.equals(color2)) continue;
                class_2960 terracottaTileModelId = CHECKER_2X2_MODEL.method_25852(HumilityAFM.getId("block/terracotta_tiles/terracotta_tiles_" + color + "_" + color2), new class_4944().method_35909(class_4945.method_27043((String)"1"), class_2960.method_60654((String)("block/" + color + "_terracotta"))).method_35909(class_4945.method_27043((String)"2"), class_2960.method_60654((String)("block/" + color2 + "_terracotta"))), blockStateModelGenerator.field_22831);
                blockStateModelGenerator.method_25623(BlockRegistry.TERRACOTTA_TILE_VARIANTS[i], terracottaTileModelId);
                blockStateModelGenerator.field_22830.accept(ModelGenerator.getDefaultBlockstate(BlockRegistry.TERRACOTTA_TILE_VARIANTS[i], terracottaTileModelId));
                ++i;
            }
        }
    }

    protected static void generateCabinetModelsAndBlockStates(class_4910 blockStateModelGenerator) {
        HashMap<Pair, CabinetModelWoodSet> mod2baseWoodSet = new HashMap<Pair, CabinetModelWoodSet>();
        int i = 0;
        for (BlockMaterial material : ActiveGenerationData.cabinetVariantMaterials) {
            if (material.layers().length != 2) {
                throw new IllegalStateException("Cabinet material must have exactly two materialLayers, but found: " + material.layers().length);
            }
            BlockMaterial.Layer woodLayer = material.layers()[0];
            Pair<SupportedMods, String> baseWoodSetKey = Pair.of(woodLayer.metadata().sourceMod(), woodLayer.name());
            mod2baseWoodSet.computeIfAbsent(baseWoodSetKey, k -> ModelGenerator.generateCabinetWoodSet(woodLayer, blockStateModelGenerator));
            CabinetModelWoodSet baseWoodSet = (CabinetModelWoodSet)mod2baseWoodSet.get(baseWoodSetKey);
            BlockMaterial.Layer colorLayer = material.layers()[1];
            class_4944 woolTextureMap = new class_4944().method_35909(class_4945.method_27043((String)"wool"), class_2960.method_60654((String)("block/" + colorLayer.name() + "_wool")));
            class_2960 coloredCabinet = baseWoodSet.wallClosed.method_25852(ModelGenerator.getCabinetCompleteModelId("wall", "closed", woodLayer, colorLayer), woolTextureMap, blockStateModelGenerator.field_22831);
            class_2960 coloredCabinetOpen = baseWoodSet.wallOpen.method_25852(ModelGenerator.getCabinetCompleteModelId("wall", "open", woodLayer, colorLayer), woolTextureMap, blockStateModelGenerator.field_22831);
            class_2960 coloredFloorCabinet = baseWoodSet.floorClosed.method_25852(ModelGenerator.getCabinetCompleteModelId("floor", "closed", woodLayer, colorLayer), woolTextureMap, blockStateModelGenerator.field_22831);
            class_2960 coloredFloorCabinetOpen = baseWoodSet.floorOpen.method_25852(ModelGenerator.getCabinetCompleteModelId("floor", "open", woodLayer, colorLayer), woolTextureMap, blockStateModelGenerator.field_22831);
            blockStateModelGenerator.method_65399(ItemRegistry.CABINET_ITEM_VARIANTS[i], coloredCabinet);
            blockStateModelGenerator.method_65399(ItemRegistry.ILLUMINATED_CABINET_ITEM_VARIANTS[i], coloredCabinet);
            blockStateModelGenerator.field_22830.accept(ModelGenerator.getCabinetBlockstate(BlockRegistry.WALL_CABINET_BLOCK_VARIANTS[i], coloredCabinet, coloredCabinetOpen));
            blockStateModelGenerator.field_22830.accept(ModelGenerator.getCabinetBlockstate(BlockRegistry.WALL_ILLUMINATED_CABINET_BLOCK_VARIANTS[i], coloredCabinet, coloredCabinetOpen));
            blockStateModelGenerator.field_22830.accept(ModelGenerator.getFloorCabinetBlockstate(BlockRegistry.FLOOR_CABINET_BLOCK_VARIANTS[i], coloredFloorCabinet, coloredFloorCabinetOpen));
            blockStateModelGenerator.field_22830.accept(ModelGenerator.getFloorCabinetBlockstate(BlockRegistry.FLOOR_ILLUMINATED_CABINET_BLOCK_VARIANTS[i], coloredFloorCabinet, coloredFloorCabinetOpen));
            ++i;
        }
    }

    protected static CabinetModelWoodSet generateCabinetWoodSet(BlockMaterial.Layer wood, class_4910 blockStateModelGenerator) {
        SupportedMods sourceMod = wood.metadata().sourceMod();
        class_4944 plankTextureMap = new class_4944().method_35909(class_4945.method_27043((String)"planks"), sourceMod != null ? class_2960.method_60655((String)sourceMod.modId, (String)("block/" + wood.name() + "_planks")) : class_2960.method_60654((String)("block/" + wood.name() + "_planks")));
        class_2960 woodTypeCabinetId = CABINET_BLOCK_MODEL.method_25852(ModelGenerator.getCabinetBaseWoodModelId(sourceMod, "wall", "closed", wood.name()), plankTextureMap, blockStateModelGenerator.field_22831);
        class_2960 woodTypeCabinetOpenId = CABINET_BLOCK_OPEN_MODEL.method_25852(ModelGenerator.getCabinetBaseWoodModelId(sourceMod, "wall", "open", wood.name()), plankTextureMap, blockStateModelGenerator.field_22831);
        class_2960 woodTypeFloorCabinetId = FLOOR_CABINET_BLOCK_MODEL.method_25852(ModelGenerator.getCabinetBaseWoodModelId(sourceMod, "floor", "closed", wood.name()), plankTextureMap, blockStateModelGenerator.field_22831);
        class_2960 woodTypeFloorCabinetOpenId = FLOOR_CABINET_BLOCK_OPEN_MODEL.method_25852(ModelGenerator.getCabinetBaseWoodModelId(sourceMod, "floor", "open", wood.name()), plankTextureMap, blockStateModelGenerator.field_22831);
        return new CabinetModelWoodSet(ModelGenerator.getModel(woodTypeCabinetId), ModelGenerator.getModel(woodTypeCabinetOpenId), ModelGenerator.getModel(woodTypeFloorCabinetId), ModelGenerator.getModel(woodTypeFloorCabinetOpenId));
    }

    protected static class_2960 getCabinetBaseWoodModelId(SupportedMods sourceMod, String wallFloor, String openClosed, String woodName) {
        String cabinetPath = "block/cabinet/" + (sourceMod != null ? sourceMod.modId : "vanilla") + "/" + wallFloor + "/" + openClosed;
        String cabinetName = "cabinet_block_" + (String)(sourceMod != null ? sourceMod.modId + "_" : "") + woodName;
        return HumilityAFM.getId(cabinetPath + "/" + cabinetName);
    }

    protected static class_2960 getCabinetCompleteModelId(String wallFloor, String openClosed, BlockMaterial.Layer woodLayer, BlockMaterial.Layer colorLayer) {
        SupportedMods woodSourceMod = woodLayer.metadata().sourceMod();
        String woodName = woodLayer.name();
        String cabinetPath = "block/cabinet/" + (woodSourceMod != null ? woodSourceMod.modId : "vanilla") + "/" + wallFloor + "/" + openClosed + "/" + woodName;
        String cabinetName = "cabinet_block_" + (String)(woodSourceMod != null ? woodSourceMod.modId + "_" : "") + woodName + "_" + colorLayer.name();
        return HumilityAFM.getId(cabinetPath + "/" + cabinetName);
    }

    protected static class_4925 getLightStripBlockstate(class_2248 block, class_2960 straightModel, class_2960 innerModel, class_2960 outerModel) {
        class_2754 FACING = class_2741.field_12481;
        class_2754 HALF = class_2741.field_12518;
        class_2754 SHAPE = class_2741.field_12503;
        return class_4925.method_25769((class_2248)block).method_25775((class_4926)class_4926.method_25785((class_2769)FACING, (class_2769)HALF, (class_2769)SHAPE).method_25806((Comparable)class_2350.field_11034, (Comparable)class_2760.field_12617, (Comparable)class_2778.field_12712, ModelGenerator.getUVLockedUpsideDownVariant(innerModel)).method_25806((Comparable)class_2350.field_11034, (Comparable)class_2760.field_12617, (Comparable)class_2778.field_12713, ModelGenerator.getUVLockedUpsideDownVariantY(innerModel, class_4936.class_4937.field_22891)).method_25806((Comparable)class_2350.field_11034, (Comparable)class_2760.field_12617, (Comparable)class_2778.field_12708, ModelGenerator.getUVLockedUpsideDownVariant(outerModel)).method_25806((Comparable)class_2350.field_11034, (Comparable)class_2760.field_12617, (Comparable)class_2778.field_12709, ModelGenerator.getUVLockedUpsideDownVariantY(outerModel, class_4936.class_4937.field_22891)).method_25806((Comparable)class_2350.field_11034, (Comparable)class_2760.field_12617, (Comparable)class_2778.field_12710, ModelGenerator.getUVLockedUpsideDownVariantY(straightModel, class_4936.class_4937.field_22891)).method_25806((Comparable)class_2350.field_11034, (Comparable)class_2760.field_12619, (Comparable)class_2778.field_12712, ModelGenerator.getUVLockedVariantY(innerModel, class_4936.class_4937.field_22893)).method_25806((Comparable)class_2350.field_11034, (Comparable)class_2760.field_12619, (Comparable)class_2778.field_12713, ModelGenerator.getVariant(innerModel)).method_25806((Comparable)class_2350.field_11034, (Comparable)class_2760.field_12619, (Comparable)class_2778.field_12708, ModelGenerator.getUVLockedVariantY(outerModel, class_4936.class_4937.field_22893)).method_25806((Comparable)class_2350.field_11034, (Comparable)class_2760.field_12619, (Comparable)class_2778.field_12709, ModelGenerator.getVariant(outerModel)).method_25806((Comparable)class_2350.field_11034, (Comparable)class_2760.field_12619, (Comparable)class_2778.field_12710, ModelGenerator.getUVLockedVariantY(straightModel, class_4936.class_4937.field_22893)).method_25806((Comparable)class_2350.field_11043, (Comparable)class_2760.field_12617, (Comparable)class_2778.field_12712, ModelGenerator.getUVLockedUpsideDownVariantY(innerModel, class_4936.class_4937.field_22893)).method_25806((Comparable)class_2350.field_11043, (Comparable)class_2760.field_12617, (Comparable)class_2778.field_12713, ModelGenerator.getUVLockedUpsideDownVariant(innerModel)).method_25806((Comparable)class_2350.field_11043, (Comparable)class_2760.field_12617, (Comparable)class_2778.field_12708, ModelGenerator.getUVLockedUpsideDownVariantY(outerModel, class_4936.class_4937.field_22893)).method_25806((Comparable)class_2350.field_11043, (Comparable)class_2760.field_12617, (Comparable)class_2778.field_12709, ModelGenerator.getUVLockedUpsideDownVariant(outerModel)).method_25806((Comparable)class_2350.field_11043, (Comparable)class_2760.field_12617, (Comparable)class_2778.field_12710, ModelGenerator.getUVLockedUpsideDownVariant(straightModel)).method_25806((Comparable)class_2350.field_11043, (Comparable)class_2760.field_12619, (Comparable)class_2778.field_12712, ModelGenerator.getUVLockedVariantY(innerModel, class_4936.class_4937.field_22892)).method_25806((Comparable)class_2350.field_11043, (Comparable)class_2760.field_12619, (Comparable)class_2778.field_12713, ModelGenerator.getUVLockedVariantY(innerModel, class_4936.class_4937.field_22893)).method_25806((Comparable)class_2350.field_11043, (Comparable)class_2760.field_12619, (Comparable)class_2778.field_12708, ModelGenerator.getUVLockedVariantY(outerModel, class_4936.class_4937.field_22892)).method_25806((Comparable)class_2350.field_11043, (Comparable)class_2760.field_12619, (Comparable)class_2778.field_12709, ModelGenerator.getUVLockedVariantY(outerModel, class_4936.class_4937.field_22893)).method_25806((Comparable)class_2350.field_11043, (Comparable)class_2760.field_12619, (Comparable)class_2778.field_12710, ModelGenerator.getUVLockedVariantY(straightModel, class_4936.class_4937.field_22892)).method_25806((Comparable)class_2350.field_11035, (Comparable)class_2760.field_12617, (Comparable)class_2778.field_12712, ModelGenerator.getUVLockedUpsideDownVariantY(innerModel, class_4936.class_4937.field_22891)).method_25806((Comparable)class_2350.field_11035, (Comparable)class_2760.field_12617, (Comparable)class_2778.field_12713, ModelGenerator.getUVLockedUpsideDownVariantY(innerModel, class_4936.class_4937.field_22892)).method_25806((Comparable)class_2350.field_11035, (Comparable)class_2760.field_12617, (Comparable)class_2778.field_12708, ModelGenerator.getUVLockedUpsideDownVariantY(outerModel, class_4936.class_4937.field_22891)).method_25806((Comparable)class_2350.field_11035, (Comparable)class_2760.field_12617, (Comparable)class_2778.field_12709, ModelGenerator.getUVLockedUpsideDownVariantY(outerModel, class_4936.class_4937.field_22892)).method_25806((Comparable)class_2350.field_11035, (Comparable)class_2760.field_12617, (Comparable)class_2778.field_12710, ModelGenerator.getUVLockedUpsideDownVariantY(straightModel, class_4936.class_4937.field_22892)).method_25806((Comparable)class_2350.field_11035, (Comparable)class_2760.field_12619, (Comparable)class_2778.field_12712, ModelGenerator.getVariant(innerModel)).method_25806((Comparable)class_2350.field_11035, (Comparable)class_2760.field_12619, (Comparable)class_2778.field_12713, ModelGenerator.getUVLockedVariantY(innerModel, class_4936.class_4937.field_22891)).method_25806((Comparable)class_2350.field_11035, (Comparable)class_2760.field_12619, (Comparable)class_2778.field_12708, ModelGenerator.getVariant(outerModel)).method_25806((Comparable)class_2350.field_11035, (Comparable)class_2760.field_12619, (Comparable)class_2778.field_12709, ModelGenerator.getUVLockedVariantY(outerModel, class_4936.class_4937.field_22891)).method_25806((Comparable)class_2350.field_11035, (Comparable)class_2760.field_12619, (Comparable)class_2778.field_12710, ModelGenerator.getVariant(straightModel)).method_25806((Comparable)class_2350.field_11039, (Comparable)class_2760.field_12617, (Comparable)class_2778.field_12712, ModelGenerator.getUVLockedUpsideDownVariantY(innerModel, class_4936.class_4937.field_22892)).method_25806((Comparable)class_2350.field_11039, (Comparable)class_2760.field_12617, (Comparable)class_2778.field_12713, ModelGenerator.getUVLockedUpsideDownVariantY(innerModel, class_4936.class_4937.field_22893)).method_25806((Comparable)class_2350.field_11039, (Comparable)class_2760.field_12617, (Comparable)class_2778.field_12708, ModelGenerator.getUVLockedUpsideDownVariantY(outerModel, class_4936.class_4937.field_22892)).method_25806((Comparable)class_2350.field_11039, (Comparable)class_2760.field_12617, (Comparable)class_2778.field_12709, ModelGenerator.getUVLockedUpsideDownVariantY(outerModel, class_4936.class_4937.field_22893)).method_25806((Comparable)class_2350.field_11039, (Comparable)class_2760.field_12617, (Comparable)class_2778.field_12710, ModelGenerator.getUVLockedUpsideDownVariantY(straightModel, class_4936.class_4937.field_22893)).method_25806((Comparable)class_2350.field_11039, (Comparable)class_2760.field_12619, (Comparable)class_2778.field_12712, ModelGenerator.getUVLockedVariantY(innerModel, class_4936.class_4937.field_22891)).method_25806((Comparable)class_2350.field_11039, (Comparable)class_2760.field_12619, (Comparable)class_2778.field_12713, ModelGenerator.getUVLockedVariantY(innerModel, class_4936.class_4937.field_22892)).method_25806((Comparable)class_2350.field_11039, (Comparable)class_2760.field_12619, (Comparable)class_2778.field_12708, ModelGenerator.getUVLockedVariantY(outerModel, class_4936.class_4937.field_22891)).method_25806((Comparable)class_2350.field_11039, (Comparable)class_2760.field_12619, (Comparable)class_2778.field_12709, ModelGenerator.getUVLockedVariantY(outerModel, class_4936.class_4937.field_22892)).method_25806((Comparable)class_2350.field_11039, (Comparable)class_2760.field_12619, (Comparable)class_2778.field_12710, ModelGenerator.getUVLockedVariantY(straightModel, class_4936.class_4937.field_22891)));
    }

    protected static class_4922 getStandingCandlestickBlockstate(class_2248 block, class_2960 emptyModel, class_2960 plainCandleModel, class_2960 litPlainCandleModel, Map<CandleColor, class_2960> colouredCandleModels, Map<CandleColor, class_2960> litColouredCandleModels) {
        class_2746 LIT = class_2741.field_12548;
        class_2754<CandleColor> CANDLE_COLOR = ModProperties.CANDLE_COLOR;
        class_4922 multipart = class_4922.method_25758((class_2248)block).method_25760((class_4918)class_4918.method_25744().method_25751(CANDLE_COLOR, (Comparable)((Object)CandleColor.NONE)), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)emptyModel)).method_25760(class_4918.method_35870((class_4918[])new class_4918[]{class_4918.method_25744().method_25751(CANDLE_COLOR, (Comparable)((Object)CandleColor.PLAIN)), class_4918.method_25744().method_25751((class_2769)LIT, (Comparable)Boolean.valueOf(false))}), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)plainCandleModel)).method_25760(class_4918.method_35870((class_4918[])new class_4918[]{class_4918.method_25744().method_25751(CANDLE_COLOR, (Comparable)((Object)CandleColor.PLAIN)), class_4918.method_25744().method_25751((class_2769)LIT, (Comparable)Boolean.valueOf(true))}), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)litPlainCandleModel));
        for (CandleColor candleColor : colouredCandleModels.keySet()) {
            multipart.method_25760(class_4918.method_35870((class_4918[])new class_4918[]{class_4918.method_25744().method_25751(CANDLE_COLOR, (Comparable)((Object)candleColor)), class_4918.method_25744().method_25751((class_2769)LIT, (Comparable)Boolean.valueOf(false))}), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)colouredCandleModels.get((Object)candleColor))).method_25760(class_4918.method_35870((class_4918[])new class_4918[]{class_4918.method_25744().method_25751(CANDLE_COLOR, (Comparable)((Object)candleColor)), class_4918.method_25744().method_25751((class_2769)LIT, (Comparable)Boolean.valueOf(true))}), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)litColouredCandleModels.get((Object)candleColor)));
        }
        return multipart;
    }

    protected static class_4922 getWallCandlestickBlockstate(class_2248 block, class_2960 emptyModel, class_2960 plainCandleModel, class_2960 litPlainCandleModel, Map<CandleColor, class_2960> colouredCandleModels, Map<CandleColor, class_2960> litColouredCandleModels) {
        class_2754 FACING = class_2741.field_12481;
        class_2746 LIT = class_2741.field_12548;
        class_2754<CandleColor> CANDLE_COLOR = ModProperties.CANDLE_COLOR;
        class_4922 multipart = class_4922.method_25758((class_2248)block).method_25760(class_4918.method_35870((class_4918[])new class_4918[]{class_4918.method_25744().method_25751(CANDLE_COLOR, (Comparable)((Object)CandleColor.NONE)), class_4918.method_25744().method_25751((class_2769)FACING, (Comparable)class_2350.field_11043)}), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)emptyModel).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22892)).method_25760(class_4918.method_35870((class_4918[])new class_4918[]{class_4918.method_25744().method_25751(CANDLE_COLOR, (Comparable)((Object)CandleColor.NONE)), class_4918.method_25744().method_25751((class_2769)FACING, (Comparable)class_2350.field_11035)}), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)emptyModel)).method_25760(class_4918.method_35870((class_4918[])new class_4918[]{class_4918.method_25744().method_25751(CANDLE_COLOR, (Comparable)((Object)CandleColor.NONE)), class_4918.method_25744().method_25751((class_2769)FACING, (Comparable)class_2350.field_11034)}), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)emptyModel).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22893)).method_25760(class_4918.method_35870((class_4918[])new class_4918[]{class_4918.method_25744().method_25751(CANDLE_COLOR, (Comparable)((Object)CandleColor.NONE)), class_4918.method_25744().method_25751((class_2769)FACING, (Comparable)class_2350.field_11039)}), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)emptyModel).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22891)).method_25760(class_4918.method_35870((class_4918[])new class_4918[]{class_4918.method_25744().method_25751(CANDLE_COLOR, (Comparable)((Object)CandleColor.PLAIN)), class_4918.method_25744().method_25751((class_2769)LIT, (Comparable)Boolean.valueOf(false)), class_4918.method_25744().method_25751((class_2769)FACING, (Comparable)class_2350.field_11043)}), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)plainCandleModel).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22892)).method_25760(class_4918.method_35870((class_4918[])new class_4918[]{class_4918.method_25744().method_25751(CANDLE_COLOR, (Comparable)((Object)CandleColor.PLAIN)), class_4918.method_25744().method_25751((class_2769)LIT, (Comparable)Boolean.valueOf(false)), class_4918.method_25744().method_25751((class_2769)FACING, (Comparable)class_2350.field_11035)}), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)plainCandleModel)).method_25760(class_4918.method_35870((class_4918[])new class_4918[]{class_4918.method_25744().method_25751(CANDLE_COLOR, (Comparable)((Object)CandleColor.PLAIN)), class_4918.method_25744().method_25751((class_2769)LIT, (Comparable)Boolean.valueOf(false)), class_4918.method_25744().method_25751((class_2769)FACING, (Comparable)class_2350.field_11034)}), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)plainCandleModel).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22893)).method_25760(class_4918.method_35870((class_4918[])new class_4918[]{class_4918.method_25744().method_25751(CANDLE_COLOR, (Comparable)((Object)CandleColor.PLAIN)), class_4918.method_25744().method_25751((class_2769)LIT, (Comparable)Boolean.valueOf(false)), class_4918.method_25744().method_25751((class_2769)FACING, (Comparable)class_2350.field_11039)}), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)plainCandleModel).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22891)).method_25760(class_4918.method_35870((class_4918[])new class_4918[]{class_4918.method_25744().method_25751(CANDLE_COLOR, (Comparable)((Object)CandleColor.PLAIN)), class_4918.method_25744().method_25751((class_2769)LIT, (Comparable)Boolean.valueOf(true)), class_4918.method_25744().method_25751((class_2769)FACING, (Comparable)class_2350.field_11043)}), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)litPlainCandleModel).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22892)).method_25760(class_4918.method_35870((class_4918[])new class_4918[]{class_4918.method_25744().method_25751(CANDLE_COLOR, (Comparable)((Object)CandleColor.PLAIN)), class_4918.method_25744().method_25751((class_2769)LIT, (Comparable)Boolean.valueOf(true)), class_4918.method_25744().method_25751((class_2769)FACING, (Comparable)class_2350.field_11035)}), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)litPlainCandleModel)).method_25760(class_4918.method_35870((class_4918[])new class_4918[]{class_4918.method_25744().method_25751(CANDLE_COLOR, (Comparable)((Object)CandleColor.PLAIN)), class_4918.method_25744().method_25751((class_2769)LIT, (Comparable)Boolean.valueOf(true)), class_4918.method_25744().method_25751((class_2769)FACING, (Comparable)class_2350.field_11034)}), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)litPlainCandleModel).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22893)).method_25760(class_4918.method_35870((class_4918[])new class_4918[]{class_4918.method_25744().method_25751(CANDLE_COLOR, (Comparable)((Object)CandleColor.PLAIN)), class_4918.method_25744().method_25751((class_2769)LIT, (Comparable)Boolean.valueOf(true)), class_4918.method_25744().method_25751((class_2769)FACING, (Comparable)class_2350.field_11039)}), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)litPlainCandleModel).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22891));
        for (CandleColor candleColor : colouredCandleModels.keySet()) {
            multipart.method_25760(class_4918.method_35870((class_4918[])new class_4918[]{class_4918.method_25744().method_25751(CANDLE_COLOR, (Comparable)((Object)candleColor)), class_4918.method_25744().method_25751((class_2769)LIT, (Comparable)Boolean.valueOf(false)), class_4918.method_25744().method_25751((class_2769)FACING, (Comparable)class_2350.field_11043)}), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)colouredCandleModels.get((Object)candleColor)).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22892)).method_25760(class_4918.method_35870((class_4918[])new class_4918[]{class_4918.method_25744().method_25751(CANDLE_COLOR, (Comparable)((Object)candleColor)), class_4918.method_25744().method_25751((class_2769)LIT, (Comparable)Boolean.valueOf(false)), class_4918.method_25744().method_25751((class_2769)FACING, (Comparable)class_2350.field_11035)}), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)colouredCandleModels.get((Object)candleColor))).method_25760(class_4918.method_35870((class_4918[])new class_4918[]{class_4918.method_25744().method_25751(CANDLE_COLOR, (Comparable)((Object)candleColor)), class_4918.method_25744().method_25751((class_2769)LIT, (Comparable)Boolean.valueOf(false)), class_4918.method_25744().method_25751((class_2769)FACING, (Comparable)class_2350.field_11034)}), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)colouredCandleModels.get((Object)candleColor)).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22893)).method_25760(class_4918.method_35870((class_4918[])new class_4918[]{class_4918.method_25744().method_25751(CANDLE_COLOR, (Comparable)((Object)candleColor)), class_4918.method_25744().method_25751((class_2769)LIT, (Comparable)Boolean.valueOf(false)), class_4918.method_25744().method_25751((class_2769)FACING, (Comparable)class_2350.field_11039)}), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)colouredCandleModels.get((Object)candleColor)).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22891)).method_25760(class_4918.method_35870((class_4918[])new class_4918[]{class_4918.method_25744().method_25751(CANDLE_COLOR, (Comparable)((Object)candleColor)), class_4918.method_25744().method_25751((class_2769)LIT, (Comparable)Boolean.valueOf(true)), class_4918.method_25744().method_25751((class_2769)FACING, (Comparable)class_2350.field_11043)}), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)litColouredCandleModels.get((Object)candleColor)).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22892)).method_25760(class_4918.method_35870((class_4918[])new class_4918[]{class_4918.method_25744().method_25751(CANDLE_COLOR, (Comparable)((Object)candleColor)), class_4918.method_25744().method_25751((class_2769)LIT, (Comparable)Boolean.valueOf(true)), class_4918.method_25744().method_25751((class_2769)FACING, (Comparable)class_2350.field_11035)}), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)litColouredCandleModels.get((Object)candleColor))).method_25760(class_4918.method_35870((class_4918[])new class_4918[]{class_4918.method_25744().method_25751(CANDLE_COLOR, (Comparable)((Object)candleColor)), class_4918.method_25744().method_25751((class_2769)LIT, (Comparable)Boolean.valueOf(true)), class_4918.method_25744().method_25751((class_2769)FACING, (Comparable)class_2350.field_11034)}), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)litColouredCandleModels.get((Object)candleColor)).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22893)).method_25760(class_4918.method_35870((class_4918[])new class_4918[]{class_4918.method_25744().method_25751(CANDLE_COLOR, (Comparable)((Object)candleColor)), class_4918.method_25744().method_25751((class_2769)LIT, (Comparable)Boolean.valueOf(true)), class_4918.method_25744().method_25751((class_2769)FACING, (Comparable)class_2350.field_11039)}), class_4935.method_25824().method_25828(class_4936.field_22887, (Object)litColouredCandleModels.get((Object)candleColor)).method_25828(class_4936.field_22886, (Object)class_4936.class_4937.field_22891));
        }
        return multipart;
    }

    protected static class_4925 getForcedCornerStairsBlockstate(class_2248 block, class_2960 modelId) {
        return class_4925.method_25769((class_2248)block).method_25775((class_4926)class_4926.method_25784((class_2769)class_2741.field_12481, (class_2769)class_2741.field_12518).method_25797((Comparable)class_2350.field_11034, (Comparable)class_2760.field_12617, ModelGenerator.getUVLockedVariantY(modelId, class_4936.class_4937.field_22891)).method_25797((Comparable)class_2350.field_11034, (Comparable)class_2760.field_12619, ModelGenerator.getUVLockedUpsideDownVariantY(modelId, class_4936.class_4937.field_22892)).method_25797((Comparable)class_2350.field_11043, (Comparable)class_2760.field_12617, ModelGenerator.getVariant(modelId)).method_25797((Comparable)class_2350.field_11043, (Comparable)class_2760.field_12619, ModelGenerator.getUVLockedUpsideDownVariantY(modelId, class_4936.class_4937.field_22891)).method_25797((Comparable)class_2350.field_11035, (Comparable)class_2760.field_12617, ModelGenerator.getUVLockedVariantY(modelId, class_4936.class_4937.field_22892)).method_25797((Comparable)class_2350.field_11035, (Comparable)class_2760.field_12619, ModelGenerator.getUVLockedUpsideDownVariantY(modelId, class_4936.class_4937.field_22893)).method_25797((Comparable)class_2350.field_11039, (Comparable)class_2760.field_12617, ModelGenerator.getUVLockedVariantY(modelId, class_4936.class_4937.field_22893)).method_25797((Comparable)class_2350.field_11039, (Comparable)class_2760.field_12619, ModelGenerator.getUVLockedUpsideDownVariant(modelId)));
    }

    protected static class_4925 getDefaultBlockstate(class_2248 block, class_2960 modelId) {
        return class_4925.method_25770((class_2248)block, (class_4935)class_4935.method_25824().method_25828(class_4936.field_22887, (Object)modelId));
    }

    protected static class_4925 getCabinetBlockstate(class_2248 cabinetBlock, class_2960 cabinetModel, class_2960 cabinetOpenModel) {
        return class_4925.method_25769((class_2248)cabinetBlock).method_25775((class_4926)class_4926.method_25784((class_2769)class_2741.field_12481, (class_2769)class_2741.field_12537).method_25797((Comparable)class_2350.field_11043, (Comparable)Boolean.valueOf(true), ModelGenerator.getVariantY(cabinetOpenModel, class_4936.class_4937.field_22892)).method_25797((Comparable)class_2350.field_11043, (Comparable)Boolean.valueOf(false), ModelGenerator.getVariantY(cabinetModel, class_4936.class_4937.field_22892)).method_25797((Comparable)class_2350.field_11034, (Comparable)Boolean.valueOf(true), ModelGenerator.getVariantY(cabinetOpenModel, class_4936.class_4937.field_22893)).method_25797((Comparable)class_2350.field_11034, (Comparable)Boolean.valueOf(false), ModelGenerator.getVariantY(cabinetModel, class_4936.class_4937.field_22893)).method_25797((Comparable)class_2350.field_11035, (Comparable)Boolean.valueOf(true), ModelGenerator.getVariant(cabinetOpenModel)).method_25797((Comparable)class_2350.field_11035, (Comparable)Boolean.valueOf(false), ModelGenerator.getVariant(cabinetModel)).method_25797((Comparable)class_2350.field_11039, (Comparable)Boolean.valueOf(true), ModelGenerator.getVariantY(cabinetOpenModel, class_4936.class_4937.field_22891)).method_25797((Comparable)class_2350.field_11039, (Comparable)Boolean.valueOf(false), ModelGenerator.getVariantY(cabinetModel, class_4936.class_4937.field_22891)));
    }

    protected static class_4925 getFloorCabinetBlockstate(class_2248 cabinetBlock, class_2960 cabinetModel, class_2960 cabinetOpenModel) {
        return class_4925.method_25769((class_2248)cabinetBlock).method_25775((class_4926)class_4926.method_25785((class_2769)class_2741.field_12518, (class_2769)class_2741.field_12481, (class_2769)class_2741.field_12537).method_25806((Comparable)class_2760.field_12617, (Comparable)class_2350.field_11043, (Comparable)Boolean.valueOf(true), ModelGenerator.getVariantY(cabinetOpenModel, class_4936.class_4937.field_22892)).method_25806((Comparable)class_2760.field_12617, (Comparable)class_2350.field_11043, (Comparable)Boolean.valueOf(false), ModelGenerator.getVariantY(cabinetModel, class_4936.class_4937.field_22892)).method_25806((Comparable)class_2760.field_12617, (Comparable)class_2350.field_11034, (Comparable)Boolean.valueOf(true), ModelGenerator.getVariantY(cabinetOpenModel, class_4936.class_4937.field_22893)).method_25806((Comparable)class_2760.field_12617, (Comparable)class_2350.field_11034, (Comparable)Boolean.valueOf(false), ModelGenerator.getVariantY(cabinetModel, class_4936.class_4937.field_22893)).method_25806((Comparable)class_2760.field_12617, (Comparable)class_2350.field_11035, (Comparable)Boolean.valueOf(true), ModelGenerator.getVariant(cabinetOpenModel)).method_25806((Comparable)class_2760.field_12617, (Comparable)class_2350.field_11035, (Comparable)Boolean.valueOf(false), ModelGenerator.getVariant(cabinetModel)).method_25806((Comparable)class_2760.field_12617, (Comparable)class_2350.field_11039, (Comparable)Boolean.valueOf(true), ModelGenerator.getVariantY(cabinetOpenModel, class_4936.class_4937.field_22891)).method_25806((Comparable)class_2760.field_12617, (Comparable)class_2350.field_11039, (Comparable)Boolean.valueOf(false), ModelGenerator.getVariantY(cabinetModel, class_4936.class_4937.field_22891)).method_25806((Comparable)class_2760.field_12619, (Comparable)class_2350.field_11043, (Comparable)Boolean.valueOf(true), ModelGenerator.getUpsideDownVariantY(cabinetOpenModel, class_4936.class_4937.field_22892)).method_25806((Comparable)class_2760.field_12619, (Comparable)class_2350.field_11043, (Comparable)Boolean.valueOf(false), ModelGenerator.getUpsideDownVariantY(cabinetModel, class_4936.class_4937.field_22892)).method_25806((Comparable)class_2760.field_12619, (Comparable)class_2350.field_11034, (Comparable)Boolean.valueOf(true), ModelGenerator.getUpsideDownVariantY(cabinetOpenModel, class_4936.class_4937.field_22893)).method_25806((Comparable)class_2760.field_12619, (Comparable)class_2350.field_11034, (Comparable)Boolean.valueOf(false), ModelGenerator.getUpsideDownVariantY(cabinetModel, class_4936.class_4937.field_22893)).method_25806((Comparable)class_2760.field_12619, (Comparable)class_2350.field_11035, (Comparable)Boolean.valueOf(true), ModelGenerator.getUpsideDownVariant(cabinetOpenModel)).method_25806((Comparable)class_2760.field_12619, (Comparable)class_2350.field_11035, (Comparable)Boolean.valueOf(false), ModelGenerator.getUpsideDownVariant(cabinetModel)).method_25806((Comparable)class_2760.field_12619, (Comparable)class_2350.field_11039, (Comparable)Boolean.valueOf(true), ModelGenerator.getUpsideDownVariantY(cabinetOpenModel, class_4936.class_4937.field_22891)).method_25806((Comparable)class_2760.field_12619, (Comparable)class_2350.field_11039, (Comparable)Boolean.valueOf(false), ModelGenerator.getUpsideDownVariantY(cabinetModel, class_4936.class_4937.field_22891)));
    }

    protected static class_4935 getUVLockedUpsideDownVariantY(class_2960 model, class_4936.class_4937 rotationY) {
        return class_4935.method_25824().method_25828(class_4936.field_22887, (Object)model).method_25828(class_4936.field_22888, (Object)true).method_25828(class_4936.field_22885, (Object)class_4936.class_4937.field_22892).method_25828(class_4936.field_22886, (Object)rotationY);
    }

    protected static class_4935 getUVLockedUpsideDownVariant(class_2960 model) {
        return class_4935.method_25824().method_25828(class_4936.field_22887, (Object)model).method_25828(class_4936.field_22888, (Object)true).method_25828(class_4936.field_22885, (Object)class_4936.class_4937.field_22892);
    }

    protected static class_4935 getUVLockedVariantY(class_2960 model, class_4936.class_4937 rotationY) {
        return class_4935.method_25824().method_25828(class_4936.field_22887, (Object)model).method_25828(class_4936.field_22888, (Object)true).method_25828(class_4936.field_22886, (Object)rotationY);
    }

    protected static class_4935 getUpsideDownVariantY(class_2960 model, class_4936.class_4937 rotationY) {
        return class_4935.method_25824().method_25828(class_4936.field_22887, (Object)model).method_25828(class_4936.field_22885, (Object)class_4936.class_4937.field_22892).method_25828(class_4936.field_22886, (Object)rotationY);
    }

    protected static class_4935 getUpsideDownVariant(class_2960 model) {
        return class_4935.method_25824().method_25828(class_4936.field_22887, (Object)model).method_25828(class_4936.field_22885, (Object)class_4936.class_4937.field_22892);
    }

    protected static class_4935 getVariantY(class_2960 model, class_4936.class_4937 rotationY) {
        return class_4935.method_25824().method_25828(class_4936.field_22887, (Object)model).method_25828(class_4936.field_22886, (Object)rotationY);
    }

    protected static class_4935 getVariant(class_2960 model) {
        return class_4935.method_25824().method_25828(class_4936.field_22887, (Object)model);
    }

    protected static class_4942 getModel(String id) {
        return new class_4942(Optional.of(HumilityAFM.getId(id)), Optional.empty(), new class_4945[0]);
    }

    protected static class_4942 getModel(class_2960 id) {
        return new class_4942(Optional.of(id), Optional.empty(), new class_4945[0]);
    }

    public void generateItemModels(class_4915 itemModelGenerator) {
        for (class_1792 item : ItemRegistry.GLOWING_POWDER_VARIANTS) {
            itemModelGenerator.method_65442(item, class_4943.field_22938);
        }
    }

    @Environment(value=EnvType.CLIENT)
    protected record CabinetModelWoodSet(class_4942 wallClosed, class_4942 wallOpen, class_4942 floorClosed, class_4942 floorOpen) {
    }
}

