/*
 * Decompiled with CFR 0.152.
 */
package io.github.mikip98.humilityafm.registries;

import io.github.mikip98.humilityafm.HumilityAFM;
import io.github.mikip98.humilityafm.content.blocks.cabinet.CabinetBlock;
import io.github.mikip98.humilityafm.content.blocks.cabinet.FloorCabinetBlock;
import io.github.mikip98.humilityafm.content.blocks.cabinet.FloorIlluminatedCabinetBlock;
import io.github.mikip98.humilityafm.content.blocks.cabinet.IlluminatedCabinetBlock;
import io.github.mikip98.humilityafm.content.blocks.jack_o_lanterns.JackOLanternRedStone;
import io.github.mikip98.humilityafm.content.blocks.jack_o_lanterns.JackOLanternSoul;
import io.github.mikip98.humilityafm.registries.BlockGeneration;
import io.github.mikip98.humilityafm.registries.ItemRegistry;
import java.util.function.Function;
import net.fabricmc.fabric.api.registry.FlammableBlockRegistry;
import net.minecraft.class_1747;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_4970;
import net.minecraft.class_5321;
import net.minecraft.class_7924;

public class BlockRegistry
extends BlockGeneration {
    public static final class_2248 CABINET_BLOCK = BlockRegistry.register("wall_cabinet_block", CabinetBlock::new, CabinetBlock.defaultSettings);
    public static final class_2248 ILLUMINATED_CABINET_BLOCK = BlockRegistry.register("wall_illuminated_cabinet_block", IlluminatedCabinetBlock::new, CabinetBlock.defaultSettings);
    public static final class_2248 FLOOR_CABINET_BLOCK = BlockRegistry.register("cabinet_block", FloorCabinetBlock::new, IlluminatedCabinetBlock.defaultSettings);
    public static final class_2248 FLOOR_ILLUMINATED_CABINET_BLOCK = BlockRegistry.register("illuminated_cabinet_block", FloorIlluminatedCabinetBlock::new, IlluminatedCabinetBlock.defaultSettings);
    public static final class_2248[] WALL_CABINET_BLOCK_VARIANTS;
    public static final class_2248[] WALL_ILLUMINATED_CABINET_BLOCK_VARIANTS;
    public static final class_2248[] FLOOR_CABINET_BLOCK_VARIANTS;
    public static final class_2248[] FLOOR_ILLUMINATED_CABINET_BLOCK_VARIANTS;
    public static final class_2248[] INNER_STAIRS_BLOCK_VARIANTS;
    public static final class_2248[] OUTER_STAIRS_BLOCK_VARIANTS;
    public static final class_2248[] WOODEN_MOSAIC_VARIANTS;
    public static final class_2248[] TERRACOTTA_TILE_VARIANTS;
    public static final class_2248 JACK_O_LANTERN_REDSTONE;
    public static final class_2248 JACK_O_LANTERN_SOUL;
    public static final class_2248[] SIMPLE_CANDLESTICK_WALL_VARIANTS;
    public static final class_2248[] SIMPLE_CANDLESTICK_FLOOR_VARIANTS;
    public static final class_2248[][] RUSTABLE_CANDLESTICK_WALL_VARIANTS;
    public static final class_2248[][] RUSTABLE_CANDLESTICK_FLOOR_VARIANTS;
    public static final class_2248[] LIGHT_STRIP_VARIANTS;
    public static final class_2248[] COLOURED_TORCH_VARIANTS;
    public static final class_2248[] COLOURED_WALL_TORCH_VARIANTS;
    public static final class_2248[] COLOURED_JACK_O_LANTERNS;

    public static void init() {
    }

    public static class_5321<class_2248> keyOfBlock(String name) {
        return class_5321.method_29179((class_5321)class_7924.field_41254, (class_2960)HumilityAFM.getId(name));
    }

    public static class_2248 registerWithItem(String name, Function<class_4970.class_2251, class_2248> blockFactory, class_4970.class_2251 settings) {
        class_2248 block = class_2246.method_63053(BlockRegistry.keyOfBlock(name), blockFactory, (class_4970.class_2251)settings);
        ItemRegistry.register(name, itemSettings -> new class_1747(block, itemSettings));
        return block;
    }

    public static class_2248 register(String name, Function<class_4970.class_2251, class_2248> blockFactory, class_4970.class_2251 settings) {
        return class_2246.method_63053(BlockRegistry.keyOfBlock(name), blockFactory, (class_4970.class_2251)settings);
    }

    protected static void registerFlammable(class_2248 block, int burnTime, int spreadSpeed) {
        FlammableBlockRegistry.getDefaultInstance().add(block, burnTime, spreadSpeed);
    }

    static {
        BlockGeneration.CabinetBlockSet cabinetBlockSet = BlockRegistry.generateCabinetBlockSet();
        WALL_CABINET_BLOCK_VARIANTS = cabinetBlockSet.wallCabinets();
        WALL_ILLUMINATED_CABINET_BLOCK_VARIANTS = cabinetBlockSet.wallIlluminatedCabinets();
        FLOOR_CABINET_BLOCK_VARIANTS = cabinetBlockSet.floorCabinets();
        FLOOR_ILLUMINATED_CABINET_BLOCK_VARIANTS = cabinetBlockSet.floorIlluminatedCabinets();
        BlockGeneration.ForcedCornerStairsBlockSet forcedCornerStairsBlockSet = BlockRegistry.generateForcedCornerStairsBlockSet();
        INNER_STAIRS_BLOCK_VARIANTS = forcedCornerStairsBlockSet.innerStairs();
        OUTER_STAIRS_BLOCK_VARIANTS = forcedCornerStairsBlockSet.outerStairs();
        WOODEN_MOSAIC_VARIANTS = BlockRegistry.generateWoodenMosaicVariants();
        TERRACOTTA_TILE_VARIANTS = BlockRegistry.generateTerracottaTilesVariants();
        JACK_O_LANTERN_REDSTONE = BlockRegistry.registerWithItem("jack_o_lantern_redstone", JackOLanternRedStone::new, JackOLanternRedStone.defaultSettings);
        JACK_O_LANTERN_SOUL = BlockRegistry.registerWithItem("jack_o_lantern_soul", JackOLanternSoul::new, JackOLanternSoul.defaultSettings);
        BlockGeneration.CandlestickBlockSet candlestickBlockSet = BlockRegistry.generateCandlestickBlockSet();
        SIMPLE_CANDLESTICK_WALL_VARIANTS = candlestickBlockSet.simpleCandlestickWallVariants();
        SIMPLE_CANDLESTICK_FLOOR_VARIANTS = candlestickBlockSet.simpleCandlestickFloorVariants();
        RUSTABLE_CANDLESTICK_WALL_VARIANTS = candlestickBlockSet.rustableCandlestickWallVariants();
        RUSTABLE_CANDLESTICK_FLOOR_VARIANTS = candlestickBlockSet.rustableCandlestickFloorVariants();
        BlockGeneration.ColouredFeatureBlockSet colouredFeatureBlockSet = BlockRegistry.generateColouredFeatureBlockSet();
        LIGHT_STRIP_VARIANTS = colouredFeatureBlockSet.lightStripVariants();
        COLOURED_TORCH_VARIANTS = colouredFeatureBlockSet.colouredTorchVariants();
        COLOURED_WALL_TORCH_VARIANTS = colouredFeatureBlockSet.colouredWallTorchVariants();
        COLOURED_JACK_O_LANTERNS = colouredFeatureBlockSet.colouredJackOLanternVariants();
    }
}

