/*
 * Decompiled with CFR 0.152.
 */
package io.github.mikip98.humilityafm.registries;

import io.github.mikip98.humilityafm.HumilityAFM;
import io.github.mikip98.humilityafm.config.ModConfig;
import io.github.mikip98.humilityafm.content.items.DoubleVerticallyAttachableBlockItem;
import io.github.mikip98.humilityafm.content.items.ModVerticallyAttachableBlockItem;
import io.github.mikip98.humilityafm.registries.BlockRegistry;
import io.github.mikip98.humilityafm.util.generation_data.ActiveGenerationData;
import io.github.mikip98.humilityafm.util.generation_data.RawGenerationData;
import io.github.mikip98.humilityafm.util.generation_data.material_management.MaterialMultiArrayIterable;
import io.github.mikip98.humilityafm.util.generation_data.material_management.material.BlockMaterial;
import java.util.Arrays;
import java.util.function.Function;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2350;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7924;

public class ItemRegistry {
    public static final class_1792[] GLOWING_POWDER_VARIANTS = ModConfig.getEnableColouredFeatureSetBeta() ? (class_1792[])Arrays.stream(RawGenerationData.vanillaColorPallet).map(color -> ItemRegistry.register("glowing_powder_" + color)).toArray(class_1792[]::new) : null;
    public static final class_1792 CABINET_ITEM = ItemRegistry.register("cabinet_block", settings -> new DoubleVerticallyAttachableBlockItem(BlockRegistry.FLOOR_CABINET_BLOCK, BlockRegistry.CABINET_BLOCK, (class_1792.class_1793)settings));
    public static final class_1792 ILLUMINATED_CABINET_ITEM = ItemRegistry.register("illuminated_cabinet_block", settings -> new DoubleVerticallyAttachableBlockItem(BlockRegistry.FLOOR_ILLUMINATED_CABINET_BLOCK, BlockRegistry.ILLUMINATED_CABINET_BLOCK, (class_1792.class_1793)settings));
    public static class_1792[] CABINET_ITEM_VARIANTS;
    public static class_1792[] ILLUMINATED_CABINET_ITEM_VARIANTS;
    public static class_1792[] CANDLESTICK_ITEM_VARIANTS;
    public static class_1792[][] RUSTABLE_CANDLESTICK_ITEM_VARIANTS;
    public static class_1792[] COLOURED_TORCH_ITEM_VARIANTS;

    public static void register() {
        int finalI;
        int cabinetAmount = BlockRegistry.WALL_CABINET_BLOCK_VARIANTS.length;
        CABINET_ITEM_VARIANTS = new class_1792[cabinetAmount];
        ILLUMINATED_CABINET_ITEM_VARIANTS = new class_1792[cabinetAmount];
        int i = 0;
        for (BlockMaterial material : ActiveGenerationData.cabinetVariantMaterials) {
            finalI = i;
            ItemRegistry.CABINET_ITEM_VARIANTS[i] = ItemRegistry.register("cabinet_" + material.getSafeName(), settings -> new DoubleVerticallyAttachableBlockItem(BlockRegistry.FLOOR_CABINET_BLOCK_VARIANTS[finalI], BlockRegistry.WALL_CABINET_BLOCK_VARIANTS[finalI], (class_1792.class_1793)settings));
            ItemRegistry.ILLUMINATED_CABINET_ITEM_VARIANTS[i] = ItemRegistry.register("illuminated_cabinet_" + material.getSafeName(), settings -> new DoubleVerticallyAttachableBlockItem(BlockRegistry.FLOOR_ILLUMINATED_CABINET_BLOCK_VARIANTS[finalI], BlockRegistry.WALL_ILLUMINATED_CABINET_BLOCK_VARIANTS[finalI], (class_1792.class_1793)settings));
            ++i;
        }
        if (ModConfig.getEnableCandlestickBeta()) {
            CANDLESTICK_ITEM_VARIANTS = new class_1792[ActiveGenerationData.simpleCandlestickMaterials.size()];
            i = 0;
            for (BlockMaterial material : ActiveGenerationData.simpleCandlestickMaterials) {
                int finalI1 = i;
                ItemRegistry.CANDLESTICK_ITEM_VARIANTS[i] = ItemRegistry.register("candlestick_" + material.getSafeName(), settings -> new ModVerticallyAttachableBlockItem(BlockRegistry.SIMPLE_CANDLESTICK_FLOOR_VARIANTS[finalI1], BlockRegistry.SIMPLE_CANDLESTICK_WALL_VARIANTS[finalI1], (class_1792.class_1793)settings, class_2350.field_11033));
                ++i;
            }
            RUSTABLE_CANDLESTICK_ITEM_VARIANTS = new class_1792[ActiveGenerationData.rustingCandlestickMaterials.length][];
            i = 0;
            for (MaterialMultiArrayIterable materialSet : ActiveGenerationData.rustingCandlestickMaterials) {
                ItemRegistry.RUSTABLE_CANDLESTICK_ITEM_VARIANTS[i] = new class_1792[materialSet.size()];
                int j = 0;
                for (BlockMaterial material : materialSet) {
                    int finalI2 = i;
                    int finalJ = j;
                    ItemRegistry.RUSTABLE_CANDLESTICK_ITEM_VARIANTS[i][j] = ItemRegistry.register("candlestick_" + material.getSafeName(), settings -> new ModVerticallyAttachableBlockItem(BlockRegistry.RUSTABLE_CANDLESTICK_FLOOR_VARIANTS[finalI2][finalJ], BlockRegistry.RUSTABLE_CANDLESTICK_WALL_VARIANTS[finalI2][finalJ], (class_1792.class_1793)settings, class_2350.field_11033));
                    if (RUSTABLE_CANDLESTICK_ITEM_VARIANTS[i][j] == null) {
                        throw new NullPointerException();
                    }
                    ++j;
                }
                ++i;
            }
        }
        if (ModConfig.getEnableColouredFeatureSetBeta()) {
            COLOURED_TORCH_ITEM_VARIANTS = new class_1792[BlockRegistry.COLOURED_TORCH_VARIANTS.length];
            i = 0;
            for (BlockMaterial material : ActiveGenerationData.colouredFeatureSetMaterials) {
                finalI = i;
                ItemRegistry.COLOURED_TORCH_ITEM_VARIANTS[i] = ItemRegistry.register("coloured_torch_" + material.getRawName(), settings -> new ModVerticallyAttachableBlockItem(BlockRegistry.COLOURED_TORCH_VARIANTS[finalI], BlockRegistry.COLOURED_WALL_TORCH_VARIANTS[finalI], (class_1792.class_1793)settings, class_2350.field_11033));
                ++i;
            }
        }
    }

    public static class_1792 register(String name) {
        return ItemRegistry.register(name, class_1792::new);
    }

    public static class_1792 register(String name, Function<class_1792.class_1793, class_1792> factory) {
        return ItemRegistry.register(name, factory, new class_1792.class_1793());
    }

    public static class_1792 register(String name, Function<class_1792.class_1793, class_1792> factory, class_1792.class_1793 settings) {
        class_5321 registryKey = class_5321.method_29179((class_5321)class_7924.field_41197, (class_2960)HumilityAFM.getId(name));
        return class_1802.method_51348((class_5321)registryKey, factory, (class_1792.class_1793)settings);
    }
}

