/*
 * Decompiled with CFR 0.152.
 */
package io.github.mikip98.humilityafm.config;

import io.github.mikip98.humilityafm.config.ConfigJSON;
import io.github.mikip98.humilityafm.config.ModConfig;
import io.github.mikip98.humilityafm.config.enums.CreativeItemGroupCategorization;
import io.github.mikip98.humilityafm.config.enums.ModSupportState;
import io.github.mikip98.humilityafm.content.block_entity_renderers.LightStripBlockEntityRenderer;
import io.github.mikip98.humilityafm.content.block_entity_renderers.cabinetBlock.FloorIlluminatedCabinetBlockEntityRenderer;
import io.github.mikip98.humilityafm.content.block_entity_renderers.cabinetBlock.IlluminatedCabinetBlockEntityRenderer;
import io.github.mikip98.humilityafm.util.mod_support.SupportedMods;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_437;

@Environment(value=EnvType.CLIENT)
public class ModConfigScreen {
    public static class_437 createScreen(class_437 parentScreen) {
        ConfigBuilder builder = ConfigBuilder.create().setSavingRunnable(ConfigJSON::saveConfigToFile).setParentScreen(parentScreen).setTitle((class_2561)class_2561.method_43470((String)"Humility AFM Config"));
        ConfigCategory rootCategory = builder.getOrCreateCategory((class_2561)class_2561.method_43470((String)"General Settings"));
        rootCategory.addEntry((AbstractConfigListEntry)ConfigEntryBuilder.create().startBooleanToggle((class_2561)class_2561.method_43470((String)"Transparent Cabinet Blocks"), ModConfig.transparentCabinetBlocks).setDefaultValue(true).setTooltip(new class_2561[]{class_2561.method_30163((String)"Makes the cabinet blocks transparent.\n(Don't use with vanilla compat rp! It will look weird!)")}).setSaveConsumer(value -> {
            ModConfig.transparentCabinetBlocks = value;
        }).build());
        rootCategory.addEntry((AbstractConfigListEntry)ConfigEntryBuilder.create().startBooleanToggle((class_2561)class_2561.method_43470((String)"Enable Illuminated Cabinet Brightening"), ModConfig.illuminatedCabinetBlockBrightening).setDefaultValue(true).setTooltip(new class_2561[]{class_2561.method_30163((String)"Enables Light Strips Brightening, better looking, small performance impact.\n(Auto disabled when Shimmer is installed)")}).setSaveConsumer(value -> {
            ModConfig.illuminatedCabinetBlockBrightening = value;
            if (value.booleanValue()) {
                IlluminatedCabinetBlockEntityRenderer.enableBrightening();
                FloorIlluminatedCabinetBlockEntityRenderer.enableBrightening();
            } else {
                IlluminatedCabinetBlockEntityRenderer.disableBrightening();
                FloorIlluminatedCabinetBlockEntityRenderer.disableBrightening();
            }
        }).build());
        rootCategory.addEntry((AbstractConfigListEntry)ConfigEntryBuilder.create().startBooleanToggle((class_2561)class_2561.method_43470((String)"Enable Light Strip Brightening"), ModConfig.enableLightStripBrightening).setDefaultValue(true).setTooltip(new class_2561[]{class_2561.method_30163((String)"Enables Light Strips Brightening, better looking, small performance impact.\n(Auto disabled when Shimmer is installed)")}).setSaveConsumer(value -> {
            ModConfig.enableLightStripBrightening = value;
            if (value.booleanValue()) {
                LightStripBlockEntityRenderer.enableBrightening();
            } else {
                LightStripBlockEntityRenderer.disableBrightening();
            }
        }).build());
        rootCategory.addEntry((AbstractConfigListEntry)ConfigEntryBuilder.create().startBooleanToggle((class_2561)class_2561.method_43470((String)"Enable Candlestick Beta"), ModConfig.getRawEnableCandlestickBeta()).setDefaultValue(false).setTooltip(new class_2561[]{class_2561.method_30163((String)"Enables Candlestick blocks and items (beta)")}).setSaveConsumer(ModConfig::setEnableCandlestickBeta).build());
        rootCategory.addEntry((AbstractConfigListEntry)ConfigEntryBuilder.create().startBooleanToggle((class_2561)class_2561.method_43470((String)"Enable Coloured Feature Set Beta"), ModConfig.getRawEnableColouredFeatureSetBeta()).setDefaultValue(false).setTooltip(new class_2561[]{class_2561.method_30163((String)"Enables coloured feature set (beta)\nThis includes coloured torches, jack o'Lanterns and light strips + a new ingredient 'glowing powder' for crafting them.\n(For all the blocks to emmit coloured light, Shimmer must be installed or a compatible shader pack must be used)")}).setSaveConsumer(ModConfig::setEnableColouredFeatureSetBeta).build());
        rootCategory.addEntry((AbstractConfigListEntry)ConfigEntryBuilder.create().startEnumSelector(class_2561.method_30163((String)"Cretive Inventory Tab Separation"), CreativeItemGroupCategorization.class, (Enum)ModConfig.creativeItemGroupCategorization).setDefaultValue((Enum)ModConfig.dCreativeItemGroupCategorization).setTooltip(new class_2561[]{class_2561.method_30163((String)"Controls how the Humility AFM block and items are separated in the creative inventory tabs.\n- SEPARATE -> Default separation based on block types and their variant amounts\n- BLOCKS_AND_ITEMS -> Only 2 additional tabs: 'Humility Blocks' and 'Humility Items'\n- SINGLE -> Only 1 additional tab with all the Humility content\n- NONE -> No additional tabs are created\n")}).setSaveConsumer(value -> {
            ModConfig.creativeItemGroupCategorization = value;
        }).build());
        rootCategory.addEntry((AbstractConfigListEntry)ConfigEntryBuilder.create().startBooleanToggle(class_2561.method_30163((String)"Put Humility Blocks In Vanilla Creative Tabs"), ModConfig.placeHumilityBlocksInVanillaCreativeCategories).setDefaultValue(true).setTooltip(new class_2561[]{class_2561.method_30163((String)"Weather to put Humility AFM content inside the vanilla creative inventopry tabs")}).setSaveConsumer(value -> {
            ModConfig.placeHumilityBlocksInVanillaCreativeCategories = value;
        }).build());
        rootCategory.addEntry((AbstractConfigListEntry)ConfigEntryBuilder.create().startBooleanToggle((class_2561)class_2561.method_43470((String)"Datagen Mode"), ModConfig.datagenMode).setDefaultValue(false).setTooltip(new class_2561[]{class_2561.method_30163((String)"Enables datagen mode, which marks all supported mods as preset.\nThis is a debug tool used for Fabric Datagen.\n(Requires a restart to take effect)")}).setSaveConsumer(value -> {
            ModConfig.datagenMode = value;
        }).build());
        rootCategory.addEntry((AbstractConfigListEntry)ConfigEntryBuilder.create().startBooleanToggle((class_2561)class_2561.method_43470((String)"Print Server Client Config Missmatch In Chat"), ModConfig.printInChatServerClientMissmatch).setDefaultValue(true).setTooltip(new class_2561[]{class_2561.method_30163((String)"If true, when you join a server with different config, the differences will be printed in chat")}).setSaveConsumer(value -> {
            ModConfig.printInChatServerClientMissmatch = value;
        }).build());
        ConfigCategory modSupportCategory = builder.getOrCreateCategory((class_2561)class_2561.method_43470((String)"Mod Support"));
        List<Map.Entry> sortedModSupport = ModConfig.modSupport.entrySet().stream().sorted(Comparator.comparing(entry -> ((SupportedMods)((Object)((Object)entry.getKey()))).modName)).toList();
        for (Map.Entry entry2 : sortedModSupport) {
            SupportedMods mod = (SupportedMods)((Object)entry2.getKey());
            ModSupportState support = (ModSupportState)((Object)entry2.getValue());
            modSupportCategory.addEntry((AbstractConfigListEntry)ConfigEntryBuilder.create().startEnumSelector((class_2561)class_2561.method_43470((String)mod.modName), ModSupportState.class, (Enum)support).setDefaultValue((Enum)ModSupportState.AUTO).setTooltip(new class_2561[]{class_2561.method_30163((String)("Enable or disable support for " + mod.modName + ".\nAuto will enable the support if the mod is present."))}).setSaveConsumer(value -> ModConfig.modSupport.put(mod, (ModSupportState)((Object)value))).build());
        }
        ConfigCategory customizationCategory = builder.getOrCreateCategory((class_2561)class_2561.method_43470((String)"Blocks Customization"));
        customizationCategory.addEntry((AbstractConfigListEntry)ConfigEntryBuilder.create().startIntSlider((class_2561)class_2561.method_43470((String)"Cabinet Block Burn Time"), ModConfig.cabinetBlockBurnTime, 0, 64).setDefaultValue(24).setSaveConsumer(value -> {
            ModConfig.cabinetBlockBurnTime = value;
        }).build());
        customizationCategory.addEntry((AbstractConfigListEntry)ConfigEntryBuilder.create().startIntSlider((class_2561)class_2561.method_43470((String)"Cabinet Block Fire Spread"), ModConfig.cabinetBlockFireSpread, 0, 64).setDefaultValue(9).setSaveConsumer(value -> {
            ModConfig.cabinetBlockFireSpread = value;
        }).build());
        customizationCategory.addEntry((AbstractConfigListEntry)ConfigEntryBuilder.create().startFloatField((class_2561)class_2561.method_43470((String)"Mosaics and Tiles Strength Multiplayer"), ModConfig.mosaicsAndTilesStrengthMultiplayer).setDefaultValue(1.3333334f).setSaveConsumer(value -> {
            ModConfig.mosaicsAndTilesStrengthMultiplayer = value.floatValue();
        }).build());
        return builder.build();
    }
}

