/*
 * Decompiled with CFR 0.152.
 */
package io.github.mikip98.humilityafm.datagen.language;

import io.github.mikip98.humilityafm.datagen.language.USEnglishLangProvider;
import io.github.mikip98.humilityafm.datagen.language.util.Translation;
import io.github.mikip98.humilityafm.datagen.language.util.TranslationCategory;
import java.util.Hashtable;
import java.util.Map;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricLanguageProvider;

public class PolishLangProvider
extends FabricLanguageProvider {
    public PolishLangProvider(FabricDataOutput dataOutput) {
        super(dataOutput, "pl_pl");
    }

    public void generateTranslations(FabricLanguageProvider.TranslationBuilder translationBuilder) {
        for (Map.Entry<TranslationCategory, Map<String, String>> entry : PolishLangProvider.generatePolishTranslations().entrySet()) {
            for (Map.Entry<String, String> subEntry : entry.getValue().entrySet()) {
                translationBuilder.add(subEntry.getKey(), subEntry.getValue());
            }
        }
    }

    public static Map<TranslationCategory, Map<String, String>> generatePolishTranslations() {
        field_40831.info("Generating Polish translations for HumilityAFM");
        Map<TranslationCategory, Map<String, String>> categoryTranslations = USEnglishLangProvider.generateBaseUSEnglishTranslations();
        field_40831.info("Replacing item groups translations EN -> PL");
        categoryTranslations.put(TranslationCategory.ITEM_GROUPS, Map.of("itemGroup.cabinets", "Gabloty", "itemGroup.innerOuterStairs", "Schody wewn\u0119trzne i zewn\u0119trzne", "itemGroup.woodenMosaics", "Drewniane Mozaiki", "itemGroup.terracottaTiles", "P\u0142ytki z terakoty", "itemGroup.humilityMisc", "R\u00f3\u017cne (Humility)", "itemGroup.leds", "LED-y", "itemGroup.candlesticks", "\u015awieczniki", "itemGroup.humilityBlocks", "AFM Bloki", "itemGroup.humilityItems", "AFM Przedmioty", "itemGroup.humilityContent", "AFM"));
        field_40831.info(" Replacing block translations EN -> PL");
        Map<String, String> blockTranslations = categoryTranslations.get((Object)TranslationCategory.BLOCKS);
        blockTranslations = new Hashtable<String, String>(blockTranslations);
        for (Map.Entry<String, String> entry : blockTranslations.entrySet()) {
            String key = entry.getKey();
            Translation valueTranslation = new Translation(entry.getValue()).translate("Test", "Testowy").translate("Illuminated Cabinet", "Pod\u015bwietlana Gablota").translate("Cabinet", "Gablota").translate("Wooden Mosaic", "Drewniana Mozaika").translate("Terracotta Tiles", "P\u0142ytki z Terakoty").translate("Inner Stairs", "Schody Wewn\u0119trzne").translate("Outer Stairs", "Schody Zewn\u0119trzne").translate("Glowing Powder", "\u015awiec\u0105cy Proszek").translate("Candlestick", "\u015awiecznik").translate("With", "Z").translate("Candle", "\u015awieczk\u0105");
            blockTranslations.put(key, valueTranslation.getString());
        }
        categoryTranslations.put(TranslationCategory.BLOCKS, blockTranslations);
        return categoryTranslations;
    }
}

