/*
 * Decompiled with CFR 0.152.
 */
package io.github.mikip98.humilityafm.datagen.language;

import io.github.mikip98.humilityafm.datagen.language.util.TranslationCategory;
import io.github.mikip98.humilityafm.datagen.language.util.TranslationHashMap;
import io.github.mikip98.humilityafm.datagen.language.util.TranslatorBase;
import io.github.mikip98.humilityafm.registries.ItemRegistry;
import io.github.mikip98.humilityafm.util.generation_data.ActiveGenerationData;
import io.github.mikip98.humilityafm.util.generation_data.material_management.material.BlockMaterial;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.Map;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricLanguageProvider;

public class USEnglishLangProvider
extends FabricLanguageProvider {
    public USEnglishLangProvider(FabricDataOutput dataOutput) {
        super(dataOutput, "en_us");
    }

    public void generateTranslations(FabricLanguageProvider.TranslationBuilder translationBuilder) {
        for (Map.Entry<TranslationCategory, Map<String, String>> entry : USEnglishLangProvider.generateBaseUSEnglishTranslations().entrySet()) {
            for (Map.Entry<String, String> subEntry : entry.getValue().entrySet()) {
                translationBuilder.add(subEntry.getKey(), subEntry.getValue());
            }
        }
    }

    public static Map<TranslationCategory, Map<String, String>> generateBaseUSEnglishTranslations() {
        EnumMap<TranslationCategory, Map<String, String>> categoryTranslations = new EnumMap<TranslationCategory, Map<String, String>>(TranslationCategory.class);
        categoryTranslations.put(TranslationCategory.ITEM_GROUPS, Map.of("itemGroup.cabinets", "Cabinets", "itemGroup.innerOuterStairs", "Inner and Outer Stairs", "itemGroup.woodenMosaics", "Wooden Mosaics", "itemGroup.terracottaTiles", "Terracotta Tiles", "itemGroup.humilityMisc", "Miscellaneous (Humility)", "itemGroup.leds", "LEDs", "itemGroup.candlesticks", "Candlesticks", "itemGroup.humilityBlocks", "AFM Blocks", "itemGroup.humilityItems", "AFM Items", "itemGroup.humilityContent", "AFM"));
        categoryTranslations.put(TranslationCategory.BLOCKS, new BlockTranslator().getBlockTranslations());
        categoryTranslations.put(TranslationCategory.ITEMS, new ItemTranslator().getItemTranslations());
        return categoryTranslations;
    }

    protected static class BlockTranslator
    extends TranslatorBase {
        public BlockTranslator() {
            super(new TranslationHashMap("block.humility-afm."));
        }

        public TranslationHashMap getBlockTranslations() {
            this.generateCabinetTranslations();
            this.generateWoodenMosaicTranslations();
            this.generateTerracottaTilesTranslations();
            this.generateForcedCornerStairsTranslations();
            this.generateSpecialJackOLanternTranslations();
            this.generateCandlestickTranslations();
            this.generateColouredTorchesTranslations();
            this.generateLightStripTranslations();
            this.generateColouredJackOLanternTranslations();
            return this.translations;
        }

        public void generateCabinetTranslations() {
            this.translations.put(ItemRegistry.CABINET_ITEM, "Test Cabinet Block");
            this.translations.put(ItemRegistry.ILLUMINATED_CABINET_ITEM, "Test Illuminated Cabinet Block");
            String idPrefix1 = "cabinet_block_";
            String idPrefix2 = "illuminated_cabinet_block_";
            String nameSuffix1 = " cabinet";
            String nameSuffix2 = " illuminated cabinet";
            this.enterTranslations(ActiveGenerationData.cabinetVariantMaterials, "cabinet_block_", " cabinet");
            this.enterTranslations(ActiveGenerationData.cabinetVariantMaterials, "illuminated_cabinet_block_", " illuminated cabinet");
        }

        public void generateWoodenMosaicTranslations() {
            String idPrefix = "wooden_mosaic_";
            String nameSuffix = " wooden mosaic";
            this.enterTranslations(ActiveGenerationData.woodenMosaicVariantMaterials, "wooden_mosaic_", " wooden mosaic");
        }

        public void generateTerracottaTilesTranslations() {
            String idPrefix = "terracotta_tiles_";
            String nameSuffix = " terracotta tiles";
            this.enterTranslations(ActiveGenerationData.terracottaTilesMaterials, "terracotta_tiles_", " terracotta tiles");
        }

        public void generateForcedCornerStairsTranslations() {
            String idPrefix1 = "inner_stairs_";
            String idPrefix2 = "outer_stairs_";
            String nameSuffix1 = " inner stairs";
            String nameSuffix2 = " outer stairs";
            this.enterTranslations(ActiveGenerationData.forcedCornerStairsVariantMaterials, "inner_stairs_", " inner stairs");
            this.enterTranslations(ActiveGenerationData.forcedCornerStairsVariantMaterials, "outer_stairs_", " outer stairs");
        }

        public void generateCandlestickTranslations() {
            String idPrefix = "candlestick_";
            String nameSuffix = " candlestick";
            this.enterTranslations(ActiveGenerationData.simpleCandlestickMaterials, "candlestick_", " candlestick");
            Arrays.stream(ActiveGenerationData.rustingCandlestickMaterials).forEach(materialSet -> this.enterTranslations((Iterable<BlockMaterial>)materialSet, "candlestick_", " candlestick"));
        }

        public void generateSpecialJackOLanternTranslations() {
            this.translations.put("jack_o_lantern_redstone", "Redstone Jack o'Lantern");
            this.translations.put("jack_o_lantern_soul", "Soul Jack o'Lantern");
        }

        public void generateColouredJackOLanternTranslations() {
            String idPrefix = "coloured_jack_o_lantern_";
            String nameSuffix = " Jack o'Lantern";
            this.enterTranslations(ActiveGenerationData.colouredFeatureSetMaterials, "coloured_jack_o_lantern_", " Jack o'Lantern");
        }

        public void generateColouredTorchesTranslations() {
            String idPrefix = "coloured_torch_";
            String nameSuffix = " torch";
            this.enterTranslations(ActiveGenerationData.colouredFeatureSetMaterials, "coloured_torch_", " torch");
        }

        public void generateLightStripTranslations() {
            String idPrefix = "light_strip_";
            String nameSuffix = " Light Strip";
            this.enterTranslations(ActiveGenerationData.colouredFeatureSetMaterials, "light_strip_", " Light Strip");
        }
    }

    protected static class ItemTranslator
    extends TranslatorBase {
        public ItemTranslator() {
            super(new TranslationHashMap("item.humility-afm."));
        }

        public TranslationHashMap getItemTranslations() {
            this.generateGlowingPowderTranslations();
            return this.translations;
        }

        public void generateGlowingPowderTranslations() {
            String idPrefix = "glowing_powder_";
            String nameSuffix = " glowing powder";
            this.enterTranslations(ActiveGenerationData.colouredFeatureSetMaterials, "glowing_powder_", " glowing powder");
        }
    }
}

