/*
 * Decompiled with CFR 0.152.
 */
package io.github.mikip98.humilityafm.datagen.language.util;

import io.github.mikip98.humilityafm.datagen.language.util.TranslationHashMap;
import io.github.mikip98.humilityafm.util.generation_data.material_management.material.BlockMaterial;
import java.util.Arrays;
import java.util.Iterator;

public abstract class TranslatorBase {
    protected TranslationHashMap translations;

    protected TranslatorBase(TranslationHashMap translationsMap) {
        this.translations = translationsMap;
    }

    protected void enterTranslations(Iterable<BlockMaterial> materials, String idPrefix, String nameSuffix) {
        for (BlockMaterial material : materials) {
            String id = idPrefix + material.getSafeName();
            String name = TranslatorBase.formatName(material.getRawName()) + nameSuffix;
            this.translations.put(id, name);
        }
    }

    protected static String formatName(String name) {
        String[] words = name.split("_");
        Iterator it = Arrays.stream(words).iterator();
        StringBuilder formattedName = new StringBuilder();
        String firstWord = (String)it.next();
        formattedName.append(Character.toUpperCase(firstWord.charAt(0))).append(firstWord.substring(1).toLowerCase()).append(" ");
        while (it.hasNext()) {
            String word = (String)it.next();
            formattedName.append(word.toLowerCase()).append(" ");
        }
        return formattedName.toString().trim();
    }
}

