/*
 * Decompiled with CFR 0.152.
 */
package io.github.mikip98.humilityafm.registries;

import io.github.mikip98.humilityafm.config.ModConfig;
import io.github.mikip98.humilityafm.content.block_entity_renderers.LightStripBlockEntityRenderer;
import io.github.mikip98.humilityafm.content.block_entity_renderers.cabinetBlock.CabinetBlockEntityRenderer;
import io.github.mikip98.humilityafm.content.block_entity_renderers.cabinetBlock.FloorCabinetBlockEntityRenderer;
import io.github.mikip98.humilityafm.content.block_entity_renderers.cabinetBlock.FloorIlluminatedCabinetBlockEntityRenderer;
import io.github.mikip98.humilityafm.content.block_entity_renderers.cabinetBlock.IlluminatedCabinetBlockEntityRenderer;
import io.github.mikip98.humilityafm.registries.BlockEntityRegistry;
import io.github.mikip98.humilityafm.util.mod_support.ModSupportManager;
import io.github.mikip98.humilityafm.util.mod_support.SupportedMods;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_5614;
import net.minecraft.class_5616;

@Environment(value=EnvType.CLIENT)
public class BlockEntityRendererRegistry {
    public static void register() {
        BlockEntityRendererRegistry.register(BlockEntityRegistry.CABINET_BLOCK_ENTITY, CabinetBlockEntityRenderer::new);
        BlockEntityRendererRegistry.register(BlockEntityRegistry.ILLUMINATED_CABINET_BLOCK_ENTITY, IlluminatedCabinetBlockEntityRenderer::new);
        BlockEntityRendererRegistry.register(BlockEntityRegistry.FLOOR_CABINET_BLOCK_ENTITY, FloorCabinetBlockEntityRenderer::new);
        BlockEntityRendererRegistry.register(BlockEntityRegistry.FLOOR_ILLUMINATED_CABINET_BLOCK_ENTITY, FloorIlluminatedCabinetBlockEntityRenderer::new);
        if (ModConfig.illuminatedCabinetBlockBrightening) {
            IlluminatedCabinetBlockEntityRenderer.enableBrightening();
            FloorIlluminatedCabinetBlockEntityRenderer.enableBrightening();
        }
        if (ModConfig.getEnableColouredFeatureSetBeta()) {
            BlockEntityRendererRegistry.register(BlockEntityRegistry.LIGHT_STRIP_BLOCK_ENTITY, LightStripBlockEntityRenderer::new);
            if (ModConfig.enableLightStripBrightening && !ModSupportManager.isModLoaded(SupportedMods.SHIMMER)) {
                LightStripBlockEntityRenderer.enableBrightening();
            }
        }
    }

    protected static <T extends class_2586> void register(class_2591<T> blockEntityType, class_5614<T> factory) {
        class_5616.method_32144(blockEntityType, factory);
    }
}

