/*
 * Decompiled with CFR 0.152.
 */
package io.github.mikip98.humilityafm.registries;

import io.github.mikip98.humilityafm.HumilityAFM;
import io.github.mikip98.humilityafm.config.ModConfig;
import io.github.mikip98.humilityafm.config.enums.ModSupportState;
import io.github.mikip98.humilityafm.registries.NetworkRegistry;
import io.github.mikip98.humilityafm.util.mod_support.SupportedMods;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_746;
import org.slf4j.Logger;

@Environment(value=EnvType.CLIENT)
public class ClientNetworkRegistry {
    public static void register() {
        ClientPlayNetworking.registerGlobalReceiver((class_2960)NetworkRegistry.CONFIG_SYNC, (client, handler, buf, responseSender) -> {
            boolean serverConfigEnableCandlestickBeta = buf.readBoolean();
            boolean serverConfigEnableColouredFeatureSetBeta = buf.readBoolean();
            float serverMosaicsAndTilesStrengthMultiplayer = buf.readFloat();
            EnumMap<SupportedMods, ModSupportState> serverConfigModSupport = new EnumMap<SupportedMods, ModSupportState>(SupportedMods.class);
            for (SupportedMods mod : SupportedMods.values()) {
                if (mod == SupportedMods.SHIMMER) continue;
                serverConfigModSupport.put(mod, ModSupportState.values()[buf.readByte()]);
            }
            DiffList differences = new DiffList();
            if (ModConfig.getEnableCandlestickBeta() != serverConfigEnableCandlestickBeta) {
                differences.add("Candlestick BETA", serverConfigEnableCandlestickBeta, ModConfig.getEnableCandlestickBeta());
            }
            if (ModConfig.getEnableCandlestickBeta() != serverConfigEnableColouredFeatureSetBeta) {
                differences.add("Coloured Feature Set BETA", serverConfigEnableColouredFeatureSetBeta, ModConfig.getEnableColouredFeatureSetBeta());
            }
            if (ModConfig.mosaicsAndTilesStrengthMultiplayer != serverMosaicsAndTilesStrengthMultiplayer) {
                differences.add("Mosaics & Tiles Strength Multiplayer", serverMosaicsAndTilesStrengthMultiplayer, ModConfig.mosaicsAndTilesStrengthMultiplayer);
            }
            for (SupportedMods mod : SupportedMods.values()) {
                if (mod == SupportedMods.SHIMMER) continue;
                ModSupportState serverModSupportSetting = (ModSupportState)((Object)((Object)serverConfigModSupport.get((Object)mod)));
                ModSupportState clientModSupportSetting = ModConfig.modSupport.get((Object)mod);
                if (clientModSupportSetting == serverModSupportSetting) continue;
                differences.add("Support for mod '" + mod.modName + " (" + mod.modId + ")'", serverModSupportSetting, clientModSupportSetting);
            }
            if (!differences.isEmpty()) {
                client.execute(() -> {
                    ClientNetworkRegistry.printDiffs(arg_0 -> ((Logger)HumilityAFM.LOGGER).error(arg_0), differences, new String[]{"", "", ""});
                    if (ModConfig.printInChatServerClientMissmatch) {
                        class_746 player = client.field_1724;
                        assert (player != null);
                        Consumer<String> message = arg_0 -> ClientNetworkRegistry.lambda$register$0((class_1657)player, arg_0);
                        ClientNetworkRegistry.printDiffs(message, differences, new String[]{"\u00a7e", "\u00a77", "\u00a7c"});
                    }
                });
            }
        });
    }

    protected static void printDiffs(Consumer<String> printer, DiffList differences, String[] c) {
        printer.accept(c[0] + "Humility AFM mod detected server-client config mismatch!");
        printer.accept(c[0] + "Your client config of Humility AFM differs from the server config!");
        printer.accept(c[1] + "You should match the configs for optimal multiplayer experience");
        printer.accept(c[1] + "Detected differences:");
        differences.forEach(msg -> printer.accept(c[1] + "  - " + msg));
        printer.accept(c[2] + "BE CAREFUL TO NOT BREAK YOUR SINGLE PLAYER WORLDS BY JOINING THEM WITH BLOCKS THAT WERE PREVIOUSLY ENABLED, NOW DISABLED!!!");
        printer.accept(c[1] + "As long as you can join the server, you can just ignore this message if you want");
    }

    protected static void sendMessage(class_1657 player, String message) {
        player.method_43496((class_2561)class_2561.method_43470((String)message));
    }

    private static /* synthetic */ void lambda$register$0(class_1657 player, String msg) {
        ClientNetworkRegistry.sendMessage(player, msg);
    }

    @Environment(value=EnvType.CLIENT)
    protected static class DiffList
    extends ArrayList<String> {
        protected DiffList() {
        }

        void add(String name, boolean server, boolean client) {
            this.add(name, String.valueOf(server), String.valueOf(client));
        }

        public void add(String name, float server, float client) {
            this.add(name, String.valueOf(server), String.valueOf(client));
        }

        void add(String name, Enum<?> server, Enum<?> client) {
            this.add(name, server.name(), client.name());
        }

        void add(String name, String server, String client) {
            super.add(name + " -> server: " + server + " (yours: " + client + ")");
        }
    }
}

