/*
 * Decompiled with CFR 0.152.
 */
package io.github.mikip98.humilityafm.registries;

import io.github.mikip98.humilityafm.HumilityAFM;
import io.github.mikip98.humilityafm.config.ModConfig;
import io.github.mikip98.humilityafm.config.enums.CreativeItemGroupCategorization;
import io.github.mikip98.humilityafm.registries.BlockRegistry;
import io.github.mikip98.humilityafm.registries.ItemRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.itemgroup.v1.FabricItemGroup;
import net.fabricmc.fabric.api.itemgroup.v1.FabricItemGroupEntries;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.minecraft.class_1761;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7706;
import net.minecraft.class_7923;

public class ItemGroupRegistry {
    public static void registerItemGroups() {
        switch (ModConfig.creativeItemGroupCategorization) {
            case SEPARATE: {
                ItemGroupRegistry.createAndRegisterItemGroup("cabinets_group", "cabinets", (class_1935)ItemRegistry.CABINET_ITEM, (class_1935[][])new class_1935[][]{ItemRegistry.CABINET_ITEM_VARIANTS, ItemRegistry.ILLUMINATED_CABINET_ITEM_VARIANTS});
                ItemGroupRegistry.createAndRegisterItemGroup("inner_outer_stairs_group", "innerOuterStairs", (class_1935)BlockRegistry.OUTER_STAIRS_BLOCK_VARIANTS[0], (class_1935[][])new class_1935[][]{BlockRegistry.INNER_STAIRS_BLOCK_VARIANTS, BlockRegistry.OUTER_STAIRS_BLOCK_VARIANTS});
                ItemGroupRegistry.createAndRegisterItemGroup("wooden_mosaics_group", "woodenMosaics", (class_1935)BlockRegistry.WOODEN_MOSAIC_VARIANTS[0], (class_1935[][])new class_1935[][]{BlockRegistry.WOODEN_MOSAIC_VARIANTS});
                ItemGroupRegistry.createAndRegisterItemGroup("terracotta_tiles_group", "terracottaTiles", (class_1935)BlockRegistry.TERRACOTTA_TILE_VARIANTS[0], (class_1935[][])new class_1935[][]{BlockRegistry.TERRACOTTA_TILE_VARIANTS});
                ArrayList<Object> items = new ArrayList<Object>();
                items.add(new class_2248[]{BlockRegistry.JACK_O_LANTERN_REDSTONE});
                items.add(new class_2248[]{BlockRegistry.JACK_O_LANTERN_SOUL});
                if (ModConfig.getEnableColouredFeatureSetBeta()) {
                    items.add(ItemRegistry.GLOWING_POWDER_VARIANTS);
                    items.add(BlockRegistry.LIGHT_STRIP_VARIANTS);
                    items.add(ItemRegistry.COLOURED_TORCH_ITEM_VARIANTS);
                    items.add(BlockRegistry.COLOURED_JACK_O_LANTERNS);
                }
                if (ModConfig.getEnableCandlestickBeta()) {
                    items.add(ItemRegistry.CANDLESTICK_ITEM_VARIANTS);
                    items.addAll(Arrays.asList(ItemRegistry.RUSTABLE_CANDLESTICK_ITEM_VARIANTS));
                }
                ItemGroupRegistry.createAndRegisterItemGroup("humility_misc_group", "humilityMisc", (class_1935)BlockRegistry.JACK_O_LANTERN_SOUL, (class_1935[][])items.toArray((T[])new class_1935[0][]));
                break;
            }
            case BLOCKS_AND_ITEMS: 
            case SINGLE: {
                ArrayList<Object> blocks = new ArrayList<Object>();
                blocks.add(ItemRegistry.CABINET_ITEM_VARIANTS);
                blocks.add(ItemRegistry.ILLUMINATED_CABINET_ITEM_VARIANTS);
                blocks.add(BlockRegistry.OUTER_STAIRS_BLOCK_VARIANTS);
                blocks.add(BlockRegistry.INNER_STAIRS_BLOCK_VARIANTS);
                blocks.add(BlockRegistry.WOODEN_MOSAIC_VARIANTS);
                blocks.add(BlockRegistry.TERRACOTTA_TILE_VARIANTS);
                blocks.add(new class_2248[]{BlockRegistry.JACK_O_LANTERN_REDSTONE});
                blocks.add(new class_2248[]{BlockRegistry.JACK_O_LANTERN_SOUL});
                blocks.add(BlockRegistry.LIGHT_STRIP_VARIANTS);
                blocks.add(ItemRegistry.COLOURED_TORCH_ITEM_VARIANTS);
                blocks.add(BlockRegistry.COLOURED_JACK_O_LANTERNS);
                blocks.add(ItemRegistry.CANDLESTICK_ITEM_VARIANTS);
                blocks.addAll(Arrays.asList(ItemRegistry.RUSTABLE_CANDLESTICK_ITEM_VARIANTS));
                if (ModConfig.creativeItemGroupCategorization == CreativeItemGroupCategorization.BLOCKS_AND_ITEMS) {
                    ItemGroupRegistry.createAndRegisterItemGroup("humility_block_group", "humilityBlocks", (class_1935)ItemRegistry.CABINET_ITEM, (class_1935[][])blocks.toArray((T[])new class_1935[0][]));
                    ItemGroupRegistry.createAndRegisterItemGroup("humility_item_group", "humilityItems", () -> ItemRegistry.GLOWING_POWDER_VARIANTS[10], (class_1935[][])new class_1935[][]{ItemRegistry.GLOWING_POWDER_VARIANTS});
                    break;
                }
                blocks.add(ItemRegistry.GLOWING_POWDER_VARIANTS);
                ItemGroupRegistry.createAndRegisterItemGroup("humility_content_group", "humilityContent", (class_1935)ItemRegistry.CABINET_ITEM, (class_1935[][])blocks.toArray((T[])new class_1935[0][]));
            }
        }
        if (ModConfig.placeHumilityBlocksInVanillaCreativeCategories) {
            ItemGroupRegistry.putIntoItemGroup((class_1935[])ItemRegistry.CABINET_ITEM_VARIANTS, class_7706.field_41059);
            ItemGroupRegistry.putIntoItemGroup((class_1935[])ItemRegistry.ILLUMINATED_CABINET_ITEM_VARIANTS, class_7706.field_41059);
            ItemGroupRegistry.putIntoItemGroup((class_1935)BlockRegistry.JACK_O_LANTERN_REDSTONE, class_7706.field_41059, class_7706.field_40198);
            ItemGroupRegistry.putIntoItemGroup((class_1935)BlockRegistry.JACK_O_LANTERN_SOUL, class_7706.field_41059);
            ItemGroupRegistry.putIntoItemGroup((class_1935[])BlockRegistry.INNER_STAIRS_BLOCK_VARIANTS, class_7706.field_40195);
            ItemGroupRegistry.putIntoItemGroup((class_1935[])BlockRegistry.OUTER_STAIRS_BLOCK_VARIANTS, class_7706.field_40195);
            ItemGroupRegistry.putIntoItemGroup((class_1935[])BlockRegistry.WOODEN_MOSAIC_VARIANTS, class_7706.field_40195);
            ItemGroupRegistry.putIntoItemGroup((class_1935[])BlockRegistry.TERRACOTTA_TILE_VARIANTS, class_7706.field_40195);
            if (ModConfig.getEnableCandlestickBeta()) {
                ItemGroupRegistry.putIntoItemGroup((class_1935[])ItemRegistry.CANDLESTICK_ITEM_VARIANTS, class_7706.field_40197);
                Arrays.stream(ItemRegistry.RUSTABLE_CANDLESTICK_ITEM_VARIANTS).forEach(s -> ItemGroupRegistry.putIntoItemGroup((class_1935[])s, class_7706.field_40197));
            }
            if (ModConfig.getEnableColouredFeatureSetBeta()) {
                ItemGroupRegistry.putIntoItemGroup((class_1935[])ItemRegistry.GLOWING_POWDER_VARIANTS, class_7706.field_41062);
                ItemGroupRegistry.putIntoItemGroup((class_1935[])BlockRegistry.LIGHT_STRIP_VARIANTS, class_7706.field_41059);
                ItemGroupRegistry.putIntoItemGroup((class_1935[])ItemRegistry.COLOURED_TORCH_ITEM_VARIANTS, class_7706.field_41059);
                ItemGroupRegistry.putIntoItemGroup((class_1935[])BlockRegistry.COLOURED_JACK_O_LANTERNS, class_7706.field_41059);
            }
        }
    }

    protected static boolean itemGroupCreationCheck(class_1935[] ... itemSets) {
        return itemSets == null || itemSets.length == 0 || Arrays.stream(itemSets).allMatch(items -> items == null || ((class_1935[])items).length == 0);
    }

    protected static void createAndRegisterItemGroup(String name, String translationId, Supplier<class_1935> displayItemSupplier, class_1935[] ... itemSets) {
        if (ItemGroupRegistry.itemGroupCreationCheck(itemSets)) {
            return;
        }
        ItemGroupRegistry.createAndRegisterItemGroup(name, translationId, displayItemSupplier.get(), itemSets);
    }

    protected static void createAndRegisterItemGroup(String name, String translationId, class_1935 displayItem, class_1935[] ... itemSets) {
        if (ItemGroupRegistry.itemGroupCreationCheck(itemSets)) {
            return;
        }
        class_2378.method_10230((class_2378)class_7923.field_44687, (class_2960)HumilityAFM.getId(name), (Object)FabricItemGroup.builder().method_47320(() -> new class_1799(displayItem)).method_47321((class_2561)class_2561.method_43471((String)("itemGroup." + translationId))).method_47317((displayContext, entries) -> Arrays.stream(itemSets).forEach(items -> {
            if (items != null) {
                Arrays.stream(items).forEach(arg_0 -> ((class_1761.class_7704)entries).method_45421(arg_0));
            }
        })).method_47324());
    }

    @SafeVarargs
    protected static void putIntoItemGroup(class_1935[] items, class_5321<class_1761> ... itemGroups) {
        for (class_5321<class_1761> itemGroup : itemGroups) {
            ItemGroupEvents.modifyEntriesEvent(itemGroup).register(content -> Arrays.stream(items).forEach(arg_0 -> ((FabricItemGroupEntries)content).method_45421(arg_0)));
        }
    }

    @SafeVarargs
    protected static void putIntoItemGroup(class_1935 item, class_5321<class_1761> ... itemGroups) {
        for (class_5321<class_1761> itemGroup : itemGroups) {
            ItemGroupEvents.modifyEntriesEvent(itemGroup).register(content -> content.method_45421(item));
        }
    }
}

