/*
 * Decompiled with CFR 0.152.
 */
package io.github.mikip98.humilityafm.registries;

import io.github.mikip98.humilityafm.HumilityAFM;
import io.github.mikip98.humilityafm.config.ModConfig;
import io.github.mikip98.humilityafm.content.items.DoubleVerticallyAttachableBlockItem;
import io.github.mikip98.humilityafm.content.items.ModVerticallyAttachableBlockItem;
import io.github.mikip98.humilityafm.registries.BlockRegistry;
import io.github.mikip98.humilityafm.util.generation_data.ActiveGenerationData;
import io.github.mikip98.humilityafm.util.generation_data.RawGenerationData;
import io.github.mikip98.humilityafm.util.generation_data.material_management.MaterialMultiArrayIterable;
import io.github.mikip98.humilityafm.util.generation_data.material_management.material.BlockMaterial;
import java.util.Arrays;
import net.fabricmc.fabric.api.item.v1.FabricItemSettings;
import net.minecraft.class_1792;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

public class ItemRegistry {
    public static final class_1792[] GLOWING_POWDER_VARIANTS = ModConfig.getEnableColouredFeatureSetBeta() ? (class_1792[])Arrays.stream(RawGenerationData.vanillaColorPallet).map(color -> ItemRegistry.register("glowing_powder_" + color)).toArray(class_1792[]::new) : null;
    public static final class_1792 CABINET_ITEM = ItemRegistry.register((class_1792)new DoubleVerticallyAttachableBlockItem(BlockRegistry.FLOOR_CABINET_BLOCK, BlockRegistry.CABINET_BLOCK, (class_1792.class_1793)new FabricItemSettings()), "cabinet_block");
    public static final class_1792 ILLUMINATED_CABINET_ITEM = ItemRegistry.register((class_1792)new DoubleVerticallyAttachableBlockItem(BlockRegistry.FLOOR_ILLUMINATED_CABINET_BLOCK, BlockRegistry.ILLUMINATED_CABINET_BLOCK, (class_1792.class_1793)new FabricItemSettings()), "illuminated_cabinet_block");
    public static class_1792[] CABINET_ITEM_VARIANTS;
    public static class_1792[] ILLUMINATED_CABINET_ITEM_VARIANTS;
    public static class_1792[] CANDLESTICK_ITEM_VARIANTS;
    public static class_1792[][] RUSTABLE_CANDLESTICK_ITEM_VARIANTS;
    public static class_1792[] COLOURED_TORCH_ITEM_VARIANTS;

    public static void register() {
        int cabinetAmount = BlockRegistry.WALL_CABINET_BLOCK_VARIANTS.length;
        CABINET_ITEM_VARIANTS = new class_1792[cabinetAmount];
        ILLUMINATED_CABINET_ITEM_VARIANTS = new class_1792[cabinetAmount];
        int i = 0;
        for (BlockMaterial material : ActiveGenerationData.cabinetVariantMaterials) {
            ItemRegistry.CABINET_ITEM_VARIANTS[i] = ItemRegistry.register((class_1792)new DoubleVerticallyAttachableBlockItem(BlockRegistry.FLOOR_CABINET_BLOCK_VARIANTS[i], BlockRegistry.WALL_CABINET_BLOCK_VARIANTS[i], (class_1792.class_1793)new FabricItemSettings()), "cabinet_" + material.getSafeName());
            ItemRegistry.ILLUMINATED_CABINET_ITEM_VARIANTS[i] = ItemRegistry.register((class_1792)new DoubleVerticallyAttachableBlockItem(BlockRegistry.FLOOR_ILLUMINATED_CABINET_BLOCK_VARIANTS[i], BlockRegistry.WALL_ILLUMINATED_CABINET_BLOCK_VARIANTS[i], (class_1792.class_1793)new FabricItemSettings()), "illuminated_cabinet_" + material.getSafeName());
            ++i;
        }
        if (ModConfig.getEnableCandlestickBeta()) {
            CANDLESTICK_ITEM_VARIANTS = new class_1792[ActiveGenerationData.simpleCandlestickMaterials.size()];
            i = 0;
            for (BlockMaterial material : ActiveGenerationData.simpleCandlestickMaterials) {
                ItemRegistry.CANDLESTICK_ITEM_VARIANTS[i] = ItemRegistry.register("candlestick_" + material.getSafeName(), (class_1792)new ModVerticallyAttachableBlockItem(BlockRegistry.SIMPLE_CANDLESTICK_FLOOR_VARIANTS[i], BlockRegistry.SIMPLE_CANDLESTICK_WALL_VARIANTS[i], (class_1792.class_1793)new FabricItemSettings(), class_2350.field_11033));
                ++i;
            }
            RUSTABLE_CANDLESTICK_ITEM_VARIANTS = new class_1792[ActiveGenerationData.rustingCandlestickMaterials.length][];
            i = 0;
            for (MaterialMultiArrayIterable materialSet : ActiveGenerationData.rustingCandlestickMaterials) {
                ItemRegistry.RUSTABLE_CANDLESTICK_ITEM_VARIANTS[i] = new class_1792[materialSet.size()];
                int j = 0;
                for (BlockMaterial material : materialSet) {
                    ItemRegistry.RUSTABLE_CANDLESTICK_ITEM_VARIANTS[i][j] = ItemRegistry.register("candlestick_" + material.getSafeName(), (class_1792)new ModVerticallyAttachableBlockItem(BlockRegistry.RUSTABLE_CANDLESTICK_FLOOR_VARIANTS[i][j], BlockRegistry.RUSTABLE_CANDLESTICK_WALL_VARIANTS[i][j], (class_1792.class_1793)new FabricItemSettings(), class_2350.field_11033));
                    if (RUSTABLE_CANDLESTICK_ITEM_VARIANTS[i][j] == null) {
                        throw new NullPointerException();
                    }
                    ++j;
                }
                ++i;
            }
        }
        if (ModConfig.getEnableColouredFeatureSetBeta()) {
            COLOURED_TORCH_ITEM_VARIANTS = new class_1792[BlockRegistry.COLOURED_TORCH_VARIANTS.length];
            i = 0;
            for (BlockMaterial material : ActiveGenerationData.colouredFeatureSetMaterials) {
                ItemRegistry.COLOURED_TORCH_ITEM_VARIANTS[i] = ItemRegistry.register("coloured_torch_" + material.getRawName(), (class_1792)new ModVerticallyAttachableBlockItem(BlockRegistry.COLOURED_TORCH_VARIANTS[i], BlockRegistry.COLOURED_WALL_TORCH_VARIANTS[i], new class_1792.class_1793(), class_2350.field_11033));
                ++i;
            }
        }
    }

    public static class_1792 register(class_1792 item, String name) {
        return ItemRegistry.register(name, item);
    }

    public static class_1792 register(String name) {
        return ItemRegistry.register(name, new class_1792((class_1792.class_1793)new FabricItemSettings()));
    }

    public static class_1792 register(String name, class_1792 item) {
        class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)HumilityAFM.getId(name), (Object)item);
        return item;
    }
}

